/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;

public final class DataSourceNode
extends AbstractDataNode {
    public static final String DATA_SOURCE_TABLE_ALIAS_CHANGED = "dataSourceTableAliasChange";
    public static final String DATA_SOURCE_TABLE_CONTENTS_CHANGED = "dataSourceTableContentChanged";
    public static final String DATA_SOURCE_TABLE_CONTENTS_REMOVED = "dataSourceTableContentRemoved";
    public static final String DATA_SOURCE_TABLE_CONTENTS_ADDED = "dataSourceTableContentAdded";
    public static final String DATA_SOURCE_ATTRIBUTES = "dataSourceAttributes";

    public DataSourceNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public Object getProperty(String string) {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        Object object = null;
        if (string.equals("dataSourceTable")) {
            TableType tableType = dataSourceNodeType.getSourceTable();
            object = new AbstractDataNode.TablePropertyValue(tableType.getSchema(), tableType.getName());
        } else if (string.equals(DATA_SOURCE_ATTRIBUTES)) {
            object = dataSourceNodeType.getAttributes();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        if (complexProperty.getPropertyName().equals("dataSourceTable")) {
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            for (AttributeType attributeType : dataSourceNodeType.getAttributes().getAttribute()) {
                hashMap.put(attributeType.getName(), attributeType);
            }
            AbstractDataNode.TablePropertyValue tablePropertyValue = new AbstractDataNode.TablePropertyValue(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName(), hashMap);
            return tablePropertyValue;
        }
        if (complexProperty.getPropertyName().equals(DATA_SOURCE_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(DATA_SOURCE_TABLE_ALIAS_CHANGED)) {
            AttributeType attributeType = (AttributeType)complexProperty.getOldData();
            boolean bl = false;
            List list = dataSourceNodeType.getAttributes().getAttribute();
            for (AttributeType attributeType2 : list) {
                attributeType = (AttributeType)complexProperty.getOldData();
                if (!attributeType2.getName().equals(attributeType.getName())) continue;
                bl = true;
                break;
            }
            return bl ? attributeType : null;
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        if (string.equals("dataSourceTable")) {
            AbstractDataNode.TablePropertyValue tablePropertyValue = (AbstractDataNode.TablePropertyValue)object;
            TableType tableType = dataSourceNodeType.getSourceTable();
            tableType.setName(tablePropertyValue.getTable());
            tableType.setSchema(tablePropertyValue.getSchema());
            List<AttributeType> list = tablePropertyValue.getColumnList();
            dataSourceNodeType.getAttributes().getAttribute().clear();
            dataSourceNodeType.getAttributes().getAttribute().addAll(list);
            this.setNavigatorRefreshPending();
        } else if (string.equals(DATA_SOURCE_TABLE_ALIAS_CHANGED)) {
            List list = dataSourceNodeType.getAttributes().getAttribute();
            AttributeType attributeType = (AttributeType)object;
            for (AttributeType attributeType2 : list) {
                if (!attributeType2.getName().equals(attributeType.getName())) continue;
                String string2 = attributeType.getAlias();
                if (string2 != null && string2.trim().isEmpty()) {
                    string2 = null;
                }
                attributeType2.setAlias(string2);
                break;
            }
            HashMap hashMap = new HashMap();
            hashMap.put(attributeType.getName(), attributeType);
            this.refactorChildrenAttributes(this, hashMap);
        } else if (string.equals(DATA_SOURCE_TABLE_CONTENTS_REMOVED)) {
            List list = (List)object;
            List list2 = dataSourceNodeType.getAttributes().getAttribute();
            AttributeType attributeType = null;
            for (AttributeType attributeType3 : list) {
                for (AttributeType attributeType4 : list2) {
                    if (!attributeType4.getName().equals(attributeType3.getName())) continue;
                    attributeType = attributeType4;
                    break;
                }
                if (attributeType == null) continue;
                list2.remove(attributeType);
            }
        } else if (string.equals(DATA_SOURCE_TABLE_CONTENTS_ADDED)) {
            List list = dataSourceNodeType.getAttributes().getAttribute();
            List list3 = (List)object;
            for (AttributeType attributeType : list3) {
                if (list.contains(attributeType)) continue;
                list.add(attributeType);
            }
        } else if (string.equals(DATA_SOURCE_ATTRIBUTES)) {
            dataSourceNodeType.setAttributes((Attributes)object);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        AttributeType attributeType;
        boolean bl2 = super.validate(bl);
        boolean bl3 = false;
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        DataSourceNodeType dataSourceNodeType2 = list.iterator();
        while (dataSourceNodeType2.hasNext()) {
            attributeType = (AttributeType)dataSourceNodeType2.next();
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
            bl2 = false;
            bl3 = true;
            break;
        }
        if (bl3) {
            this.addMessage("DATASRC_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
        }
        if (list.size() == 0) {
            bl2 = false;
            this.addMessage("DATASRC_NO_ATTR", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if ((attributeType = (dataSourceNodeType2 = (DataSourceNodeType)this.getData()).getSourceTable()).getName() == null || attributeType.getSchema() == null) {
            bl2 = false;
            this.addMessage("DATASRC_NO_TABLE", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (this.areAttributeNamesDuplicates(list)) {
            bl2 = false;
            this.addMessage("DATASRC_DUPLICATE_ATTR_NAMES", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2) {
            ((DataSourceNodeType)this.getData()).setSQLExpression(this.generateSQLExpression());
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    protected boolean areAttributeNamesDuplicates(List<AttributeType> list) {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        for (AttributeType attributeType : list) {
            if (attributeType.getAlias() != null) continue;
            if (vector.contains(attributeType.getName())) {
                bl = true;
                attributeType.setStatus(AttributeStatus.INVALID);
                continue;
            }
            vector.add(attributeType.getName());
        }
        for (AttributeType attributeType : list) {
            if (attributeType.getAlias() == null) continue;
            if (vector.contains(attributeType.getAlias())) {
                bl = true;
                attributeType.setStatus(AttributeStatus.INVALID);
                continue;
            }
            vector.add(attributeType.getAlias());
        }
        return bl;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        TableType tableType = new TableType();
        tableType.setName(null);
        tableType.setSchema(null);
        dataSourceNodeType.setSourceTable(tableType);
        dataSourceNodeType.setAttributes(new Attributes());
        dataSourceNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        return false;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DATASOURCE_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public String generateSQLExpression() {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        TableType tableType = dataSourceNodeType.getSourceTable();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        String[] stringArray = new String[list.size()];
        String[] stringArray2 = new String[list.size()];
        String[] stringArray3 = new String[]{SQLHelper.delimitTable(tableType.getSchema(), tableType.getName())};
        for (int i = 0; i < list.size(); ++i) {
            AttributeType attributeType = (AttributeType)list.get(i);
            stringArray[i] = SQLHelper.delimit(attributeType.getName(), tableType.getName());
            stringArray2[i] = attributeType.getAlias() == null ? null : "\"" + attributeType.getAlias() + "\"";
        }
        String string = SQLHelper.buildSimpleAliasQuery(stringArray, stringArray2, stringArray3, null);
        return this.wrapExpressionInWithClause(string);
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        TableType tableType = dataSourceNodeType.getSourceTable();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName(), DatabaseObjectType.TABLE_OR_VIEW);
        List list = dataSourceNodeType.getAttributes().getAttribute();
        String[] stringArray = new String[list.size()];
        String[] stringArray2 = new String[list.size()];
        String[] stringArray3 = new String[]{parameterizedSourceDefinitions.getParmNameWithAmpersand(this, dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName(), DatabaseObjectType.TABLE_OR_VIEW) + " " + StringUtils.addDoubleQuotes(tableType.getName())};
        for (int i = 0; i < list.size(); ++i) {
            AttributeType attributeType = (AttributeType)list.get(i);
            stringArray[i] = SQLHelper.delimit(attributeType.getName(), tableType.getName());
            stringArray2[i] = attributeType.getAlias() == null ? null : "\"" + attributeType.getAlias() + "\"";
        }
        String string2 = SQLHelper.buildSimpleAliasQuery(stringArray, stringArray2, stringArray3, null);
        String string3 = CodeTemplate.updateBodyTemplate(string, "<SQL_EXPRESSION>", string2);
        string3 = CodeTemplate.updateBodyTemplate(string3, "<PARALLEL_HINT>", this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true));
        return string3;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        if (list != null && list.size() > 0) {
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = new AttributeType();
                attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
                attributeType2.setDataType(attributeType.getDataType());
                attributeType2.setStatus(attributeType.getStatus());
                attributeType2.setAnnotation(attributeType.getAnnotation());
                attributes.getAttribute().add(attributeType2);
            }
        }
        return attributes;
    }

    @Override
    public String getHelpTopic() {
        return "datasource_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DATA_SOURCE_SVG"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DATA_SOURCE_ICON"));
    }

    @Override
    public ArrayList<SourceDefinition> getLineageSources() {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this.getData();
        SourceDefinition sourceDefinition = new SourceDefinition(this, dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName(), DatabaseObjectType.TABLE_OR_VIEW);
        arrayList.add(sourceDefinition);
        return arrayList;
    }
}

