/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.FeatureExtractionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class FeatureExtractionBuildNode
extends UnsupervisedBuildNode {
    private static final Logger theLogger = Logger.getLogger(FeatureExtractionBuildNode.class.getName());
    public static final String FEAT_NUM_FEATURES = "FEAT_NUM_FEATURES";
    public static final String NMFS_CONV_TOLERANCE = "NMFS_CONV_TOLERANCE";
    public static final String NMFS_NUM_ITERATIONS = "NMFS_NUM_ITERATIONS";
    public static final String NMFS_RANDOM_SEED = "NMFS_RANDOM_SEED";
    private static Preferences _p = Preferences.getPreferences();
    private FeatureExtractionModelBuildPreferencesPanelSettings featureBuildPref = FeatureExtractionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);
    private Version _dbVersion = null;

    public FeatureExtractionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        try {
            this._dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = new FeatureExtractionBuildNodeType.Models();
        featureExtractionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.featureBuildPref.isNMF()) {
            arrayList.add("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
            if (this.featureBuildPref.isSVD()) {
                arrayList.add("ALGO_SINGULAR_VALUE_DECOMP");
            }
            if (this.featureBuildPref.isPCA()) {
                arrayList.add("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
            }
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "FEATURE_EXTRACTION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.featureBuildPref.isNMF()) {
            modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNMFModel((NonNegativeMatrixFactorModelType)modelType);
        }
        if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, this._dbVersion, true)) {
            if (this.featureBuildPref.isSVD()) {
                modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
                modelType.setUseForOutput(true);
                this.addSVDModel((SVDModelType)modelType);
            }
            if (this.featureBuildPref.isPCA()) {
                modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
                modelType.setUseForOutput(true);
                this.addPCAModel((PCAModelType)modelType);
            }
        }
        featureExtractionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public ModelType createNewModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "FEATURE_EXTRACTION", string3);
        return modelType;
    }

    public void addNMFModel(NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getNonNegativeMatrixFactorModel();
        list.add(nonNegativeMatrixFactorModelType);
    }

    public void addSVDModel(SVDModelType sVDModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getSVDModel();
        list.add(sVDModelType);
    }

    public void addPCAModel(PCAModelType pCAModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getPCAModel();
        list.add(pCAModelType);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_FEAT_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        if (models.getNonNegativeMatrixFactorModel().isEmpty() && models.getSVDModel().isEmpty() && models.getPCAModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNonNegativeMatrixFactorModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getSVDModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getPCAModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list2 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (list2.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (!list3.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType2 = (FeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType2, string2);
                modelType.setStatus((ModelStatusType)map.get(string2));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType3 = (FeatureExtractionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "feature_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_ICON"));
    }

    private String generateBuildSettingsCode(Context context, FeatureExtractionBuildNodeType featureExtractionBuildNodeType, ModelType modelType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType = (NonNegativeMatrixFactorModelType)modelType;
            if (nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getFEATNUMFEATURES() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_CONV_TOLERANCE||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSCONVTOLERANCE() + "'')'); \n");
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_NUM_ITERATIONS||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSNUMITERATIONS() + "'')'); \n");
            if (nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSRANDOMSEED() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_RANDOM_SEED||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSRANDOMSEED() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_NONNEGATIVE_MATRIX_FACTOR||''')'); \n");
        } else if (modelType instanceof PCAModelType) {
            PCAModelType pCAModelType = (PCAModelType)modelType;
            if (pCAModelType.getPCAAlgo().getFEATNUMFEATURES() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + pCAModelType.getPCAAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            if (pCAModelType.getPCAAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + pCAModelType.getPCAAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (pCAModelType.getPCAAlgo().getSVDSSCORINGMODE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SCORING_MODE||''', ''" + pCAModelType.getPCAAlgo().getSVDSSCORINGMODE() + "'')'); \n");
            }
            if (pCAModelType.getPCAAlgo().getSVDSUMATRIXOUTPUT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_U_MATRIX_OUTPUT||''', ''" + pCAModelType.getPCAAlgo().getSVDSUMATRIXOUTPUT() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SINGULAR_VALUE_DECOMP||''')'); \n");
        } else if (modelType instanceof SVDModelType) {
            SVDModelType sVDModelType = (SVDModelType)modelType;
            if (sVDModelType.getSVDAlgo().getFEATNUMFEATURES() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + sVDModelType.getSVDAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            if (sVDModelType.getSVDAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + sVDModelType.getSVDAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (sVDModelType.getSVDAlgo().getSVDSSCORINGMODE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SCORING_MODE||''', ''" + sVDModelType.getSVDAlgo().getSVDSSCORINGMODE() + "'')'); \n");
            }
            if (sVDModelType.getSVDAlgo().getSVDSUMATRIXOUTPUT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_U_MATRIX_OUTPUT||''', ''" + sVDModelType.getSVDAlgo().getSVDSUMATRIXOUTPUT() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SINGULAR_VALUE_DECOMP||''')'); \n");
        }
        if (bl) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, ModelType modelType) throws Exception {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = CodeTemplate.getInstance().getTemplate("workflow_generic_build_model.sql");
        string = CodeTemplate.updateBodyTemplate(string, "<MINING_FUNCTION>", "DBMS_DATA_MINING.FEATURE_EXTRACTION");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, (BuildNodeType)featureExtractionBuildNodeType, modelType, null, stringBuffer, stringBuffer2);
        String string2 = this.generateBuildSettingsCode(context, featureExtractionBuildNodeType, modelType, bl);
        String string3 = Connections.getUserAccountName(this.getContext());
        String string4 = modelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string3, string4, DatabaseObjectType.MODEL);
        String string5 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string3, string4, DatabaseObjectType.MODEL);
        String string6 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        string = CodeTemplate.updateBodyTemplate(string, "<PARALLEL_HINT>", string6);
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_SETTING>", string2);
        string = CodeTemplate.updateBodyTemplate(string, "<MODEL_NAME_PARAM>", string5);
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_ID>", modelType.getId());
        String string7 = null;
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            string7 = MiningAlgorithms.NON_NEGATIVE_MATRIX_FACTORIZATION.toString();
        } else if (modelType instanceof PCAModelType) {
            string7 = MiningAlgorithms.PRINCIPAL_COMPONENT_ANALYSIS.toString();
        } else if (modelType instanceof SVDModelType) {
            string7 = MiningAlgorithms.SINGULAR_VALUE_DECOMP.toString();
        }
        string = CodeTemplate.updateBodyTemplate(string, "<BUILD_MODEL_TYPE>", string7);
        return string;
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
            if (!featureExtractionBuildNodeType.getModels().getPCAModel().isEmpty()) {
                stringBuffer.append(CodeGenLrb.get("VALIDATE_PCA_BUILD_SETTING_NOT_SUPPORTED"));
                return false;
            }
            if (!featureExtractionBuildNodeType.getModels().getSVDModel().isEmpty()) {
                stringBuffer.append(CodeGenLrb.get("VALIDATE_SVD_BUILD_SETTING_NOT_SUPPORTED"));
                return false;
            }
        }
        return true;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ModelType)nonNegativeMatrixFactorModelType));
        }
        for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : featureExtractionBuildNodeType.getModels().getPCAModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ModelType)nonNegativeMatrixFactorModelType));
        }
        for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : featureExtractionBuildNodeType.getModels().getSVDModel()) {
            stringBuffer.append(this.generateBuildCode(context, parameterizedSourceDefinitions, (ModelType)nonNegativeMatrixFactorModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

