/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class RegressionBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildNode.class.getName());
    public static final String GLMSETTINGS = "RGLMSettings";
    public static final String TODO = "add settings here";
    public static final String TEST_RESULTS = "regrTestResults";
    public static final String GEN_ACCURACY_METRICS = "genAccuracyMetrics";
    public static final String GEN_RESIDUALS = "genResiduals";
    private static Preferences _p = Preferences.getPreferences();
    private RegressionModelBuildPreferencesPanelSettings regrBuildPref = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public RegressionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        Object object;
        Double d;
        TestDataSource.BuildData buildData;
        super.initNewInstance(context);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL")) {
            buildData = new TestDataSource.BuildData();
            regressionBuildNodeType.getTestDataSource().setBuildData(buildData);
        } else if (regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT")) {
            buildData = new TestDataSource.SplitData();
            d = regressionModelBuildPreferencesPanelSettings.getTestSplitPercent();
            buildData.setTestPercent(d.doubleValue());
            object = regressionModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
            buildData.setDataFormat((String)object);
            regressionBuildNodeType.getTestDataSource().setSplitData((TestDataSource.SplitData)buildData);
        } else {
            buildData = new TestDataSource.TestData();
            regressionBuildNodeType.getTestDataSource().setTestData((TestDataSource.TestData)buildData);
        }
        buildData = new RegressionBuildNodeType.Models();
        d = new RegressionBuildNodeType.Results();
        regressionBuildNodeType.setModels((RegressionBuildNodeType.Models)buildData);
        d.setGenAccuracyMetrics(regressionModelBuildPreferencesPanelSettings.isAccuracyMetrics());
        d.setGenResiduals(regressionModelBuildPreferencesPanelSettings.isResiduals());
        regressionBuildNodeType.setResults((RegressionBuildNodeType.Results)d);
        object = new ArrayList();
        if (this.regrBuildPref.isSvm()) {
            object.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.regrBuildPref.isGlm()) {
            object.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "REGRESSION", (List<String>)object);
        int n = 0;
        ModelType modelType = null;
        if (this.regrBuildPref.isSvm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)object.get(n++));
            modelType.setUseForOutput(true);
            this.addSVMModel((RSupportVectorMachineModelType)modelType);
        }
        if (this.regrBuildPref.isGlm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)object.get(n));
            modelType.setUseForOutput(true);
            this.addGLMModel((RGeneralizedLinearModelType)modelType);
        }
        regressionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addGLMModel(RGeneralizedLinearModelType rGeneralizedLinearModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRGeneralizedLinearModel();
        list.add(rGeneralizedLinearModelType);
    }

    public void addSVMModel(RSupportVectorMachineModelType rSupportVectorMachineModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRSupportVectorMachineModel();
        list.add(rSupportVectorMachineModelType);
    }

    public ModelType createNewRegressionModel(String string, String string2, String string3) {
        RegressionModelType regressionModelType = (RegressionModelType)super.createNewModel(string, string2, "REGRESSION", string3);
        return regressionModelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_REG_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (!regressionBuildNodeType.getResults().getRegressionResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
            results.setGenAccuracyMetrics(regressionBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenResiduals(regressionBuildNodeType.getResults().isGenResiduals());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, results);
        }
        super.refactor(node, bl);
    }

    @Override
    public Object getProperty(String string) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("splitDataFormat")) {
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            String string2 = testDataSource.getSplitData().getDataFormat();
            return string2;
        }
        if (string.equals("testOptionsChanged")) {
            return regressionBuildNodeType.getTestDataSource();
        }
        if (string.equals(GEN_ACCURACY_METRICS)) {
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            return results.isGenAccuracyMetrics();
        }
        if (string.equals(GEN_RESIDUALS)) {
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            return results.isGenResiduals();
        }
        if (string.equals(TEST_RESULTS)) {
            return regressionBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (RegressionResultType regressionResultType : list) {
                if (null == map.get(regressionResultType.getModelId())) continue;
                hashMap.put(regressionResultType.getModelId(), regressionResultType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        if (models.getRGeneralizedLinearModel().isEmpty() && models.getRSupportVectorMachineModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getRGeneralizedLinearModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getRSupportVectorMachineModel())) {
                bl3 = false;
            }
            HashMap<String, RSupportVectorMachineModelType> hashMap = new HashMap<String, RSupportVectorMachineModelType>();
            for (Object object2 : models.getRSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            for (Object object2 : models.getRGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
            results.setGenAccuracyMetrics(regressionBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenResiduals(regressionBuildNodeType.getResults().isGenResiduals());
            for (Object object3 : regressionBuildNodeType.getResults().getRegressionResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (RegressionResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getRegressionResult().add(object);
            }
            boolean bl5 = bl4 = results.getRegressionResult().size() != regressionBuildNodeType.getResults().getRegressionResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty(TEST_RESULTS, results);
                complexProperty.setOldData(regressionBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals(GLMSETTINGS)) {
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            List list = models.getRGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
                if (!rGeneralizedLinearModelType.getName().equals(string2)) continue;
                for (Property property : list2) {
                    if (!property.getDescription().equals("TODO")) continue;
                    rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().setGLMSCONFLEVEL(0.0);
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            RegressionBuildNodeType regressionBuildNodeType2 = (RegressionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(this);
            Map map = (Map)object;
            for (RegressionResultType regressionResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(regressionResultType.getModelId());
                if (null == modelStatusType) continue;
                regressionResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("splitDataFormat")) {
            String string4 = (String)object;
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            if (string4 == null || testDataSource.getSplitData().getDataFormat() == null || !testDataSource.getSplitData().getDataFormat().equals(string4)) {
                testDataSource.getSplitData().setDataFormat(string4);
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            regressionBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("alltestsRemoved")) {
            RegressionBuildNodeType regressionBuildNodeType3 = (RegressionBuildNodeType)this.getData();
            if (regressionBuildNodeType3.getResults() != null && !regressionBuildNodeType3.getResults().getRegressionResult().isEmpty()) {
                regressionBuildNodeType3.getResults().getRegressionResult().clear();
            }
        } else if (string.equals("testsRemoved")) {
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType4 = (RegressionBuildNodeType)this.getData();
            List list5 = regressionBuildNodeType4.getResults().getRegressionResult();
            block6: for (MiningResultType miningResultType : list) {
                for (RegressionResultType regressionResultType : list5) {
                    if (!regressionResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list5.remove(regressionResultType);
                    continue block6;
                }
            }
        } else if (string.equals("alltestsRestored")) {
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType5 = (RegressionBuildNodeType)this.getData();
            regressionBuildNodeType5.getResults().getRegressionResult().clear();
            regressionBuildNodeType5.getResults().getRegressionResult().addAll(list);
        } else if (string.equals("testsRestored")) {
            Object object22;
            RegressionBuildNodeType regressionBuildNodeType6 = (RegressionBuildNodeType)this.getData();
            List list = regressionBuildNodeType6.getResults().getRegressionResult();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object22 : list) {
                hashMap.put(object22.getModelId(), object22);
            }
            List list6 = (List)object;
            object22 = list6.iterator();
            while (object22.hasNext()) {
                RegressionResultType regressionResultType = (RegressionResultType)object22.next();
                if (null != hashMap.get(regressionResultType.getModelId())) continue;
                list.add(regressionResultType);
            }
        } else if (string.equals(GEN_ACCURACY_METRICS)) {
            Boolean bl = (Boolean)object;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals(GEN_RESIDUALS)) {
            Boolean bl = (Boolean)object;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenResiduals())) {
                results.setGenResiduals(bl);
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType7 = (RegressionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType7, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(TEST_RESULTS)) {
            regressionBuildNodeType.setResults((RegressionBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        return regressionBuildNodeType.getTargetAttribute();
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RSupportVectorMachineModelType rSupportVectorMachineModelType : list) {
            String string3 = rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string3 = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public HashMap<String, RowDiagnosticTableDetails> getRowDiagnosticTables() {
        HashMap<String, RowDiagnosticTableDetails> hashMap = new HashMap<String, RowDiagnosticTableDetails>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            RowDiagnosticTableDetails rowDiagnosticTableDetails = new RowDiagnosticTableDetails(this.getMetadataId(), string);
            hashMap.put(rGeneralizedLinearModelType.getId(), rowDiagnosticTableDetails);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "regression_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_REGRESSION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_REGRESSION_ICON"));
    }

    private String generateBuildSettingsCode(Context context, RegressionBuildNodeType regressionBuildNodeType, RegressionModelType regressionModelType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  execSQL('CREATE TABLE '||v_build_setting||' (SETTING_NAME VARCHAR2(30), SETTING_VALUE VARCHAR2(128))'); \n");
        if (regressionModelType instanceof RSupportVectorMachineModelType) {
            RSupportVectorMachineModelType rSupportVectorMachineModelType = (RSupportVectorMachineModelType)regressionModelType;
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSEPSILON() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_EPSILON||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSEPSILON() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSACTIVELEARNING() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() + ")'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCONVTOLERANCE() + ")'); \n");
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() + ")'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSTDDEV() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSTDDEV() + ")'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
        } else if (regressionModelType instanceof RGeneralizedLinearModelType) {
            RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)regressionModelType;
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONF_LEVEL||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSCONFLEVEL() + ")'); \n");
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSVIFFORRIDGE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_VIF_FOR_RIDGE||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSVIFFORRIDGE() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_DIAGNOSTICS_TABLE_NAME||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() + "'')'); \n");
                stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', '" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() + "', 'TABLE', NULL,'" + "GLM Diagnostics Table" + "'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEREGRESSION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_REGRESSION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEREGRESSION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEVALUE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_VALUE||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEVALUE() + ")'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSMISSINGVALUETREATMENT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_MISSING_VALUE_TREATMENT||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSMISSINGVALUETREATMENT() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSROWWEIGHTCOLUMNNAME() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ROW_WEIGHT_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSROWWEIGHTCOLUMNNAME())) + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SEL_CRIT||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_MAX_FEATURES||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() + ")'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SELECT_BLOCK||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_PRUNE_MODEL||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_ACCEPTANCE||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SELECTION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GENERATION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() != null) {
                stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GEN_METHOD||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() + "'')'); \n");
            }
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_GENERALIZED_LINEAR_MODEL||''')'); \n");
        }
        if (bl) {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_ON||''')'); \n");
        } else {
            stringBuffer.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.PREP_AUTO||''', '''||DBMS_DATA_MINING.PREP_AUTO_OFF||''')'); \n");
        }
        return stringBuffer.toString();
    }

    private String generateBuildTestCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, RegressionModelType regressionModelType) throws Exception {
        CharSequence charSequence;
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string2 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string3 = CodeTemplate.getInstance().getTemplate("workflow_regress_build_model.sql");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.generateDataUsageCode(version, (BuildNodeType)regressionBuildNodeType, (ModelType)regressionModelType, regressionBuildNodeType.getTargetAttribute(), stringBuffer, stringBuffer2);
        String string4 = this.generateBuildSettingsCode(context, regressionBuildNodeType, regressionModelType, bl);
        String string5 = Connections.getUserAccountName(this.getContext());
        String string6 = regressionModelType.getName();
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string5, string6, DatabaseObjectType.MODEL);
        String string7 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string5, string6, DatabaseObjectType.MODEL);
        String string8 = "";
        if (regressionBuildNodeType.getTestDataSource().getNone() == null) {
            string8 = CodeTemplate.getInstance().getTemplate("workflow_regress_test_model.sql");
            charSequence = new StringBuffer("");
            if (regressionBuildNodeType.getResults().isGenResiduals() == null || regressionBuildNodeType.getResults().isGenResiduals().booleanValue()) {
                String string9 = "  -- Residual plot \n  v_residual_plot := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT \n            A.'||v_caseid||' CASEID, \n            (B.\"'||v_target||'\") TARGET, \n            A.pred PREDICTION, \n            ((B.\"'||v_target||'\") - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.'||v_caseid||' = B.'||v_caseid||' \n            ORDER BY A.pred ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot, 'TABLE', NULL, 'Residual Plot'); \n";
                string9 = StringUtils.getReplacedString(string9, "<TABLE_PARALLEL_HINT>", string);
                string9 = StringUtils.getReplacedString(string9, "<PARALLEL_HINT>", string2);
                charSequence.append(string9);
            }
            string8 = CodeTemplate.updateBodyTemplate(string8, "<TABLE_PARALLEL_HINT>", string);
            string8 = CodeTemplate.updateBodyTemplate(string8, "<PARALLEL_HINT>", string2);
            string8 = CodeTemplate.updateBodyTemplate(string8, "<RESIDUAL_PLOT>", charSequence.toString());
        }
        string3 = CodeTemplate.updateBodyTemplate(string3, "<TEST_MODELS>", string8);
        string3 = CodeTemplate.updateBodyTemplate(string3, "<PARALLEL_HINT>", string2);
        string3 = CodeTemplate.updateBodyTemplate(string3, "<DATA_USAGE_ATTRIBUTES>", stringBuffer.toString());
        string3 = CodeTemplate.updateBodyTemplate(string3, "<DATA_USAGE_TRANSFORMATIONS>", stringBuffer2.toString());
        string3 = CodeTemplate.updateBodyTemplate(string3, "<BUILD_SETTING>", string4);
        string3 = CodeTemplate.updateBodyTemplate(string3, "<MODEL_NAME_PARAM>", string7);
        string3 = CodeTemplate.updateBodyTemplate(string3, "<BUILD_MODEL_ID>", regressionModelType.getId());
        charSequence = null;
        if (regressionModelType instanceof RGeneralizedLinearModelType) {
            charSequence = MiningAlgorithms.GENERALIZED_LINEAR_MODEL.toString();
        } else if (regressionModelType instanceof RSupportVectorMachineModelType) {
            charSequence = MiningAlgorithms.SUPPORT_VECTOR_MACHINE.toString();
        }
        string3 = CodeTemplate.updateBodyTemplate(string3, "<BUILD_MODEL_TYPE>", (String)charSequence);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateBuildTestDataCode(Context context) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        String string = null;
        if (regressionBuildNodeType.getCaseAttributes() != null && !regressionBuildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string = ((AttributeType)regressionBuildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
        }
        String string2 = null;
        String string3 = null;
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        String string6 = "        ";
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = null;
        boolean bl = false;
        if (regressionBuildNodeType.getTestDataSource().getSplitData() != null) {
            string2 = "VIEW";
            string3 = "VIEW";
            double d = 100.0 - regressionBuildNodeType.getTestDataSource().getSplitData().getTestPercent();
            string7 = "  v_build_data := generateUniqueName; \n  v_sql :=  \n    'CREATE VIEW '||v_build_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT * FROM (SELECT /*+ no_merge */ t.* FROM '||v_input_data||' t) \n      WHERE ORA_HASH('||v_caseid||', 99, 0) <= " + d + " \n" + "    )'; \n" + "  execSQL(v_sql); \n" + "  \n" + "  v_test_data := generateUniqueName; \n" + "  v_sql := \n" + "    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n" + "    ( \n" + "      SELECT * FROM (SELECT /*+ no_merge */ t.* FROM '||v_input_data||' t) \n" + "      WHERE ORA_HASH('||v_caseid||', 99, 0) > " + d + " \n" + "    )'; \n" + "  execSQL(v_sql); \n";
            string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            bl = true;
        } else if (regressionBuildNodeType.getTestDataSource().getTestData() != null) {
            String string8 = regressionBuildNodeType.getTestDataSource().getTestData().getSourceId();
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
                string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.*  \n      FROM '||getInputSource('" + string8 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
                string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            } else {
                Object object;
                Object object2;
                Object object32;
                String string9 = null;
                List<Object> list = new ArrayList();
                list = this.getModel().findLinksToNode((IlvSDMNode)this);
                for (Object object32 : list) {
                    object2 = (AbstractNode)((GeneralLink)object32).getFrom();
                    if (!((AbstractNode)object2).getMetadataId().equals(string8)) continue;
                    object = (AbstractDataNode)object2;
                    string9 = ((AbstractDataNode)object).getInputSQL();
                    break;
                }
                Object object4 = null;
                object32 = null;
                object2 = null;
                object = new StringBuffer("");
                try {
                    object4 = Connections.getSharedConnection(context);
                    object32 = Connections.getUserAccountName(context);
                    object2 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", (Connection)object4);
                    string9 = "SELECT * FROM (" + string9 + ")";
                    DatabaseMetadataUtils.createViewAs((Connection)object4, string9, (String)object32, (String)object2);
                    Map<String, DatabaseMetadataUtils.ColumnInfo> map = DatabaseMetadataUtils.getColumnInfo(context, (String)object2);
                    for (DatabaseMetadataUtils.ColumnInfo columnInfo : map.values()) {
                        if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (((StringBuffer)object).length() > 0) {
                                ((StringBuffer)object).append(",\n" + string6);
                            }
                            ((StringBuffer)object).append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (columnInfo.getDataType().contains("NESTED")) {
                            if (((StringBuffer)object).length() > 0) {
                                ((StringBuffer)object).append(",\n" + string6);
                            }
                            ((StringBuffer)object).append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (((StringBuffer)object).length() > 0) {
                            ((StringBuffer)object).append(",\n" + string6);
                        }
                        ((StringBuffer)object).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    try {
                        DatabaseMetadataUtils.dropView((Connection)object4, (String)object32, (String)object2);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
                string2 = "TABLE";
                string3 = "TABLE";
                string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_test_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string8 + "')||' t \n" + "    )'; \n" + "  execSQL(v_sql); \n";
                string7 = StringUtils.getReplacedString(string7, "<STORAGE_CLAUSE>", ((StringBuffer)object).toString());
                string7 = StringUtils.getReplacedString(string7, "<TABLE_PARALLEL_HINT>", string5);
                string7 = StringUtils.getReplacedString(string7, "<PARALLEL_HINT>", string4);
            }
            bl = true;
        } else if (regressionBuildNodeType.getTestDataSource().getBuildData() != null) {
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
            } else {
                string2 = "TABLE";
                string3 = "TABLE";
            }
            string7 = "  \n  v_build_data := v_input_data; \n  v_test_data := v_build_data; \n";
            bl = true;
        } else {
            string2 = string != null ? "VIEW" : "TABLE";
            string7 = "  \n  v_build_data := v_input_data; \n";
            bl = false;
        }
        stringBuffer.append(string7);
        stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_build_data, '" + string2 + "', NULL, 'Build Data');\n");
        if (bl) {
            stringBuffer.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_test_data, '" + string3 + "', NULL, 'Test Data');\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
            if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true)) {
                for (RGeneralizedLinearModelType rGeneralizedLinearModelType : regressionBuildNodeType.getModels().getRGeneralizedLinearModel()) {
                    if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        String string3 = this.generateBuildTestDataCode(context);
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_TEST_DATA>", string3);
        StringBuffer stringBuffer = new StringBuffer();
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : regressionBuildNodeType.getModels().getRGeneralizedLinearModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (RegressionModelType)rGeneralizedLinearModelType));
        }
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : regressionBuildNodeType.getModels().getRSupportVectorMachineModel()) {
            stringBuffer.append(this.generateBuildTestCode(context, parameterizedSourceDefinitions, (RegressionModelType)rGeneralizedLinearModelType));
        }
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_MODELS>", stringBuffer.toString());
        return string2;
    }
}

