/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.controls.HistogramPreferences;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class TransformationNode
extends AbstractTransformNode
implements SampleSettingsProperties,
DataConsumer,
ApplyChainNode {
    public static final String SAMPLE_SETTINGS = "sampleSize";
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String ADD_COLUMNS = "addColumns";
    public static final String REMOVE_COLUMNS = "removeColumns";
    private static final String INPUT_COLUMNS = NodeMessagesLrb.get("TRANSFORM_TABLE_INPUT");
    public static final String ALL_TRANSFORMATION_NODE_COLUMNS = "allXfomNodeColumns";
    public static final String EDIT_COLUMN = "editColumn";
    public static final String EDIT_COLUMNS = "editColumns";
    public static final String OUTPUT_STATE = "outputState";
    public static final String REFACTOR_XFORM_SOURCE_COLUMNS = "refactorSrcXformColumns";
    public static final String DATAPROFILE_SETTINGS = NodeMessagesLrb.get("DATAPROFILE_SETTINGS");
    public static final String STATS_SELECTION = NodeMessagesLrb.get("STATS_SELECTION");
    private static Preferences _p = Preferences.getPreferences();
    private HistogramPreferences histogramPreferences = HistogramPreferences.getInstance((PropertyStorage)_p);

    @Override
    public void refactorForApply() throws Exception {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        if (transformedAttributes == null) {
            return;
        }
        List list = transformedAttributes.getMapTransformedSourceType();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MapTransformedSource mapTransformedSource : list) {
            TransformationType.MissingValuesDate.Value value;
            Object object;
            Object object2;
            Object object3;
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            TransformationType transformationType = transformationOutputAttribute.getTransformationElementType();
            if (null != transformationType.getNormalization() && null == transformationType.getNormalization().getManual()) {
                object3 = transformationType.getNormalization();
                object2 = null;
                object = null;
                if (null != transformationType.getNormalization().getLinearScale()) {
                    object2 = transformationType.getNormalization().getLinearScale().getScale();
                    object = transformationType.getNormalization().getLinearScale().getShift();
                } else if (null != transformationType.getNormalization().getZScore()) {
                    object2 = transformationType.getNormalization().getZScore().getScale();
                    object = transformationType.getNormalization().getZScore().getShift();
                } else if (null != transformationType.getNormalization().getMinMax()) {
                    object2 = transformationType.getNormalization().getMinMax().getScale();
                    object = transformationType.getNormalization().getMinMax().getShift();
                }
                if (null == object2 || null == object) continue;
                value = new TransformationType.Normalization.Manual();
                value.setShift((Double)object);
                value.setScale((Double)object2);
                object3.setManual((TransformationType.Normalization.Manual)value);
                object3.setLinearScale(null);
                object3.setZScore(null);
                object3.setMinMax(null);
                continue;
            }
            if (null != transformationType.getOutlier() && null == transformationType.getOutlier().getValue()) {
                object3 = transformationType.getOutlier();
                object2 = null;
                object = null;
                if (null != object3.getPercent()) {
                    object2 = object3.getPercent().getLowerValue();
                    object = object3.getPercent().getUpperValue();
                } else if (null != object3.getStandardDeviation()) {
                    object2 = object3.getStandardDeviation().getLowerValue();
                    object = object3.getStandardDeviation().getUpperValue();
                }
                if (null == object2 || null == object) continue;
                value = new TransformationType.Outlier.Value();
                value.setLowerValue((Double)object2);
                value.setUpperValue((Double)object);
                object3.setValue((TransformationType.Outlier.Value)value);
                object3.setPercent(null);
                object3.setStandardDeviation(null);
                continue;
            }
            if (null != transformationType.getMissingValuesDate() && null != transformationType.getMissingValuesDate().getDateStatistic()) {
                object3 = transformationType.getMissingValuesDate();
                object2 = object3.getDateStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesDate.Value();
                value.setReplaceNullsWith((XMLGregorianCalendar)object);
                object3.setValue(value);
                object3.setDateStatistic(null);
                continue;
            }
            if (null != transformationType.getMissingValuesNumeric() && null != transformationType.getMissingValuesNumeric().getNumericStatistic()) {
                object3 = transformationType.getMissingValuesNumeric();
                object2 = object3.getNumericStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesNumeric.Value();
                value.setReplaceNullsWith((Double)object);
                object3.setValue((TransformationType.MissingValuesNumeric.Value)value);
                object3.setNumericStatistic(null);
                continue;
            }
            if (null != transformationType.getMissingValuesCategorical() && null != transformationType.getMissingValuesCategorical().getCategoricalStatistic()) {
                object3 = transformationType.getMissingValuesCategorical();
                object2 = object3.getCategoricalStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesCategorical.Value();
                value.setReplaceNullsWith((String)object);
                object3.setValue((TransformationType.MissingValuesCategorical.Value)value);
                object3.setCategoricalStatistic(null);
                continue;
            }
            if (null != transformationType.getBinning() && (null != transformationType.getBinning().getEqualWidth() || null != transformationType.getBinning().getQuantile())) {
                object3 = null;
                object2 = null;
                if (null != transformationType.getBinning().getEqualWidth()) {
                    object3 = transformationType.getBinning().getEqualWidth().getNumericBin();
                    object2 = transformationType.getBinning().getEqualWidth().getBinLabels();
                } else if (null != transformationType.getBinning().getQuantile()) {
                    object3 = transformationType.getBinning().getQuantile().getNumericBin();
                    object2 = transformationType.getBinning().getQuantile().getBinLabels();
                }
                object = new TransformationType.Binning.CustomNumeric();
                object.getNumericBin().addAll(object3);
                object.setBinLabels((BinLabels)object2);
                transformationType.getBinning().setCustomNumeric((TransformationType.Binning.CustomNumeric)object);
                transformationType.getBinning().setEqualWidth(null);
                transformationType.getBinning().setQuantile(null);
                continue;
            }
            if (null != transformationType.getBinning() && null != transformationType.getBinning().getTopN()) {
                object3 = transformationType.getBinning().getTopN().getCategoricalBin();
                object2 = new TransformationType.Binning.CustomCategorical();
                object2.getCategoricalBin().addAll(object3);
                transformationType.getBinning().setCustomCategorical((TransformationType.Binning.CustomCategorical)object2);
                transformationType.getBinning().setTopN(null);
                continue;
            }
            if (null != transformationType.getBinning() && null != transformationType.getBinning().getDateEqualWidth()) {
                object3 = transformationType.getBinning().getDateEqualWidth().getDateBin();
                object2 = new TransformationType.Binning.CustomDate();
                object2.getDateBin().addAll(object3);
                object2.setBinLabels(transformationType.getBinning().getDateEqualWidth().getBinLabels());
                transformationType.getBinning().setCustomDate((TransformationType.Binning.CustomDate)object2);
                transformationType.getBinning().setDateEqualWidth(null);
                continue;
            }
            if (null == transformationType.getBinning() || null == transformationType.getBinning().getTimestampEqualWidth()) continue;
            object3 = transformationType.getBinning().getTimestampEqualWidth().getTimestampTimezoneBin();
            object2 = new TransformationType.Binning.CustomTimestamp();
            object2.getTimestampTimezoneBin().addAll(object3);
            object2.setBinLabels(transformationType.getBinning().getTimestampEqualWidth().getBinLabels());
            transformationType.getBinning().setCustomTimestamp((TransformationType.Binning.CustomTimestamp)object2);
            transformationType.getBinning().setTimestampEqualWidth(null);
        }
        this.validate(false);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        Object object;
        StringCollection stringCollection;
        StringCollection stringCollection2;
        Object object22;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list = transformedAttributes.getMapTransformedSourceType();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformedAttributes transformedAttributes2 = transformationNodeType.getTransformedAttributes();
        List list2 = transformedAttributes2.getMapTransformedSourceType();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        List list3 = transformationSourceAttributes.getTransformationSourceAttributeType();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Object object22 : list3) {
            hashMap2.put(object22.getName(), object22);
        }
        TransformationSourceAttributes transformationSourceAttributes2 = new TransformationSourceAttributes();
        object22 = transformationSourceAttributes2.getTransformationSourceAttributeType();
        for (Object object3 : list2) {
            stringCollection2 = object3.getStringCollectionNames();
            stringCollection = new StringCollection();
            object = (MapTransformedSource)MetaDataHelper.copyMetadataObject(object3);
            for (String string : stringCollection2.getValue()) {
                AttributeType attributeType = map.get(string);
                TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)hashMap2.get(string);
                if (attributeType != null) {
                    if (string.equals(attributeType.getName()) && transformationSourceAttribute.getDataType().equals(attributeType.getDataType())) continue;
                    stringCollection.getValue().add(attributeType.getName());
                    continue;
                }
                stringCollection.getValue().add(string);
            }
            object.setStringCollectionNames(stringCollection);
            list.add(object);
        }
        for (Object object3 : list3) {
            stringCollection2 = map.get(object3.getName());
            stringCollection = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(object3);
            if (!(stringCollection2 == null || object3.getName().equals(stringCollection2.getName()) && object3.getDataType().equals(stringCollection2.getDataType()))) {
                object = object3.getName();
                stringCollection.setName(stringCollection2.getName());
                stringCollection.setDataType(stringCollection2.getDataType());
                hashMap.put((String)object, (AttributeType)stringCollection);
            }
            object22.add(stringCollection);
        }
        if (!hashMap.isEmpty()) {
            Object object3;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            object3 = new HashMap();
            object3.put("TransformationSourceAttributes", transformationSourceAttributes2);
            object3.put("TransformedAttributes", transformedAttributes);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_XFORM_SOURCE_COLUMNS, object3);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    public TransformationNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TRANSFORMATION_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TRANSFORMATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        transformationNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        transformationNodeType.setTransformedAttributes(transformedAttributes);
        transformationNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        SampleSettings sampleSettings = new SampleSettings();
        sampleSettings.setNumberOfRows(Long.valueOf(2000L));
        SampleSettings.Method method = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(12345L));
        method.setRandom(random);
        sampleSettings.setMethod(method);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        transformationNodeType.setSampleSettings(sampleSettings);
        DataProfileSettingsType dataProfileSettingsType = new DataProfileSettingsType();
        dataProfileSettingsType.setCategoricalBins(this.histogramPreferences.getNumberOfCategoricBins());
        dataProfileSettingsType.setNumericalBins(this.histogramPreferences.getNumberOfNumericBins());
        dataProfileSettingsType.setDateBins(this.histogramPreferences.getNumberOfDateBins());
        transformationNodeType.setDataProfileSettings(dataProfileSettingsType);
        StatsSelection statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        transformationNodeType.setStatsSelection(statsSelection);
        transformationNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getHelpTopic() {
        return "transform_node";
    }

    public Attributes getNonTransformedAttributes() {
        Attributes attributes = new Attributes();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        List list = transformationSourceAttributes.getTransformationSourceAttributeType();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            AttributeType attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, (AttributeType)transformationSourceAttribute);
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    @Override
    public Attributes getAttributes() {
        AttributeType attributeType;
        Object object2;
        Attributes attributes = new Attributes();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        for (Object object2 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!object2.isIsOutput()) continue;
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, (AttributeType)object2);
            attributes.getAttribute().add(attributeType);
        }
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        object2 = transformedAttributes.getMapTransformedSourceType();
        attributeType = object2.iterator();
        while (attributeType.hasNext()) {
            MapTransformedSource mapTransformedSource = (MapTransformedSource)attributeType.next();
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            if (!transformationOutputAttribute.isIsOutput()) continue;
            AttributeType attributeType2 = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType2, (AttributeType)transformationOutputAttribute);
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    public Attributes getTransformationSourceAttributes() {
        Attributes attributes = new Attributes();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!transformationSourceAttribute.isIsOutput()) continue;
            AttributeType attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, (AttributeType)transformationSourceAttribute);
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        String string;
        Object object;
        AttributeType attributeType2;
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list) {
            object = attributeType2.getAlias();
            string = object != null && ((String)object).trim().length() > 0 ? object : attributeType2.getName();
            hashMap.put(string, attributeType2);
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        attributeType2 = transformationNodeType.getTransformationSourceAttributes();
        if (attributeType2 == null) {
            attributeType2 = new TransformationSourceAttributes();
            transformationNodeType.setTransformationSourceAttributes((TransformationSourceAttributes)attributeType2);
        }
        if ((object = attributeType2.getTransformationSourceAttributeType()).isEmpty()) {
            TransformationNode.copyAttributes((List<TransformationSourceAttribute>)object, list);
            this.excecuteInputColumnsTxn((TransformationSourceAttributes)attributeType2, new Helper());
        } else {
            string = new TransformationSourceAttributes();
            AttributeTypeHelper.copyTransformationSourceAttributes(string.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            Map<String, AttributeStatus> map = this.buildDependentObjectStatusMap();
            this.validateInputAttributes();
            this.excecuteInputColumnsTxn(transformationNodeType.getTransformationSourceAttributes(), new Helper((TransformationSourceAttributes)string, map));
        }
        this.validate(true);
    }

    public static void copyAttributes(List<TransformationSourceAttribute> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            TransformationSourceAttribute transformationSourceAttribute = new TransformationSourceAttribute();
            transformationSourceAttribute.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            transformationSourceAttribute.setDataType(attributeType.getDataType());
            transformationSourceAttribute.setStatus(attributeType.getStatus());
            transformationSourceAttribute.setAnnotation(attributeType.getAnnotation());
            transformationSourceAttribute.setIsOutput(true);
            list.add(transformationSourceAttribute);
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    private void excecuteInputColumnsTxn(TransformationSourceAttributes transformationSourceAttributes, Helper helper) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(INPUT_COLUMNS, new Helper(transformationSourceAttributes, this.buildDependentObjectStatusMap()));
        complexProperty.setOldData(helper);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public void setNodeReady() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("status", NodeStatusType.READY);
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public Object getProperty(String string) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        HashMap<String, Object> hashMap = null;
        if (string.equals(INPUT_COLUMNS)) {
            hashMap = new Helper(transformationNodeType.getTransformationSourceAttributes(), this.buildDependentObjectStatusMap());
        } else if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            hashMap = AttributeTypeHelper.getAllColumns(transformationNodeType);
        } else if (string.equals("SQL_EXPRESSION")) {
            hashMap = this.getSQLExpression();
        } else if (string.equals(STATS_SELECTION)) {
            hashMap = transformationNodeType.getStatsSelection();
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            hashMap = transformationNodeType.getDataProfileSettings();
        } else if (string.equals(REFACTOR_XFORM_SOURCE_COLUMNS)) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("TransformationSourceAttributes", transformationNodeType.getTransformationSourceAttributes());
            hashMap2.put("TransformedAttributes", transformationNodeType.getTransformedAttributes());
            hashMap = hashMap2;
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            SampleSettings sampleSettings = transformationNodeType.getSampleSettings();
            hashMap = sampleSettings;
        } else {
            return super.getProperty(string);
        }
        return hashMap;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(EDIT_COLUMN) || complexProperty.getPropertyName().equals(OUTPUT_STATE) || complexProperty.getPropertyName().equals(EDIT_COLUMNS) || complexProperty.getPropertyName().equals(ADD_COLUMNS) || complexProperty.getPropertyName().equals(REMOVE_COLUMNS) || complexProperty.getPropertyName().equals(STATS_SELECTION) || complexProperty.getPropertyName().equals(INPUT_COLUMNS) || complexProperty.getPropertyName().equals(REFACTOR_XFORM_SOURCE_COLUMNS) || complexProperty.getPropertyName().equals(DATAPROFILE_SETTINGS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        if (string.equals(INPUT_COLUMNS)) {
            Helper helper = (Helper)object;
            transformationNodeType.setTransformationSourceAttributes(helper.newAttributes);
            if (helper.dependentObjectStatusMap.isEmpty()) {
                return;
            }
            for (MapTransformedSource mapTransformedSource : transformationNodeType.getTransformedAttributes().getMapTransformedSourceType()) {
                AttributeStatus attributeStatus = helper.dependentObjectStatusMap.get(mapTransformedSource.getKey().getName());
                if (attributeStatus == null) continue;
                mapTransformedSource.getKey().setStatus(attributeStatus);
            }
        } else if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            AttributeTypeHelper.TransformationNodeColumns transformationNodeColumns = (AttributeTypeHelper.TransformationNodeColumns)object;
            AttributeTypeHelper.copyTransformedAttributes(transformationNodeType.getTransformedAttributes(), transformationNodeColumns.getXformedAttributes());
            AttributeTypeHelper.copyTransformationSourceAttributes(transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), transformationNodeColumns.getXformSourceAttributes().getTransformationSourceAttributeType());
        } else if (string.equals(EDIT_COLUMN)) {
            List list;
            MapTransformedSource mapTransformedSource = (MapTransformedSource)object;
            TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
            if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
                for (MapTransformedSource mapTransformedSource2 : list) {
                    if (!mapTransformedSource2.getKey().getName().equals(mapTransformedSource.getKey().getName())) continue;
                    AttributeTypeHelper.copyMapTransformedSource(mapTransformedSource2, mapTransformedSource);
                    break;
                }
            }
        } else if (string.equals(OUTPUT_STATE)) {
            Object object2;
            Object object3;
            Map<String, Boolean> map = ConverterHelper.objectToMapStringBoolean(object);
            TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
            if (transformedAttributes != null && (object3 = transformedAttributes.getMapTransformedSourceType()) != null && !object3.isEmpty()) {
                TransformationSourceAttribute transformationSourceAttribute = object3.iterator();
                while (transformationSourceAttribute.hasNext()) {
                    object2 = (MapTransformedSource)transformationSourceAttribute.next();
                    Boolean bl = map.get(object2.getKey().getName());
                    if (null == bl) continue;
                    object2.getKey().setIsOutput(bl.booleanValue());
                }
            }
            for (TransformationSourceAttribute transformationSourceAttribute : transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                object2 = map.get(transformationSourceAttribute.getName());
                if (null == object2) continue;
                transformationSourceAttribute.setIsOutput(((Boolean)object2).booleanValue());
            }
        } else if (string.equals(EDIT_COLUMNS)) {
            TransformedAttributes transformedAttributes = (TransformedAttributes)object;
            transformationNodeType.setTransformedAttributes(transformedAttributes);
        } else if (string.equals(REMOVE_COLUMNS) || string.equals(ADD_COLUMNS)) {
            TransformedAttributes transformedAttributes = (TransformedAttributes)object;
            transformationNodeType.setTransformedAttributes(transformedAttributes);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            DataProfileSettingsType dataProfileSettingsType = (DataProfileSettingsType)object;
            transformationNodeType.setDataProfileSettings(dataProfileSettingsType);
        } else if (string.equals("metadata")) {
            super.setProperty(string, object);
            transformationNodeType = (TransformationNodeType)this.getData();
            transformationNodeType.setInputStatisticTable(null);
        } else if (string.equals(STATS_SELECTION)) {
            StatsSelection statsSelection = (StatsSelection)object;
            transformationNodeType.setStatsSelection(statsSelection);
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                transformationNodeType.setSampleSettings((SampleSettings)object);
            }
        } else if (string.equals(REFACTOR_XFORM_SOURCE_COLUMNS)) {
            Map map = (Map)object;
            TransformationSourceAttributes transformationSourceAttributes = (TransformationSourceAttributes)map.get("TransformationSourceAttributes");
            transformationNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
            TransformedAttributes transformedAttributes = (TransformedAttributes)map.get("TransformedAttributes");
            transformationNodeType.setTransformedAttributes(transformedAttributes);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        List list;
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n" + (TransformationNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        if (transformationSourceAttributes != null && (list = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n");
                }
                String string = null;
                string = !StringUtils.isDoubleQuotedString(((TransformationSourceAttribute)list.get(i)).getName()) ? "\"" + ((TransformationSourceAttribute)list.get(i)).getName() + "\"" : ((TransformationSourceAttribute)list.get(i)).getName();
                stringBuilder.append(string);
                String string2 = ((TransformationSourceAttribute)list.get(i)).getAlias();
                if (string2 == null || string2.isEmpty()) continue;
                if (!StringUtils.isDoubleQuotedString(string2)) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuilder.append(" AS ");
                stringBuilder.append(string2);
            }
        }
        stringBuilder.append(" FROM {INPUT_SOURCE}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        TransformationSourceAttributes transformationSourceAttributes;
        boolean bl2 = super.validate(bl);
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        if (dataProfileSettingsType.getCategoricalBins() <= 0 || dataProfileSettingsType.getNumericalBins() <= 0 || dataProfileSettingsType.getDateBins() <= 0) {
            bl2 = false;
            this.addMessage("DATAPROFILE_SETTINGS_INVALID", MessageEnumType.ERROR, new String[0]);
        }
        if (bl2 && (null == (transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes()) || null == transformationSourceAttributes.getTransformationSourceAttributeType() || transformationSourceAttributes.getTransformationSourceAttributeType().isEmpty())) {
            Attributes attributes;
            List list;
            Object object2;
            bl2 = false;
            object = transformationSourceAttributes.getTransformationSourceAttributeType();
            if (object.isEmpty() && (object2 = this.findParentNode()) != null && !(list = (attributes = ((DataProvider)object2).getAttributes()).getAttribute()).isEmpty()) {
                TransformationNode.copyAttributes((List<TransformationSourceAttribute>)object, list);
                this.excecuteInputColumnsTxn(transformationSourceAttributes, new Helper());
                bl2 = true;
            }
            if (!bl2) {
                this.addMessage("TRANSFORM_NODE_SOURCE_COLUMNS_MISSING", MessageEnumType.INCOMPLETE, new String[0]);
            }
        }
        if (bl2) {
            transformationSourceAttributes = new TransformationSourceAttributes();
            AttributeTypeHelper.copyTransformationSourceAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            object = this.buildDependentObjectStatusMap();
            this.validateInputAttributes();
            this.excecuteInputColumnsTxn(transformationNodeType.getTransformationSourceAttributes(), new Helper(transformationSourceAttributes, (Map<String, AttributeStatus>)object));
            for (Attributes attributes : transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                if (attributes.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl2 = false;
                this.addMessage("TRANSFORM_NODE_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    private Map<String, AttributeStatus> buildDependentObjectStatusMap() {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        HashMap<String, AttributeStatus> hashMap = new HashMap<String, AttributeStatus>();
        for (MapTransformedSource mapTransformedSource : transformationNodeType.getTransformedAttributes().getMapTransformedSourceType()) {
            hashMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource.getKey().getStatus());
        }
        return hashMap;
    }

    private boolean validateInputAttributes() {
        Object object;
        Object object22;
        Object object32;
        boolean bl = true;
        AbstractNode abstractNode = this.findParentNode();
        boolean bl2 = SQLHelper.isExtendedTypeEnabled(this.getContext());
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        List list = transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        for (Object object32 : list) {
            DatabaseMetadataUtils.convertExtendedTypes((AttributeType)object32, bl2);
        }
        Attributes attributes = null;
        object32 = (DataProvider)((Object)abstractNode);
        if (object32 != null) {
            attributes = object32.getAttributes();
        }
        List list2 = attributes != null ? attributes.getAttribute() : new ArrayList();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object22 : list2) {
            object = object22.getAlias();
            String string = object != null && ((String)object).trim().length() > 0 ? object : object22.getName();
            hashMap.put(string, object22);
        }
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        object22 = new ArrayList();
        for (String string : list) {
            AttributeType attributeType = (AttributeType)hashMap.get(string.getName());
            if (null == attributeType) {
                if (!this.isColumnUsedForTransformations(transformedAttributes, (TransformationSourceAttribute)string)) {
                    object22.add(string);
                    continue;
                }
                string.setStatus(AttributeStatus.MISSING);
                continue;
            }
            if (!AttributeTypeHelper.areCompatibleTypes(attributeType.getDataType(), string.getDataType())) {
                string.setStatus(AttributeStatus.INVALID);
                continue;
            }
            string.setStatus(attributeType.getStatus());
            this.isColumnUsedForTransformations(transformedAttributes, (TransformationSourceAttribute)string);
            hashMap.remove(string.getName());
        }
        if (!object22.isEmpty()) {
            this.removeMissingColumns((List<TransformationSourceAttribute>)object22);
        }
        object = new ArrayList<AttributeType>(hashMap.values());
        TransformationNode.copyAttributes(list, object);
        return bl;
    }

    private boolean isColumnUsedForTransformations(TransformedAttributes transformedAttributes, TransformationSourceAttribute transformationSourceAttribute) {
        boolean bl = false;
        for (MapTransformedSource mapTransformedSource : transformedAttributes.getMapTransformedSourceType()) {
            if (TransformationTypes.isCustomXform(mapTransformedSource.getKey().getTransformationElementType())) {
                if (-1 == mapTransformedSource.getKey().getTransformationElementType().getCustomTransformation().getValue().indexOf(transformationSourceAttribute.getName())) continue;
                bl = true;
                mapTransformedSource.getKey().setStatus(transformationSourceAttribute.getStatus());
                continue;
            }
            StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
            for (String string : stringCollection.getValue()) {
                if (!string.equals(transformationSourceAttribute.getName())) continue;
                bl = true;
                mapTransformedSource.getKey().setStatus(transformationSourceAttribute.getStatus());
            }
        }
        return bl;
    }

    private void removeMissingColumns(List<TransformationSourceAttribute> list) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        List list2 = transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>(list2.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)hashMap.get(transformationSourceAttribute.getName());
            list2.remove(transformationSourceAttribute2);
        }
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() == NodeStatusType.COMPLETE || this.getData().getStatus() == NodeStatusType.WARNING;
        return bl;
    }

    private class Helper {
        TransformationSourceAttributes newAttributes;
        Map<String, AttributeStatus> dependentObjectStatusMap;

        Helper() {
            this.newAttributes = new TransformationSourceAttributes();
            this.dependentObjectStatusMap = new HashMap<String, AttributeStatus>();
        }

        Helper(TransformationSourceAttributes transformationSourceAttributes, Map<String, AttributeStatus> map) {
            this.newAttributes = transformationSourceAttributes;
            this.dependentObjectStatusMap = map;
        }
    }
}

