/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvAbstractSDMModel;
import ilog.views.sdm.model.IlvSDMNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Link;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.model.WorkflowRunStateAdapter;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GeneralLinkType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LinkType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public final class WorkflowModel
extends IlvAbstractSDMModel {
    private static final Logger theLogger = Logger.getLogger(WorkflowModel.class.getName());
    private WorkflowProcess jaxbTopLevel;
    private LinkedHashMap<String, IlvSDMNode> diagramObjectStore;
    private List<GeneralLinkType> jaxbLinkStore;
    private HashMap<String, List<? extends NodeType>> jaxbNodeStore;
    private Map<String, String> refactoredModelNames;
    private Map<String, String> refactoredTableNames;
    private boolean isRefactoring;
    private Context context;
    private WorkflowRunStateAdapter runStateAdapter;
    private String COMMENT = "comment";
    private boolean inPaste = false;
    private static final long ID_BASE = 10000L;
    private long maxId = 10000L;

    public WorkflowModel() {
        this.setEditable(true);
        this.isRefactoring = false;
        this.refactoredModelNames = null;
        this.refactoredTableNames = null;
    }

    public IlvSDMNode getObject(String string) {
        IlvSDMNode ilvSDMNode = null;
        for (IlvSDMNode ilvSDMNode2 : this.diagramObjectStore.values()) {
            if (!string.equals(ilvSDMNode2.getID())) continue;
            ilvSDMNode = ilvSDMNode2;
            break;
        }
        return ilvSDMNode;
    }

    public void setRunStateAdapter(WorkflowRunStateAdapter workflowRunStateAdapter) {
        this.runStateAdapter = workflowRunStateAdapter;
    }

    public void unsetRunStateAdapter() {
        this.runStateAdapter = null;
    }

    public WorkflowRunStateAdapter getRunStateAdapter() {
        return this.runStateAdapter;
    }

    public void load(WorkflowProcess workflowProcess, Context context, boolean bl, StringBuffer stringBuffer) throws Exception {
        this.context = context;
        this.jaxbTopLevel = workflowProcess;
        this.diagramObjectStore = new LinkedHashMap();
        this.loadNodeStore();
        this.loadLinkStore();
        Collection<List<? extends NodeType>> collection = this.jaxbNodeStore.values();
        for (List<? extends NodeType> linkType : collection) {
            for (Object object : linkType) {
                AbstractNode abstractNode = AbstractNode.createNode(object, this.context);
                if (bl && stringBuffer != null) {
                    StringBuffer stringBuffer2 = new StringBuffer("");
                    try {
                        if (!abstractNode.isVersionSupported(this.context, stringBuffer2)) {
                            String string = " " + abstractNode.getDefaultName() + ": " + abstractNode.getData().getName() + " (" + stringBuffer2 + ") ";
                            stringBuffer.append(string + "\n");
                        }
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage());
                        stringBuffer.append(exception.getMessage());
                    }
                }
                this.loadObject((IlvSDMNode)abstractNode, object.getId());
            }
        }
        for (LinkType linkType : this.jaxbLinkStore) {
            Object object;
            AbstractNode abstractNode = (AbstractNode)this.diagramObjectStore.get(linkType.getTo());
            object = (AbstractNode)this.diagramObjectStore.get(linkType.getFrom());
            assert (abstractNode != null);
            assert (object != null);
            this.loadObject((IlvSDMNode)GeneralLink.createLink(linkType, abstractNode, (AbstractNode)object, this.context), linkType.getId());
        }
    }

    public void load(WorkflowProcess workflowProcess, Context context) throws Exception {
        this.load(workflowProcess, context, false, null);
    }

    private void loadLinkStore() {
        this.jaxbLinkStore = this.jaxbTopLevel.getLinks().getLink();
    }

    private void loadObject(IlvSDMNode ilvSDMNode, String string) {
        long l;
        List<ModelType> list;
        AbstractNode abstractNode;
        long l2 = Long.valueOf(string);
        this.updateMaxId(l2);
        if (ilvSDMNode.getID() == null) {
            this.setID(ilvSDMNode, AbstractNode.createNodeId());
        }
        this.diagramObjectStore.put(string, ilvSDMNode);
        if (ilvSDMNode instanceof AbstractBuildNode) {
            abstractNode = (AbstractBuildNode)ilvSDMNode;
            list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractNode.getData());
            for (ModelType modelType : list) {
                l = Long.valueOf(modelType.getId());
                this.updateMaxId(l);
            }
        }
        if (ilvSDMNode instanceof BuildTextNode) {
            abstractNode = (BuildTextNode)ilvSDMNode;
            list = MetaDataHelper.getStoplistsCollection((BuildTextNodeType)abstractNode.getData());
            for (ModelType modelType : list) {
                l = Long.valueOf(modelType.getId());
                this.updateMaxId(l);
            }
        }
    }

    private void loadNodeStore() {
        this.jaxbNodeStore = MetaDataHelper.getNodeCollectionMap(this.jaxbTopLevel);
    }

    public void refresh() {
        try {
            this.load(this.jaxbTopLevel, this.context);
            this.fireDataChanged(null);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void updateMaxId(long l) {
        if (this.maxId < l) {
            this.maxId = l;
        }
    }

    private long getNextNewId() {
        ++this.maxId;
        return this.maxId;
    }

    public String getNextNewIdString() {
        long l = this.getNextNewId();
        return Long.toString(l);
    }

    public Enumeration getObjects() {
        if (this.diagramObjectStore == null) {
            return null;
        }
        Vector<IlvSDMNode> vector = new Vector<IlvSDMNode>(this.diagramObjectStore.values());
        return vector.elements();
    }

    public Object createNode(String string) {
        Object object = super.createNode(string);
        return object;
    }

    public Object createLink(String string) {
        Object object = super.createLink(string);
        return object;
    }

    public void addObjectImpl(Object object, Object object2, Object object3) {
        Object object4;
        if (object instanceof AbstractNode) {
            object4 = (AbstractNode)object;
            NodeType nodeType = ((AbstractNode)object4).getData();
            if (((AbstractObject)object4).getID() == null) {
                this.setID(object4, AbstractObject.createNodeId());
            }
            List<? extends NodeType> list = this.jaxbNodeStore.get(nodeType.getClass().getName());
            list.add((NodeType)nodeType);
            this.diagramObjectStore.put(((AbstractNode)object4).getMetadataId(), (IlvSDMNode)object);
        } else {
            CommandProcessor commandProcessor;
            assert (object instanceof GeneralLink);
            object4 = (GeneralLink)object;
            LinkType linkType = ((GeneralLink)object4).getData();
            if (((AbstractObject)object4).getID() == null) {
                this.setID(object4, AbstractObject.createNodeId());
            }
            AbstractNode abstractNode = (AbstractNode)((GeneralLink)object4).getFrom();
            AbstractNode abstractNode2 = (AbstractNode)((GeneralLink)object4).getTo();
            this.jaxbLinkStore.add((GeneralLinkType)linkType);
            this.diagramObjectStore.put(((GeneralLink)object4).getMetadataId(), (IlvSDMNode)object);
            if (abstractNode2 != null && abstractNode != null && (commandProcessor = CommandProcessor.getInstance()).isTransactionActive()) {
                abstractNode2.handleNewConnectionFrom(abstractNode);
            }
        }
        this.fireObjectAdded(object);
        object4 = object;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (object4 instanceof AbstractNode) {
                    AbstractNode abstractNode = (AbstractNode)object4;
                    abstractNode.addPropertyChangeListener(abstractNode.getEngine());
                }
            }
        });
    }

    public void removeObject(Object object) {
        if (object instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)object;
            NodeType nodeType = abstractNode.getData();
            List<? extends NodeType> list = this.jaxbNodeStore.get(nodeType.getClass().getName());
            list.remove(nodeType);
            this.diagramObjectStore.remove(abstractNode.getMetadataId());
        } else {
            CommandProcessor commandProcessor;
            assert (object instanceof GeneralLink);
            GeneralLink generalLink = (GeneralLink)object;
            LinkType linkType = generalLink.getData();
            this.jaxbLinkStore.remove(linkType);
            this.diagramObjectStore.remove(generalLink.getMetadataId());
            AbstractNode abstractNode = (AbstractNode)generalLink.getFrom();
            AbstractNode abstractNode2 = (AbstractNode)generalLink.getTo();
            if (abstractNode2 != null && abstractNode != null && (commandProcessor = CommandProcessor.getInstance()).isTransactionActive()) {
                abstractNode2.handleRemoveConnectionFrom(abstractNode);
            }
        }
        super.removeObject(object);
        this.fireObjectRemoved(object);
    }

    protected void setIDImpl(Object object, String string) {
        assert (object instanceof AbstractObject);
        AbstractObject abstractObject = (AbstractObject)object;
        abstractObject.setID(string);
    }

    protected String getIDImpl(Object object) {
        assert (object instanceof AbstractObject);
        AbstractObject abstractObject = (AbstractObject)object;
        return abstractObject.getID();
    }

    public String allocID(String string) {
        return AbstractNode.createNodeId();
    }

    public void setTo(Object object, Object object2) {
        LinkType linkType = ((Link)object).getData();
        linkType.setTo(((AbstractNode)object2).getMetadataId());
        super.setTo(object, object2);
    }

    public void setFrom(Object object, Object object2) {
        LinkType linkType = ((Link)object).getData();
        linkType.setFrom(((AbstractNode)object2).getMetadataId());
        super.setFrom(object, object2);
    }

    public void replacedMetaData(NodeType nodeType, NodeType nodeType2) {
        List<? extends NodeType> list = this.jaxbNodeStore.get(nodeType2.getClass().getName());
        if (list.indexOf(nodeType2) == -1) {
            theLogger.log(Level.WARNING, "replaceMetaData - no such element");
            return;
        }
        list.remove(nodeType2);
        list.add((NodeType)nodeType);
    }

    public void replacedMetaData(LinkType linkType, LinkType linkType2) {
        List<GeneralLinkType> list = this.jaxbLinkStore;
        if (list.indexOf(linkType2) == -1) {
            theLogger.log(Level.WARNING, "replaceMetaData - no such element");
            return;
        }
        list.remove(linkType2);
        list.add((GeneralLinkType)linkType);
    }

    public Map<String, ModelType> getAllMiningModels() {
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        Collection<IlvSDMNode> collection = this.diagramObjectStore.values();
        for (IlvSDMNode ilvSDMNode : collection) {
            if (!(ilvSDMNode instanceof AbstractBuildNode)) continue;
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)ilvSDMNode;
            List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
            for (ModelType modelType : list) {
                hashMap.put(modelType.getName(), modelType);
            }
        }
        return hashMap;
    }

    public boolean isDuplicateBuildModelName(String string) {
        boolean bl = false;
        boolean bl2 = false;
        Collection<IlvSDMNode> collection = this.diagramObjectStore.values();
        for (IlvSDMNode ilvSDMNode : collection) {
            if (ilvSDMNode instanceof AbstractBuildNode) {
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)ilvSDMNode;
                List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
                for (ModelType modelType : list) {
                    if (!modelType.getName().equals(string)) continue;
                    if (bl) {
                        bl2 = true;
                        break;
                    }
                    bl = true;
                }
            }
            if (!bl2) continue;
            break;
        }
        return bl2;
    }

    public Collection<Object> getObjectsCollection() {
        Collection<IlvSDMNode> collection = this.diagramObjectStore.values();
        List<Object> list = Arrays.asList(collection.toArray());
        return list;
    }

    public List<String> getAllOutputTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<IlvSDMNode> collection = this.diagramObjectStore.values();
        for (IlvSDMNode ilvSDMNode : collection) {
            CreateTableNodeType createTableNodeType;
            Object object;
            if (ilvSDMNode instanceof CreateTableNode) {
                object = (CreateTableNode)ilvSDMNode;
                createTableNodeType = (CreateTableNodeType)((AbstractNode)object).getData();
                arrayList.add(createTableNodeType.getTableName());
                continue;
            }
            if (ilvSDMNode instanceof UpdateTableNode) {
                object = (UpdateTableNode)ilvSDMNode;
                createTableNodeType = (UpdateTableNodeType)((AbstractNode)object).getData();
                if (null == createTableNodeType.getUpdateTargetTable()) continue;
                arrayList.add(createTableNodeType.getUpdateTargetTable().getName());
                continue;
            }
            if (ilvSDMNode instanceof DataProfileNode) {
                object = (DataProfileNode)ilvSDMNode;
                createTableNodeType = (DataProfileNodeType)((AbstractNode)object).getData();
                arrayList.add(createTableNodeType.getStatisticTable().getName());
                continue;
            }
            if (ilvSDMNode instanceof SQLQueryNode) {
                object = (SQLQueryNode)ilvSDMNode;
                createTableNodeType = (SQLQueryNodeType)((AbstractNode)object).getData();
                arrayList.add(createTableNodeType.getViewName());
                continue;
            }
            if (ilvSDMNode instanceof DataProvider) {
                object = (DataProvider)ilvSDMNode;
                if (object.getCacheTableName() == null) continue;
                arrayList.add(object.getCacheTableName());
                continue;
            }
            if (!(ilvSDMNode instanceof GraphNode) || null == (createTableNodeType = (GraphNodeType)((AbstractNode)(object = (GraphNode)ilvSDMNode)).getData()).getViewName()) continue;
            arrayList.add(createTableNodeType.getViewName());
        }
        return arrayList;
    }

    public Map<String, StoplistType> getAllStoplists() {
        return MetaDataHelper.getStoplistsCollection(this.jaxbTopLevel);
    }

    public List<GeneralLink> findLinksToNode(IlvSDMNode ilvSDMNode) {
        ArrayList<GeneralLink> arrayList = new ArrayList<GeneralLink>();
        for (IlvSDMNode ilvSDMNode2 : this.diagramObjectStore.values()) {
            GeneralLink generalLink;
            if (!(ilvSDMNode2 instanceof GeneralLink) || (generalLink = (GeneralLink)ilvSDMNode2).getTo() == null || !generalLink.getTo().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(generalLink);
        }
        return arrayList;
    }

    public List<GeneralLink> findLinksFromNode(IlvSDMNode ilvSDMNode) {
        ArrayList<GeneralLink> arrayList = new ArrayList<GeneralLink>();
        for (IlvSDMNode ilvSDMNode2 : this.diagramObjectStore.values()) {
            GeneralLink generalLink;
            if (!(ilvSDMNode2 instanceof GeneralLink) || (generalLink = (GeneralLink)ilvSDMNode2).getFrom() == null || !generalLink.getFrom().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(generalLink);
        }
        return arrayList;
    }

    public String generateNextDistinctName(String string) {
        String string2 = string;
        while (this.findNodeByName(string2) != null) {
            if ((string2 = this.incrementNumberSuffix(string2)).length() <= 30) continue;
            string2 = this.incrementNumberSuffix(string2.substring(0, 25));
        }
        return string2;
    }

    private String incrementNumberSuffix(String string) {
        char c;
        int n;
        String string2 = "";
        String string3 = "";
        int n2 = string.length();
        for (n = 0; n < n2 - 1 && Character.isDigit(c = string.charAt(n2 - 1 - n)); ++n) {
            string3 = c + string3;
        }
        if (string3.length() > 0) {
            string2 = string.substring(0, n2 - 1 - n);
            string2 = string2 + " " + (Long.parseLong(string3) + 1L);
        } else {
            string2 = string + " 1";
        }
        return string2;
    }

    public Node findNodeByName(String string) {
        for (IlvSDMNode ilvSDMNode : this.diagramObjectStore.values()) {
            Node node;
            String string2;
            if (!(ilvSDMNode instanceof Node) || (string2 = (node = (Node)ilvSDMNode).getData().getName()) == null || !string2.equals(string)) continue;
            return node;
        }
        return null;
    }

    public IlvSDMNode findNodeByMetadataId(String string) {
        IlvSDMNode ilvSDMNode = null;
        for (IlvSDMNode ilvSDMNode2 : this.diagramObjectStore.values()) {
            Node node;
            if (!(ilvSDMNode2 instanceof Node) || !(node = (Node)ilvSDMNode2).getMetadataId().equals(string)) continue;
            ilvSDMNode = ilvSDMNode2;
            break;
        }
        return ilvSDMNode;
    }

    public void clear() {
        this.jaxbNodeStore.clear();
        this.jaxbLinkStore.clear();
        this.diagramObjectStore.clear();
    }

    public Context getContext() {
        return this.context;
    }

    public boolean doesNodeNameAlreadyExist(String string) {
        boolean bl = false;
        Collection<List<? extends NodeType>> collection = this.jaxbNodeStore.values();
        for (List<? extends NodeType> list : collection) {
            for (NodeType nodeType : list) {
                if (nodeType.getName().compareTo(string) != 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }

    public WorkflowProcess getDocumentObject() {
        return this.jaxbTopLevel;
    }

    public Object getObjectProperty(Object object, String string) {
        if (object instanceof WorkflowProcess) {
            if (string.compareToIgnoreCase(this.COMMENT) == 0) {
                return this.getDocumentObject().getComment();
            }
            return super.getObjectProperty(object, string);
        }
        return super.getObjectProperty(object, string);
    }

    public void setObjectProperty(Object object, String string, Object object2) {
        if (object instanceof WorkflowProcess) {
            if (string.compareToIgnoreCase(this.COMMENT) == 0) {
                this.getDocumentObject().setComment((String)object2);
            } else {
                super.setObjectProperty(object, string, object2);
            }
        } else {
            super.setObjectProperty(object, string, object2);
        }
    }

    public void setInPaste(boolean bl) {
        this.inPaste = bl;
    }

    public boolean isInPaste() {
        return this.inPaste;
    }

    public void initOldNodeIds() {
        Collection<IlvSDMNode> collection = this.diagramObjectStore.values();
        for (IlvSDMNode ilvSDMNode : collection) {
            if (!(ilvSDMNode instanceof AbstractNode)) continue;
            AbstractNode abstractNode = (AbstractNode)ilvSDMNode;
            abstractNode.setOldId(abstractNode.getMetadataId());
        }
    }

    public boolean isRefactoring() {
        return this.isRefactoring;
    }

    public void beginRefactoring() {
        if (this.isRefactoring) {
            throw new InvalidRefactoringState("Invalid Refactoring State - refactor already in progress");
        }
        this.isRefactoring = true;
        this.refactoredModelNames = new HashMap<String, String>();
        this.refactoredTableNames = new HashMap<String, String>();
    }

    public void endRefactoring() {
        if (!this.isRefactoring) {
            throw new InvalidRefactoringState("Invalid Refactoring State - refactor not in progress");
        }
        this.isRefactoring = false;
        this.refactoredModelNames.clear();
        this.refactoredTableNames.clear();
        this.refactoredModelNames = null;
        this.refactoredTableNames = null;
    }

    public Map<String, String> getRefactoredModelNames() {
        return this.refactoredModelNames;
    }

    public Map<String, String> getRefactoredTableNames() {
        return this.refactoredTableNames;
    }

    public void addRefactoredModelName(String string, String string2) {
        if (!this.isRefactoring) {
            throw new InvalidRefactoringState("Inconsistent state - model is not in refactoring mode");
        }
        this.refactoredModelNames.put(string, string2);
    }

    public void addRefactoredTableName(String string, String string2) {
        if (!this.isRefactoring) {
            throw new InvalidRefactoringState("Inconsistent state - model is not in refactoring mode");
        }
        this.refactoredTableNames.put(string, string2);
    }

    public class InvalidRefactoringState
    extends RuntimeException {
        public InvalidRefactoringState(String string) {
            super(string);
        }
    }
}

