/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.WorkflowParallelDegreeDialog;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ParallelismType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ORAData;

public class ParallelTablePanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private ParallelQueryPreferences parallelQueryPreferences;
    private static final Logger theLogger = Logger.getLogger(ParallelTablePanel.class.getName());
    final String SYSTEM_DETERMINED = WorkflowEditorLrb.get("PARALLEL_VALUE_SYSTEM_DETERMINED");
    private HashMap<String, AbstractNode> metadata;
    private WorkflowModel model;
    private boolean isPreferencePanel = false;
    private WorkflowNode wfNode;
    private WorkflowEditor workflowEditor;
    private List<AbstractNode> selectedNodes;
    private Context context;
    private DataMinerTablePanel dataMinerTablePanel1 = new DataMinerTablePanel();

    public ParallelTablePanel() {
        this.setLayout(new BorderLayout());
        this.add(this.dataMinerTablePanel1);
        this.isPreferencePanel = true;
        this.setHelpID("preferences_para");
    }

    public ParallelTablePanel(Context context, List<AbstractNode> list) {
        this.selectedNodes = list;
        this.setLayout(new BorderLayout());
        this.add(this.dataMinerTablePanel1);
        this.dataMinerTablePanel1.setSize(this.dataMinerTablePanel1.getParent().getWidth(), this.dataMinerTablePanel1.getParent().getHeight());
        this.isPreferencePanel = false;
        this.model = ((WorkflowNode)context.getNode()).getWorkflowModel();
        this.wfNode = (WorkflowNode)context.getNode();
        this.workflowEditor = (WorkflowEditor)context.getView();
        this.context = context;
        this.initUI();
        this.setHelpID("parallel_settings");
    }

    private void initComponents() {
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, GroupLayout.Alignment.TRAILING, -1, 750, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel1, -2, 205, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        int n = 35;
        boolean bl = this.isPreferencePanel || !this.wfNode.isReadOnly();
        final JButton jButton = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_ON"));
        jButton.setEnabled(bl);
        jButton.setToolTipText(WorkflowEditorLrb.get("PARALLEL_QUERY_ENABLE"));
        final JButton jButton2 = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_OFF"));
        jButton2.setToolTipText(WorkflowEditorLrb.get("PARALLEL_QUERY_DISABLED"));
        jButton2.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelTablePanel.this.setParallelValues(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelTablePanel.this.setParallelValues(false);
            }
        });
        final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
        dropDownMenuButton.setEnabled(bl);
        dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.GEAR_ICON));
        dropDownMenuButton.setToolTipText(WorkflowEditorLrb.get("PARALLEL_NODE_PREFERENCES"));
        dropDownMenuButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_PREFERENCE_LAUNCH")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String[] stringArray = new String[]{PreferencesLrb.get("DATA_MINER_PREFERENCES_KEY"), PreferencesLrb.get("NODE_SETTINGS_PREFERENCES_KEY"), PreferencesLrb.get("PARALLEL_QUERY_PREFERENCES_KEY")};
                            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                        }
                    });
                    dropDownMenuButton.addPopupItem((Action)new AbstractAction(WorkflowEditorLrb.get("PARALLEL_APPLY_DEFAULT_PREFERENCES")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ParallelTablePanel.this.initNonPreferenceTableDefault();
                        }
                    });
                } else if (itemEvent.getStateChange() == 2) {
                    dropDownMenuButton.removeAllPopupItems();
                }
            }
        });
        final JButton jButton3 = new JButton();
        jButton3.setEnabled(bl);
        jButton3.setToolTipText(WorkflowEditorLrb.get("PARALLEL_SETTING"));
        jButton3.setIcon(OracleIcons.getIcon((String)"edit.png"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = WorkflowEditorLrb.get("NODE_PARALLEL_DEGREE_DIALOG_TITLE");
                WorkflowParallelDegreeDialog workflowParallelDegreeDialog = new WorkflowParallelDegreeDialog(ParallelTablePanel.this, string);
                workflowParallelDegreeDialog.invoke((Component)((Object)ParallelTablePanel.this));
            }
        });
        if (this.isPreferencePanel) {
            this.dataMinerTablePanel1.addControlBarComponents(jButton, jButton2, jButton3);
        } else {
            this.dataMinerTablePanel1.addControlBarComponents(new Component[]{jButton3, dropDownMenuButton});
            this.dataMinerTablePanel1.addControlBarComponents(jButton, jButton2);
        }
        jButton.setPreferredSize(new Dimension(n, jButton.getHeight()));
        jButton2.setPreferredSize(new Dimension(n, jButton2.getHeight()));
        this.initTable(this.isPreferencePanel);
        if (this.getTable().getSelectedRowCount() <= 0) {
            jButton3.setEnabled(false);
        } else {
            jButton3.setEnabled(true);
        }
        int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        this.getTable().getColumnModel().getColumn(n2).setMaxWidth(150);
        this.getTable().setEnabled(bl);
        this.getTable().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("rowSorter")) {
                    int n = ParallelTablePanel.this.dataMinerTablePanel1.getTable().getRowCount();
                    if (n <= 0) {
                        jButton.setEnabled(false);
                        jButton2.setEnabled(false);
                        jButton3.setEnabled(false);
                        dropDownMenuButton.setEnabled(false);
                    } else {
                        jButton.setEnabled(true);
                        jButton2.setEnabled(true);
                        dropDownMenuButton.setEnabled(true);
                        if (ParallelTablePanel.this.dataMinerTablePanel1.getTable().getSelectedRowCount() <= 0) {
                            jButton3.setEnabled(false);
                        } else {
                            jButton3.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ParallelTablePanel.this.dataMinerTablePanel1.getTable().getSelectedRowCount() > 0) {
                    jButton3.setEnabled(true);
                } else {
                    jButton3.setEnabled(false);
                }
            }
        });
    }

    public void setParallelEnable(boolean bl) {
        this.setParallelEnable(bl, this.getTable().getSelectedRows());
    }

    public void setDegreeValue(String string) {
        this.setDegreeValues(string, this.getTable().getSelectedRows());
    }

    private void setParallelEnable(boolean bl, int[] nArray) {
        if (nArray.length > 0) {
            int n = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(bl, nArray[i], n);
            }
        }
    }

    private void setDegreeValues(String string, int[] nArray) {
        if (nArray.length > 0) {
            int n = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
            for (int i = 0; i < nArray.length; ++i) {
                this.getTable().setValueAt(string, nArray[i], n);
            }
        }
    }

    private void setParallelValues(boolean bl) {
        int n = this.getTable().getModel().getRowCount();
        int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        for (int i = 0; i < n; ++i) {
            this.getTable().setValueAt(bl, i, n2);
        }
    }

    private void setParallelValues(boolean bl, int[] nArray) {
        if (nArray.length >= 1) {
            int n = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
            for (int i = 0; i <= nArray.length; ++i) {
                this.getTable().setValueAt(bl, nArray[i], n);
            }
        }
    }

    public DataMinerTable getTable() {
        return this.dataMinerTablePanel1.getTable();
    }

    public void updateToolBarTitle(int n, int n2) {
        this.dataMinerTablePanel1.setTitle(MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_TITLE_BAR"), n, n2));
    }

    private void initTable(boolean bl) {
        if (bl) {
            this.initPreferenceTable();
        } else {
            this.initNonPreferenceTable();
        }
    }

    private void savePreferences() {
        int n = this.getTable().getModel().getRowCount();
        int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_TYPE_COLUMN"));
        int n3 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        int n4 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
        HashMap<String, String> hashMap = this.reverseHash(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n; ++i) {
            String string = this.getTable().getModel().getValueAt(i, n2).toString();
            String string2 = String.valueOf(this.getTable().getModel().getValueAt(i, n3));
            String string3 = this.getTable().getModel().getValueAt(i, n4).toString();
            String string4 = hashMap.get(string);
            this.parallelQueryPreferences.setProperty(string4, ParallelQueryPreferences.PROPERTY.IS_PARALLEL, string2);
            this.parallelQueryPreferences.setProperty(string4, ParallelQueryPreferences.PROPERTY.VALUE, string3);
        }
    }

    private HashMap<String, String> reverseHash(HashMap<String, String> hashMap) {
        Iterator<String> iterator = hashMap.keySet().iterator();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            hashMap2.put(hashMap.get(string), string);
        }
        return hashMap2;
    }

    private void initPreferenceTable() {
        Vector<String> vector = new Vector<String>();
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_TYPE_COLUMN"));
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = 0;
        WorkflowProcess workflowProcess = new WorkflowProcess();
        workflowProcess.setNodes(new WorkflowProcess.Nodes());
        HashMap<String, String> hashMap = MetaDataHelper.getNodeTypeNameMap();
        HashMap<String, String> hashMap2 = MetaDataHelper.getNodeTypeParallelExcluded();
        Iterator<String> iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Vector<Object> vector3 = new Vector<Object>();
            String string = iterator.next();
            if (hashMap2.containsKey(string)) {
                ++n2;
                continue;
            }
            String string2 = hashMap.get(string);
            vector3.add(string2);
            String string3 = this.parallelQueryPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            if (string3 != null && string3.equals("true")) {
                ++n;
                vector3.add(true);
            } else {
                vector3.add(false);
            }
            String string4 = this.parallelQueryPreferences.getProperty(string, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string4 != null) {
                vector3.add(string4);
            } else {
                vector3.add(this.SYSTEM_DETERMINED);
            }
            vector2.add(vector3);
        }
        this.dataMinerTablePanel1.setup((TableModel)new ParallelTableModel(vector2, vector, vector2.size() - n2, n), null, new String[]{WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_TYPE_COLUMN")}, 0);
        this.dataMinerTablePanel1.getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector2.size());
    }

    private void initNonPreferenceTableDefault() {
        if (this.parallelQueryPreferences == null) {
            this.parallelQueryPreferences = ParallelQueryPreferences.getInstance();
        }
        int n = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
        int n3 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_TYPE_COLUMN"));
        int n4 = 0;
        int n5 = this.getTable().getRowCount();
        HashMap<String, String> hashMap = this.reverseHash(MetaDataHelper.getNodeTypeNameMap());
        for (int i = 0; i < n5; ++i) {
            String string = (String)this.getTable().getModel().getValueAt(i, n3);
            String string2 = hashMap.get(string);
            String string3 = this.parallelQueryPreferences.getProperty(string2, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            String string4 = this.parallelQueryPreferences.getProperty(string2, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string3 != null) {
                if (Boolean.parseBoolean(string3)) {
                    this.getTable().getModel().setValueAt(Boolean.TRUE, i, n);
                    ++n4;
                } else {
                    this.getTable().getModel().setValueAt(Boolean.FALSE, i, n);
                }
            } else {
                this.getTable().getModel().setValueAt(Boolean.FALSE, i, n);
            }
            if (string4 != null) {
                this.getTable().getModel().setValueAt(string4, i, n2);
                continue;
            }
            this.getTable().getModel().setValueAt(this.SYSTEM_DETERMINED, i, n2);
        }
        this.updateToolBarTitle(n4, n5);
    }

    private void initNonPreferenceTable() {
        Vector<String> vector = new Vector<String>();
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_COLUMN"));
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_TYPE_COLUMN"));
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        vector.add(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
        Vector vector2 = new Vector();
        Enumeration enumeration = this.model.getObjects();
        this.metadata = new HashMap();
        HashMap<String, String> hashMap = MetaDataHelper.getNodeTypeNameMap();
        HashMap<String, String> hashMap2 = MetaDataHelper.getNodeTypeParallelExcluded();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof GeneralLink) continue;
            AbstractNode abstractNode = (AbstractNode)e;
            NodeType nodeType = abstractNode.getData();
            Vector<Object> vector3 = new Vector<Object>();
            String string = nodeType.getClass().getName();
            if (hashMap2.containsKey(string)) {
                ++n2;
                continue;
            }
            this.metadata.put(nodeType.getName(), abstractNode);
            vector3.add(nodeType.getName());
            vector3.add(hashMap.get(string));
            if (nodeType.getParallelism() == null) {
                vector3.add(false);
                vector3.add(this.SYSTEM_DETERMINED);
            } else {
                if (nodeType.getParallelism().isEnable()) {
                    ++n;
                    vector3.add(true);
                } else {
                    vector3.add(false);
                }
                if (nodeType.getParallelism().getSystemDetermined() != null) {
                    vector3.add(this.SYSTEM_DETERMINED);
                } else {
                    long l = nodeType.getParallelism().getCustom().getDegree();
                    vector3.add(l);
                }
            }
            vector2.add(vector3);
        }
        this.dataMinerTablePanel1.setup((TableModel)new ParallelTableModel(vector2, vector, vector2.size() - n2, n), null, new String[]{WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_COLUMN"), WorkflowEditorLrb.get("PARALLEL_TABLE_TYPE_COLUMN")}, 0);
        this.dataMinerTablePanel1.getTable().setSortColumn(0, true);
        this.updateToolBarTitle(n, vector2.size());
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.selectedNodes != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (AbstractNode abstractNode : this.selectedNodes) {
                String string = abstractNode.getData().getName();
                int n = this.getRowIndexbyName(string);
                if (n < 0) continue;
                arrayList.add(n);
            }
            this.getTable().setSelectedRowsInModel(this.listToArray(arrayList));
            this.getTable().scrollToSelection();
        }
    }

    private int[] listToArray(List<Integer> list) {
        if (list == null) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        int n = 0;
        for (Integer n2 : list) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    private int getRowIndexbyName(String string) {
        int n = this.getTable().getRowCount();
        int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_COLUMN"));
        for (int i = 0; i < n; ++i) {
            String string2 = this.getTable().getModel().getValueAt(i, n2).toString();
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.parallelQueryPreferences = ParallelQueryPreferences.getInstance(traversableContext.getPropertyStorage());
        this.initUI();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.savePreferences();
    }

    public boolean doWork() {
        try {
            if (this.metadata == null) {
                return false;
            }
            final ArrayList<String> arrayList = new ArrayList<String>();
            int n = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_NODE_COLUMN"));
            int n2 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
            int n3 = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
            int n4 = this.getTable().getRowCount();
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                ParallelismType parallelismType = new ParallelismType();
                String string = this.getTable().getValueAt(i, n).toString();
                String string2 = this.getTable().getValueAt(i, n2).toString();
                String string3 = this.getTable().getValueAt(i, n3).toString();
                AbstractNode abstractNode = this.metadata.get(string);
                NodeType nodeType = abstractNode.getData();
                if (string2.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    parallelismType.setEnable(true);
                    ++n5;
                } else {
                    parallelismType.setEnable(false);
                }
                if (string3.equalsIgnoreCase(this.SYSTEM_DETERMINED)) {
                    parallelismType.setSystemDetermined(new ParallelismType.SystemDetermined());
                } else {
                    ParallelismType.Custom custom = new ParallelismType.Custom();
                    custom.setDegree(Long.parseLong(string3));
                    parallelismType.setCustom(custom);
                }
                if ((nodeType instanceof CreateTableNodeType || nodeType instanceof GraphNodeType || nodeType instanceof SQLQueryNodeType || nodeType instanceof DataProfileNodeType) && nodeType.getStatus() == NodeStatusType.COMPLETE && this.hashChange(nodeType.getParallelism(), parallelismType)) {
                    arrayList.add(nodeType.getId());
                }
                nodeType.setParallelism(parallelismType);
            }
            this.wfNode.markDirty(true);
            if (arrayList.size() > 0) {
                MessageDialog.optionalInformation((String)(this.getClass().getName() + "displaySaveWFRequired"), (Component)((Object)this), (Object)WorkflowEditorLrb.get("SAVE_WORKFLOW_MESSAGE"), (String)WorkflowEditorLrb.get("SAVE_WORKFLOW_TITTLE"), null);
                this.wfNode.addNodeListener(new NodeListener(){

                    public void nodeSaved(NodeEvent nodeEvent) {
                        String[] stringArray = arrayList.toArray(new String[0]);
                        if (stringArray.length > 0) {
                            UpdateObjects updateObjects = new UpdateObjects(ParallelTablePanel.this.wfNode.getId(), stringArray);
                            updateObjects.execute();
                            ParallelTablePanel.this.wfNode.removeNodeListener(this);
                        }
                    }
                });
                this.wfNode.save();
            }
            this.workflowEditor.updateParallelToolBarLink();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private boolean hashChange(ParallelismType parallelismType, ParallelismType parallelismType2) {
        if (parallelismType == null) {
            return true;
        }
        if (parallelismType.isEnable() != parallelismType2.isEnable()) {
            return true;
        }
        if (parallelismType.getSystemDetermined() == null && parallelismType2.getSystemDetermined() == null) {
            return parallelismType.getCustom().getDegree() != parallelismType2.getCustom().getDegree();
        }
        return parallelismType.getSystemDetermined() == null || parallelismType2.getSystemDetermined() == null;
    }

    public int getColumnIndex(String string) {
        return this.getTable().getColumnModel().getColumnIndex(string);
    }

    class UpdateObjects
    extends SwingWorker {
        private BigDecimal workflowId;
        private String[] nodeIds;

        public UpdateObjects(BigDecimal bigDecimal, String[] stringArray) {
            this.workflowId = bigDecimal;
            this.nodeIds = stringArray;
        }

        protected Object doInBackground() {
            this.updateTableViewObjects(this.workflowId, this.nodeIds);
            return null;
        }

        @Override
        protected void done() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTableViewObjects(BigDecimal bigDecimal, String[] stringArray) {
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[]{new OdmrObjectNames(stringArray)};
            OracleCallableStatement oracleCallableStatement = null;
            Connection connection = null;
            try {
                connection = ConnectionFolder.getConnectionFolder(ParallelTablePanel.this.context).getUniqueConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_UTIL.UPDATE_VIEWS_AND_TABLES(:1,:2)}");
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
                oracleCallableStatement.execute();
            }
            catch (Exception exception) {
                try {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
        }
    }

    class ParallelDegreeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    class ParallelTableModel
    extends DefaultTableModel {
        private int totalRows;
        private int activeParallel;
        private int parallelColumnIndex;

        public ParallelTableModel(Vector vector, Vector vector2, int n, int n2) {
            super(vector, vector2);
            this.totalRows = 0;
            this.activeParallel = 0;
            this.parallelColumnIndex = -1;
            this.totalRows = n;
            this.activeParallel = n2;
            this.parallelColumnIndex = this.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == this.parallelColumnIndex;
        }

        public Class getColumnClass(int n) {
            if (n == this.parallelColumnIndex) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == this.parallelColumnIndex) {
                boolean bl;
                Object object2 = this.getValueAt(n, n2);
                boolean bl2 = bl = !object2.equals(object);
                if (bl) {
                    this.activeParallel = object == Boolean.valueOf(true) ? ++this.activeParallel : --this.activeParallel;
                    ParallelTablePanel.this.updateToolBarTitle(this.activeParallel, this.totalRows);
                }
            }
            super.setValueAt(object, n, n2);
        }

        private int getColumnIndex(String string) {
            for (int i = 0; i < this.columnIdentifiers.size(); ++i) {
                String string2 = (String)this.columnIdentifiers.get(i);
                if (!string.equals(string2)) continue;
                return i;
            }
            return -1;
        }
    }
}

