/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQuerySettingPanel;
import oracle.ide.panels.DefaultTraversablePanel;

public class ViewDataParallelPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private ParallelQueryPreferences parallelQueryPreferences;
    public static final String VIEW_KEY = ViewDataParallelPanel.class.getName();
    public static final String SYSTEM_DETERMINED = WorkflowEditorLrb.get("PARALLEL_VALUE_SYSTEM_DETERMINED");
    private boolean fromParallelEditor = false;
    private JCheckBox jCheckBox1;
    private JPanel jPanel2;
    private ParallelQuerySettingPanel parallelQuerySettingPanel1;

    public ViewDataParallelPanel() {
        this.initComponents();
        this.parallelQueryPreferences = ParallelQueryPreferences.getInstance();
        this.fromParallelEditor = false;
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.parallelQuerySettingPanel1 = new ParallelQuerySettingPanel();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.parallelQuerySettingPanel1.setPreferredSize(new Dimension(300, 150));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.jCheckBox1.setText("Parallel Query On");
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.parallelQuerySettingPanel1, -2, 265, -2).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parallelQuerySettingPanel1, -1, 105, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jCheckBox1.setText(DataLrb.get("DATA_VIEWER_PARALLEL_CHECK"));
    }

    @Override
    public void initUI() {
        if (!this.fromParallelEditor) {
            String string = this.parallelQueryPreferences.getViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            String string2 = this.parallelQueryPreferences.getViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string == null || !Boolean.parseBoolean(string)) {
                this.jCheckBox1.setSelected(false);
            } else {
                this.jCheckBox1.setSelected(true);
            }
            if (string2 == null || string2.equalsIgnoreCase(SYSTEM_DETERMINED)) {
                this.parallelQuerySettingPanel1.setSystemDetermined();
            } else {
                this.parallelQuerySettingPanel1.setDegreeValue(Integer.parseInt(string2));
            }
        }
    }

    public void doWork() {
        this.parallelQueryPreferences.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL, Boolean.toString(this.jCheckBox1.isSelected()));
        if (this.parallelQuerySettingPanel1.isSystemDetermined()) {
            this.parallelQueryPreferences.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE, SYSTEM_DETERMINED);
        } else {
            String string = this.parallelQuerySettingPanel1.getDegreeValue();
            this.parallelQueryPreferences.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE, string);
        }
    }

    public boolean isParallelEnable() {
        return this.jCheckBox1.isSelected();
    }

    public boolean isSystemDetermined() {
        return this.parallelQuerySettingPanel1.isSystemDetermined();
    }

    public String getDegreeValue() {
        return this.parallelQuerySettingPanel1.getDegreeValue();
    }

    public void setParallelEnable(boolean bl) {
        this.jCheckBox1.setSelected(bl);
    }

    public void setSystemDetermined() {
        this.parallelQuerySettingPanel1.setSystemDetermined();
    }

    public void setDegreeValue(int n) {
        this.parallelQuerySettingPanel1.setDegreeValue(n);
    }
}

