/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.AbstractDialogDisplayable;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelTablePanel;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;

public class WorkflowParallelDegreeDialog
extends AbstractDialogDisplayable<ViewDataParallelPanel> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowParallelDegreeDialog.class.getName());
    private static final String SYSTEM_DETERMINED = WorkflowEditorLrb.get("PARALLEL_VALUE_SYSTEM_DETERMINED");
    private ParallelTablePanel parallelTablePanel;
    private String dialogTitle;

    public WorkflowParallelDegreeDialog(ParallelTablePanel parallelTablePanel, String string) {
        this.parallelTablePanel = parallelTablePanel;
        this.dialogTitle = string;
    }

    protected JEWTDialog buildDialog(Component component) {
        final ViewDataParallelPanel viewDataParallelPanel = new ViewDataParallelPanel();
        int n = this.parallelTablePanel.getTable().getSelectedRowCount();
        if (n <= 0) {
            viewDataParallelPanel.setParallelEnable(false);
            viewDataParallelPanel.setSystemDetermined();
        } else if (n == 1) {
            int n2 = this.parallelTablePanel.getTable().getSelectedRow();
            int n3 = this.parallelTablePanel.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_PARALLLE_COLUMN"));
            int n4 = this.parallelTablePanel.getColumnIndex(WorkflowEditorLrb.get("PARALLEL_TABLE_DEGREE_COLUMN"));
            String string = this.parallelTablePanel.getTable().getValueAt(n2, n3).toString();
            String string2 = this.parallelTablePanel.getTable().getValueAt(n2, n4).toString();
            if (Boolean.parseBoolean(string)) {
                viewDataParallelPanel.setParallelEnable(true);
            } else {
                viewDataParallelPanel.setParallelEnable(false);
            }
            if (SYSTEM_DETERMINED.equals(string2)) {
                viewDataParallelPanel.setSystemDetermined();
            } else {
                viewDataParallelPanel.setDegreeValue(Integer.parseInt(string2));
            }
        } else {
            viewDataParallelPanel.setEnabled(false);
            viewDataParallelPanel.setSystemDetermined();
        }
        JEWTDialog jEWTDialog = this.createDialog(component, viewDataParallelPanel, this.dialogTitle);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                    if (viewDataParallelPanel.isParallelEnable()) {
                        WorkflowParallelDegreeDialog.this.parallelTablePanel.setParallelEnable(true);
                    } else {
                        WorkflowParallelDegreeDialog.this.parallelTablePanel.setParallelEnable(false);
                    }
                    if (viewDataParallelPanel.isSystemDetermined()) {
                        WorkflowParallelDegreeDialog.this.parallelTablePanel.setDegreeValue(WorkflowEditorLrb.get("PARALLEL_VALUE_SYSTEM_DETERMINED"));
                    } else {
                        WorkflowParallelDegreeDialog.this.parallelTablePanel.setDegreeValue(viewDataParallelPanel.getDegreeValue());
                    }
                }
            }
        });
        jEWTDialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)viewDataParallelPanel), "parallel_settings_dop");
        return jEWTDialog;
    }

    @Override
    public boolean invoke(Component component) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(component);
            bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }
}

