/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.AbstractDialogDisplayable;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.parallelquery.WorkflowParallelQueryEditor;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;

public class WorkflowParallelQueryDialog
extends AbstractDialogDisplayable<WorkflowParallelQueryEditor> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowParallelQueryDialog.class.getName());
    private Context context;
    private List<AbstractNode> selectedNodes = new ArrayList<AbstractNode>();

    public WorkflowParallelQueryDialog(Context context, List<AbstractNode> list) {
        this.context = context;
        this.selectedNodes = list;
    }

    private JEWTDialog buildDialog(Component component) throws Exception {
        final WorkflowParallelQueryEditor workflowParallelQueryEditor = new WorkflowParallelQueryEditor(this.context, this.selectedNodes);
        JEWTDialog jEWTDialog = this.createDialog(component, workflowParallelQueryEditor, WorkflowEditorLrb.get("WORKFLOW_PARALLEL_DIALOG_TITLE"));
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                    workflowParallelQueryEditor.doWork();
                }
            }
        });
        jEWTDialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)workflowParallelQueryEditor, "parallel_settings");
        return jEWTDialog;
    }

    @Override
    public boolean invoke(Component component) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(component);
            bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }
}

