/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.dmt.dataminer.workflow.preferences.WorkflowPreferencesPanelSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class WorkflowPreferencesPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private JRadioButton btnOrthogonal;
    private JRadioButton btnStraight;
    private JCheckBox chkAltRouting;
    private ButtonGroup groupLinkStyle;
    private JLabel labelLinkStyle;
    private JCheckBox smartNodeAssist;
    private JLabel smartNodeAssistHint;

    public WorkflowPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.groupLinkStyle = new ButtonGroup();
        this.smartNodeAssist = new JCheckBox();
        this.smartNodeAssistHint = new JLabel();
        this.labelLinkStyle = new JLabel();
        this.btnOrthogonal = new JRadioButton();
        this.btnStraight = new JRadioButton();
        this.chkAltRouting = new JCheckBox();
        this.smartNodeAssist.setText("Display wizards and node editors when creating new nodes, or connecting existing nodes");
        this.smartNodeAssist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowPreferencesPanel.this.smartNodeAssistActionPerformed(actionEvent);
            }
        });
        this.smartNodeAssistHint.setText("(when available)");
        this.labelLinkStyle.setText("Link Style:");
        this.btnOrthogonal.setSelected(true);
        this.btnOrthogonal.setText("Orthogonal");
        this.btnStraight.setText("Straight");
        this.chkAltRouting.setText("Alternate Link Routing");
        this.chkAltRouting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowPreferencesPanel.this.chkAltRoutingActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.smartNodeAssistHint, -1, 574, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.smartNodeAssist, -1, 575, Short.MAX_VALUE).addGap(30, 30, 30)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.chkAltRouting).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelLinkStyle, -1, 467, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStraight).addComponent(this.btnOrthogonal)).addGap(378, 378, 378))).addGap(134, 134, 134)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.smartNodeAssist).addGap(10, 10, 10).addComponent(this.smartNodeAssistHint).addGap(27, 27, 27).addComponent(this.labelLinkStyle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStraight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOrthogonal).addGap(18, 18, 18).addComponent(this.chkAltRouting, -2, 23, -2).addContainerGap(116, Short.MAX_VALUE)));
    }

    private void smartNodeAssistActionPerformed(ActionEvent actionEvent) {
    }

    private void chkAltRoutingActionPerformed(ActionEvent actionEvent) {
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(PreferencesLrb.get("SMART_EDIT_ASSIST"), this.smartNodeAssist);
        hashMap.put(PreferencesLrb.get("SMART_EDIT_ASSIST_HINT"), this.smartNodeAssistHint);
        hashMap.put(PreferencesLrb.get("LINK_STYLE_LABEL"), this.labelLinkStyle);
        hashMap.put(PreferencesLrb.get("LINK_STYLE_ORTHOGONAL"), this.btnOrthogonal);
        hashMap.put(PreferencesLrb.get("LINK_STYLE_DIRECT"), this.btnStraight);
        hashMap.put(PreferencesLrb.get("LINK_LAYOUT_MODE"), this.chkAltRouting);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("preferences_workflow_editor");
    }

    public void initUI() {
        this.groupLinkStyle.add(this.btnOrthogonal);
        this.groupLinkStyle.add(this.btnStraight);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void onEntry(TraversableContext traversableContext) {
        WorkflowPreferencesPanelSettings workflowPreferencesPanelSettings = WorkflowPreferencesPanel.getPreferences(traversableContext);
        this.smartNodeAssist.setSelected(workflowPreferencesPanelSettings.isAutoNodeAssist());
        this.btnOrthogonal.setSelected(workflowPreferencesPanelSettings.getLinkLayoutStyle() == 2);
        this.btnStraight.setSelected(workflowPreferencesPanelSettings.getLinkLayoutStyle() == 4);
        this.chkAltRouting.setSelected(workflowPreferencesPanelSettings.getLinkLayoutMode() == 1);
    }

    public void onExit(TraversableContext traversableContext) {
        WorkflowPreferencesPanelSettings workflowPreferencesPanelSettings = WorkflowPreferencesPanel.getPreferences(traversableContext);
        workflowPreferencesPanelSettings.setAutoNodeAssist(this.smartNodeAssist.isSelected());
        int n = 2;
        if (this.btnOrthogonal.isSelected()) {
            n = 2;
        } else if (this.btnStraight.isSelected()) {
            n = 4;
        }
        workflowPreferencesPanelSettings.setLinkLayoutStyle(n);
        if (this.chkAltRouting.isSelected()) {
            workflowPreferencesPanelSettings.setLinkLayoutMode(1);
        } else {
            workflowPreferencesPanelSettings.setLinkLayoutMode(0);
        }
    }

    private static WorkflowPreferencesPanelSettings getPreferences(TraversableContext traversableContext) {
        return WorkflowPreferencesPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

