/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.workflowImport;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowDialogState;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowLrb;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class ImportWorkflowDialog {
    private WorkflowDialogState _state;
    protected JEWTDialog _dlg;
    protected String wizName = "importWorkflow";
    private String _XMLFileName = null;

    public ImportWorkflowDialog(String string) {
        this._XMLFileName = string;
    }

    protected JEWTDialog buildDialog(Context context, WorkflowDialogState workflowDialogState) {
        WorkflowPanel workflowPanel = this.buildPanel(context, workflowDialogState);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)workflowPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "workflowImport.htm");
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderImage(this.getHeaderImage());
        dialogHeader.setHeaderDescription(this.getHeaderDescription());
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        return jEWTDialog;
    }

    protected String getHeaderTitle() {
        return WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE");
    }

    protected String getHeaderDescription() {
        return WorkflowLrb.get("CREATE_WORKFLOW_DESCRIPTION");
    }

    protected String getDialogTitle() {
        return WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE");
    }

    protected WorkflowDialogState buildState(Context context) throws Exception {
        WorkflowDialogState workflowDialogState = null;
        workflowDialogState = new WorkflowDialogState(context, this._XMLFileName);
        return workflowDialogState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context) {
        boolean bl = false;
        try {
            this._state = this.buildState(context);
            if (this._state != null) {
                JEWTDialog jEWTDialog = this.buildDialog(context, this._state);
                jEWTDialog.setResizable(true);
                final WorkflowPanel workflowPanel = (WorkflowPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                            ImportWorkflowDialog.this._state.setXMLFileName(ImportWorkflowDialog.this._XMLFileName);
                            if (!workflowPanel.validateAndWriteToState(ImportWorkflowDialog.this._state)) {
                                throw new PropertyVetoException("panel", propertyChangeEvent);
                            }
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    workflowPanel.initializeFromState(this._state);
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_MESG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        this._state = null;
        this._dlg = null;
        return bl;
    }

    protected void cancel() {
    }

    protected WorkflowPanel buildPanel(Context context, WorkflowDialogState workflowDialogState) {
        return new WorkflowPanel(context, workflowDialogState, this);
    }

    protected Image getHeaderImage() {
        return DataMinerIcons.get(Icons.CREATE_WORKFLOW_DIALOG).getImage();
    }

    public JEWTDialog getDialog() {
        return this._dlg;
    }
}

