/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.workflowImport;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;

public class WorkflowDialogState {
    private static final Logger theLogger = Logger.getLogger(WorkflowDialogState.class.getName());
    private Context _context;
    private String _name;
    private String _XMLFileName = null;
    private boolean _renameObjects = true;

    public WorkflowDialogState(Context context, String string) {
        this._context = context;
        this._XMLFileName = string;
        this.loadDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workflow finishCreate() throws Exception {
        Connection connection = null;
        Workflow workflow = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        Reader reader = null;
        try {
            int n;
            connection = Connections.getSharedConnection(this._context);
            fileInputStream = new FileInputStream(this._XMLFileName);
            StringBuffer stringBuffer = new StringBuffer();
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            while ((n = reader.read()) > -1) {
                stringBuffer.append((char)n);
            }
            ProjectFolder projectFolder = (ProjectFolder)NodeFactory.find((URL)WorkflowDialogState.getRoot(this.getContext()));
            workflow = Workflow.WorkFlowImport(this._context, connection, projectFolder.getId(), this.getName(), this._renameObjects, stringBuffer);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        }
        return workflow;
    }

    public static URL getRoot(Context context) {
        Node node = context.getNode();
        URL uRL = node.getURL();
        if (node instanceof WorkflowNode) {
            uRL = URLFileSystem.getParent((URL)node.getURL());
        }
        return uRL;
    }

    public Workflow finish() throws Exception {
        return this.finishCreate();
    }

    private void loadDefaults() {
        this._name = this.loadDefaultName();
    }

    private String loadDefaultName() {
        Connection connection = null;
        int n = this._XMLFileName.lastIndexOf("/");
        if (n == -1) {
            n = this._XMLFileName.lastIndexOf("\\");
        }
        String string = this._XMLFileName.substring(n + 1);
        n = string.lastIndexOf(".");
        if ((string = string.substring(0, n)).length() > 30) {
            string = string.substring(0, 30);
        }
        String string2 = "";
        try {
            connection = Connections.getSharedConnection(this._context);
            ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
            string2 = Workflow.createUniqueName(connection, projectFolder.getId(), string);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string2;
    }

    public String getName() {
        return this._name.toString();
    }

    public void setName(String string) {
        this._name = string;
    }

    public Context getContext() {
        return this._context;
    }

    public void setRenameObjects(boolean bl) {
        this._renameObjects = bl;
    }

    public void setXMLFileName(String string) {
        this._XMLFileName = string;
    }
}

