/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.workflowImport;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.workflowImport.ImportWorkflowDialog;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowDialogState;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowImportException;
import oracle.dmt.dataminer.workflow.workflowImport.WorkflowLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import org.xml.sax.SAXException;

public class WorkflowPanel
extends JPanel
implements DataminerGUIPanel {
    private Context _context;
    private WorkflowDialogState _state;
    private ImportWorkflowDialog _parentDialog;
    private ButtonGroup buttonGroup;
    private JRadioButton jKeepOptionBtn;
    private JTextField jName;
    private JLabel jNameLabel;
    private JLabel jOptionLabel;
    private JRadioButton jRenameOptionBtn;

    public WorkflowPanel(Context context, WorkflowDialogState workflowDialogState, ImportWorkflowDialog importWorkflowDialog) {
        this.initComponents();
        this._context = context;
        this._state = workflowDialogState;
        this._parentDialog = importWorkflowDialog;
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jNameLabel = new JLabel();
        this.jName = new JTextField();
        this.jOptionLabel = new JLabel();
        this.jRenameOptionBtn = new JRadioButton();
        this.jKeepOptionBtn = new JRadioButton();
        this.jNameLabel.setDisplayedMnemonic('N');
        this.jNameLabel.setText("Workflow Name:");
        this.jOptionLabel.setText("Object Name Management Options");
        this.jRenameOptionBtn.setText("Rename Model and Output Table names if necessary");
        this.jKeepOptionBtn.setText("Keep Existing Model and Output table names even if conflict exists");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jNameLabel, -1, 84, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jName, -2, 292, -2)).addComponent(this.jOptionLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jKeepOptionBtn).addComponent(this.jRenameOptionBtn)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRenameOptionBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jKeepOptionBtn).addContainerGap()));
    }

    @Override
    public void initUI() {
        this.buttonGroup.add(this.jRenameOptionBtn);
        this.buttonGroup.add(this.jKeepOptionBtn);
        this.jRenameOptionBtn.setSelected(true);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jNameLabel, (Component)this.jName, (String)WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this.jNameLabel.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this.jNameLabel.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this.jName.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this.jName.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this.jName.setDocument(new TextFieldLimit(30));
        this.jOptionLabel.setText(WorkflowLrb.get("CREATE_WORKFLOW_OPTION"));
        ResourceUtils.resButton((AbstractButton)this.jRenameOptionBtn, (String)WorkflowLrb.get("CREATE_WORKFLOW_RENAME_OPTION"));
        this.jRenameOptionBtn.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_RENAME_OPTION_ADA"));
        this.jRenameOptionBtn.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_RENAME_OPTION"));
        ResourceUtils.resButton((AbstractButton)this.jKeepOptionBtn, (String)WorkflowLrb.get("CREATE_WORKFLOW_KEEP_OPTION"));
        this.jKeepOptionBtn.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_KEEP_OPTION_ADA"));
        this.jKeepOptionBtn.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_KEEP_OPTION"));
    }

    public boolean validateAndWriteToState(WorkflowDialogState workflowDialogState) {
        final WorkflowDialogState workflowDialogState2 = workflowDialogState;
        boolean bl = false;
        try {
            class ValidateWriteThread
            extends ProgressRunnable {
                boolean validated = true;
                private Workflow _workflowObj = null;
                private String workflowName;

                ValidateWriteThread() {
                }

                public boolean getValidation() {
                    return this.validated;
                }

                public Workflow getWorkflowObj() {
                    return this._workflowObj;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doWork() throws Exception {
                    Connection connection = null;
                    boolean bl = false;
                    try {
                        connection = Connections.getSharedConnection(WorkflowPanel.this._context);
                        this.workflowName = WorkflowPanel.this.jName.getText();
                        this.workflowName = this.workflowName.trim();
                        if (!bl && !Workflow.validateWorkflowName(connection, this.workflowName, WorkflowPanel.this._context)) {
                            this.validated = false;
                        }
                        if (!this.validated) {
                            Boolean bl2 = this.validated;
                            return bl2;
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                    }
                    try {
                        if (this.validated) {
                            workflowDialogState2.setName(this.getProjectName());
                            workflowDialogState2.setRenameObjects(WorkflowPanel.this.jRenameOptionBtn.isSelected());
                            this._workflowObj = workflowDialogState2.finish();
                            if (this._workflowObj == null) {
                                WorkflowPanel.this._parentDialog.getDialog().closeDialog(true);
                            }
                        }
                    }
                    catch (SAXException sAXException) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sAXException, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                        this.validated = false;
                    }
                    catch (WorkflowImportException workflowImportException) {
                        this.validated = false;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == 17155) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("CREATE_WORKFLOW_CHARSET_ERROR"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), null);
                        } else {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sQLException, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                        }
                        this.validated = false;
                    }
                    catch (Exception exception) {
                        if (exception.getMessage().equals("INVALID_WORKFLOW_XML")) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_INVALID_DOC"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), null);
                        } else {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                        }
                        this.validated = false;
                    }
                    return this.validated;
                }

                public String getProjectName() {
                    return this.workflowName;
                }
            }
            ValidateWriteThread validateWriteThread = new ValidateWriteThread();
            validateWriteThread.setTitle(WorkflowLrb.get("WIZARD_CREATING_WORKFLOW_TITLE"));
            validateWriteThread.setMessage(WorkflowLrb.get("WIZARD_CREATING_WORKFLOW_MESG"));
            validateWriteThread.setCancelable(false);
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
            if (!bl) {
                return bl;
            }
            Workflow workflow = validateWriteThread.getWorkflowObj();
            if (workflow == null) {
                return false;
            }
            BaseTreeNode baseTreeNode = (BaseTreeNode)this._context.getElement();
            TreeExplorer treeExplorer = ((NavigatorWindow)this._context.getView()).getTreeExplorer();
            TNode tNode = this.findProjectFolder(treeExplorer, baseTreeNode, this._context);
            WorkflowNode workflowNode = this.createWorkflowNode(tNode, workflow);
            this.addWorkflowNode(this._context, workflowNode);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
        }
        return bl;
    }

    public void initializeFromState(WorkflowDialogState workflowDialogState) {
        this.jName.setText(workflowDialogState.getName());
    }

    private WorkflowNode createWorkflowNode(TNode tNode, Workflow workflow) {
        ProjectFolder projectFolder = (ProjectFolder)tNode.getData();
        WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
        workflowNode.setRepositoryData(workflow);
        workflowNode.setId(workflow.getId());
        workflowNode.setParent(tNode);
        return workflowNode;
    }

    private TNode findProjectFolder(TreeExplorer treeExplorer, BaseTreeNode baseTreeNode, Context context) {
        TNode tNode = null;
        TNode tNode2 = null;
        if (!(baseTreeNode instanceof ConnectionFolder)) {
            if (baseTreeNode instanceof ProjectFolder) {
                tNode = treeExplorer.searchTNode((Element)baseTreeNode, treeExplorer.getRoot(), context);
                tNode2 = tNode.getAncestorTNode(ProjectFolder.class, false);
                assert (tNode2 != null) : "Did not find TNode for ConnectionFolder!";
            } else {
                tNode2 = baseTreeNode.getParent();
            }
        } else {
            tNode2 = treeExplorer.searchTNode((Element)baseTreeNode, baseTreeNode.getParent(), context);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode2);
        return tNode2;
    }

    private void addWorkflowNode(Context context, WorkflowNode workflowNode) {
        ProjectFolder projectFolder = (ProjectFolder)NodeFactory.find((URL)WorkflowDialogState.getRoot(this._context));
        projectFolder.add((Element)workflowNode, true);
        projectFolder.markDirty(false);
        workflowNode.selectAndOpen(context);
    }
}

