/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlInterrogator {
    private PlSqlTokenizer m_tokenizer;
    private PlSqlFragment m_rootFrag;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_nameToken;
    private PlSqlFragment m_triggerBaseItemFragment;
    private String m_source;
    private String m_objType;
    private String m_schemaName;
    private int m_schemaDotNameStart;
    private String m_userDefTypeTypeCode = "";
    private String m_userDefTypeCollectionType = "";
    private boolean m_newStatementBlockReqd;
    private boolean m_fullInterrogation;
    private boolean m_isUserDefType;
    private boolean m_isUserDefTypeSepc;
    private boolean m_isSourceWrapped = false;
    private boolean m_evolvedType = false;
    private Boolean m_containsTodo = null;
    private String[] m_sourceByLines = null;
    private PlSqlSearch m_methodTailSearch = null;
    private PlSqlSearch m_alterSubClauseSearch = null;
    private PlSqlSearch m_dataTypeSearch = null;
    private char[] m_searchBuffer = null;
    private Holder<Boolean> m_cancelled;
    private static HashSet<String> s_knownTypes = new HashSet();
    private static final String OBJECT_TYPECODE = "OBJECT";
    private static final String COLLECTION_TYPECODE = "COLLECTION";
    private static final String TABLE_TYPE = "TABLE";
    private static final String VARRAY_TYPE = "VARYING ARRAY";
    private static final String TYPE_BODY = "TYPE BODY";
    private static final String PACKAGE_BODY = "PACKAGE BODY";
    private static WeakHashMap<String, WeakReference<PlSqlInterrogator>> s_cache = new WeakHashMap();
    private static int s_invocations = 0;
    private boolean m_debug = false;
    private static final String EMPTY_STRING = "";
    private static final String KW_ADD = "ADD";
    private static final String KW_AFTER = "AFTER";
    private static final String KW_ALTER = "ALTER";
    private static final String KW_AS = "AS";
    private static final String KW_BEFORE = "BEFORE";
    private static final String KW_BEGIN = "BEGIN";
    private static final String KW_BODY = "BODY";
    private static final String KW_CALL = "CALL";
    private static final String KW_CASE = "CASE";
    private static final String KW_CONSTRUCTOR = "CONSTRUCTOR";
    private static final String KW_CREATE = "CREATE";
    private static final String KW_CURSOR = "CURSOR";
    private static final String KW_DECLARE = "DECLARE";
    private static final String KW_DROP = "DROP";
    private static final String KW_EACH = "EACH";
    private static final String KW_ELSE = "ELSE";
    private static final String KW_ELSIF = "ELSIF";
    private static final String KW_END = "END";
    private static final String KW_EXCEPTION = "EXCEPTION";
    private static final String KW_FINAL = "FINAL";
    private static final String KW_FOR = "FOR";
    private static final String KW_FUNCTION = "FUNCTION";
    private static final String KW_IF = "IF";
    private static final String KW_INSTANTIABLE = "INSTANTIABLE";
    private static final String KW_INSTEAD = "INSTEAD";
    private static final String KW_IS = "IS";
    private static final String KW_LANGUAGE = "LANGUAGE";
    private static final String KW_LOOP = "LOOP";
    private static final String KW_MAP = "MAP";
    private static final String KW_MEMBER = "MEMBER";
    private static final String KW_MODIFY = "MODIFY";
    private static final String KW_NESTED = "NESTED";
    private static final String KW_NOT = "NOT";
    private static final String KW_OBJECT = "OBJECT";
    private static final String KW_OF = "OF";
    private static final String KW_ON = "ON";
    private static final String KW_OPAQUE = "OPAQUE";
    private static final String KW_OR = "OR";
    private static final String KW_ORDER = "ORDER";
    private static final String KW_OVERRIDING = "OVERRIDING";
    private static final String KW_PACKAGE = "PACKAGE";
    private static final String KW_PRAGMA = "PRAGMA";
    private static final String KW_PROCEDURE = "PROCEDURE";
    private static final String KW_REFERENCING = "REFERENCING";
    private static final String KW_REPLACE = "REPLACE";
    private static final String KW_RETURN = "RETURN";
    private static final String KW_ROW = "ROW";
    private static final String KW_STATIC = "STATIC";
    private static final String KW_TABLE = "TABLE";
    private static final String KW_THEN = "THEN";
    private static final String KW_TRIGGER = "TRIGGER";
    private static final String KW_TYPE = "TYPE";
    private static final String KW_UNDER = "UNDER";
    private static final String KW_UPDATE = "UPDATE";
    private static final String KW_VARRAY = "VARRAY";
    private static final String KW_VARYING = "VARYING";
    private static final String KW_WHEN = "WHEN";
    private static final String KW_WHILE = "WHILE";
    private static final String KW_WRAPPED = "WRAPPED";
    private static final String PUNC_COMMA = ",";
    private static final String PUNC_DBL_LCHEV = "<<";
    private static final String PUNC_DBL_RCHEV = ">>";
    private static final String PUNC_DOT = ".";
    private static final String PUNC_LPAREN = "(";
    private static final String PUNC_RPAREN = ")";
    private static final String PUNC_SEMICOLON = ";";

    private PlSqlInterrogator() {
    }

    public static PlSqlInterrogator findOrCreate(String source) {
        return PlSqlInterrogator.findOrCreate(source, source);
    }

    public static PlSqlInterrogator findOrCreate(String key, String source) {
        return PlSqlInterrogator.findOrCreate(key, source, null);
    }

    public static PlSqlInterrogator findOrCreate(String key, String source, Holder<PlSqlInterrogator> holder) {
        WeakReference<PlSqlInterrogator> piRef;
        PlSqlInterrogator retval = null;
        if (s_invocations++ > 1000) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String s : s_cache.keySet()) {
                WeakReference<PlSqlInterrogator> piRef2 = s_cache.get(s);
                if (piRef2 == null) {
                    keysToRemove.add(s);
                    continue;
                }
                if (piRef2.get() != null) continue;
                keysToRemove.add(s);
            }
            if (keysToRemove.size() > 0) {
                for (int i = 0; i < keysToRemove.size(); ++i) {
                    s_cache.remove(keysToRemove.get(i));
                }
            }
            s_invocations = 0;
        }
        if ((piRef = s_cache.get(key)) != null) {
            retval = (PlSqlInterrogator)piRef.get();
        }
        if (retval == null) {
            retval = new PlSqlInterrogator();
            if (holder != null) {
                holder.set((Object)retval);
            }
            try {
                retval.setSource(source);
                piRef = new WeakReference<PlSqlInterrogator>(retval);
                s_cache.put(key, piRef);
                retval.m_cancelled = null;
            }
            catch (InterrogatorCancelledException e) {}
        } else if (holder != null) {
            holder.set((Object)retval);
        }
        return retval;
    }

    static PlSqlIdentifier getPlSqlIdentifier(String source, String schemaName, boolean force) {
        PlSqlInterrogator pi = new PlSqlInterrogator();
        pi.interrogateBasics(source);
        return pi.getPlSqlIdentifier(schemaName, force);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String schemaName) {
        return this.getPlSqlIdentifier(schemaName, false);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String schemaName, boolean force) {
        String name = null;
        String schema = null;
        PlSqlIdentifier.PlSqlType plsqlType = null;
        if (this.m_nameToken != null) {
            name = this.m_nameToken.getSource(true);
        }
        schema = ModelUtil.hasLength((String)this.m_schemaName) && !force ? this.m_schemaName : schemaName;
        if (ModelUtil.hasLength((String)this.m_objType)) {
            try {
                plsqlType = PlSqlIdentifier.PlSqlType.valueOf(this.m_objType.replaceAll(" ", "_"));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown type " + this.m_objType);
            }
        }
        return new PlSqlIdentifier(name, schema, plsqlType);
    }

    private void setSource(String source) throws InterrogatorCancelledException {
        this.m_cancelled = new Holder((Object)false);
        this.interrogateBasics(source);
        if (this.m_firstToken != null) {
            this.m_rootFrag = new PlSqlFragment(this);
            this.m_rootFrag.setFragmentType(PlSqlFragment.Type.ROOT);
            this.m_rootFrag.setFirstToken(this.m_firstToken);
            boolean full = this.m_fullInterrogation;
            if (full) {
                try {
                    if (this.m_firstToken.matches(KW_BEGIN) || this.m_firstToken.matches(KW_DECLARE)) {
                        this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.PLSQL_BLOCK);
                    } else {
                        this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.DECLARATIVE_SECTION);
                    }
                }
                catch (PlSqlInterrogationException psie) {
                    this.m_rootFrag.getSubFragments().clear();
                    full = false;
                }
            }
            if (!full) {
                PlSqlFragment typeFrag = new PlSqlFragment(this, this.m_rootFrag);
                if (this.m_objType.equals(KW_PROCEDURE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                } else if (this.m_objType.equals(KW_FUNCTION)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                } else if (this.m_objType.equals(KW_PACKAGE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                } else if (this.m_objType.equals(PACKAGE_BODY)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                } else if (this.m_objType.equals(KW_TYPE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                } else if (this.m_objType.equals(TYPE_BODY)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                } else {
                    typeFrag.setFragmentType(PlSqlFragment.Type.UNKNOWN);
                }
                typeFrag.setFirstToken(this.m_firstToken);
                typeFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
                PlSqlFragment statementFrag = new PlSqlFragment(this, typeFrag);
                statementFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                statementFrag.setFirstToken(this.m_firstToken);
                statementFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
                this.m_rootFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
            }
        }
    }

    public void cancelCurrentBuild() {
        Holder<Boolean> cancelled = this.m_cancelled;
        if (cancelled != null) {
            cancelled.set((Object)true);
        }
    }

    public boolean isCurrentBuildCancelled() {
        Holder<Boolean> cancelled = this.m_cancelled;
        if (cancelled != null) {
            return (Boolean)cancelled.get();
        }
        return false;
    }

    private void checkInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelCurrentBuild();
        }
    }

    private void checkInterruptOrCancel() throws InterrogatorCancelledException {
        this.checkInterrupt();
        if (this.isCurrentBuildCancelled()) {
            throw new InterrogatorCancelledException();
        }
    }

    private void interrogateBasics(String source) {
        if (this.m_methodTailSearch == null) {
            this.m_methodTailSearch = new PlSqlSearch("[RETURN {SELF AS RESULT|?%} [EXTERNAL [VARIABLE] NAME ? ] ] [{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME?     | C [NAME ?] LIBRARY ?.       [AGENT IN ({^)}...) ]       [WITH CONTEXT]       [PARAMETERS ({^)}...) ]     } ]");
        }
        if (this.m_alterSubClauseSearch == null) {
            this.m_alterSubClauseSearch = new PlSqlSearch("[ALTER TYPE ?.] <action {ADD|DROP|MODIFY} [ATTRIBUTE]> {^{LIMIT|ELEMENT}}");
        }
        if (this.m_dataTypeSearch == null) {
            this.m_dataTypeSearch = new PlSqlSearch("{ <timetamp TIMESTAMP [(?)][WITH [LOCAL] TIME ZONE]> | <interval INTERVAL {YEAR|DAY}[(?)] TO {MONTH|SECOND[(?)]}> | <number NUMBER [(?[,?])]> | <ref REF ?[.?]> | <pct ?[.?]...%{TYPE|ROWTYPE}> | <other {^{(|)|,|;|:=|DEFAULT|IS|AS|EXTERNAL|ALTER TYPE|DETERMINISTIC|PIPELINED|RESULT_CACHE}}... [({^)}...)]>}");
        }
        this.m_source = source;
        this.m_objType = EMPTY_STRING;
        this.m_schemaName = null;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_tokenizer = new PlSqlTokenizer(this.m_source, new String[0]);
        this.m_firstToken = this.m_tokenizer.getFirst();
        this.m_rootFrag = null;
        this.m_nameToken = null;
        this.m_triggerBaseItemFragment = null;
        this.m_newStatementBlockReqd = false;
        this.m_fullInterrogation = true;
        this.m_isUserDefType = false;
        this.m_isUserDefTypeSepc = false;
        this.m_isSourceWrapped = false;
        this.m_sourceByLines = null;
        this.m_evolvedType = false;
        this.m_containsTodo = null;
        this.m_searchBuffer = null;
        if (this.m_firstToken != null) {
            this.m_fullInterrogation = true;
            this.m_isUserDefTypeSepc = false;
            this.m_userDefTypeTypeCode = EMPTY_STRING;
            this.m_userDefTypeCollectionType = EMPTY_STRING;
            this.m_isSourceWrapped = false;
            PlSqlToken tk = this.m_firstToken;
            if (!tk.isCode() && tk.getType() != PlSqlToken.Type.END_MARKER) {
                tk = tk.getNextCodeToken();
            }
            while (tk.matches(KW_CREATE) || tk.matches(KW_OR) || tk.matches(KW_REPLACE)) {
                tk = tk.getNextCodeToken();
            }
            this.m_firstToken = tk;
            this.m_objType = tk.getSource(true);
            if (this.m_objType != null && s_knownTypes.contains(this.m_objType)) {
                if (this.m_objType.equals(KW_TYPE)) {
                    this.m_isUserDefType = true;
                    if (tk.getNextCodeToken().matches(KW_BODY)) {
                        this.m_objType = this.m_objType + " BODY";
                        tk = tk.getNextCodeToken();
                    } else {
                        this.m_fullInterrogation = false;
                        this.m_isUserDefTypeSepc = true;
                        while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON) || tk.matches(KW_UNDER) || tk.matches(KW_WRAPPED) || tk == this.m_tokenizer.getEndMarker())) {
                            tk = tk.getNextCodeToken();
                        }
                        if (tk.matches(KW_WRAPPED)) {
                            this.m_isSourceWrapped = true;
                        } else if (tk != this.m_tokenizer.getEndMarker()) {
                            if (tk.matches(KW_IS) || tk.matches(KW_AS)) {
                                if ((tk = tk.getNextCodeToken()).matches("OBJECT") || tk.matches(KW_OPAQUE)) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = "OBJECT";
                                    this.m_userDefTypeCollectionType = EMPTY_STRING;
                                } else if (tk.matches("TABLE")) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                                    this.m_userDefTypeCollectionType = "TABLE";
                                } else if (tk.matches(KW_VARRAY) || tk.matches(KW_VARYING)) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                                    this.m_userDefTypeCollectionType = VARRAY_TYPE;
                                }
                            } else if (tk.matches(KW_UNDER)) {
                                this.m_fullInterrogation = true;
                                this.m_userDefTypeTypeCode = "OBJECT";
                            }
                        }
                        tk = this.m_firstToken;
                    }
                } else if (tk.getNextCodeToken().matches(KW_BODY)) {
                    this.m_objType = this.m_objType + " BODY";
                    tk = tk.getNextCodeToken();
                }
            } else {
                this.m_objType = EMPTY_STRING;
            }
            if (!this.m_objType.equals(EMPTY_STRING)) {
                this.m_nameToken = tk = tk.getNextCodeToken();
                if (tk == null || tk.getType() == PlSqlToken.Type.END_MARKER) {
                    return;
                }
                this.m_schemaDotNameStart = tk.getStart();
                if (tk.getNextCodeToken().matches(PUNC_DOT)) {
                    this.m_schemaName = this.m_nameToken.getSource();
                    this.m_nameToken = tk = tk.getNextCodeToken(2);
                }
                if ((tk = tk.getNextCodeToken()).matches(KW_WRAPPED)) {
                    this.m_fullInterrogation = false;
                    this.m_isUserDefType = false;
                    this.m_isUserDefTypeSepc = false;
                    this.m_isSourceWrapped = true;
                }
            }
        }
    }

    public PlSqlFragment getRoot() {
        return this.m_rootFrag;
    }

    public String getType() {
        return this.m_objType;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getName() {
        return this.m_nameToken == null ? EMPTY_STRING : this.m_nameToken.getSource(true);
    }

    public int getNameOffset() {
        return this.m_nameToken == null ? -1 : this.m_nameToken.getStart();
    }

    public String getTypeCode() {
        return this.m_userDefTypeTypeCode;
    }

    public String getCollectionType() {
        return this.m_userDefTypeCollectionType;
    }

    public boolean isWrapped() {
        return this.m_isSourceWrapped;
    }

    private PlSqlToken buildFragmentTree(PlSqlToken startToken, PlSqlFragment currentFrag, InterrogateState parseState) throws PlSqlInterrogationException {
        return this.buildFragmentTree(startToken, currentFrag, parseState, null);
    }

    private PlSqlToken buildFragmentTree(PlSqlToken startToken, PlSqlFragment currentFrag, InterrogateState parseState, PlSqlFragment.AlterSubType alterSubType) throws PlSqlInterrogationException {
        PlSqlToken tk = this.debugBuildFragmentTree(startToken, currentFrag, parseState, alterSubType);
        this.m_newStatementBlockReqd = false;
        PlSqlToken lastTk = null;
        try {
            if (currentFrag.getFirstToken() == null) {
                currentFrag.setFirstToken(startToken);
            }
            while (tk != null && tk.getType() != PlSqlToken.Type.END_MARKER) {
                this.checkInterruptOrCancel();
                if (lastTk == tk) {
                    throw new PlSqlInterrogationException();
                }
                lastTk = tk;
                switch (parseState) {
                    case PROCEDURE: 
                    case FUNCTION: {
                        PlSqlFragment childFrag;
                        if (this.m_isUserDefTypeSepc) {
                            while (!(tk.matches(PUNC_COMMA) || tk.matches(PUNC_LPAREN) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER) || tk.getType() == PlSqlToken.Type.END_MARKER)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(PUNC_LPAREN)) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                                childFrag.setFirstToken(tk);
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                            }
                            if (this.m_methodTailSearch.matches(tk)) {
                                tk = this.m_methodTailSearch.getEndToken();
                                tk = tk.getNextCodeToken();
                            }
                            while (!(tk.matches(PUNC_COMMA) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER) || tk.getType() == PlSqlToken.Type.END_MARKER)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            currentFrag.setAlterSubType(alterSubType);
                            if (tk.matches(PUNC_COMMA)) {
                                tk = tk.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON) || tk.matches(PUNC_LPAREN))) {
                            tk = tk.getNextCodeToken();
                        }
                        if (tk.matches(PUNC_LPAREN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                            while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON))) {
                                tk = tk.getNextCodeToken();
                            }
                        }
                        if (tk.matches(PUNC_SEMICOLON)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if ((tk = tk.getNextCodeToken()).matches(KW_LANGUAGE)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFirstToken(tk);
                        childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        currentFrag.replaceChildWithGrandChildren(childFrag);
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case TRIGGER: {
                        int parens;
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_BEFORE) || tk.matches(KW_AFTER) || tk.matches(KW_INSTEAD) && tk.getNextCodeToken().matches(KW_OF)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TIMING);
                            childFrag.setFirstToken(tk);
                            if (tk.matches(KW_INSTEAD)) {
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            if (tk.matches(KW_ON) || tk.matches(KW_FOR) || tk.matches(KW_REFERENCING) || tk.matches(KW_WHEN) || tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN) || tk.matches(KW_CALL)) break;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_EVENTS);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_EVENTS);
                            break;
                        }
                        if (tk.matches(KW_ON)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TABLE);
                                this.m_triggerBaseItemFragment = childFrag;
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_WHEN)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_WHEN);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                if (tk.matches(PUNC_LPAREN)) {
                                    parens = 1;
                                    while (parens > 0) {
                                        if ((tk = tk.getNextCodeToken()).matches(PUNC_LPAREN)) {
                                            ++parens;
                                            continue;
                                        }
                                        if (!tk.matches(PUNC_RPAREN)) continue;
                                        --parens;
                                    }
                                    tk = tk.getNextCodeToken();
                                } else {
                                    while (!tk.matches(KW_BEGIN) && !tk.matches(KW_DECLARE)) {
                                        tk = tk.getNextCodeToken();
                                    }
                                }
                                childFrag.setLastToken(tk.getPrevCodeToken());
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_REFERENCING)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_REFERENCING);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_FOR) && tk.getNextCodeToken().matches(KW_EACH) && tk.getNextCodeToken(2).matches(KW_ROW)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_ROW_LEVEL);
                                childFrag.setFirstToken(tk);
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (currentFrag.getFragmentType() == PlSqlFragment.Type.TRIGGER_TABLE && tk.matches(KW_NESTED)) {
                            while (!tk.matches(KW_OF)) {
                                tk = tk.getNextCodeToken();
                            }
                            if ((tk = tk.getNextCodeToken()).getNextCodeToken().matches(PUNC_DOT)) {
                                tk = tk.getNextCodeToken(2);
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        tk = tk.getNextCodeToken();
                        break;
                    }
                    case TRIGGER_EVENTS: {
                        PlSqlFragment childFrag;
                        while (!(tk.matches(KW_ON) || tk.matches(KW_FOR) || tk.matches(KW_REFERENCING) || tk.matches(KW_WHEN) || tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN) || tk.matches(KW_CALL))) {
                            if (tk.matches(KW_UPDATE) && tk.getNextCodeToken().matches(KW_OF)) {
                                tk = tk.getNextCodeToken();
                                tk = tk.getNextCodeToken();
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_COLUMNS);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_COLUMNS);
                                continue;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case TRIGGER_COLUMNS: {
                        while (tk.matches(PUNC_COMMA) || tk.getNextCodeToken().matches(PUNC_COMMA)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case PLSQL_BLOCK: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_BEGIN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.BEGIN);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            if (tk.matches(KW_EXCEPTION)) break;
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_EXCEPTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.EXCEPTION);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.EXCEPTION_BLOCK);
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.getType() == PlSqlToken.Type.PUNCTUATION) {
                            throw new PlSqlInterrogationException();
                        }
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARE);
                        childFrag.setFirstToken(tk);
                        if (tk.matches(KW_DECLARE)) {
                            tk = tk.getNextCodeToken();
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                        break;
                    }
                    case DECLARATIVE_SECTION: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_END) && (currentFrag.getFragmentType() == PlSqlFragment.Type.PACKAGE_BODY || currentFrag.getFragmentType() == PlSqlFragment.Type.PACKAGE_SPEC || currentFrag.getFragmentType() == PlSqlFragment.Type.TYPE_BODY)) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                tk = tk.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_PACKAGE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches(KW_BODY)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                                tk = tk.getNextCodeToken();
                            } else {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                            }
                            while (!tk.matches(KW_IS) && !tk.matches(KW_AS)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                            break;
                        }
                        if (tk.matches(KW_TYPE) && currentFrag.getFragmentType() == PlSqlFragment.Type.ROOT) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches(KW_BODY)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                                while (!tk.matches(KW_IS) && !tk.matches(KW_AS)) {
                                    tk = tk.getNextCodeToken();
                                }
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                            while ("OBJECT".equals(this.m_userDefTypeTypeCode) && !tk.matches(PUNC_LPAREN)) {
                                if (!(tk = tk.getNextCodeToken()).matches(PUNC_LPAREN) || !tk.getPrevCodeToken().matches(KW_VARYING) || !tk.getNextCodeToken().matches("*") || !tk.getNextCodeToken(2).matches(PUNC_RPAREN)) continue;
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            if (!(tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TYPE_SPEC)).matches(KW_ALTER)) break;
                            this.m_evolvedType = true;
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches(KW_ALTER) && tk.firstCodeTokenOnLine()) {
                                    childFrag.setLastToken(tk.getPrevCodeToken());
                                    childFrag = new PlSqlFragment(this, currentFrag);
                                    childFrag.setFirstToken(tk);
                                    childFrag.setFragmentType(PlSqlFragment.Type.TYPE_ALTER_STATEMENT);
                                    boolean buildingSubclauses = false;
                                    while (this.m_alterSubClauseSearch.matches(tk)) {
                                        buildingSubclauses = true;
                                        PlSqlFragment.AlterSubType subType = null;
                                        String alterSubTypeStr = this.m_alterSubClauseSearch.getNamedMatch("action", true);
                                        if ("ADD ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.ADD_ATTRIBUTE;
                                        } else if ("DROP ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.DROP_ATTRIBUTE;
                                        } else if ("MODIFY ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.MODIFY_ATTRIBUTE;
                                        } else if (KW_ADD.equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.ADD_METHOD;
                                        } else if (KW_DROP.equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.DROP_METHOD;
                                        }
                                        tk = this.m_alterSubClauseSearch.getEndToken();
                                        if (!(tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION, subType)).matches(KW_ALTER)) continue;
                                        break;
                                    }
                                    if (!buildingSubclauses) {
                                        for (tk = tk.getNextCodeToken(); !tk.matches(KW_ALTER) && tk != this.m_tokenizer.getEndMarker(); tk = tk.getNextCodeToken()) {
                                        }
                                    }
                                }
                                if (tk.matches(KW_ALTER) || tk == this.m_tokenizer.getEndMarker()) continue;
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_BEGIN)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.DECLARE) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                            }
                            if (currentFrag.getFragmentType() != PlSqlFragment.Type.PACKAGE_BODY) break;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_FUNCTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(KW_PROCEDURE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                            break;
                        }
                        if (tk.matches(KW_CURSOR)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CURSOR);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.CURSOR);
                            break;
                        }
                        if (tk.matches(KW_TRIGGER)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                            break;
                        }
                        if (tk.matches(KW_PRAGMA)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PRAGMA);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (tk.matches(PUNC_DBL_LCHEV)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (this.m_isUserDefType && (tk.matches(KW_NOT) || tk.matches(KW_OVERRIDING) || tk.matches(KW_FINAL) || tk.matches(KW_INSTANTIABLE) || tk.matches(KW_MEMBER) || tk.matches(KW_STATIC) || tk.matches(KW_CONSTRUCTOR) || tk.matches(KW_MAP) || tk.matches(KW_ORDER) || tk.matches(KW_PROCEDURE) || tk.matches(KW_FUNCTION))) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_PROCEDURE) && !tk.matches(KW_FUNCTION)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(KW_PROCEDURE)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE, alterSubType);
                            } else {
                                childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION, alterSubType);
                            }
                            if (!tk.matches(KW_ALTER) && !tk.matches(KW_ADD) && !tk.matches(KW_DROP) && !tk.matches(KW_MODIFY)) break;
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(PUNC_SEMICOLON)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        if (this.m_isUserDefTypeSepc && (currentFrag.getFragmentType() == PlSqlFragment.Type.TYPE_SPEC || currentFrag.getFragmentType() == PlSqlFragment.Type.TYPE_ALTER_STATEMENT)) {
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                            childFrag.setAlterSubType(alterSubType);
                            if (!tk.matches(KW_ALTER) && !tk.matches(KW_ADD) && !tk.matches(KW_DROP) && !tk.matches(KW_MODIFY)) break;
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                        break;
                    }
                    case STATEMENT_BLOCK: {
                        PlSqlFragment childFrag;
                        if ((tk.matches(KW_END) || tk.matches(KW_WHEN)) && (currentFrag.getFragmentType() == PlSqlFragment.Type.EX_WHEN || currentFrag.getFragmentType() == PlSqlFragment.Type.CASE_WHEN || currentFrag.getFragmentType() == PlSqlFragment.Type.CASE_ELSE)) {
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_END)) {
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_EXCEPTION)) {
                            if (currentFrag.getFragmentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        if (tk.matches(KW_IF)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.IF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_ELSIF)) {
                            if (!(currentFrag.getFragmentType() != PlSqlFragment.Type.IF && currentFrag.getFragmentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSIF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_ELSE)) {
                            if (currentFrag.getFragmentType() == PlSqlFragment.Type.CASE_WHEN && !this.m_newStatementBlockReqd) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                            }
                            if (!(currentFrag.getFragmentType() != PlSqlFragment.Type.IF && currentFrag.getFragmentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSE);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_LOOP)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LOOP);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_FOR)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FOR_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_LOOP)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_WHILE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.WHILE_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_LOOP)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_CASE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_WHEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.CASE_STATEMENT);
                            break;
                        }
                        if (tk.matches(PUNC_DBL_LCHEV)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (!tk.matches(PUNC_SEMICOLON)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (!tk.matches(PUNC_SEMICOLON)) break;
                        currentFrag.setLastToken(tk);
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case CASE_STATEMENT: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_END)) {
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_WHEN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE_WHEN);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (!tk.matches(KW_ELSE)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.CASE_ELSE);
                        childFrag.setFirstToken(tk);
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_WHEN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.EX_WHEN);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                        }
                        if (!tk.matches(KW_END)) break;
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case TYPE_SPEC: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_ALTER) && tk.firstCodeTokenOnLine()) {
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(PUNC_RPAREN)) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches(KW_ALTER) && tk.firstCodeTokenOnLine()) {
                                    return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                                }
                                tk = tk.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        if (tk.matches(KW_NOT) || tk.matches(KW_OVERRIDING) || tk.matches(KW_FINAL) || tk.matches(KW_INSTANTIABLE) || tk.matches(KW_MEMBER) || tk.matches(KW_STATIC) || tk.matches(KW_CONSTRUCTOR) || tk.matches(KW_MAP) || tk.matches(KW_ORDER) || tk.matches(KW_PROCEDURE) || tk.matches(KW_FUNCTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_PROCEDURE) && !tk.matches(KW_FUNCTION)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(KW_PROCEDURE)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(PUNC_SEMICOLON)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                        break;
                    }
                    case ORACLE_TYPE_DECLN: {
                        int parens = 0;
                        while (!(tk == null || tk == this.m_tokenizer.getEndMarker() || parens == 0 && (tk.matches(PUNC_COMMA) || tk.matches(PUNC_SEMICOLON) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER)))) {
                            if (tk.matches(PUNC_LPAREN)) {
                                ++parens;
                            } else if (tk.matches(PUNC_RPAREN)) {
                                --parens;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_RPAREN) && !tk.matches(KW_ALTER)) {
                            tk = tk.getNextCodeToken();
                        }
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case SIMPLE_STATEMENT: {
                        while (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_SEMICOLON)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case LABEL: {
                        while (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_DBL_RCHEV)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case PARAMETER_LIST: {
                        if (tk.matches(PUNC_RPAREN)) {
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                        }
                        PlSqlFragment childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER);
                        break;
                    }
                    case PARAMETER: {
                        int pars = 0;
                        while (tk != null && (pars != 0 || !tk.matches(PUNC_COMMA) && !tk.matches(PUNC_RPAREN))) {
                            if (tk.matches(PUNC_LPAREN)) {
                                ++pars;
                            } else if (tk.matches(PUNC_RPAREN)) {
                                --pars;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk.matches(PUNC_COMMA)) {
                            tk = tk.getNextCodeToken();
                        }
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                    case CURSOR: {
                        PlSqlFragment childFrag;
                        tk = tk.getNextCodeToken(2);
                        if (tk.matches(PUNC_LPAREN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                        }
                        if (tk.matches(PUNC_SEMICOLON)) {
                            tk = tk.getNextCodeToken();
                        } else if (tk.matches(KW_IS) || tk.matches(KW_RETURN)) {
                            tk = tk.getNextCodeToken();
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                        } else {
                            throw new PlSqlInterrogationException();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
                    }
                }
            }
        }
        catch (NullPointerException e) {
            return this.debugBuildFragmentTree(null, currentFrag, parseState, alterSubType);
        }
        return this.debugBuildFragmentTree(tk, currentFrag, parseState, alterSubType);
    }

    public int getLineNumber(int offset) {
        return this.m_tokenizer.getLineNumber(offset);
    }

    public PlSqlFragment getFragmentAtOffset(int offset) {
        return this.getFragmentAtOffset(offset, this.m_rootFrag);
    }

    private PlSqlFragment getFragmentAtOffset(int offset, PlSqlFragment parent) {
        if (parent != null && parent.getFirstToken() != null && parent.getFirstToken().getStart() <= offset && (parent.getLastToken() == null || parent.getLastToken().getEnd() >= offset)) {
            if (parent.getChildren() == null || parent.getChildren().length == 0) {
                return parent;
            }
            for (PlSqlFragment frag : parent.getChildren()) {
                if (frag.getFirstToken().getStart() > offset || frag.getLastToken() != null && frag.getLastToken().getEnd() < offset) continue;
                PlSqlFragment ret = this.getFragmentAtOffset(offset, frag);
                return ret == null ? frag : ret;
            }
        }
        return null;
    }

    public PlSqlToken getTokenAtOffset(int offset) {
        return this.m_firstToken == null ? null : this.m_firstToken.getTokenAt(offset);
    }

    @Deprecated
    public PlsqlError[] getPlSqlErrors() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean hasParseErrors() {
        return false;
    }

    public boolean containsToDo() {
        if (this.m_containsTodo == null) {
            this.m_containsTodo = Boolean.FALSE;
            PlSqlToken tk = this.m_tokenizer.getStartMarker().getNextToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if ((tk.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT || tk.getType() == PlSqlToken.Type.MULTI_LINE_COMMENT) && tk.getSource().toUpperCase().contains("TODO")) {
                    this.m_containsTodo = Boolean.TRUE;
                    break;
                }
                tk = tk.getNextToken();
            }
        }
        return this.m_containsTodo;
    }

    public String getRenamedSource(String newName) {
        return this.getRenamedSource(newName, false);
    }

    public String getRenamedSource(String newName, boolean includeSchema) {
        StringBuilder newSource = new StringBuilder();
        if (this.m_nameToken != null) {
            int start = includeSchema ? this.m_schemaDotNameStart : this.m_nameToken.getStart();
            newSource.append(this.m_source.substring(0, start));
            newSource.append(newName);
            PlSqlToken nToken = this.m_tokenizer.getEndMarker().getPrevCodeToken();
            PlSqlToken n1Token = nToken.getPrevCodeToken();
            PlSqlToken n2Token = n1Token.getPrevCodeToken();
            if (nToken.matches(PUNC_SEMICOLON) && n1Token.matches(this.m_nameToken.getSource()) && n2Token.matches(KW_END)) {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1, n1Token.getStart()));
                if (newName.indexOf(PUNC_DOT) > -1 && includeSchema) {
                    newSource.append(newName.substring(newName.indexOf(PUNC_DOT) + 1));
                } else {
                    newSource.append(newName);
                }
                newSource.append(this.m_source.substring(n1Token.getEnd() + 1));
            } else {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1));
            }
        }
        return newSource.toString();
    }

    public boolean isEvolvedType() {
        return this.m_evolvedType;
    }

    public String getUpdatedSourceForRelationRename(String newRelationName) {
        if (this.m_triggerBaseItemFragment == null) {
            return this.m_source;
        }
        StringBuilder newSource = new StringBuilder();
        newSource.append(this.m_source.substring(0, this.m_triggerBaseItemFragment.getStartOffset()));
        newSource.append(newRelationName);
        newSource.append(this.m_source.substring(this.m_triggerBaseItemFragment.getEndOffset() + 1));
        return newSource.toString();
    }

    public String getSource(PlSqlToken start, PlSqlToken end) {
        return start.getSource(false, end);
    }

    int getSourceLength() {
        return this.m_source == null ? 0 : this.m_source.length();
    }

    public PlSqlToken skipToCodeToken(PlSqlFragment frag, PlSqlToken tk, String ... tkStrs) {
        int limit = frag != null ? frag.getLastToken().getEnd() : this.getSourceLength();
        do {
            for (String tkStr : tkStrs) {
                if (!tk.matches(tkStr)) continue;
                return tk;
            }
        } while ((tk = tk.getNextCodeToken()) != null && tk.getType() != PlSqlToken.Type.END_MARKER && tk.getStart() <= limit);
        return null;
    }

    public int findExecutableLineNumber(String signature) {
        List<PlSqlFragment> frags = this.findFragmentsBySignature(signature);
        if (frags.size() > 0) {
            return this.findExecutableLineNumber(frags.get(0));
        }
        return 0;
    }

    private int findExecutableLineNumber(PlSqlFragment frag) {
        if (frag.getFragmentType() == PlSqlFragment.Type.STATEMENT || frag.getFragmentType() == PlSqlFragment.Type.IF || frag.getFragmentType() == PlSqlFragment.Type.FOR_LOOP || frag.getFragmentType() == PlSqlFragment.Type.WHILE_LOOP || frag.getFragmentType() == PlSqlFragment.Type.CASE) {
            return this.getLineNumber(frag.getFirstToken().getStart());
        }
        for (PlSqlFragment f : frag.getChildren()) {
            int i = this.findExecutableLineNumber(f);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public int getMatchingOffset(int offset) {
        PlSqlFragment frag = this.getFragmentAtOffset(offset);
        if (frag != null) {
            PlSqlToken start = frag.getFirstToken();
            PlSqlToken end = frag.getLastToken();
            if (offset >= start.getStart() && offset <= start.getEnd()) {
                return end.getStart();
            }
            if (offset >= end.getStart() && offset <= end.getEnd()) {
                return start.getStart();
            }
        }
        return -1;
    }

    public List<PlSqlFragment> findFragmentsBySignature(String signature) {
        if (this.m_objType == null) {
            throw new IllegalStateException("object type not known");
        }
        ArrayList<PlSqlFragment> fragList = new ArrayList<PlSqlFragment>();
        PlSqlToken tk = PlSqlTokenizer.tokenize(signature, new String[0]);
        String name = tk.getSource(true);
        ArrayList<String> paramExpression = null;
        String returnType = null;
        if ((tk = tk.getNextCodeToken()).matches(PUNC_LPAREN)) {
            paramExpression = new ArrayList<String>();
        }
        while (tk.matches(PUNC_LPAREN) || tk.matches(PUNC_COMMA)) {
            StringBuffer expr = new StringBuffer();
            if ((tk = tk.getNextCodeToken()).matches(PUNC_RPAREN)) continue;
            if (tk.getNextCodeToken().matches("=>")) {
                expr.append(tk.getSource(true));
                tk = tk.getNextCodeToken(2);
            } else {
                expr.append("?");
            }
            expr.append(" [{in out|in|out}]");
            while (!tk.matches(PUNC_RPAREN) && !tk.matches(PUNC_COMMA)) {
                if (tk.getType() == PlSqlToken.Type.END_MARKER) {
                    throw new IllegalArgumentException("Missing )");
                }
                expr.append(" ");
                expr.append(tk.getSource(true));
                tk = tk.getNextCodeToken();
            }
            paramExpression.add(expr.toString());
        }
        if (tk.matches(PUNC_RPAREN)) {
            tk = tk.getNextCodeToken();
        }
        if (tk.matches(":")) {
            PlSqlToken lastTk = tk = tk.getNextCodeToken();
            while (lastTk.getNextToken().getType() != PlSqlToken.Type.END_MARKER) {
                lastTk = lastTk.getNextToken();
            }
            returnType = tk.getSource(true, lastTk);
        }
        this.findSignature(fragList, this.m_rootFrag, name, paramExpression, returnType);
        return fragList;
    }

    private void findSignature(List<PlSqlFragment> fragList, PlSqlFragment parent, String name, ArrayList<String> paramExpression, String returnType) {
        boolean specOnly = this.m_objType.equals(KW_PACKAGE) || this.m_objType.equals(KW_TYPE);
        boolean procedure = returnType == null;
        boolean function = paramExpression == null || returnType != null;
        for (PlSqlFragment frag : parent.getChildren()) {
            if ((!procedure || frag.getFragmentType() != (specOnly ? PlSqlFragment.Type.PROCEDURE_FD : PlSqlFragment.Type.PROCEDURE)) && (!function || frag.getFragmentType() != (specOnly ? PlSqlFragment.Type.FUNCTION_FD : PlSqlFragment.Type.FUNCTION)) || !frag.getFirstToken().getNextCodeToken().matches(name)) continue;
            if (returnType != null) {
                PlSqlSearch search = null;
                try {
                    search = new PlSqlSearch("return " + returnType);
                    if (search == null || !search.isWithin(frag.getFirstToken())) {
                        continue;
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (paramExpression == null) {
                fragList.add(frag);
                continue;
            }
            PlSqlFragment params = null;
            for (PlSqlFragment f : frag.getChildren()) {
                if (f.getFragmentType() != PlSqlFragment.Type.PARAMETER_LIST) continue;
                params = f;
                break;
            }
            if (params == null && paramExpression.size() == 0) {
                fragList.add(frag);
                continue;
            }
            if (params == null || params.getChildren().length != paramExpression.size()) continue;
            boolean ok = true;
            for (int i = 0; i < params.getChildren().length; ++i) {
                PlSqlSearch search = null;
                try {
                    search = new PlSqlSearch(paramExpression.get(i));
                    if (search != null && search.matches(params.getChildren()[i].getSource())) continue;
                    ok = false;
                    break;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (!ok) continue;
            fragList.add(frag);
        }
        if (fragList.size() == 0) {
            for (PlSqlFragment frag : parent.getChildren()) {
                this.findSignature(fragList, frag, name, paramExpression, returnType);
            }
        }
    }

    @Deprecated
    public List<String> getExternalDeclarations() {
        return Collections.emptyList();
    }

    private PlSqlToken debugBuildFragmentTree(PlSqlToken tk, PlSqlFragment currentFrag, InterrogateState parseState, PlSqlFragment.AlterSubType alterSubType) {
        if (this.m_debug) {
            int i;
            Exception e = new Exception();
            StackTraceElement[] st = e.getStackTrace();
            StackTraceElement ste = st[1];
            System.out.println("\nLine:  " + ste.getLineNumber());
            for (i = 1; i < st.length && "buildFragmentTree".equals(st[i].getMethodName()); ++i) {
            }
            System.out.println("Depth: " + i);
            StringBuilder sb = new StringBuilder(currentFrag.getFragmentType().toString());
            for (PlSqlFragment par = currentFrag.getParent(); par != null; par = par.getParent()) {
                sb.append(PUNC_DOT).append(par.getFragmentType().toString());
            }
            System.out.println("Frags: " + sb.toString());
            System.out.println("State: " + parseState.toString());
            if (tk != null) {
                System.out.println("Offset:" + tk.getStart());
                System.out.println("Token: " + tk.getSource());
            } else {
                System.out.println("Offset:");
                System.out.println("Token: ");
            }
        }
        return tk;
    }

    public List<Integer> getLocationOffsets(String text) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        char[] searchBuffer = this.getSearchBuffer();
        for (int i = 1; i < searchBuffer.length - text.length(); ++i) {
            int j;
            if (searchBuffer[i - 1] != ' ' || searchBuffer[i] != text.charAt(0)) continue;
            boolean found = true;
            for (j = 0; j < text.length(); ++j) {
                if (searchBuffer[i + j] == text.charAt(j)) continue;
                found = false;
                break;
            }
            if (searchBuffer[i + j] != ' ') {
                found = false;
            }
            if (!found) continue;
            ret.add(i - 1);
            i += j;
        }
        return ret;
    }

    private char[] getSearchBuffer() {
        if (this.m_searchBuffer == null) {
            PlSqlToken tk = this.getTokenAtOffset(0);
            if (tk != null) {
                this.m_searchBuffer = new char[this.m_source.length() + 2];
                for (int i = 0; i < this.m_source.length() + 2; ++i) {
                    this.m_searchBuffer[i] = 32;
                }
                while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                    int i;
                    int offset;
                    if (tk.getType() == PlSqlToken.Type.DOUBLE_QUOTED_STRING) {
                        String val = tk.getSource();
                        offset = tk.getStart() + 1;
                        for (i = 1; i < val.length() - 1; ++i) {
                            this.m_searchBuffer[offset + i] = val.charAt(i);
                        }
                    } else if (tk.isCode(true)) {
                        String val = tk.getSource().toUpperCase();
                        offset = tk.getStart() + 1;
                        for (i = 0; i < val.length(); ++i) {
                            this.m_searchBuffer[offset + i] = val.charAt(i);
                        }
                    }
                    tk = tk.getNextToken();
                }
            } else {
                this.m_searchBuffer = new char[0];
            }
        }
        return this.m_searchBuffer;
    }

    static {
        s_knownTypes.add(KW_PROCEDURE);
        s_knownTypes.add(KW_FUNCTION);
        s_knownTypes.add(KW_TRIGGER);
        s_knownTypes.add(KW_PACKAGE);
        s_knownTypes.add(KW_TYPE);
    }

    private static class InterrogatorCancelledException
    extends PlSqlInterrogationException {
        private InterrogatorCancelledException() {
        }
    }

    private static class PlSqlInterrogationException
    extends Exception {
        private PlSqlInterrogationException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InterrogateState {
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        DECLARATIVE_SECTION,
        STATEMENT_BLOCK,
        EXCEPTION_BLOCK,
        SIMPLE_STATEMENT,
        LABEL,
        PARAMETER,
        PARAMETER_LIST,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        CASE_STATEMENT,
        ORACLE_TYPE_DECLN,
        TYPE_SPEC,
        CURSOR;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

