/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import oracle.javatools.db.plsql.PlSqlSearchClause;
import oracle.javatools.db.plsql.PlSqlSearchClauseInverter;
import oracle.javatools.db.plsql.PlSqlSearchClauseOptions;
import oracle.javatools.db.plsql.PlSqlSearchClauseParentheses;
import oracle.javatools.db.plsql.PlSqlSearchClauseRepeater;
import oracle.javatools.db.plsql.PlSqlSearchClauseSequence;
import oracle.javatools.db.plsql.PlSqlSearchClauseToken;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;

public class PlSqlSearch {
    private PlSqlSearchClause m_searchClause;
    private ArrayList<String> m_names = new ArrayList();
    private PlSqlToken m_starToken = null;
    private PlSqlToken m_lastOKToken = null;
    private PlSqlToken m_rangeEndToken = null;

    public PlSqlSearch(String expression) {
        PlSqlToken startToken;
        if (expression == null || expression.trim().length() == 0) {
            throw new IllegalArgumentException("empty expression");
        }
        String e = expression;
        e = e.replaceAll("\\?\\.", "{?[.?]...}");
        e = e.replaceAll("\\?\\%", "{ TIMESTAMP [(?)][WITH [LOCAL] TIME ZONE] | INTERVAL {YEAR|DAY}[(?)] TO {MONTH|SECOND[(?)]} | NUMBER [(?[,?])] | REF ?[.?] | ?[.?]...%{TYPE|ROWTYPE}| {^{(|)|,|;|:=|DEFAULT|IS|AS|EXTERNAL|ALTER TYPE|DETERMINISTIC|PIPELINED|RESULT_CACHE}}... [({^)}...)]}");
        PlSqlToken tk = startToken = PlSqlTokenizer.tokenize(e, "(...)", "...");
        ArrayList<String> stack = new ArrayList<String>();
        while (this.isWithinRange(tk)) {
            String s = tk.getSource();
            if (tk.getPrevCodeToken().matches("<")) {
                if (this.m_names.contains(s)) {
                    throw new IllegalArgumentException("repeated name " + s);
                }
                this.m_names.add(s);
            }
            if (s.equals("{") || s.equals("[") || s.equals("<")) {
                stack.add(s);
            } else if (s.equals("|")) {
                if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("{")) {
                    throw new IllegalArgumentException("| not within {}");
                }
            } else {
                if (s.equals("^") && !tk.getPrevCodeToken().matches("{")) {
                    throw new IllegalArgumentException("^ not following {");
                }
                if (s.equals("}")) {
                    if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("{")) {
                        throw new IllegalArgumentException("{ } mismatch");
                    }
                    stack.remove(stack.size() - 1);
                } else if (s.equals("]")) {
                    if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("[")) {
                        throw new IllegalArgumentException("[ ] mismatch");
                    }
                    stack.remove(stack.size() - 1);
                } else if (s.equals(">")) {
                    if (stack.size() == 0 || !((String)stack.get(stack.size() - 1)).equals("<")) {
                        throw new IllegalArgumentException("< > mismatch");
                    }
                    stack.remove(stack.size() - 1);
                }
            }
            tk = tk.getNextCodeToken();
        }
        if (stack.size() != 0) {
            throw new IllegalArgumentException("ran out of brackets");
        }
        this.m_searchClause = new PlSqlSearchClauseSequence(this);
        this.build(this.m_searchClause, startToken);
    }

    public final boolean matches(String source) {
        return this.found(PlSqlTokenizer.tokenize(source, "..."), null, false);
    }

    public final boolean matches(PlSqlToken startToken) {
        return this.found(startToken, null, false);
    }

    public final boolean matches(PlSqlToken startToken, PlSqlToken endToken) {
        return this.found(startToken, endToken, false);
    }

    public final boolean isWithin(String source) {
        return this.found(PlSqlTokenizer.tokenize(source, "..."), null, true);
    }

    public final boolean isWithin(PlSqlToken startToken) {
        return this.found(startToken, null, true);
    }

    public final boolean isWithin(PlSqlToken startToken, PlSqlToken endToken) {
        return this.found(startToken, endToken, true);
    }

    public final String getNamedMatch(String name) {
        return this.getNamedMatch(name, true);
    }

    public final String getNamedMatch(String name, boolean format) {
        PlSqlSearchClause sc = this.m_searchClause.getNamedSearchClause(name);
        if (sc != null) {
            PlSqlToken tk1 = sc.getStartToken();
            PlSqlToken tk2 = sc.getEndToken();
            return tk1.getSource(format, tk2);
        }
        return null;
    }

    public final PlSqlToken getNamedMatchStartToken(String name) {
        PlSqlSearchClause sc = this.m_searchClause.getNamedSearchClause(name);
        if (sc != null) {
            return sc.getStartToken();
        }
        return null;
    }

    public final PlSqlToken getNamedMatchEndToken(String name) {
        PlSqlSearchClause sc = this.m_searchClause.getNamedSearchClause(name);
        if (sc != null) {
            return sc.getEndToken();
        }
        return null;
    }

    public PlSqlToken getStartToken() {
        return this.m_searchClause.getStartToken();
    }

    public PlSqlToken getEndToken() {
        return this.m_searchClause.getEndToken();
    }

    public String[] getNames() {
        return this.m_names.toArray(new String[this.m_names.size()]);
    }

    private boolean found(PlSqlToken startToken, PlSqlToken endToken, boolean isWithin) {
        this.m_starToken = startToken;
        boolean retval = false;
        if (startToken != null) {
            this.m_searchClause.reset();
            this.m_lastOKToken = null;
            PlSqlToken token = startToken;
            if (!token.isCode()) {
                token = token.getNextCodeToken();
            }
            if (endToken != null) {
                this.m_rangeEndToken = endToken;
            }
            while (this.isWithinRange(token)) {
                if (this.m_searchClause.matches(token)) {
                    retval = this.m_searchClause.getEndToken() != null;
                    break;
                }
                if (!isWithin) break;
                token = token.getNextCodeToken();
            }
        }
        return retval;
    }

    private PlSqlToken build(PlSqlSearchClause parent, PlSqlToken startToken) {
        PlSqlToken tk = startToken;
        while (tk.getType() != PlSqlToken.Type.END_MARKER) {
            if (tk.matches("}") || tk.matches(">") || tk.matches("]") || tk.matches("|")) {
                return tk;
            }
            if (tk.matches("{") || tk.matches("[")) {
                PlSqlSearchClauseSequence sc2;
                boolean invert = false;
                if (tk.getNextCodeToken().matches("^")) {
                    invert = true;
                    tk = tk.getNextCodeToken();
                }
                PlSqlSearchClause sc = new PlSqlSearchClauseOptions(this);
                while (!tk.matches("}") && !tk.matches("]")) {
                    sc2 = new PlSqlSearchClauseSequence(this);
                    ((PlSqlSearchClause)sc).addSearchClause(sc2);
                    tk = this.build(sc2, tk.getNextCodeToken());
                }
                if (tk.matches("]")) {
                    sc2 = new PlSqlSearchClauseSequence(this);
                    ((PlSqlSearchClause)sc).addSearchClause(sc2);
                }
                if (invert) {
                    sc = new PlSqlSearchClauseInverter(this, sc);
                }
                if (tk.getNextCodeToken().matches("...")) {
                    sc = new PlSqlSearchClauseRepeater(this, sc);
                    tk = tk.getNextCodeToken();
                }
                parent.addSearchClause(sc);
            } else if (tk.matches("<")) {
                PlSqlSearchClauseSequence sc = new PlSqlSearchClauseSequence(this);
                parent.addSearchClause(sc);
                sc.setKnownAs(tk.getNextCodeToken().getSource());
                tk = this.build(sc, tk.getNextCodeToken(2));
            } else if (tk.matches("(...)")) {
                PlSqlSearchClauseParentheses sc = new PlSqlSearchClauseParentheses(this);
                parent.addSearchClause(sc);
            } else {
                parent.addSearchClause(new PlSqlSearchClauseToken(this, tk));
            }
            tk = tk.getNextCodeToken();
        }
        return tk;
    }

    void setLastOKToken(PlSqlToken lastOKToken) {
        if (lastOKToken != null && (this.m_lastOKToken == null || this.m_lastOKToken.getStart() < lastOKToken.getStart())) {
            this.m_lastOKToken = lastOKToken;
        }
    }

    public int getTokenCount() {
        int i = 0;
        if (this.m_lastOKToken != null && this.m_starToken != null) {
            PlSqlToken tk = this.m_starToken;
            i = 1;
            while (tk != this.m_lastOKToken) {
                tk = tk.getNextCodeToken();
                ++i;
            }
        }
        return i;
    }

    boolean isWithinRange(PlSqlToken token) {
        if (token == null) {
            return false;
        }
        if (token.getType() == PlSqlToken.Type.END_MARKER) {
            return false;
        }
        return this.m_rangeEndToken == null || this.m_rangeEndToken.getStart() >= token.getStart();
    }
}

