/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.plsql.PlsqlTokens;

public class PlSqlToken {
    private Type m_type;
    private int m_start;
    private int m_end;
    private PlSqlToken m_startToken;
    private PlSqlToken m_nextToken;
    private PlSqlToken m_prevToken;
    private String m_source;
    private Boolean m_isNumber;
    private List<PlSqlToken> m_index;
    private static final int INDEX_WIDTH = 1000;
    private static final Set<String> s_plsqlKeywords = new HashSet<String>();
    private static final Set<String> s_plsqlReservedWords = new HashSet<String>();

    public static boolean isKeyWord(String token) {
        if (s_plsqlKeywords.size() == 0) {
            s_plsqlKeywords.addAll(Arrays.asList(PlsqlTokens.KW_words));
        }
        return s_plsqlKeywords.contains(token.toLowerCase());
    }

    public static boolean isKeyWord(PlSqlToken token) {
        return PlSqlToken.isKeyWord(token.getSource());
    }

    public static boolean isReservedWord(String token) {
        if (s_plsqlReservedWords.size() == 0) {
            s_plsqlReservedWords.add("all");
            s_plsqlReservedWords.add("alter");
            s_plsqlReservedWords.add("and");
            s_plsqlReservedWords.add("any");
            s_plsqlReservedWords.add("as");
            s_plsqlReservedWords.add("asc");
            s_plsqlReservedWords.add("at");
            s_plsqlReservedWords.add("begin");
            s_plsqlReservedWords.add("between");
            s_plsqlReservedWords.add("by");
            s_plsqlReservedWords.add("case");
            s_plsqlReservedWords.add("check");
            s_plsqlReservedWords.add("cluster");
            s_plsqlReservedWords.add("clusters");
            s_plsqlReservedWords.add("colauth");
            s_plsqlReservedWords.add("columns");
            s_plsqlReservedWords.add("compress");
            s_plsqlReservedWords.add("connect");
            s_plsqlReservedWords.add("crash");
            s_plsqlReservedWords.add("create");
            s_plsqlReservedWords.add("current");
            s_plsqlReservedWords.add("declare");
            s_plsqlReservedWords.add("default");
            s_plsqlReservedWords.add("delete");
            s_plsqlReservedWords.add("desc");
            s_plsqlReservedWords.add("distinct");
            s_plsqlReservedWords.add("drop");
            s_plsqlReservedWords.add("else");
            s_plsqlReservedWords.add("end");
            s_plsqlReservedWords.add("exception");
            s_plsqlReservedWords.add("exclusive");
            s_plsqlReservedWords.add("exists");
            s_plsqlReservedWords.add("fetch");
            s_plsqlReservedWords.add("for");
            s_plsqlReservedWords.add("from");
            s_plsqlReservedWords.add("goto");
            s_plsqlReservedWords.add("grant");
            s_plsqlReservedWords.add("group");
            s_plsqlReservedWords.add("having");
            s_plsqlReservedWords.add("identified");
            s_plsqlReservedWords.add("if");
            s_plsqlReservedWords.add("in");
            s_plsqlReservedWords.add("index");
            s_plsqlReservedWords.add("indexes");
            s_plsqlReservedWords.add("insert");
            s_plsqlReservedWords.add("intersect");
            s_plsqlReservedWords.add("into");
            s_plsqlReservedWords.add("is");
            s_plsqlReservedWords.add("like");
            s_plsqlReservedWords.add("lock");
            s_plsqlReservedWords.add("minus");
            s_plsqlReservedWords.add("mode");
            s_plsqlReservedWords.add("nocompress");
            s_plsqlReservedWords.add("not");
            s_plsqlReservedWords.add("nowait");
            s_plsqlReservedWords.add("null");
            s_plsqlReservedWords.add("of");
            s_plsqlReservedWords.add("on");
            s_plsqlReservedWords.add("option");
            s_plsqlReservedWords.add("or");
            s_plsqlReservedWords.add("order");
            s_plsqlReservedWords.add("overlaps");
            s_plsqlReservedWords.add("prior");
            s_plsqlReservedWords.add("procedure");
            s_plsqlReservedWords.add("public");
            s_plsqlReservedWords.add("resource");
            s_plsqlReservedWords.add("revoke");
            s_plsqlReservedWords.add("select");
            s_plsqlReservedWords.add("share");
            s_plsqlReservedWords.add("size");
            s_plsqlReservedWords.add("sql");
            s_plsqlReservedWords.add("start");
            s_plsqlReservedWords.add("tabauth");
            s_plsqlReservedWords.add("table");
            s_plsqlReservedWords.add("then");
            s_plsqlReservedWords.add("to");
            s_plsqlReservedWords.add("union");
            s_plsqlReservedWords.add("unique");
            s_plsqlReservedWords.add("update");
            s_plsqlReservedWords.add("values");
            s_plsqlReservedWords.add("view");
            s_plsqlReservedWords.add("views");
            s_plsqlReservedWords.add("when");
            s_plsqlReservedWords.add("where");
            s_plsqlReservedWords.add("with");
        }
        return s_plsqlReservedWords.contains(token.toLowerCase());
    }

    public static boolean isReservedWord(PlSqlToken token) {
        return PlSqlToken.isReservedWord(token.getSource());
    }

    PlSqlToken(Type type, int start, PlSqlToken prev) {
        this.initialise(type, start, prev);
    }

    PlSqlToken(Type type, int start) {
        this.initialise(type, start, null);
    }

    private void initialise(Type type, int start, PlSqlToken prev) {
        if (prev != null) {
            int idx;
            this.m_startToken = prev.m_startToken;
            if (type != Type.END_MARKER && (idx = start / 1000) >= this.m_startToken.m_index.size()) {
                this.m_startToken.m_index.add(this);
            }
        } else {
            this.m_startToken = this;
            this.m_index = new ArrayList<PlSqlToken>();
        }
        this.m_type = type;
        this.m_start = start;
        this.m_end = -1;
        if (prev == null) {
            this.m_prevToken = null;
            this.m_nextToken = null;
        } else {
            this.m_nextToken = prev.getNextToken();
            this.m_prevToken = prev;
            if (this.m_nextToken != null) {
                this.m_nextToken.setPrevToken(this);
            }
            this.m_prevToken.setNextToken(this);
        }
    }

    void setHeaderSource(String source) {
        if (this.m_prevToken != null) {
            throw new IllegalStateException("Can only set source on start token");
        }
        this.m_source = source;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getEnd() {
        return this.m_end;
    }

    public void setEnd(int end) {
        this.m_end = end;
    }

    public PlSqlToken getNextToken() {
        return this.m_nextToken;
    }

    public void setNextToken(PlSqlToken nextToken) {
        this.m_nextToken = nextToken;
    }

    public PlSqlToken getPrevToken() {
        return this.m_prevToken;
    }

    public void setPrevToken(PlSqlToken prevToken) {
        this.m_prevToken = prevToken;
    }

    public boolean isCode() {
        return this.isCode(false);
    }

    public boolean isWord() {
        return this.isCode(true);
    }

    public boolean isPunctuation() {
        return this.m_type == Type.PUNCTUATION;
    }

    public boolean isWhiteSpace() {
        return this.m_type == Type.WHITESPACE;
    }

    public boolean isComment() {
        return this.m_type == Type.SINGLE_LINE_COMMENT || this.m_type == Type.MULTI_LINE_COMMENT;
    }

    public boolean isEndMarker() {
        return this.m_type == Type.END_MARKER;
    }

    public boolean isCode(boolean ignorePuncAndLiterals) {
        if (ignorePuncAndLiterals) {
            if (this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN) {
                return false;
            }
            if (this.m_type == Type.DOUBLE_QUOTED_STRING) {
                return true;
            }
            if (this.m_type == Type.ALPHANUMERIC) {
                return !this.isNumber();
            }
            return false;
        }
        return this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.DOUBLE_QUOTED_STRING || this.m_type == Type.ALPHANUMERIC || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN;
    }

    public boolean isNumber() {
        return this.m_startToken.m_source.charAt(this.m_start) >= '0' && this.m_startToken.m_source.charAt(this.m_start) <= '9';
    }

    public PlSqlToken getPrevCodeToken() {
        PlSqlToken tk;
        for (tk = this.getPrevToken(); tk != null && tk.getType() != Type.END_MARKER && !tk.isCode(); tk = tk.getPrevToken()) {
        }
        return tk;
    }

    public PlSqlToken getNextCodeToken() {
        return this.getNextCodeToken(1);
    }

    public PlSqlToken getNextCodeToken(int numAhead) {
        PlSqlToken tk;
        int counter = 0;
        for (tk = this.getNextToken(); tk != null && tk.getType() != Type.END_MARKER; tk = tk.getNextToken()) {
            if (tk.isCode()) {
                ++counter;
            }
            if (counter >= numAhead) break;
        }
        return tk;
    }

    public String getSource() {
        return this.getSource(false, null);
    }

    public String getSource(boolean format) {
        return this.getSource(format, null);
    }

    public String getSource(boolean format, PlSqlToken toToken) {
        if (format) {
            if (toToken == null || toToken == this) {
                return this.formattedSource();
            }
            StringBuffer sb = new StringBuffer(this.formattedSource());
            PlSqlToken tk = this.getNextCodeToken();
            while (tk.getType() != Type.END_MARKER) {
                if (tk.getType() != Type.PUNCTUATION && (tk.getPrevCodeToken().getType() != Type.PUNCTUATION || tk.getPrevCodeToken().matches(")"))) {
                    sb.append(" ");
                }
                sb.append(tk.formattedSource());
                if (tk == toToken) break;
                tk = tk.getNextCodeToken();
            }
            return sb.toString();
        }
        int start = this.getStart();
        int end = toToken == null ? this.getEnd() : toToken.getEnd();
        if (end > this.m_startToken.m_source.length() - 1) {
            end = this.m_startToken.m_source.length() - 1;
        }
        if (end < start || start < 0) {
            return "";
        }
        return this.m_startToken.m_source.substring(start, end + 1);
    }

    private String formattedSource() {
        if (this.m_type == Type.END_MARKER) {
            return "";
        }
        if (this.m_type == Type.ALPHANUMERIC) {
            return this.getSource().toUpperCase();
        }
        return this.getSource();
    }

    public boolean matches(String str) {
        return str.equalsIgnoreCase(this.getSource());
    }

    public boolean firstCodeTokenOnLine() {
        PlSqlToken tk = this.getPrevToken();
        while (tk.getType() != Type.END_MARKER) {
            if (tk.getType() == Type.WHITESPACE && tk.getSource().contains("\n")) {
                return true;
            }
            if (tk.isCode()) {
                return false;
            }
            tk = tk.getPrevToken();
        }
        return true;
    }

    public PlSqlToken getTokenAt(int pos) {
        PlSqlToken ret = null;
        if (this.m_startToken != null) {
            PlSqlToken next;
            int idx = pos / 1000;
            PlSqlToken start = this.m_startToken;
            if (start != null && start.m_index != null && start.m_index.size() > idx) {
                start = start.m_index.get(idx);
                start = start.getPrevToken();
            }
            while (start.getEnd() < pos && (next = start.getNextToken()).getType() != Type.END_MARKER) {
                start = next;
            }
            ret = start;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        WHITESPACE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_QUOTED_STRING,
        DOUBLE_QUOTED_STRING,
        ALPHANUMERIC,
        PUNCTUATION,
        USER_TOKEN,
        END_MARKER;

    }
}

