/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import oracle.javatools.db.plsql.PlSqlToken;

public class PlSqlTokenizer {
    private static final Pattern s_wsPattern = Pattern.compile("\\s");
    private static final Pattern s_puncPattern = Pattern.compile("\\p{Punct}");
    private static final Pattern s_underDollarHashPattern = Pattern.compile("[_$#]");
    private PlSqlToken m_startMarker;
    private PlSqlToken m_endMarker;
    private PlSqlToken m_first;
    private ArrayList<Integer> m_lineStarts = new ArrayList();
    private ArrayList<Integer> m_offsetIndex = new ArrayList();
    private String m_SLC = "--";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlSqlToken tokenize(String source, String ... userTokens) {
        PlSqlToken retval = null;
        if (source != null) {
            StringReader reader = new StringReader(source);
            try {
                retval = PlSqlTokenizer.tokenize(reader, null, userTokens);
            }
            finally {
                reader.close();
            }
        }
        return retval;
    }

    public static PlSqlToken tokenize(Reader reader, Integer maxCodeTokens, String ... userTokens) {
        PlSqlTokenizer tz = new PlSqlTokenizer(reader, maxCodeTokens, userTokens);
        return tz.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlSqlToken tokenizeJava(String source) {
        PlSqlToken retval = null;
        if (source != null) {
            StringReader reader = new StringReader(source);
            try {
                PlSqlTokenizer tz = new PlSqlTokenizer();
                tz.m_SLC = "//";
                tz.tokenizeImpl(reader, null, new String[0]);
                retval = tz.getStartMarker().getNextToken();
            }
            finally {
                reader.close();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlSqlTokenizer(String source, String ... userTokens) {
        if (source != null) {
            StringReader reader = new StringReader(source);
            try {
                this.tokenizeImpl(reader, null, userTokens);
            }
            finally {
                reader.close();
            }
        } else {
            this.tokenizeImpl(null, null, null);
        }
    }

    private PlSqlTokenizer(Reader reader, Integer maxCodeTokens, String ... userTokens) {
        this.tokenizeImpl(reader, maxCodeTokens, userTokens);
    }

    private PlSqlTokenizer() {
    }

    private void tokenizeImpl(Reader reader, Integer maxCodeTokens, String ... userTokens) {
        try {
            this.m_startMarker = new PlSqlToken(PlSqlToken.Type.END_MARKER, -1, null);
            this.m_endMarker = new PlSqlToken(PlSqlToken.Type.END_MARKER, -1, this.m_startMarker);
            this.m_first = null;
            int codeTokenCount = 0;
            char[] buf = new char[1000];
            if (reader == null) {
                return;
            }
            int sourceLength = reader.read(buf);
            if (sourceLength <= 0) {
                return;
            }
            StringBuilder source = new StringBuilder();
            source.append(buf, 0, sourceLength);
            PlSqlToken.Type currentType = PlSqlToken.Type.UNKNOWN;
            int currentPos = 0;
            this.m_lineStarts.add(0);
            boolean quit = false;
            PlSqlToken currentToken = this.m_startMarker;
            while (currentPos < sourceLength && !quit) {
                int chars;
                String currOneCharString = source.substring(currentPos, currentPos + 1);
                String currTwoCharString = currentPos < sourceLength - 1 ? source.substring(currentPos, currentPos + 2) : "";
                String currSLCLengthString = currentPos < sourceLength - this.m_SLC.length() + 1 ? source.substring(currentPos, currentPos + this.m_SLC.length()) : "";
                if (currOneCharString.equals("\n") && this.m_lineStarts.get(this.m_lineStarts.size() - 1) != currentPos + 1) {
                    this.m_lineStarts.add(currentPos + 1);
                }
                switch (currentType) {
                    case UNKNOWN: {
                        boolean userTokenFound = false;
                        for (String userToken : userTokens) {
                            if (currentPos >= sourceLength + 1 - userToken.length() || !source.substring(currentPos, currentPos + userToken.length()).equals(userToken)) continue;
                            currentToken = new PlSqlToken(PlSqlToken.Type.USER_TOKEN, currentPos, currentToken);
                            currentToken.setEnd((currentPos += userToken.length()) - 1);
                            userTokenFound = true;
                            break;
                        }
                        if (userTokenFound) break;
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            currentType = PlSqlToken.Type.WHITESPACE;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            currentToken.setEnd(++currentPos - 1);
                        } else if (currTwoCharString.equals("/*")) {
                            currentType = PlSqlToken.Type.MULTI_LINE_COMMENT;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                            ++currentPos;
                        } else if (currSLCLengthString.equals(this.m_SLC)) {
                            currentType = PlSqlToken.Type.SINGLE_LINE_COMMENT;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                            ++currentPos;
                        } else if (currOneCharString.equals("\"")) {
                            currentType = PlSqlToken.Type.DOUBLE_QUOTED_STRING;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else if (currOneCharString.equals("'")) {
                            currentType = PlSqlToken.Type.SINGLE_QUOTED_STRING;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else if (currTwoCharString.equals(":=") || currTwoCharString.equals("=>") || currTwoCharString.equals("||") || currTwoCharString.equals("**") || currTwoCharString.equals("<<") || currTwoCharString.equals(">>") || currTwoCharString.equals("..") || currTwoCharString.equals("<>") || currTwoCharString.equals("!=") || currTwoCharString.equals("~=") || currTwoCharString.equals("^=") || currTwoCharString.equals("<=") || currTwoCharString.equals(">=")) {
                            currentType = PlSqlToken.Type.PUNCTUATION;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                            ++currentPos;
                        } else if (s_puncPattern.matcher(currOneCharString).matches()) {
                            currentType = PlSqlToken.Type.PUNCTUATION;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        } else {
                            currentType = PlSqlToken.Type.ALPHANUMERIC;
                            currentToken = new PlSqlToken(currentType, currentPos, currentToken);
                            ++currentPos;
                        }
                        if (currentToken.isCode() && maxCodeTokens != null && ++codeTokenCount > maxCodeTokens) {
                            quit = true;
                            break;
                        }
                        if (currentType != PlSqlToken.Type.PUNCTUATION) break;
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    case WHITESPACE: {
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            currentToken.setEnd(++currentPos - 1);
                            break;
                        }
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        if (currentPos < source.length() - 2 && !currTwoCharString.equals("*/")) {
                            ++currentPos;
                            break;
                        }
                        currentToken.setEnd(currentPos + 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    case SINGLE_LINE_COMMENT: {
                        if (!currOneCharString.equals("\n")) {
                            ++currentPos;
                            break;
                        }
                        currentToken.setEnd(currentPos);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case DOUBLE_QUOTED_STRING: {
                        if (!currOneCharString.equals("\"")) {
                            ++currentPos;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals("\"\"")) {
                            ++currentPos;
                            ++currentPos;
                            break;
                        }
                        currentToken.setEnd(currentPos);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case SINGLE_QUOTED_STRING: {
                        if (!currOneCharString.equals("'")) {
                            ++currentPos;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals("''")) {
                            ++currentPos;
                            ++currentPos;
                            break;
                        }
                        currentToken.setEnd(currentPos);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        ++currentPos;
                        break;
                    }
                    case ALPHANUMERIC: {
                        if (s_underDollarHashPattern.matcher(currOneCharString).matches()) {
                            ++currentPos;
                            break;
                        }
                        if (s_wsPattern.matcher(currOneCharString).matches()) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (currentPos < sourceLength - 1 && currTwoCharString.equals("/*")) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (currSLCLengthString.equals(this.m_SLC)) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (currOneCharString.equals("\"")) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (currOneCharString.equals("'")) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (currTwoCharString.equals(":=") || currTwoCharString.equals("=>") || currTwoCharString.equals("||") || currTwoCharString.equals("**") || currTwoCharString.equals("<<") || currTwoCharString.equals(">>") || currTwoCharString.equals("..") || currTwoCharString.equals("<>") || currTwoCharString.equals("!=") || currTwoCharString.equals("~=") || currTwoCharString.equals("^=") || currTwoCharString.equals("<=") || currTwoCharString.equals(">=")) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        if (s_puncPattern.matcher(currOneCharString).matches()) {
                            currentToken.setEnd(currentPos - 1);
                            currentType = PlSqlToken.Type.UNKNOWN;
                            break;
                        }
                        ++currentPos;
                        break;
                    }
                }
                if (currentPos <= sourceLength - 10 || (chars = reader.read(buf)) <= 0) continue;
                source.append(buf, 0, chars);
                sourceLength += chars;
            }
            currentToken.setEnd(source.length() - 1);
            this.m_startMarker.setHeaderSource(source.toString());
            if (this.m_startMarker.getNextToken().getType() != PlSqlToken.Type.END_MARKER) {
                this.m_first = this.m_startMarker.getNextCodeToken();
            }
            int lastIdx = -1;
            for (int i = 0; i < this.m_lineStarts.size(); ++i) {
                int idx = this.m_lineStarts.get(i) / 100;
                if (idx <= lastIdx) continue;
                for (int j = lastIdx + 1; j < idx; ++j) {
                    this.m_offsetIndex.add(j, this.m_offsetIndex.get(lastIdx));
                }
                this.m_offsetIndex.add(idx, i);
                lastIdx = idx;
            }
            this.m_lineStarts.add(source.length() + 1);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getLineNumber(int offset) {
        Integer line;
        int idx = offset / 100;
        if (idx > this.m_offsetIndex.size() - 1) {
            idx = this.m_offsetIndex.size() - 1;
        }
        if ((line = this.m_offsetIndex.get(idx)) == null) {
            line = 0;
        }
        if (line > 0) {
            line = line - 1;
        }
        while (this.m_lineStarts.get(line + 1) <= offset) {
            Integer n = line;
            Integer n2 = line = Integer.valueOf(line + 1);
        }
        return line + 1;
    }

    final PlSqlToken getStartMarker() {
        return this.m_startMarker;
    }

    final PlSqlToken getEndMarker() {
        return this.m_endMarker;
    }

    final PlSqlToken getFirst() {
        return this.m_first;
    }
}

