/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.logging.Level;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;

public final class ProviderReference {
    private final MetaClass<Provider> providerClass;
    private final String name;
    private Provider provider;

    public ProviderReference(String name, MetaClass<Provider> providerClass) {
        this.name = name;
        this.providerClass = providerClass;
    }

    public String name() {
        return this.name;
    }

    public synchronized Provider provider() {
        try {
            if (this.provider == null) {
                this.provider = (Provider)this.providerClass.newInstance();
            }
        }
        catch (Exception e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create searchbar provider from class " + this.providerClass.getClassName(), e);
            this.provider = new NullProvider();
        }
        return this.provider;
    }

    private class NullProvider
    extends Provider<Object> {
        private NullProvider() {
        }

        @Override
        public void search(String searchText, ResultContext context) {
        }

        @Override
        public void open(Result<Object> result) {
            throw new IllegalStateException();
        }
    }
}

