/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableGenericTable;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.BaseController;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.SearchBar;
import oracle.ideimpl.searchbar.SearchBarHook;
import oracle.ideimpl.searchbar.ShowAllNode;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.ideimpl.searchbar.ShowAllTableModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.GenericTablePersistentSettings;

class ShowAllEditor
extends Editor {
    private JPanel mainPanel;
    private GenericTable table;
    private ShowAllTableModel tableModel;
    private SearchField searchField;
    private BaseController controller;
    private ShowAllResultsL showAllResultsL;
    private JComboBox categoryCombo;
    private JLabel resultsLabel;
    private JLabel busyLabel;
    private static EmptyIcon emptyIcon;
    private Toolbar toolbar;
    private static GenericTablePersistentSettings tableSettings;

    ShowAllEditor() {
        this.setEditorAttribute("scrollable", false);
    }

    public void open() {
    }

    public void close() {
        this.controller.stopSearch(true);
        this.controller.getModel().removeResultListener(this.showAllResultsL);
        this.controller.getModel().clear();
        this.tableModel.clear();
        this.controller.disconnect();
        super.close();
    }

    public Component getGUI() {
        if (this.mainPanel == null) {
            this.mainPanel = this.createUI();
            this.setController(ShowAllNode.getInstance().passController());
            this.updateResultsLabel();
        }
        return this.mainPanel;
    }

    private JPanel createUI() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIManager.getColor("Viewport.background"));
        panel.add((Component)this.getToolbar(), "North");
        panel.add((Component)this.createTable(), "Center");
        panel.setPreferredSize(new Dimension(100, 100));
        return panel;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_globalsearchresults_html");
    }

    public Toolbar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
            this.toolbar.setPrimaryViewToolbar(true);
            this.setToolbarVisible(true);
            this.searchField = new SearchField();
            this.searchField.getTextField().setColumns(30);
            this.searchField.setPrompt(Bundle.get("SEARCH_PROMPT"));
            this.searchField.setStyle(SearchField.Style.FILTER);
            this.searchField.addSearchListener((SearchListener)new SearchFieldL());
            this.installSearchFieldKeyboardActions();
            SearchBar.createSearchDropMenu(this.searchField);
            this.categoryCombo = new JComboBox();
            this.categoryCombo.setRenderer(new CategoryRenderer());
            this.categoryCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ShowAllEditor.this.tableModel.filterProvider((Provider)ShowAllEditor.this.categoryCombo.getSelectedItem());
                    ShowAllEditor.this.updateResultsLabel();
                }
            });
            String typeText = Bundle.get("CATEGORY_FILTER_LABEL");
            JLabel typeLabel = new JLabel(StringUtils.stripMnemonic((String)typeText));
            typeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)typeText));
            typeLabel.setLabelFor(this.categoryCombo);
            this.busyLabel = new JLabel();
            this.busyLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            this.searchField.setMaximumSize(this.searchField.getPreferredSize());
            this.categoryCombo.setMaximumSize(this.categoryCombo.getPreferredSize());
            this.toolbar.add((Component)this.searchField);
            this.toolbar.add(Box.createHorizontalStrut(15));
            this.toolbar.add((Component)typeLabel);
            this.toolbar.add((Component)this.categoryCombo);
            this.toolbar.add(Box.createHorizontalStrut(15));
            this.toolbar.add(Box.createHorizontalGlue());
            this.toolbar.add((Component)this.busyLabel);
            this.toolbar.add(Box.createHorizontalStrut(5));
        }
        return this.toolbar;
    }

    private void updateBusy(boolean busy) {
        Icon icon = OracleIcons.getIcon((String)"throbber.gif");
        if (emptyIcon == null) {
            emptyIcon = new EmptyIcon(icon.getIconWidth(), icon.getIconHeight());
        }
        this.busyLabel.setIcon(busy ? icon : emptyIcon);
    }

    private JComponent createTable() {
        this.tableModel = new ShowAllTableModel();
        this.table = new ShowAllTable();
        this.table.setModel((TableModel)this.tableModel);
        this.table.setDefaultRenderer(Result.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new TableResultRenderer()));
        this.table.setColumnSelectorAvailable(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(320);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(320);
        this.table.setSelectionMode(0);
        TableRowSorter<ShowAllTableModel> tableSorter = new TableRowSorter<ShowAllTableModel>(this.tableModel);
        this.table.setRowSorter(tableSorter);
        tableSorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                ShowAllTableModel showAllModel = (ShowAllTableModel)model;
                Object value = showAllModel.getValueAt(row, column);
                if (value instanceof Result) {
                    return ((Result)value).displayText();
                }
                return value.toString();
            }
        });
        this.table.addMouseListener((MouseListener)new DoubleClickL());
        this.bindKey((JComponent)this.table, "ENTER", "openSelectedAction", new OpenAction());
        JScrollPane sp = new JScrollPane((Component)this.table);
        sp.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        if (tableSettings != null) {
            this.table.setPersistentSettings(tableSettings);
        }
        JPanel panel = new JPanel(new BorderLayout());
        this.resultsLabel = new JLabel(String.format("RESULTS_LABEL", 0));
        this.resultsLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.updateBusy(false);
        JPanel headerPanel = new JPanel(new BorderLayout(5, 5));
        headerPanel.add((Component)this.resultsLabel, "Before");
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        headerPanel.setOpaque(false);
        panel.setOpaque(false);
        panel.add((Component)headerPanel, "North");
        panel.add((Component)sp, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow"))));
        return panel;
    }

    private void bindKey(JComponent c, String key, String actionName, Action action) {
        c.getInputMap(1).put(KeyStroke.getKeyStroke(key), actionName);
        c.getInputMap(0).put(KeyStroke.getKeyStroke(key), actionName);
        c.getActionMap().put(actionName, action);
    }

    private void unbindKey(JComponent c, String key) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key);
        c.getInputMap(1).remove(stroke);
        c.getInputMap(0).remove(stroke);
    }

    private void installSearchFieldKeyboardActions() {
        this.unbindKey((JComponent)this.searchField, "UP");
        this.unbindKey((JComponent)this.searchField, "DOWN");
        this.unbindKey((JComponent)this.searchField, "ENTER");
        this.bindKey((JComponent)this.searchField, "UP", "selectPreviousRow", new SelectPrevAction());
        this.bindKey((JComponent)this.searchField, "DOWN", "selectNextRow", new SelectNextAction());
        this.bindKey((JComponent)this.searchField, "ENTER", "openSelectedAction", new OpenAction());
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public Component getDefaultFocusComponent() {
        return this.searchField;
    }

    public void activate() {
        this.updateContents();
        super.activate();
    }

    public void deactivate() {
        tableSettings = this.table.getPersistentSettings();
    }

    public void updateContents() {
        BaseController newController = ShowAllNode.getInstance().passController();
        if (newController != null) {
            this.setController(newController);
        }
        this.updateResultsLabel();
    }

    private void setController(BaseController newController) {
        if (this.controller != null) {
            this.controller.getModel().removeResultListener(this.showAllResultsL);
            this.controller.getModel().clear();
            this.tableModel.clear();
            this.controller.disconnect();
        }
        this.controller = newController;
        this.populateFilters();
        this.showAllResultsL = new ShowAllResultsL();
        this.controller.getModel().addResultListener(this.showAllResultsL);
        this.tableModel.addResults(this.controller.getModel().getAllResults());
        this.searchField.setText(this.controller.getLastSearch(), true);
        this.updateBusy(this.controller.getModel().isRunning());
        SearchBarHook.get().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("PROPERTY_PROVIDER_ENABLED")) {
                    ShowAllEditor.this.updateFilters((Provider)evt.getSource(), (Boolean)evt.getNewValue());
                }
            }
        });
    }

    private void populateFilters() {
        Vector<Provider> providerV = new Vector<Provider>();
        for (Provider provider : this.controller.getProviders()) {
            if (!SearchBarHook.isProviderEnabled(provider)) continue;
            providerV.add(provider);
        }
        Collections.sort(providerV, new Comparator<Provider>(){

            @Override
            public int compare(Provider o1, Provider o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        providerV.add(0, new ShowAllProvider(this.controller));
        this.categoryCombo.setModel(new DefaultComboBoxModel<Object>(providerV.toArray()));
    }

    private void updateFilters(Provider provider, boolean enabled) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.categoryCombo.getModel();
        if (enabled) {
            Provider listProvider;
            int j;
            int i;
            String name = provider.name();
            for (i = 1; i < model.getSize() && (j = name.compareTo((listProvider = (Provider)model.getElementAt(i)).name())) >= 0; ++i) {
            }
            model.insertElementAt(provider, i);
        } else {
            Object selected = this.categoryCombo.getSelectedItem();
            model.removeElement(provider);
        }
        this.categoryCombo.setSelectedIndex(0);
    }

    private void updateResultsLabel() {
        int n;
        int n2 = n = this.categoryCombo.getSelectedIndex() == 0 ? this.controller.getModel().getTotalResultCount() : this.controller.getModel().getCountForProvider((Provider)this.categoryCombo.getSelectedItem());
        if (this.controller.getModel().getTotalResultCount() >= ResultModel.SOFT_LIMIT) {
            this.resultsLabel.setText(MessageFormat.format(Bundle.get("RESULTS_LABEL_LIMIT"), n, this.tableModel.getRowCount()));
        } else {
            this.resultsLabel.setText(String.format(Bundle.get("RESULTS_LABEL"), n));
        }
    }

    private class RowSorter
    extends TableRowSorter {
        public RowSorter(TableModel model) {
            super(model);
        }
    }

    private class ShowAllTable
    extends PeekableGenericTable {
        private ShowAllTable() {
        }

        public Peek createPeek(int row, int col) {
            if (col != 0) {
                return null;
            }
            Result r = ShowAllEditor.this.tableModel.getRow(ShowAllEditor.this.table.getRowSorter().convertRowIndexToModel(row));
            return r.provider().peek(r, (JComponent)ShowAllEditor.this.table, ShowAllEditor.this.table.getCellRect(row, col, true));
        }
    }

    private class CategoryRenderer
    extends DefaultListCellRenderer {
        private CategoryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Provider p = (Provider)value;
            label.setText(p instanceof ShowAllProvider ? Bundle.get("CATEGORY_FILTER_ALL") : (p == null ? "" : p.name()));
            return label;
        }
    }

    private class EmptyIcon
    implements Icon {
        int w;
        int h;

        public EmptyIcon(int width, int height) {
            this.w = width;
            this.h = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }
    }

    private class SearchFieldL
    implements SearchListener {
        private SearchFieldL() {
        }

        public void searchPerformed(SearchEvent se) {
            if (se.getSearchText() == null || se.getSearchText().equals("") || se.isFromClear()) {
                ShowAllEditor.this.controller.stopSearch(true);
            } else {
                ShowAllEditor.this.controller.stopSearch(false);
                ShowAllEditor.this.controller.startSearch(se.getSearchText());
            }
            ShowAllEditor.this.updateResultsLabel();
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }

    private class DoubleClickL
    extends MouseAdapter {
        private DoubleClickL() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2 && ShowAllEditor.this.table.getSelectedRow() != -1) {
                Result r = ShowAllEditor.this.tableModel.getRow(ShowAllEditor.this.table.getRowSorter().convertRowIndexToModel(ShowAllEditor.this.table.getSelectedRow()));
                r.open();
            }
        }
    }

    private class SelectPrevAction
    extends AbstractAction {
        private SelectPrevAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.this.table.getSelectedRow();
            i = Math.max(i - 1, 0);
            ShowAllEditor.this.table.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private class SelectNextAction
    extends AbstractAction {
        private SelectNextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.this.table.getSelectedRow();
            i = Math.min(i + 1, ShowAllEditor.this.table.getRowCount() - 1);
            ShowAllEditor.this.table.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private class OpenAction
    extends AbstractAction {
        private OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ShowAllEditor.this.table.getSelectedRow();
            if (i < 0) {
                return;
            }
            i = ShowAllEditor.this.table.getRowSorter().convertRowIndexToModel(i);
            Result r = ShowAllEditor.this.tableModel.getRow(i);
            r.open();
        }
    }

    private static class TableResultRenderer
    extends DefaultTableCellRenderer {
        private TableResultRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Result) {
                Result result = (Result)value;
                label.setIcon(result.displayIcon());
                label.setText(result.displayText());
            }
            return label;
        }
    }

    private class ShowAllResultsL
    implements ResultModel.ResultListener {
        private ShowAllResultsL() {
        }

        @Override
        public void newResults(Collection<Result<?>> results) {
            ShowAllEditor.this.tableModel.addResults(results);
            ShowAllEditor.this.updateResultsLabel();
        }

        @Override
        public void clearResults() {
            ShowAllEditor.this.tableModel.clear();
            ShowAllEditor.this.updateResultsLabel();
        }

        @Override
        public void runningChange(boolean isRunning) {
            ShowAllEditor.this.updateBusy(isRunning);
            ShowAllEditor.this.updateResultsLabel();
        }

        @Override
        public void deletedResult(Result result) {
            ShowAllEditor.this.tableModel.removeResult(result);
            ShowAllEditor.this.updateResultsLabel();
        }

        @Override
        public void deletedResults(Collection<Result<?>> results) {
            ShowAllEditor.this.tableModel.removeResults(results);
            ShowAllEditor.this.updateResultsLabel();
        }
    }
}

