/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

public class UTFEncoder {
    public static String UTFEncodeXMLString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append(c);
                if (bl) {
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl && (!UTFEncoder.isSafe(c) || c == '&' && !UTFEncoder.andSignIsPartOfUTFCode(string, i))) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public static String UTFEncode(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!UTFEncoder.isSafe(c) || c == '&' && !UTFEncoder.andSignIsPartOfUTFCode(string, i)) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    private static boolean andSignIsPartOfUTFCode(String string, int n) {
        int n2;
        if (string.length() <= n + 3) {
            return false;
        }
        if (string.charAt(n + 1) != '#') {
            return false;
        }
        for (n2 = n + 2; n2 < string.length() && string.charAt(n2) <= '9' && string.charAt(n2) >= '0'; ++n2) {
        }
        return n2 != n + 2 && n2 != string.length() && string.charAt(n2) == ';';
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '&' || c == '-' || c == '_' || c == '.' || c == '*' || c == '#' || c == ' ' || c == '\t' || c == ';' || c == '$' || c == ',' || c == ']' || c == '[' || c == '\'';
    }
}

