/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;

public class RangedBucket
extends Bucket {
    static final long serialVersionUID = -5125025974937295048L;
    Field low = null;
    Field high = null;

    public RangedBucket(String string) {
        super(string);
    }

    public RangedBucket(String string, Field field, Field field2) {
        super(string);
        this.setRange(field, field2);
    }

    public Object clone() {
        RangedBucket rangedBucket = (RangedBucket)super.clone();
        return rangedBucket;
    }

    public Field getLowerBoundValue() {
        return this.low;
    }

    public Field getUpperBoundValue() {
        return this.high;
    }

    public void setRange(Field field, Field field2) {
        this.low = field;
        this.high = field2;
        this.bucketLabel = "" + field + " - " + field2;
    }

    public boolean contains(Field field) {
        block10: {
            if (field == null || this.low == null && this.high == null) {
                return false;
            }
            try {
                if (this.low == null && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(field) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) == 0 && this.isLastBucket()) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                field = this.low != null ? Field.createField(field.getString(), this.low.getShortJavaTypeName()) : Field.createField(field.getString(), this.high.getShortJavaTypeName());
                if (this.low == null && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.high == null && this.low.compareTo(field) <= 0) {
                    return true;
                }
                if (this.low != null && this.high != null && this.low.compareTo(field) <= 0 && this.high.compareTo(field) > 0) {
                    return true;
                }
                if (this.low == null || this.high == null || this.low.compareTo(field) > 0 || this.high.compareTo(field) != 0 || !this.isLastBucket()) break block10;
                return true;
            }
        }
        return false;
    }
}

