/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;

public class VariableMarkerStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = 4360058853925091486L;
    SizeDefinition2D markerSize = new SizeDefinition2D(0.0, 0.0, null);
    String baseMarkerName = null;

    public VariableMarkerStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public VariableMarkerStyleModel(BucketSeries bucketSeries) {
        this.type = 9;
        this.bucketSeries = bucketSeries;
    }

    public Object clone() {
        VariableMarkerStyleModel variableMarkerStyleModel = (VariableMarkerStyleModel)super.clone();
        variableMarkerStyleModel.setSizes(this.markerSize);
        return variableMarkerStyleModel;
    }

    public void setSizes(SizeDefinition2D sizeDefinition2D) {
        this.markerSize = new SizeDefinition2D(0.0, 0.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.markerSize.setSize(sizeDefinition2D.getWidth(), sizeDefinition2D.getHeight());
        this.markerSize.setUnit(sizeDefinition2D.getUnit());
    }

    public String getTypeName() {
        return "ADVANCED";
    }

    public String toXMLString() {
        String string = "<?xml version=\"1.0\" ?>\n";
        string = string + "<AdvancedStyle>\n  <VariableMarkerStyle";
        String string2 = "";
        if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
            string2 = this.markerSize.getUnit();
        }
        String string3 = StyleUtils.getUSLocaleFormat(this.markerSize.getWidth());
        string3 = StyleUtils.cleanDecimalZeros(string3, 1);
        String string4 = StyleUtils.getUSLocaleFormat(this.markerSize.getHeight());
        string4 = StyleUtils.cleanDecimalZeros(string4, 1);
        if (this.markerSize.isPixelUnit()) {
            string3 = String.valueOf((int)this.markerSize.getWidth());
            string4 = String.valueOf((int)this.markerSize.getHeight());
        }
        string = string + " basemarker=\"" + XMLUtil.replaceXMLEntities(this.baseMarkerName) + "\"";
        string = string + " startsize=\"" + string3 + string2 + "\"";
        string = string + " increment=\"" + string4 + string2 + "\">\n";
        string = string + this.bucketSeries.toXMLString();
        string = string + "\n   </VariableMarkerStyle>\n</AdvancedStyle>\n";
        return string;
    }

    public void setStartSize(int n) {
        this.markerSize.setWidth(n);
    }

    public void setStartSize(double d) {
        this.markerSize.setWidth(d);
    }

    public int getStartSize() {
        return (int)this.markerSize.getWidth();
    }

    public double getDoubleStartSize() {
        return this.markerSize.getWidth();
    }

    public void setIncrement(int n) {
        this.markerSize.setHeight(n);
    }

    public void setIncrement(double d) {
        this.markerSize.setHeight(d);
    }

    public int getIncrement() {
        return (int)this.markerSize.getHeight();
    }

    public double getDoubleIncrement() {
        return this.markerSize.getHeight();
    }

    public String getSizesUnit() {
        return this.markerSize.getUnit();
    }

    public void setSizesUnit(String string) {
        this.markerSize.setUnit(string);
    }

    public void setBaseMarkerName(String string) {
        this.baseMarkerName = string;
    }

    public String getBaseMarkerName() {
        return this.baseMarkerName;
    }
}

