/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;

public class BaseMap2
extends BaseMap {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected ZoomLevel[] zoomLevels;

    public void setZoomLevels(ZoomLevel[] zoomLevelArray) {
        this.zoomLevels = zoomLevelArray;
    }

    public ZoomLevel[] getZoomLevels() {
        return this.zoomLevels;
    }

    public int addMapToMapMaker(DBMapMaker dBMapMaker) {
        if (this.zoomLevels == null) {
            return 0;
        }
        ZoomLevel zoomLevel = this.determineZoomLevel(dBMapMaker.getVisContext());
        if (zoomLevel == null) {
            return 0;
        }
        BaseMap.PredefinedThemeDesc[] predefinedThemeDescArray = zoomLevel.themes;
        int n = 0;
        for (int i = 0; i < predefinedThemeDescArray.length; ++i) {
            try {
                BaseMap2.addPredefinedTheme(dBMapMaker, predefinedThemeDescArray[i], i);
                ++n;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return n;
    }

    private static void addPredefinedTheme(DBMapMaker dBMapMaker, BaseMap.PredefinedThemeDesc predefinedThemeDesc, int n) throws Exception {
        Theme theme = dBMapMaker.addPredefinedTheme(predefinedThemeDesc.name, dBMapMaker.getVisContext().getMasterDataSourceName(), n, predefinedThemeDesc.mods, null, null);
    }

    private ZoomLevel determineZoomLevel(VisContext visContext) {
        double d = visContext.getCurrentScale();
        SRSCache sRSCache = DSManager.getSRSCache(visContext.getMasterDataSourceName());
        double d2 = Double.POSITIVE_INFINITY;
        int n = -1;
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            ZoomLevel zoomLevel = this.zoomLevels[i];
            int n2 = zoomLevel.srid;
            double d3 = zoomLevel.scale;
            SRS sRS = sRSCache.get(n2);
            double d4 = sRS.getScreenInchScale(d3, null);
            double d5 = Math.abs(d4 - d);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n = i;
        }
        log.finest("for current scale: " + d + ", best zoom level is: " + n);
        return n < 0 ? null : this.zoomLevels[n];
    }

    public static class ZoomLevel {
        public int id;
        public int srid;
        public double scale;
        public BaseMap.PredefinedThemeDesc[] themes;
    }
}

