/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapStore;

public class BasemapCache {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected BasemapStore basemapStore;
    protected String dsName;
    protected Hashtable basemaps;
    protected int maxSize = 9999;
    private Hashtable editedBasemaps = null;

    public BasemapCache(String string, BasemapStore basemapStore) {
        this.dsName = string;
        this.basemaps = new Hashtable(17);
        this.basemapStore = basemapStore;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setBasemapStore(BasemapStore basemapStore) {
        this.basemapStore = basemapStore;
    }

    public BasemapStore getBasemapStore() {
        return this.basemapStore;
    }

    public synchronized BaseMap getOrLoadBasemap(String string) {
        string = string.toUpperCase();
        BaseMap baseMap = null;
        if (this.editedBasemaps != null && (baseMap = (BaseMap)this.editedBasemaps.get(string)) != null) {
            return baseMap;
        }
        CacheEntry cacheEntry = (CacheEntry)this.basemaps.get(string);
        if (cacheEntry != null) {
            cacheEntry.mark();
            return cacheEntry.basemap;
        }
        BaseMap baseMap2 = null;
        try {
            baseMap2 = this.basemapStore.loadBasemapDefinition(string);
            if (baseMap2 != null) {
                this.putBasemapDefinition(string, baseMap2);
            }
            return baseMap2;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "[datasource:" + this.dsName + "] cannot load basemap " + string, exception);
            return null;
        }
    }

    public BaseMap getBasemap(String string) {
        string = string.toUpperCase();
        BaseMap baseMap = null;
        if (this.editedBasemaps != null && (baseMap = (BaseMap)this.editedBasemaps.get(string)) != null) {
            return baseMap;
        }
        CacheEntry cacheEntry = (CacheEntry)this.basemaps.get(string);
        if (cacheEntry != null) {
            cacheEntry.mark();
            return cacheEntry.basemap;
        }
        return null;
    }

    public void putBasemapDefinition(String string, BaseMap baseMap) {
        string = string.toUpperCase();
        if (this.basemaps.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry cacheEntry = new CacheEntry(baseMap);
        this.basemaps.put(string, cacheEntry);
    }

    public void remove(String string) {
        string = string.toUpperCase();
        this.basemaps.remove(string);
    }

    public void removeAll() {
        this.basemaps.clear();
    }

    private void purge() {
    }

    public boolean addBasemapToEditedList(String string, BaseMap baseMap) {
        if (string == null || baseMap == null) {
            return false;
        }
        if (this.editedBasemaps == null) {
            this.editedBasemaps = new Hashtable();
        }
        this.editedBasemaps.put(string.toUpperCase(), baseMap);
        return true;
    }

    public boolean removeBasemapFromEditedList(String string) {
        if (string == null || this.editedBasemaps == null) {
            return false;
        }
        this.editedBasemaps.remove(string.toUpperCase());
        return true;
    }

    public void clearBasemapEditedList() {
        if (this.editedBasemaps != null) {
            this.editedBasemaps.clear();
        }
    }

    public String[] getCachedBasemapNames() {
        if (this.basemaps == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.basemaps.size()];
        int n = 0;
        Enumeration enumeration = this.basemaps.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    static class CacheEntry {
        BaseMap basemap;
        long lastUsed;

        public CacheEntry(BaseMap baseMap) {
            this.basemap = baseMap;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

