/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.cache.MVHashMap;
import oracle.sdovis.cache.SubRegion;

public class CacheMgr2 {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final String ROOT_REGION = "SDOVIS_DATA";
    static long MAX_CACHE_SIZE = 0x2000000L;
    static int MAX_OBJECTS = 80000000;
    static int REFRESH_INTERVAL = 40;
    private static boolean initialized = false;
    private static boolean enabled = true;
    static boolean _poll_statistics = false;
    static PollerThread pollerThread = null;
    private static int count = 0;
    private static long currentCacheSize = 0L;
    static Hashtable subRegions = null;

    public static boolean isReady() {
        return initialized && enabled;
    }

    public static void setMaxCacheSize(int n) {
        MAX_CACHE_SIZE = n * 1024 * 1024;
        if (n <= 0) {
            enabled = false;
            log.warning("In memory cache will be disabled.");
        } else {
            log.info("In memory cache limit set to: " + n + "MB");
        }
    }

    public static long getMaxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    public static void setMaxObjects(int n) {
        MAX_OBJECTS = n;
    }

    public static int getMaxObjects() {
        return MAX_OBJECTS;
    }

    public static void setReportStats(boolean bl) {
        _poll_statistics = bl;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            subRegions = new Hashtable(11, 0.95f);
            count = 0;
            currentCacheSize = 0L;
            initialized = true;
            log.info("Spatial Data Cache opened. Region=SDOVIS_DATA.");
            log.info("\tmax_cache_size=" + MAX_CACHE_SIZE / 1024L / 1024L + " MB.");
            if (_poll_statistics) {
                CacheMgr2.startStatsPoller();
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error initializing cache manager.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        if (!initialized || !enabled) {
            return;
        }
        try {
            Enumeration enumeration = subRegions.elements();
            while (enumeration.hasMoreElements()) {
                SubRegion subRegion = (SubRegion)enumeration.nextElement();
                subRegion.clear();
            }
            subRegions.clear();
            if (pollerThread != null) {
                pollerThread.stopMe();
            }
            pollerThread = null;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        finally {
            initialized = false;
        }
    }

    public static boolean hasRoom(int n) {
        return currentCacheSize + (long)n < MAX_CACHE_SIZE;
    }

    public static void increaseSize(long l) {
        currentCacheSize += l;
    }

    public static void decreaseSize(long l) {
        currentCacheSize -= l;
    }

    public static long getCurrentSize() {
        return currentCacheSize;
    }

    public static String getSubRegionName(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getUserName();
            String string2 = databaseMetaData.getURL();
            return CacheMgr2.getSubRegionName(string, string2);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
    }

    public static String getSubRegionName(String string, String string2) {
        return "sdovis_subreg_" + (string != null ? string.toLowerCase() : "default") + "_" + (string2 != null ? string2 : "url");
    }

    public static synchronized String createSubRegion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getUserName();
            String string2 = databaseMetaData.getURL();
            return CacheMgr2.createSubRegion(string, string2);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
    }

    public static synchronized String createSubRegion(String string, String string2) {
        if (!initialized || !enabled) {
            return null;
        }
        String string3 = CacheMgr2.getSubRegionName(string, string2);
        if (CacheMgr2.subRegionExists(string3)) {
            return string3;
        }
        SubRegion subRegion = new SubRegion(string3);
        subRegions.put(string3, subRegion);
        log.info("sub region " + string3 + " created in cache.");
        return string3;
    }

    public static synchronized String createSubRegion(String string) {
        if (!initialized || !enabled || string == null) {
            return null;
        }
        if (CacheMgr2.subRegionExists(string)) {
            return string;
        }
        SubRegion subRegion = new SubRegion(string);
        subRegions.put(string, subRegion);
        log.info("sub region " + string + " created in cache.");
        return string;
    }

    public static synchronized boolean subRegionExists(String string) {
        if (!initialized || !enabled) {
            return false;
        }
        return subRegions.containsKey(string);
    }

    public static synchronized SubRegion getSubRegion(String string) {
        return (SubRegion)subRegions.get(string);
    }

    public static synchronized boolean groupExists(String string, String string2) {
        if (!initialized || !enabled) {
            return false;
        }
        SubRegion subRegion = CacheMgr2.getSubRegion(string);
        if (subRegion == null) {
            return false;
        }
        return subRegion.groupExists(string2);
    }

    public static synchronized CacheGroup getGroup(String string, String string2) {
        if (!initialized || !enabled) {
            return null;
        }
        SubRegion subRegion = CacheMgr2.getSubRegion(string);
        if (subRegion == null) {
            return null;
        }
        return subRegion.getGroup(string2);
    }

    public static synchronized void removeGroup(String string, String string2) {
        if (!initialized || !enabled) {
            return;
        }
        SubRegion subRegion = CacheMgr2.getSubRegion(string);
        if (subRegion == null) {
            return;
        }
        subRegion.removeGroup(string2);
    }

    public static void createGeomGroup(String string, String string2, int n, boolean bl) {
        MVHashMap mVHashMap;
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(string, string2) && ((CacheGroup)(mVHashMap = CacheMgr2.getSubRegion(string).getGroup(string2))).isPinned() == bl) {
            return;
        }
        log.info("Creating/replacing a geometry cache group: " + string + " : " + string2 + ".");
        try {
            mVHashMap = CacheMgr2.getSubRegion(string);
            if (mVHashMap == null) {
                throw new Exception("cannot find the specified subregion: " + string);
            }
            ((SubRegion)mVHashMap).createNewGroup(string2, n, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static void createImageGroup(String string, String string2) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(string, string2)) {
            return;
        }
        log.info("creating an image cache group: " + string + " : " + string2 + ".");
        try {
            SubRegion subRegion = CacheMgr2.getSubRegion(string);
            subRegion.createNewGroup(string2, 0, false);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static void createGeoRasterGroup(String string, String string2) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(string, string2)) {
            return;
        }
        log.info("creating an image cache group: " + string + " : " + string2 + ".");
        try {
            SubRegion subRegion = CacheMgr2.getSubRegion(string);
            subRegion.createNewGroup(string2, 0, false);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static void createWFSGroup(String string, String string2) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(string, string2)) {
            return;
        }
        log.info("creating an WFS cache group: " + string + " : " + string2 + ".");
        try {
            SubRegion subRegion = CacheMgr2.getSubRegion(string);
            subRegion.createNewGroup(string2, 0, false);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static synchronized Object getWFSCapabilities(String string, String string2, String string3) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string2, string3);
            return cacheGroup.get(string);
        }
        catch (Exception exception) {
            log.warning("cannot get object using WFS cache loader.");
            return null;
        }
    }

    public static synchronized void put(String string, String string2, Object object, Object object2, long l) {
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string, string2);
            cacheGroup.put(object, object2, l);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static synchronized Object getGeometry(String string, Object object, String string2, String string3) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string2, string3);
            return cacheGroup.get(string);
        }
        catch (Exception exception) {
            log.warning("cannot get object using geom cache loader.");
            return null;
        }
    }

    public static synchronized Object getImage(String string, Object object, String string2, String string3) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string2, string3);
            return cacheGroup.get(string);
        }
        catch (Exception exception) {
            log.warning("cannot get image from cache.");
            return null;
        }
    }

    public static synchronized Object getGeoRasterBlock(String string, Object object, String string2, String string3) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string2, string3);
            return cacheGroup.get(string);
        }
        catch (Exception exception) {
            log.warning("cannot load image using cache loader.");
            return null;
        }
    }

    public static void invalidate(String string) {
        if (!initialized || !enabled) {
            return;
        }
        try {
            SubRegion subRegion = CacheMgr2.getSubRegion(string);
            subRegion.clear();
            log.info("Invalidated subregion " + string);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static void invalidate(String string, String string2) {
        if (!initialized || !enabled) {
            return;
        }
        try {
            CacheGroup cacheGroup = CacheMgr2.getGroup(string, string2);
            cacheGroup.clear();
            log.info("Invalidated group " + string2 + " in subregion " + string);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static void invalidate() {
        if (!initialized || !enabled) {
            return;
        }
        try {
            Enumeration enumeration = subRegions.elements();
            while (enumeration.hasMoreElements()) {
                SubRegion subRegion = (SubRegion)enumeration.nextElement();
                subRegion.invalidate();
            }
            currentCacheSize = 0L;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public static String collectStatistics() {
        if (!initialized || !enabled) {
            return "Cache Info: cache not initialized or enabled.";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("\nMapViewer Spatial Data Cache info (upper limit=" + MAX_CACHE_SIZE / 1024L + "kb):\n" + "\tIn Memory Cache Size:     " + currentCacheSize / 1024L + " kb\n");
            Enumeration enumeration = subRegions.elements();
            while (enumeration.hasMoreElements()) {
                SubRegion subRegion = (SubRegion)enumeration.nextElement();
                stringBuffer.append(subRegion.report(1));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return exception.getMessage();
        }
    }

    private static void startStatsPoller() {
        if (pollerThread != null && !pollerThread.getStop()) {
            pollerThread.stopMe();
        }
        pollerThread = new PollerThread();
        pollerThread.start();
    }

    static class PollerThread
    extends Thread {
        boolean stop = false;

        PollerThread() {
        }

        public void stopMe() {
            this.stop = true;
        }

        public boolean getStop() {
            return this.stop;
        }

        public void run() {
            long l = System.currentTimeMillis();
            while (!this.stop) {
                long l2 = System.currentTimeMillis();
                if (l2 - l < 300000L) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                l = l2;
                log.info(CacheMgr2.collectStatistics());
            }
        }
    }
}

