/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.MapBounds;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.AnnotationTextTheme;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.DataException;
import oracle.sdovis.DynamicGeometryTheme;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.LoadThemeData2;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.NetworkTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.ThemeList;
import oracle.sdovis.TopologyTheme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WFSTheme;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.MapCacheThemeProducer;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.util.Util;

public class DBMapMaker
extends MapMaker {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String mCacheSubRegion = null;
    Vector mBaseMaps = new Vector();

    public DBMapMaker(String string) throws SQLException {
        this(string, "USER_SDO_MAPS", "USER_SDO_THEMES", "ALL_SDO_STYLES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBMapMaker(String string, String string2, String string3, String string4) throws SQLException {
        this.vc.setMasterDataSourceName(string);
        Connection connection = null;
        try {
            CacheMgr2.init();
            DataSourceI dataSourceI = DSManager.get(string);
            if (dataSourceI instanceof DBDataSource) {
                connection = DSUtil.getDBConnection(string, this.vc);
                this.mCacheSubRegion = CacheMgr2.createSubRegion(connection);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
            }
        }
    }

    public String getCacheSubRegionName() {
        return this.mCacheSubRegion;
    }

    public void destroy() {
        this.clear();
    }

    public void addPredefinedMap(String string) throws SQLException {
        BasemapCache basemapCache = null;
        DataSourceI dataSourceI = DSManager.get(this.vc.getMasterDataSourceName());
        basemapCache = dataSourceI.getBasemapCache();
        BaseMap baseMap = basemapCache.getOrLoadBasemap(string);
        if (baseMap != null) {
            baseMap.addMapToMapMaker(this);
            for (int i = 0; i < this.mBaseMaps.size(); ++i) {
                BaseMap baseMap2 = (BaseMap)this.mBaseMaps.get(i);
                if (!baseMap2.getName().equalsIgnoreCase(baseMap.getName())) continue;
                return;
            }
            this.mBaseMaps.add(baseMap);
        }
    }

    public Theme addPredefinedTheme(String string, int n, double d, double d2) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), n, d, d2, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String string, int n, double d, double d2, boolean bl, double d3, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), n, d, d2, bl, d3, bl2, bl3, bl4);
    }

    public Theme addPredefinedTheme(String string, String string2, int n, double d, double d2, boolean bl, double d3, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        return this.addPredefinedTheme(string, string2, n, d, d2, bl, d3, bl2, bl3, bl4, null);
    }

    public Theme addPredefinedTheme(String string, String string2, int n, double d, double d2, boolean bl, double d3, boolean bl2, boolean bl3, boolean bl4, Object[] objectArray) throws SQLException {
        return this.addPredefinedTheme(string, string2, n, d, d2, bl, d3, bl2, bl3, bl4, objectArray, null);
    }

    public Theme addPredefinedTheme(String string, String string2, int n, double d, double d2, boolean bl, double d3, boolean bl2, boolean bl3, boolean bl4, Object[] objectArray, String string3) throws SQLException {
        ThemeDecorator themeDecorator = new ThemeDecorator();
        themeDecorator.setLabelAlwaysOn(bl);
        themeDecorator.setMinScale(d);
        themeDecorator.setMaxScale(d2);
        themeDecorator.setMinDistBetweenPoints(d3);
        themeDecorator.setFixedSVGLabel(bl2);
        themeDecorator.setFastUnpickle(bl3);
        themeDecorator.setReorientLines(bl4);
        return this.addPredefinedTheme(string, string2, n, themeDecorator, objectArray, string3);
    }

    public Theme addPredefinedTheme(String string, String string2, int n, ThemeDecorator themeDecorator, Object[] objectArray, String string3) throws SQLException {
        string = string.toUpperCase();
        if (string3 != null) {
            log.finest("using template theme [name=" + string3 + "]");
        }
        Theme theme = null;
        ThemeDefinition themeDefinition = null;
        ThemeCache themeCache = null;
        DataSourceI dataSourceI = DSManager.get(string2);
        themeCache = dataSourceI.getThemeCache();
        themeDefinition = string3 == null ? themeCache.getOrLoadThemeDefinition(string) : themeCache.getOrLoadThemeDefinition(string3);
        if (themeDefinition == null) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01002") + " [" + string + "]");
            return null;
        }
        String string4 = themeDefinition.getThemeType();
        if ("GEOM_PREDEFINED".equals(string4)) {
            PredGeomThemeDefinition predGeomThemeDefinition = (PredGeomThemeDefinition)themeDefinition;
            theme = new PredefinedGeometryTheme(string, predGeomThemeDefinition, objectArray);
        } else if ("GEOM_DYNAMIC".equals(string4)) {
            theme = new DynamicGeometryTheme((DynGeomThemeDefinition)themeDefinition, objectArray);
        } else if ("GEORASTER".equals(string4)) {
            theme = new GeoRasterTheme((GeoRasterThemeDefinition)themeDefinition, objectArray);
        } else if ("SHADED_RELIEF".equals(string4)) {
            theme = new ShadedReliefTheme((ShadedReliefThemeDefinition)themeDefinition, objectArray);
        } else if ("IMAGE".equals(string4)) {
            theme = new ImageTheme((ImageThemeDefinition)themeDefinition);
        } else if ("NETWORK".equals(string4)) {
            theme = new NetworkTheme((NetworkThemeDefinition)themeDefinition);
        } else if ("SHADED_RELIEF".equals(string4)) {
            theme = new ShadedReliefTheme((ShadedReliefThemeDefinition)themeDefinition);
        } else if ("TOPOLOGY".equals(string4)) {
            theme = new TopologyTheme((TopologyThemeDefinition)themeDefinition);
        } else if ("WFS".equals(string4)) {
            theme = new WFSTheme((WFSThemeDefinition)themeDefinition);
        } else if ("GEOM_CUSTOM".equals(string4)) {
            theme = new CustomGeomTheme((CustomGeomThemeDefinition)themeDefinition);
        } else if ("ANNOTATION".equals(string4)) {
            theme = new AnnotationTextTheme((AnnotationTextThemeDefinition)themeDefinition, objectArray);
        } else if ("WMS".equals(string4)) {
            theme = new WMSMapTheme((WMSMapThemeDefinition)themeDefinition);
        } else {
            log.severe("Invalid theme definition type returned.");
            return null;
        }
        theme.setDecorator(themeDecorator);
        this.vc.getThemeList().addTheme(theme, n);
        return theme;
    }

    public Theme addPredefinedTheme(String string, int n) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), n, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String string) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String string, String string2) throws SQLException {
        return this.addPredefinedTheme(string, string2, this.vc.getThemeList().size(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String string, double d, double d2) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), d, d2, false, -1.0, false, false, true);
    }

    public Theme addPredefinedTheme(String string, double d, double d2, boolean bl, boolean bl2) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), d, d2, false, -1.0, false, bl, bl2);
    }

    public Theme addPredefinedTheme(String string, double d, double d2, boolean bl) throws SQLException {
        return this.addPredefinedTheme(string, this.vc.getMasterDataSourceName(), this.vc.getThemeList().size(), d, d2, bl, -1.0, false, false, true);
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, int n, String[] stringArray, String[] stringArray2, double d, boolean bl2, boolean bl3) {
        Object object;
        string = string.toUpperCase();
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynGeomThemeDefinition dynGeomThemeDefinition = new DynGeomThemeDefinition(string, string2, string3, string4, n2);
        dynGeomThemeDefinition.setFeatureStyleName(string6);
        dynGeomThemeDefinition.setLabelColumn(string7);
        dynGeomThemeDefinition.setLabelStyleName(string8);
        if (stringArray != null && stringArray.length > 0) {
            object = new Field[stringArray.length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                Field field = new Field("").setName(stringArray[i]);
                field.setDisplayName(stringArray2[i]);
                object[i] = field;
            }
            dynGeomThemeDefinition.setIdentifiableColumns((Field[])object);
        }
        dynGeomThemeDefinition.setPassthrough(bl);
        object = new DynamicGeometryTheme(dynGeomThemeDefinition, null);
        ((Theme)object).getDecorator().setLabelAlwaysOn(bl2);
        ((Theme)object).getDecorator().setMinDistBetweenPoints(d);
        ((Theme)object).getDecorator().setFixedSVGLabel(bl3);
        this.addTheme((Theme)object, n);
        return object;
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, String[] stringArray, String[] stringArray2, double d, boolean bl) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, false, n, stringArray, stringArray2, d, bl, false);
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, n, null, null, 1.0, false);
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, int n) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, bl, n, null, null, 1.0, false, false);
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, this.vc.getThemeList().size());
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, bl, this.vc.getThemeList().size());
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String[] stringArray, String[] stringArray2, double d, boolean bl) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, this.vc.getThemeList().size(), stringArray, stringArray2, d, bl);
    }

    public Theme addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String[] stringArray, String[] stringArray2, double d) {
        return this.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, bl, this.vc.getThemeList().size(), stringArray, stringArray2, d, false, false);
    }

    public void addJDBCTopologyTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, int n, String[] stringArray, String[] stringArray2, double d, boolean bl2) {
        Field[] fieldArray;
        string = string.toUpperCase();
        TopologyThemeDefinition topologyThemeDefinition = null;
        topologyThemeDefinition = new TopologyThemeDefinition(string, string2, string3, string6, string4, string5, string7, string8, string9, string10, bl);
        topologyThemeDefinition.setMinDistBetweenNodes(d);
        topologyThemeDefinition.setASIS(bl);
        if (stringArray != null && stringArray.length > 0) {
            fieldArray = new Field[stringArray.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(stringArray[i]);
                field.setDisplayName(stringArray2[i]);
                fieldArray[i] = field;
            }
            topologyThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        fieldArray = new TopologyTheme(topologyThemeDefinition);
        fieldArray.getDecorator().setLabelAlwaysOn(bl2);
        fieldArray.getDecorator().setMinDistBetweenPoints(d);
        this.addTheme((Theme)fieldArray, n);
    }

    public void addJDBCTopologyDebugTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, String string8, String string9, String string10, String string11, String string12, boolean bl, int n2) {
        string = string.toUpperCase();
        TopologyThemeDefinition topologyThemeDefinition = null;
        topologyThemeDefinition = new TopologyThemeDefinition(string, string2, string5, string3, string4, string6, string7, n, string8, string9, string10, string11, string12, bl);
        topologyThemeDefinition.setASIS(bl);
        TopologyTheme topologyTheme = new TopologyTheme(topologyThemeDefinition);
        topologyTheme.getDecorator().setLabelAlwaysOn(true);
        this.addTheme(topologyTheme, n2);
    }

    public void addJDBCAnnotationTheme(String string, String string2, String string3, String string4, String string5, int n, boolean bl) {
        this.addJDBCAnnotationTheme(string, string2, string3, string4, string5, n, bl, this.vc.getThemeList().size());
    }

    public void addJDBCAnnotationTheme(String string, String string2, String string3, String string4, String string5, int n, boolean bl, int n2) {
        string = string.toUpperCase();
        AnnotationTextThemeDefinition annotationTextThemeDefinition = new AnnotationTextThemeDefinition(string, string2, string3, string4, string5, n, bl);
        AnnotationTextTheme annotationTextTheme = new AnnotationTextTheme(annotationTextThemeDefinition);
        this.addTheme(annotationTextTheme, n2);
    }

    public void addJDBCAnnotationTheme(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) {
        this.addJDBCAnnotationTheme(string, string2, string3, string4, string5, string6, n, bl, this.vc.getThemeList().size());
    }

    public void addJDBCAnnotationTheme(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl, int n2) {
        string = string.toUpperCase();
        AnnotationTextThemeDefinition annotationTextThemeDefinition = new AnnotationTextThemeDefinition(string, string2, string3, string4, string5, string6, n, bl);
        AnnotationTextTheme annotationTextTheme = new AnnotationTextTheme(annotationTextThemeDefinition);
        this.addTheme(annotationTextTheme, n2);
    }

    public Style loadStyleFromDB(String string) {
        return this.loadStyleFromDB(string, this.vc.getMasterDataSourceName());
    }

    public Style loadStyleFromDB(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
            StyleCache styleCache = dBDataSource.getStyleCache();
            return styleCache.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadStylesFromDB(StylingRule[] stylingRuleArray) {
        if (stylingRuleArray == null) {
            return;
        }
        for (int i = 0; i < stylingRuleArray.length; ++i) {
            StylingRule stylingRule = stylingRuleArray[i];
            String string = stylingRule.getFeatureStyleName();
            this.loadStyleFromDB(string);
            if (!stylingRule.getLabeled()) continue;
            string = stylingRule.getLabelStyleName();
            this.loadStyleFromDB(string);
        }
    }

    public void loadStylesFromDB(Theme theme) {
        if (theme == null) {
            return;
        }
        for (int i = 0; i < theme.size(); ++i) {
            StyledFeatureI styledFeatureI = theme.getStyledFeature(i);
            this.loadStyleFromDB(styledFeatureI.getFeatureStyleName());
            this.loadStyleFromDB(styledFeatureI.getLabelStyleName());
        }
    }

    public void renderMap(MapBounds mapBounds, Graphics2D graphics2D) throws DataException {
        MapBounds mapBounds2 = this.transformBounds(mapBounds);
        this.vc.setQueryWindowSrid(mapBounds2.getSrid());
        switch (mapBounds2.getType()) {
            case 3: {
                this.vc.setBoundingThemes(mapBounds2.getBoundingThemes(), mapBounds2.getBoundingThemeBorderMargin(), mapBounds2.isBoundingThemeKeepAspectRatio());
                this.vc.setBoundingThemesSizeHint(mapBounds2.getBoundingThemeSizeHint());
                this.renderMap(graphics2D);
                return;
            }
            case 2: {
                double[] dArray = mapBounds2.getCenterSize();
                this.renderMap(dArray[0], dArray[1], dArray[2], graphics2D);
                return;
            }
            case 1: {
                double[] dArray = mapBounds2.getRect();
                if (mapBounds2.isKeepBoxAspectRatio()) {
                    Rectangle2D rectangle2D = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
                    rectangle2D = this.getMBRWithAspectRatio(this.vc, rectangle2D);
                    dArray[0] = rectangle2D.getMinX();
                    dArray[1] = rectangle2D.getMinY();
                    dArray[2] = rectangle2D.getMaxX();
                    dArray[3] = rectangle2D.getMaxY();
                }
                this.renderMap(dArray[0], dArray[1], dArray[2], dArray[3], graphics2D);
                return;
            }
            case 4: {
                double[] dArray = mapBounds2.getCenterSize();
                long l = mapBounds2.getScale();
                this.renderMapWithScale(dArray[0], dArray[1], l, graphics2D);
                return;
            }
        }
        this.renderMap(graphics2D);
    }

    public Image renderMap(MapBounds mapBounds) throws DataException {
        Graphics2D graphics2D = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderMap(mapBounds, graphics2D);
        graphics2D.dispose();
        return this.vc.getMapImage();
    }

    private Rectangle2D getMBRWithAspectRatio(VisContext visContext, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        double d = double_.getMinX();
        double d2 = double_.getMinY();
        double d3 = double_.getMaxX();
        double d4 = double_.getMaxY();
        double d5 = Math.abs(d4 - d2);
        double d6 = Math.abs(d3 - d);
        if (d5 == 0.0 || d6 == 0.0) {
            return double_;
        }
        double d7 = d6 / d5;
        Rectangle2D rectangle2D2 = visContext.getDeviceWindow();
        double d8 = rectangle2D2.getWidth() / rectangle2D2.getHeight();
        if (d7 > d8) {
            d5 = d6 / d8;
        } else if (d7 < d8) {
            d6 = d5 * d8;
        }
        double d9 = (d + d3) / 2.0;
        double d10 = (d2 + d4) / 2.0;
        d = d9 - d6 / 2.0;
        d2 = d10 - d5 / 2.0;
        d3 = d9 + d6 / 2.0;
        d4 = d10 + d5 / 2.0;
        double_.add(d, d2);
        double_.add(d3, d4);
        return double_;
    }

    public void renderSVGMap(Writer writer, MapBounds mapBounds, boolean bl) throws DataException, IOException {
        MapBounds mapBounds2 = this.transformBounds(mapBounds);
        this.vc.setQueryWindowSrid(mapBounds2.getSrid());
        switch (mapBounds2.getType()) {
            case 3: {
                this.vc.setBoundingThemes(mapBounds2.getBoundingThemes(), mapBounds2.getBoundingThemeBorderMargin(), mapBounds2.isBoundingThemeKeepAspectRatio());
                this.vc.setBoundingThemesSizeHint(mapBounds2.getBoundingThemeSizeHint());
                this.renderSVGMap(writer, bl);
                return;
            }
            case 2: {
                double[] dArray = mapBounds2.getCenterSize();
                this.renderSVGMap(writer, dArray[0], dArray[1], dArray[2], bl);
                return;
            }
            case 1: {
                double[] dArray = mapBounds2.getRect();
                if (mapBounds2.isKeepBoxAspectRatio()) {
                    Rectangle2D rectangle2D = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
                    rectangle2D = this.getMBRWithAspectRatio(this.vc, rectangle2D);
                    dArray[0] = rectangle2D.getMinX();
                    dArray[1] = rectangle2D.getMinY();
                    dArray[2] = rectangle2D.getMaxX();
                    dArray[3] = rectangle2D.getMaxY();
                }
                this.renderSVGMap(writer, dArray[0], dArray[1], dArray[2], dArray[3], bl);
                return;
            }
            case 4: {
                double[] dArray = mapBounds2.getCenterSize();
                long l = mapBounds2.getScale();
                this.renderSVGMapWithScale(writer, dArray[0], dArray[1], l, bl);
                return;
            }
        }
        this.renderSVGMap(writer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapBounds transformBounds(MapBounds mapBounds) {
        Object object;
        Object object2;
        int n = mapBounds.getSrid();
        int n2 = this.vc.getMasterSRID();
        if (n2 == 0 && this.vc.getThemeList() != null && (object2 = this.vc.getThemeList().getTheme(0)) != null) {
            n2 = ((Theme)object2).getSRID();
        }
        if (n == 0 || n2 == 0 || n == n2 || mapBounds.getType() == 3) {
            return mapBounds;
        }
        object2 = this.getJDBCConnection();
        if (object2 == null) {
            log.warning("error getting a database connection.");
            return mapBounds;
        }
        try {
            switch (mapBounds.getType()) {
                case 1: {
                    double[] dArray = mapBounds.getRect();
                    double[] dArray2 = Util.transform((Connection)object2, dArray[0], dArray[1], dArray[2], dArray[3], n, n2);
                    if (dArray2 != null) {
                        MapBounds mapBounds2 = new MapBounds(dArray2[0], dArray2[1], dArray2[2], dArray2[3], n2, mapBounds.isKeepBoxAspectRatio());
                        return mapBounds2;
                    }
                    throw new DataException("cannot transform rectangle.");
                }
                case 2: {
                    object = mapBounds.getCenterSize();
                    double[] dArray3 = Util.transform((Connection)object2, object[0], object[1], object[2], n, n2);
                    if (dArray3 != null) {
                        MapBounds mapBounds3 = new MapBounds(dArray3[0], dArray3[1], dArray3[2], n2);
                        return mapBounds3;
                    }
                }
                case 4: {
                    double[] dArray = mapBounds.getCenterSize();
                    double[] dArray3 = Util.transform((Connection)object2, dArray[0], dArray[1], n, n2);
                    if (dArray3 != null) {
                        MapBounds mapBounds4 = new MapBounds(dArray3[0], dArray3[1], mapBounds.getScale(), n2);
                        return mapBounds4;
                    }
                    throw new DataException("cannot transform center point");
                }
            }
            MapBounds mapBounds5 = mapBounds;
            return mapBounds5;
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            object = mapBounds;
            return object;
        }
        finally {
            try {
                object2.close();
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image renderEm(Graphics2D graphics2D) throws DataException {
        long l = System.currentTimeMillis();
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D.getMinX() == Double.NEGATIVE_INFINITY || rectangle2D.getMinY() == Double.NEGATIVE_INFINITY || rectangle2D.getMaxX() == Double.POSITIVE_INFINITY || rectangle2D.getMaxY() == Double.POSITIVE_INFINITY) {
            this.clearRotation();
        }
        this.vc.setInterrupted(false);
        this.vc.setScale(rectangle2D, rectangle2D2);
        if (!(this.vc.getBoundingThemes() == null || rectangle2D.getMinX() != Double.NEGATIVE_INFINITY && rectangle2D.getMinY() != Double.NEGATIVE_INFINITY && rectangle2D.getMaxX() != Double.POSITIVE_INFINITY && rectangle2D.getMaxY() != Double.POSITIVE_INFINITY || this.vc.getNoQuery())) {
            if (this.prepareBoundingThemes(this.vc) == null) {
                log.info(RSBundle.getMsg("MAPVIEWER-01004"));
                throw new DataException(RSBundle.getMsg("MAPVIEWER-01004"));
            }
            rectangle2D = this.vc.getQueryWindow();
        }
        if (rectangle2D.getMinX() != Double.NEGATIVE_INFINITY && rectangle2D.getMinY() != Double.NEGATIVE_INFINITY && rectangle2D.getMaxX() != Double.POSITIVE_INFINITY && rectangle2D.getMaxY() != Double.POSITIVE_INFINITY && this.vc.shouldUseCachedBaseMap()) {
            this.processCachedBaseMap();
        }
        if (rectangle2D.getMinX() != Double.NEGATIVE_INFINITY && rectangle2D.getMinY() != Double.NEGATIVE_INFINITY && rectangle2D.getMaxX() != Double.POSITIVE_INFINITY && rectangle2D.getMaxY() != Double.POSITIVE_INFINITY && this.vc.getBgImage() == null && this.vc.mapCacheThemeExists()) {
            this.adjustQueryWindowForMapCacheTheme();
        }
        this.beginHandlingNSProviders(this.vc, null);
        try {
            if (!this.vc.getNoQuery()) {
                this.prepareThemes(this.vc);
            }
        }
        finally {
            this.vc.setNoQuery(false);
        }
        if (rectangle2D.getMinX() == Double.NEGATIVE_INFINITY || rectangle2D.getMinY() == Double.NEGATIVE_INFINITY || rectangle2D.getMaxX() == Double.POSITIVE_INFINITY || rectangle2D.getMaxY() == Double.POSITIVE_INFINITY) {
            rectangle2D = this.buildDataMBR();
            if (rectangle2D == null) {
                throw new DataException(RSBundle.getMsg("MAPVIEWER-01005"));
            }
            this.vc.setQueryWindow(rectangle2D);
            this.vc.setScale(rectangle2D, rectangle2D2);
        }
        this.endHandlingNSProviders(this.vc, null);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        log.info(" **** time spent on loading features: " + l3 + "ms.");
        l = System.currentTimeMillis();
        this.mRenderEng.render(graphics2D, this.vc);
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        log.info(" **** time spent on rendering: " + l4 + "ms");
        this.vc.setLastRotation(this.vc.getRotation());
        return this.vc.getMapImage();
    }

    private void adjustQueryWindowForMapCacheTheme() throws DataException {
        ThemeList themeList = this.vc.getThemeList();
        boolean bl = false;
        for (int i = 0; i < themeList.size(); ++i) {
            Theme theme = themeList.getTheme(i);
            if (!(theme instanceof MapCacheTheme)) continue;
            MapCacheTheme mapCacheTheme = (MapCacheTheme)theme;
            Rectangle2D rectangle2D = null;
            if (mapCacheTheme.getExternalMapViewerURL() == null) {
                rectangle2D = mapCacheTheme.getCacheInstance().getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), false);
            } else {
                MapCacheThemeProducer mapCacheThemeProducer = (MapCacheThemeProducer)theme.getProducer();
                mapCacheThemeProducer.prepareData(this.vc.getQueryWindow(), this.vc);
                rectangle2D = mapCacheThemeProducer.getMapWindow();
            }
            mapCacheTheme.setMapWindow(rectangle2D);
            if (!bl && mapCacheTheme.snapToCachedScale()) {
                this.vc.setQueryWindow(rectangle2D);
            }
            for (int j = i + 1; j < themeList.size(); ++j) {
                Theme theme2 = themeList.getTheme(j);
                if (!(theme2 instanceof MapCacheTheme)) continue;
                ((MapCacheTheme)theme2).setMapWindow(rectangle2D);
            }
            return;
        }
    }

    private void processCachedBaseMap() {
        this.vc.setMapCacheInstance(this);
        MapCache mapCache = this.vc.getMapCache();
        if (mapCache == null) {
            return;
        }
        Rectangle2D rectangle2D = mapCache.getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), !this.vc.snapToCachedScale());
        Image image = null;
        if (rectangle2D != null) {
            try {
                image = mapCache.getMap(rectangle2D, (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight());
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Failed to generated cached base map!", exception);
            }
        }
        if (image != null) {
            this.vc.setQueryWindow(rectangle2D);
            this.vc.removeBaseMapThemes();
            this.vc.setBgImage(image);
        }
    }

    public void beginHandlingNSProviders(VisContext visContext, String string) throws DataException {
        NsDpHandler nsDpHandler;
        int n;
        Vector vector = visContext.getNsDpHandlers();
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            nsDpHandler = (NsDpHandler)vector.get(n);
            if (string != null && !nsDpHandler.getDef().getTheme().equalsIgnoreCase(string)) continue;
            nsDpHandler.startThread();
        }
        try {
            for (n = 0; n < vector.size(); ++n) {
                boolean bl;
                nsDpHandler = (NsDpHandler)vector.get(n);
                if ((string == null || nsDpHandler.getDef().getTheme().equalsIgnoreCase(string)) && (bl = nsDpHandler.waitForThread())) continue;
            }
        }
        catch (Exception exception) {
            throw new DataException("Error processing NS data provider(s).", exception);
        }
    }

    public void endHandlingNSProviders(VisContext visContext, String string) throws DataException {
        Vector vector = visContext.getNsDpHandlers();
        if (vector == null || vector.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < vector.size(); ++i) {
                NsDpHandler nsDpHandler = (NsDpHandler)vector.get(i);
                if (string != null && !nsDpHandler.getDef().getTheme().equalsIgnoreCase(string)) continue;
                nsDpHandler.doDataJoin(visContext);
            }
        }
        catch (Exception exception) {
            throw new DataException("Error processing NS data provider(s).", exception);
        }
    }

    public Connection getJDBCConnection() {
        try {
            return DSUtil.getDBConnection(this.vc.getMasterDataSourceName(), this.vc);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
    }

    public Style getStyleWithName(String string) {
        return DBMapMaker.getStyleWithName(string, this.vc.getMasterDataSourceName(), this.vc);
    }

    public void invalidateThemeDataCache(String string) {
        this.invalidateThemeDataCache(string, this.vc.getMasterDataSourceName());
    }

    private void invalidateThemeDataCache(ThemeDefinition themeDefinition, ThemeCache themeCache) {
        String string;
        Enumeration enumeration;
        Exception exception;
        String string2;
        String string3;
        ThemeDefinition themeDefinition2;
        String string4 = themeDefinition.getName();
        if (themeDefinition instanceof PredGeomThemeDefinition) {
            themeDefinition2 = (PredGeomThemeDefinition)themeDefinition;
            string3 = ((PredGeomThemeDefinition)themeDefinition2).getCacheGroupName();
            string2 = ((PredGeomThemeDefinition)themeDefinition2).getCacheSubRegionName();
            exception = null;
            try {
                CacheMgr2.invalidate(string2, string3);
                log.info("Invalidated theme " + string4 + "'s cached data: " + string3);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (((PredGeomThemeDefinition)themeDefinition2).getSRidCache().size() > 0) {
                enumeration = ((PredGeomThemeDefinition)themeDefinition2).getSRidCache().elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        CacheMgr2.invalidate(string2, string);
                        log.info("Invalidated theme " + string4 + "'s cached data: " + string);
                    }
                    catch (Exception exception3) {
                        log.warning(exception3.getMessage());
                    }
                }
                ((PredGeomThemeDefinition)themeDefinition2).getSRidCache().clear();
            }
            themeCache.remove(string4);
        }
        if (themeDefinition instanceof NetworkThemeDefinition) {
            themeDefinition2 = (NetworkThemeDefinition)themeDefinition;
            string3 = ((NetworkThemeDefinition)themeDefinition2).getLinkCacheGroup();
            string2 = ((NetworkThemeDefinition)themeDefinition2).getCacheSubRegion();
            exception = null;
            try {
                CacheMgr2.invalidate(string2, string3);
                log.info("Invalidated theme " + string4 + "'s cached data: " + string3);
            }
            catch (Exception exception4) {
                exception = exception4;
            }
            if (((NetworkThemeDefinition)themeDefinition2).getLinkSRidCache().size() > 0) {
                enumeration = ((NetworkThemeDefinition)themeDefinition2).getLinkSRidCache().elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        CacheMgr2.invalidate(string2, string);
                        log.info("Invalidated theme " + string4 + "'s cached data: " + string);
                    }
                    catch (Exception exception5) {
                        log.warning(exception5.getMessage());
                        return;
                    }
                }
                ((NetworkThemeDefinition)themeDefinition2).getLinkSRidCache().clear();
            }
            string3 = ((NetworkThemeDefinition)themeDefinition2).getNodeCacheGroup();
            try {
                CacheMgr2.invalidate(string2, string3);
                log.info("Invalidated theme " + string4 + "'s cached data: " + string3);
            }
            catch (Exception exception6) {
                exception = exception6;
            }
            if (((NetworkThemeDefinition)themeDefinition2).getNodeSRidCache().size() > 0) {
                enumeration = ((NetworkThemeDefinition)themeDefinition2).getNodeSRidCache().elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        CacheMgr2.invalidate(string2, string);
                        log.info("Invalidated theme " + string4 + "'s cached data: " + string);
                    }
                    catch (Exception exception7) {
                        log.warning(exception7.getMessage());
                        return;
                    }
                }
                ((NetworkThemeDefinition)themeDefinition2).getNodeSRidCache().clear();
            }
        }
        if (themeDefinition instanceof TopologyThemeDefinition) {
            themeDefinition2 = (TopologyThemeDefinition)themeDefinition;
            string3 = ((TopologyThemeDefinition)themeDefinition2).getCacheEdgeGroup();
            string2 = ((TopologyThemeDefinition)themeDefinition2).getCacheSubRegion();
            exception = null;
            try {
                CacheMgr2.invalidate(string2, string3);
                log.info("Invalidated theme " + string4 + "'s cached data: " + string3);
            }
            catch (Exception exception8) {
                exception = exception8;
            }
            if (((TopologyThemeDefinition)themeDefinition2).getSRidEdgeCache().size() > 0) {
                enumeration = ((TopologyThemeDefinition)themeDefinition2).getSRidEdgeCache().elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        CacheMgr2.invalidate(string2, string);
                        log.info("Invalidated theme " + string4 + "'s cached data: " + string);
                    }
                    catch (Exception exception9) {
                        log.warning(exception9.getMessage());
                    }
                }
                ((TopologyThemeDefinition)themeDefinition2).getSRidEdgeCache().clear();
            }
            string3 = ((TopologyThemeDefinition)themeDefinition2).getCacheNodeGroup();
            try {
                CacheMgr2.invalidate(string2, string3);
                log.info("Invalidated theme " + string4 + "'s cached data: " + string3);
            }
            catch (Exception exception10) {
                exception = exception10;
            }
            if (((TopologyThemeDefinition)themeDefinition2).getSRidNodeCache().size() > 0) {
                enumeration = ((TopologyThemeDefinition)themeDefinition2).getSRidNodeCache().elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        string = enumeration.nextElement().toString();
                        CacheMgr2.invalidate(string2, string);
                        log.info("Invalidated theme " + string4 + "'s cached data: " + string);
                    }
                    catch (Exception exception11) {
                        log.warning(exception11.getMessage());
                    }
                }
                ((TopologyThemeDefinition)themeDefinition2).getSRidNodeCache().clear();
            }
            themeCache.remove(string4);
        }
        if (themeDefinition instanceof WFSThemeDefinition) {
            themeDefinition2 = (WFSThemeDefinition)themeDefinition;
            ((WFSThemeDefinition)themeDefinition2).clearCapabilitiesFromCache();
        }
    }

    public void invalidateThemeDataCache(String string, String string2) {
        ThemeDefinition themeDefinition = null;
        ThemeCache themeCache = null;
        try {
            DataSourceI dataSourceI = DSManager.get(string2);
            themeCache = dataSourceI.getThemeCache();
            themeDefinition = themeCache.getThemeDefinition(string);
            if (themeDefinition == null) {
                return;
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            return;
        }
        this.invalidateThemeDataCache(themeDefinition, themeCache);
    }

    public void inavlidateAllThemeDataCaches(String string) {
        ThemeDefinition themeDefinition = null;
        ThemeCache themeCache = null;
        try {
            DataSourceI dataSourceI = DSManager.get(string);
            themeCache = dataSourceI.getThemeCache();
            if (themeCache == null) {
                return;
            }
            String[] stringArray = themeCache.getCachedThemeNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                themeDefinition = themeCache.getThemeDefinition(string2);
                if (themeDefinition == null) continue;
                this.invalidateThemeDataCache(themeDefinition, themeCache);
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            return;
        }
    }

    public void prepareThemes(VisContext visContext) throws DataException {
        this.prepareThemes2(visContext);
    }

    public void prepareThemes2(VisContext visContext) throws DataException {
        visContext.setDataException(null);
        for (int i = 0; i < visContext.getThemeList().size(); ++i) {
            Theme theme = visContext.getThemeList().getTheme(i);
            if (theme.getDecorator().isPrepared()) continue;
            if (this.isThemeToBePrepared(theme, visContext)) {
                Rectangle2D rectangle2D = visContext.getQueryWindow();
                LoadThemeData2 loadThemeData2 = new LoadThemeData2(theme, rectangle2D, visContext);
                loadThemeData2.run();
                if (!visContext.shouldReportError()) continue;
                throw visContext.getDataException();
            }
            this.setEmptyFeatures(theme);
        }
    }

    private boolean isThemeToBePrepared(Theme theme, VisContext visContext) {
        if (visContext.getMasterSRID() > 0 && theme.getDefinition().getSrid() > 0 && theme.getDefinition().getSrid() != visContext.getMasterSRID()) {
            return true;
        }
        Rectangle2D rectangle2D = visContext.getQueryWindow();
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double d5 = visContext.getCurrentScale();
        if (Util.isFullExtent(d, d2, d3, d4) || d5 == Double.POSITIVE_INFINITY || d5 == Double.NEGATIVE_INFINITY) {
            return true;
        }
        SRSCache sRSCache = DSManager.getSRSCache(theme.getDefinition().getDataSourceName());
        if (sRSCache == null) {
            return true;
        }
        SRS sRS = sRSCache.get(theme.getDefinition().getSrid());
        double d6 = 1.0;
        double d7 = d5 * d6;
        if (theme.getDecorator().getScaleType() == "RATIO") {
            if (sRS == null) {
                log.severe("Theme must have SRS when using ratio scale mode. [" + theme.getName() + "]");
                return false;
            }
            double d8 = (d + d3) / 2.0;
            double d9 = (d2 + d4) / 2.0;
            if (visContext.isTileRequest() && sRS.isGeodetic()) {
                d8 = 0.0;
                d9 = 0.0;
            }
            d7 = sRS.getRatioScale(d5 * d6, new Point2D.Double(d8, d9));
        }
        if (!theme.getDecorator().withinScaleLimits(d7)) {
            if (theme.getDecorator().getScaleType() == "RATIO") {
                log.info("Scale range for theme " + theme.getName() + " is out of map scale [Ratio scale= 1:" + (long)Math.rint(d7) + "].");
            } else {
                log.info("Scale range for theme " + theme.getName() + " is out of map scale [Screen inch scale= " + d7 + "].");
            }
            return false;
        }
        return true;
    }

    public void setEmptyFeatures(Theme theme) {
        if (theme == null) {
            return;
        }
        if (theme instanceof GeoRasterTheme || theme instanceof ImageTheme || theme instanceof WMSMapTheme || theme instanceof MapCacheTheme) {
            theme.getProducer().destroy();
        } else if (!(theme instanceof LocalTheme)) {
            theme.getProducer().setStyledFeatures(new StyledFeatureI[0]);
        }
    }

    public Rectangle2D prepareBoundingThemes(VisContext visContext) throws DataException {
        Cloneable cloneable;
        int n;
        log.finest("Preparing bounding themes...");
        String[] stringArray = visContext.getBoundingThemes();
        for (n = 0; n < stringArray.length; ++n) {
            cloneable = visContext.getThemeList().getLastMatchingTheme(stringArray[n]);
            if (cloneable == null || cloneable.getDecorator().isPrepared()) continue;
            LoadThemeData2 loadThemeData2 = new LoadThemeData2((Theme)cloneable, visContext.getQueryWindow(), visContext);
            loadThemeData2.run();
            if (!visContext.shouldReportError()) continue;
            throw visContext.getDataException();
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.beginHandlingNSProviders(this.vc, stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.endHandlingNSProviders(this.vc, stringArray[n]);
        }
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        cloneable = this.vc.getDeviceWindow();
        rectangle2D = visContext.getBoundingThemesSizeHint() <= 0.0 ? this.buildDataMBR(stringArray, visContext.getBorderMarginForBoundingThemes(), visContext.boundingThemesRespectAspectRatio(), (Rectangle2D)cloneable) : this.buildDataMBR(stringArray, visContext.getBoundingThemesSizeHint(), visContext.getBorderMarginForBoundingThemes(), visContext.boundingThemesRespectAspectRatio(), (Rectangle2D)cloneable);
        if (rectangle2D != null) {
            this.vc.setQueryWindow(rectangle2D);
            this.vc.setScale(rectangle2D, (Rectangle2D)cloneable);
        }
        return rectangle2D;
    }

    public void clear() {
        log.info("Clearing in-memory geometry and metadata caches.");
        try {
            CacheMgr2.invalidate(this.mCacheSubRegion);
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        ThemeList themeList = this.vc.getThemeList();
        if (themeList != null) {
            themeList.clear();
        }
        ThemeCache themeCache = null;
        BasemapCache basemapCache = null;
        DataSourceI dataSourceI = DSManager.get(this.vc.getMasterDataSourceName());
        if (dataSourceI != null) {
            themeCache = dataSourceI.getThemeCache();
            if (themeCache != null) {
                themeCache.removeAll();
            }
            if ((basemapCache = dataSourceI.getBasemapCache()) != null) {
                basemapCache.removeAll();
            }
        }
    }

    public void clearOwnerTableSridCache() {
        Hashtable hashtable;
        log.info("clearing data source owner-table-srid cache");
        DataSourceI dataSourceI = DSManager.get(this.vc.getMasterDataSourceName());
        if (dataSourceI != null && dataSourceI instanceof FileDataSource) {
            return;
        }
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.vc.getMasterDataSourceName());
        if (abstractDBDataSource != null && (hashtable = abstractDBDataSource.getOwnerTableSridCache()) != null) {
            hashtable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSVGEm(Writer writer, boolean bl) throws DataException, IOException {
        long l = System.currentTimeMillis();
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D.getMinX() == Double.NEGATIVE_INFINITY || rectangle2D.getMinY() == Double.NEGATIVE_INFINITY || rectangle2D.getMaxX() == Double.POSITIVE_INFINITY || rectangle2D.getMaxY() == Double.POSITIVE_INFINITY) {
            this.clearRotation();
        }
        this.vc.setScale(rectangle2D, rectangle2D2);
        if (!(this.vc.getBoundingThemes() == null || rectangle2D.getMinX() != Double.NEGATIVE_INFINITY && rectangle2D.getMinY() != Double.NEGATIVE_INFINITY && rectangle2D.getMaxX() != Double.POSITIVE_INFINITY && rectangle2D.getMaxY() != Double.POSITIVE_INFINITY || this.vc.getNoQuery())) {
            if (this.prepareBoundingThemes(this.vc) == null) {
                log.info(RSBundle.getMsg("DBMapMaker-error-3"));
                throw new DataException(RSBundle.getMsg("DBMapMaker-error-3"));
            }
            rectangle2D = this.vc.getQueryWindow();
        }
        this.beginHandlingNSProviders(this.vc, null);
        try {
            if (!this.vc.getNoQuery()) {
                this.prepareThemes(this.vc);
            }
        }
        finally {
            this.vc.setNoQuery(false);
        }
        if (rectangle2D.getMinX() == Double.NEGATIVE_INFINITY || rectangle2D.getMinY() == Double.NEGATIVE_INFINITY || rectangle2D.getMaxX() == Double.POSITIVE_INFINITY || rectangle2D.getMaxY() == Double.POSITIVE_INFINITY) {
            rectangle2D = this.buildDataMBR();
            this.vc.setScale(rectangle2D, rectangle2D2);
            this.vc.setQueryWindow(rectangle2D);
        }
        this.endHandlingNSProviders(this.vc, null);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        log.info(" **** time spent on loading features: " + l3 + "ms.");
        l = System.currentTimeMillis();
        this.mRenderEng.renderSVG(writer, this.vc, bl);
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        this.vc.setLastRotation(this.vc.getRotation());
        log.info(" **** time spent on rendering SVG: " + l4 + "ms");
    }

    public Vector getPredefinedMapList() {
        return this.mBaseMaps;
    }

    public void clearPredefinedMapList() {
        this.mBaseMaps.clear();
    }

    public BaseMap getPredefinedBaseMap(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.mBaseMaps.size(); ++i) {
            BaseMap baseMap = (BaseMap)this.mBaseMaps.get(i);
            if (!baseMap.getName().equalsIgnoreCase(string)) continue;
            return baseMap;
        }
        return null;
    }
}

