/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.PrintStream;
import java.io.PrintWriter;

public class DataException
extends Exception {
    public static final String MESSAGE_ABORTED = "Aborted by user.";
    public static final String MESSAGE_OUT_OF_MEMORY = "Out of memory.";
    public String description = "";
    public Throwable detail = null;

    public DataException() {
    }

    public DataException(Throwable throwable) {
        this.detail = throwable;
    }

    public DataException(String string) {
        super(string);
    }

    public DataException(String string, Throwable throwable) {
        super(string);
        this.detail = throwable;
    }

    public boolean isAbortedByUser() {
        return MESSAGE_ABORTED.equals(this.getMessage());
    }

    public String toString() {
        String string = "Message:" + this.getMessage() + "\n";
        string = string + "Description: " + this.description;
        if (this.detail != null) {
            string = string + "Nested exception is:\n" + this.detail.toString();
        }
        return string;
    }

    public boolean isOutOfMemory() {
        return MESSAGE_OUT_OF_MEMORY.equals(this.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        if (this.detail == null) {
            super.printStackTrace(printStream);
        } else {
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.println(this);
                this.detail.printStackTrace(printStream);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        if (this.detail == null) {
            super.printStackTrace(printWriter);
        } else {
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.println(this);
                this.detail.printStackTrace(printWriter);
            }
        }
    }
}

