/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BaseMap2;
import oracle.sdovis.BasemapRowData;
import oracle.sdovis.BasemapStore;
import oracle.sdovis.MapTable;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileBasemapStore
implements BasemapStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataSource = null;
    private FileDataSource fds = null;

    public FileBasemapStore(String string) {
        this.dataSource = string;
        this.fds = FileDataSource.getDataSource(this.dataSource);
        if (this.fds == null) {
            throw new IllegalArgumentException("Local data source environment not initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasemapRowData getBasemapData(String string) {
        DatabaseEntry databaseEntry;
        SerialBinding serialBinding;
        block5: {
            Database database = this.fds.getBasemapDb();
            Database database2 = this.fds.getClassDb();
            StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
            serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, BasemapRowData.class);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(string.toUpperCase().getBytes("UTF-8"));
            databaseEntry = new DatabaseEntry();
            OperationStatus operationStatus = database.get(null, databaseEntry2, databaseEntry, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) break block5;
            log.fine("No style named " + string + " found.");
            BasemapRowData basemapRowData = null;
            Object var11_12 = null;
            return basemapRowData;
        }
        try {
            BasemapRowData basemapRowData = (BasemapRowData)serialBinding.entryToObject(databaseEntry);
            Object var11_13 = null;
            return basemapRowData;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, "Exception getting basemap '" + string + "'.", exception);
                serialBinding = null;
                Object var11_14 = null;
                return serialBinding;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                throw throwable;
            }
        }
    }

    public BaseMap loadBasemapDefinition(String string) {
        BasemapRowData basemapRowData = null;
        try {
            basemapRowData = this.getBasemapData(string);
            if (basemapRowData == null) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        BaseMap baseMap = null;
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(basemapRowData.definition)) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01013"));
            return null;
        }
        Document document = xMLDOMParser.getDocument();
        if (document == null) {
            return null;
        }
        Node node = xMLDOMParser.getElementNode("map_definition");
        String string2 = XMLDOMParser.getAttribute(node, "type");
        if (string2 != null && "2".equals(string2)) {
            baseMap = new BaseMap2();
            MapTable.parseType2(xMLDOMParser, (BaseMap2)baseMap);
        } else {
            baseMap = new BaseMap();
            NodeList nodeList = xMLDOMParser.getElementNodes("theme");
            BaseMap.PredefinedThemeDesc[] predefinedThemeDescArray = new BaseMap.PredefinedThemeDesc[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                BaseMap.PredefinedThemeDesc predefinedThemeDesc = new BaseMap.PredefinedThemeDesc();
                predefinedThemeDesc.name = XMLDOMParser.getAttribute(node2, "name");
                predefinedThemeDesc.mods = MapTable.extractThemeModifiers(xMLDOMParser, node2);
                predefinedThemeDescArray[i] = predefinedThemeDesc;
            }
            baseMap.setThemes(predefinedThemeDescArray);
        }
        baseMap.setCustomTags(MapTable.parseCustomTags(xMLDOMParser));
        baseMap.setName(basemapRowData.name);
        baseMap.setDescription(basemapRowData.description);
        try {
            baseMap.setInitX(Double.parseDouble(XMLDOMParser.getAttribute(node, "initx")));
        }
        catch (Exception exception) {
            baseMap.setInitX(0.0);
        }
        try {
            baseMap.setInitY(Double.parseDouble(XMLDOMParser.getAttribute(node, "inity")));
        }
        catch (Exception exception) {
            baseMap.setInitY(0.0);
        }
        xMLDOMParser.close();
        return baseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getBasemapNames() {
        Object object;
        Cursor cursor = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(250);
        Database database = this.fds.getBasemapDb();
        Database database2 = this.fds.getClassDb();
        try {
            try {
                StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
                cursor = database.openCursor(null, null);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    object = new String(databaseEntry.getData(), "UTF-8");
                    arrayList.add(object);
                }
                object = arrayList;
                Object var10_11 = null;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "cannot list basemaps.", exception);
                List list = null;
                Object var10_12 = null;
                try {
                    if (cursor == null) return list;
                    cursor.close();
                    return list;
                }
                catch (Exception exception3) {
                    log.warning("error closing cursor." + exception3.getMessage());
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {}
            catch (Exception exception2) {
                log.warning("error closing cursor." + exception2.getMessage());
                throw throwable;
            }
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            log.warning("error closing cursor." + exception.getMessage());
            return object;
        }
        if (cursor == null) return object;
        cursor.close();
        return object;
    }

    public static void main(String[] stringArray) throws Exception {
        DSManager.registerFileDataSource("mvdemo", "/tmp/mvdemo");
        FileBasemapStore fileBasemapStore = new FileBasemapStore("mvdemo");
        List list = fileBasemapStore.getBasemapNames();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("basemap: " + list.get(i));
        }
    }
}

