/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRSRowData;
import oracle.sdovis.SRSStore;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.util.IntHashtable;
import oracle.sdovis.util.Util;

public class FileSRSStore
implements SRSStore {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataSource;
    private FileDataSource fds = null;

    public FileSRSStore(String string) {
        this.dataSource = string;
        this.fds = FileDataSource.getDataSource(this.dataSource);
        if (this.fds == null) {
            throw new IllegalArgumentException("Local data source environment not initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRSRowData getSRSRowData(int n) {
        DatabaseEntry databaseEntry;
        SerialBinding serialBinding;
        block5: {
            Database database = this.fds.getSrsDb();
            Database database2 = this.fds.getClassDb();
            StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
            serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, SRSRowData.class);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(Util.int2bytes(n));
            databaseEntry = new DatabaseEntry();
            OperationStatus operationStatus = database.get(null, databaseEntry2, databaseEntry, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) break block5;
            log.fine("No SRS with srid " + n + " found.");
            SRSRowData sRSRowData = null;
            Object var11_12 = null;
            return sRSRowData;
        }
        try {
            SRSRowData sRSRowData = (SRSRowData)serialBinding.entryToObject(databaseEntry);
            Object var11_13 = null;
            return sRSRowData;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, "Exception getting SRS '" + n + "'.", exception);
                serialBinding = null;
                Object var11_14 = null;
                return serialBinding;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadGeodeticSrids(IntHashtable intHashtable) {
        int n;
        intHashtable.clear();
        Cursor cursor = null;
        Database database = this.fds.getSrsDb();
        Database database2 = this.fds.getClassDb();
        int n2 = 0;
        try {
            try {
                cursor = database.openCursor(null, null);
                StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
                SerialBinding serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, SRSRowData.class);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    n = Util.bytes2int(databaseEntry.getData());
                    SRSRowData sRSRowData = (SRSRowData)serialBinding.entryToObject(databaseEntry2);
                    String string = sRSRowData.wktext;
                    if (string == null || !string.startsWith("GEOGCS")) continue;
                    intHashtable.put(n, (Object)"");
                    ++n2;
                }
                n = n2;
                Object var14_15 = null;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "cannot list SRIDs.", exception);
                int n3 = 0;
                Object var14_16 = null;
                try {
                    if (cursor == null) return n3;
                    cursor.close();
                    return n3;
                }
                catch (Exception exception3) {
                    log.warning("error closing cursor." + exception3.getMessage());
                }
                return n3;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {}
            catch (Exception exception2) {
                log.warning("error closing cursor." + exception2.getMessage());
                throw throwable;
            }
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            log.warning("error closing cursor." + exception.getMessage());
            return n;
        }
        if (cursor == null) return n;
        cursor.close();
        return n;
    }
}

