/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ThemeRowData;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.theme.CommonThemeAttrs;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class FileThemeStore
implements ThemeStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataSource;
    private FileDataSource fds = null;
    private String mName;
    private String mDescription;
    private String mBaseTable;
    private String mBaseTableOwner;
    private String mSpatialColumn;
    private StringBuffer mStylingRulesData;
    private int mSRID;
    private CommonThemeAttrs commonAttrs = new CommonThemeAttrs();

    public FileThemeStore(String string) {
        this.dataSource = string;
        this.fds = FileDataSource.getDataSource(this.dataSource);
        if (this.fds == null) {
            throw new IllegalArgumentException("Local data source environment not initialized.");
        }
    }

    public ThemeDefinition getThemeDefinition(String string) {
        ThemeRowData themeRowData = null;
        try {
            themeRowData = this.getThemeData(string);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error fetching theme definition.", exception);
            return null;
        }
        this.mName = string.toUpperCase();
        this.mDescription = themeRowData.description;
        this.mBaseTable = themeRowData.base_table;
        this.mBaseTableOwner = "";
        this.mSpatialColumn = themeRowData.geometry_column;
        this.mStylingRulesData = new StringBuffer(themeRowData.styling_rules);
        String string2 = themeRowData.styling_rules.toLowerCase();
        if (string2.indexOf("theme_type=\"wfs\"") >= 0 || string2.indexOf("theme_type=\"wms\"") >= 0 || string2.indexOf("theme_type=\"geom_custom\"") < 0) {
            // empty if block
        }
        try {
            XMLDOMParser xMLDOMParser = new XMLDOMParser();
            if (!xMLDOMParser.parse(themeRowData.styling_rules)) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01014") + " [" + string + "]");
                return null;
            }
            Node node = xMLDOMParser.getElementNode("styling_rules");
            if (node == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01016") + " [" + string + "]");
                return null;
            }
            this.commonAttrs.getAttributes(string, xMLDOMParser, node, this.mBaseTable, this.mSpatialColumn);
            this.commonAttrs.cacheMode = 3;
            String string3 = XMLDOMParser.getAttribute(node, "theme_type");
            string3 = string3 == null || string3.length() == 0 ? "GEOMETRY" : string3.toUpperCase();
            ThemeDefinition themeDefinition = null;
            if (string3.equals("GEOMETRY")) {
                themeDefinition = this.getGeometryTheme(string, xMLDOMParser, node);
                if (themeDefinition != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)themeDefinition).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            } else if (string3.equals("IMAGE")) {
                log.warning("Local data source does not support themes of type: image");
            } else if (string3.equals("GEORASTER")) {
                log.warning("Local data source does not support themes of type: georaster");
            } else if (string3.equals("NETWORK")) {
                log.warning("Local data source does not support themes of type: network");
            } else if (string3.equals("SHADED_RELIEF")) {
                log.warning("Local data source does not support themes of type: shaded-relief");
            } else if (string3.equals("TOPOLOGY")) {
                log.warning("Local data source does not support themes of type: topology");
            } else if (string3.equals("WFS")) {
                log.warning("Local data source does not support themes of type: wfs");
            } else if (string3.equals("GEOM_CUSTOM")) {
                themeDefinition = ThemeTable.getCustomGeomTheme(string, xMLDOMParser, node, this.commonAttrs);
                if (themeDefinition != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)themeDefinition).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            } else if (string3.equals("ANNOTATION")) {
                log.warning("Local data source does not support themes of type: annotation");
            } else if (string3.equals("WMS")) {
                log.warning("Local data source does not support themes of type: wms");
            } else {
                log.warning("Invalid theme type specified: " + string3 + ". Will treat as geometry theme.");
                themeDefinition = this.getGeometryTheme(string, xMLDOMParser, node);
                if (themeDefinition != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)themeDefinition).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            }
            if (themeDefinition != null) {
                themeDefinition.setDescription(this.mDescription);
                themeDefinition.setFetchSize(this.commonAttrs.fetchSize);
            }
            return themeDefinition;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeRowData getThemeData(String string) {
        DatabaseEntry databaseEntry;
        SerialBinding serialBinding;
        block5: {
            Database database = this.fds.getThemeDb();
            Database database2 = this.fds.getClassDb();
            StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
            serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, ThemeRowData.class);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(string.toUpperCase().getBytes("UTF-8"));
            databaseEntry = new DatabaseEntry();
            OperationStatus operationStatus = database.get(null, databaseEntry2, databaseEntry, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) break block5;
            log.fine("No theme named " + string + " found.");
            ThemeRowData themeRowData = null;
            Object var11_12 = null;
            return themeRowData;
        }
        try {
            ThemeRowData themeRowData = (ThemeRowData)serialBinding.entryToObject(databaseEntry);
            Object var11_13 = null;
            return themeRowData;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, "Exception getting theme '" + string + "'.", exception);
                serialBinding = null;
                Object var11_14 = null;
                return serialBinding;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getThemeNames() {
        Object object;
        Cursor cursor = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(250);
        Database database = this.fds.getThemeDb();
        try {
            try {
                cursor = database.openCursor(null, null);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    object = new String(databaseEntry.getData(), "UTF-8");
                    arrayList.add(object);
                }
                object = arrayList;
                Object var8_9 = null;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "cannot list themes.", exception);
                List list = null;
                Object var8_10 = null;
                try {
                    if (cursor == null) return list;
                    cursor.close();
                    return list;
                }
                catch (Exception exception3) {
                    log.warning("error closing cursor." + exception3.getMessage());
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {}
            catch (Exception exception2) {
                log.warning("error closing cursor." + exception2.getMessage());
                throw throwable;
            }
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            log.warning("error closing cursor." + exception.getMessage());
            return object;
        }
        if (cursor == null) return object;
        cursor.close();
        return object;
    }

    private ThemeDefinition getGeometryTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        for (int i = 0; i < this.commonAttrs.styleRules.length; ++i) {
            if (!this.commonAttrs.styleRules[i].isCompleteSQLQuery()) continue;
            log.severe("Full-SQL JDBC theme not supproted on local data source.");
            return null;
        }
        PredGeomThemeDefinition predGeomThemeDefinition = new PredGeomThemeDefinition(string, this.dataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID);
        predGeomThemeDefinition.setCachingMode(this.commonAttrs.cacheMode);
        predGeomThemeDefinition.setTableAlias(this.commonAttrs.table_Alias);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] fieldArray = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                field.setDisplayName(this.commonAttrs.identifiableNames[i]);
                fieldArray[i] = field;
            }
            predGeomThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(predGeomThemeDefinition);
        return predGeomThemeDefinition;
    }

    public static void main(String[] stringArray) throws Exception {
        DSManager.registerFileDataSource("mvdemo", "/tmp/mvdemo");
        FileThemeStore fileThemeStore = new FileThemeStore("mvdemo");
        List list = fileThemeStore.getThemeNames();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("theme: " + list.get(i));
        }
    }
}

