/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ShearDescriptor;
import javax.media.jai.operator.TransposeDescriptor;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Renderer;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.raytracing.Render3DException;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeProducer;
import oracle.sdovis.util.ImageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageRenderer
implements Renderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String currentFormat = null;

    public void prepare() {
    }

    @Override
    public void render(Graphics2D graphics2D, Theme theme, VisContext visContext) {
        if (theme instanceof ImageTheme) {
            ImageTheme imageTheme = null;
            try {
                imageTheme = (ImageTheme)theme;
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
                return;
            }
            ImageThemeDefinition imageThemeDefinition = (ImageThemeDefinition)imageTheme.getDefinition();
            String string = imageThemeDefinition.getImageFormat().toUpperCase();
            log.finer("format of image theme data: " + string);
            if ("GIF".equals(string) || "JPEG".equals(string) || "JPG".equals(string) || "PNG".equals(string) || "TIFF".equals(string)) {
                this.renderImageTheme(graphics2D, imageTheme, visContext.getImageScaling(), visContext);
            } else {
                CustomImageRenderer customImageRenderer = GlobalVisContext.findCustomImageRenderer(string);
                if (customImageRenderer != null) {
                    this.renderImageThemeUsingCIR(graphics2D, imageTheme, customImageRenderer, visContext.getImageScaling(), visContext);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01011") + string);
                }
            }
        } else if (theme instanceof ShadedReliefTheme) {
            ShadedReliefTheme shadedReliefTheme = null;
            try {
                shadedReliefTheme = (ShadedReliefTheme)theme;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
                return;
            }
            this.renderShadedReliefTheme(graphics2D, shadedReliefTheme, visContext.getImageScaling(), visContext);
        } else {
            GeoRasterTheme geoRasterTheme = null;
            try {
                geoRasterTheme = (GeoRasterTheme)theme;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
                return;
            }
            this.renderGeoRasterTheme(graphics2D, geoRasterTheme, visContext.getImageScaling(), visContext);
        }
    }

    @Override
    public void label(Graphics2D graphics2D, Theme theme, VisContext visContext) {
    }

    private void renderImageTheme(Graphics2D graphics2D, ImageTheme imageTheme, boolean bl, VisContext visContext) {
        byte[][] byArray = imageTheme.getImages();
        double[][] dArray = imageTheme.getMBRs();
        if (byArray == null || byArray.length == 0) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.currentFormat = ((ImageThemeDefinition)imageTheme.getDefinition()).getImageFormat();
            float f = ((ImageThemeDefinition)imageTheme.getDefinition()).getAlpha();
            float f2 = imageTheme.getDecorator().getOpacity();
            if (f2 >= 0.0f && f2 < 1.0f) {
                f = f2;
            }
            this.renderImage(graphics2D, byArray[i], dArray[i], bl, f, visContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(Graphics2D graphics2D, byte[] byArray, double[] dArray, boolean bl, float f, VisContext visContext) {
        log.finest("image[].length=" + byArray.length);
        Image image = null;
        if (this.currentFormat != null && this.currentFormat.equalsIgnoreCase("TIFF")) {
            this.renderTIFFImage(graphics2D, byArray, dArray, bl, f, visContext);
            return;
        }
        image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (!ImageUtils.waitForImage(image)) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01012"));
            return;
        }
        log.finest("image ground mbr=" + dArray[0] + "," + dArray[1] + " " + dArray[2] + "," + dArray[3]);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        AffineTransform affineTransform = visContext.getAffineXF();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(dArray[0], dArray[3]), double_);
            affineTransform.transform(new Point2D.Double(dArray[2], dArray[1]), double_2);
        }
        if (image != null) {
            int n = (int)((Point2D)double_).getX();
            int n2 = (int)((Point2D)double_).getY();
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            log.finest("image width: " + n3 + ", height:" + n4);
            log.finest("rendering image at: " + n + ", " + n2);
            Composite composite = null;
            if (f > 0.0f && f < 1.0f) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean bl2 = false;
                if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(visContext.getQueryWindow())) {
                    double d = -1.0 * visContext.getRotation() * Math.PI / 180.0;
                    Point2D.Double double_3 = new Point2D.Double();
                    affineTransform.transform(new Point2D.Double(visContext.getQueryWindow().getCenterX(), visContext.getQueryWindow().getCenterY()), double_3);
                    AffineTransform affineTransform3 = AffineTransform.getRotateInstance(d, ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
                    graphics2D.setTransform(affineTransform3);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    bl2 = true;
                }
                if (bl) {
                    graphics2D.drawImage(image, n, n2, (int)(((Point2D)double_2).getX() - ((Point2D)double_).getX() + 1.0), (int)(((Point2D)double_2).getY() - ((Point2D)double_).getY() + 1.0), null);
                } else {
                    log.finest("Drawing image in original resolution.");
                    if (visContext.getDeviceWindow().contains(10.0, n4 - n2) || visContext.getDeviceWindow().contains(n3 - n, 10.0)) {
                        graphics2D.drawImage(image, n, n2, n3 + 1, n4 + 1, null);
                    } else {
                        graphics2D.drawImage(image, n, n2, null);
                    }
                }
                if (bl2) {
                    graphics2D.setTransform(affineTransform2);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                }
            }
            catch (Exception exception) {
                graphics2D.setTransform(affineTransform2);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                log.severe(exception.getMessage());
            }
            finally {
                if (f > 0.0f && f < 1.0f) {
                    try {
                        graphics2D.setComposite(composite);
                    }
                    catch (Exception exception) {}
                }
                if (image != null) {
                    ImageUtils.removeImageFromTracker(image);
                    image.flush();
                    image = null;
                }
            }
        }
    }

    private void renderImageThemeUsingCIR(Graphics2D graphics2D, ImageTheme imageTheme, CustomImageRenderer customImageRenderer, boolean bl, VisContext visContext) {
        byte[][] byArray = imageTheme.getImages();
        double[][] dArray = imageTheme.getMBRs();
        if (byArray == null || byArray.length == 0) {
            return;
        }
        try {
            customImageRenderer.renderImages(graphics2D, byArray, dArray, visContext.getQueryWindow(), visContext.getDeviceWindow(), visContext.getAffineXF(), bl);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
        byArray = null;
        dArray = null;
    }

    private void renderShadedReliefTheme(Graphics2D graphics2D, ShadedReliefTheme shadedReliefTheme, boolean bl, VisContext visContext) {
        double[][] dArray = shadedReliefTheme.getMBRs();
        ShadedReliefThemeProducer shadedReliefThemeProducer = (ShadedReliefThemeProducer)shadedReliefTheme.getProducer();
        ShadedReliefThemeDefinition shadedReliefThemeDefinition = (ShadedReliefThemeDefinition)shadedReliefTheme.getDefinition();
        if (dArray == null || dArray.length == 0 || shadedReliefThemeProducer.getRenderedImages().size() == 0) {
            log.warning("Shaded Relief theme " + shadedReliefTheme.getName() + " has no rendered images.");
            return;
        }
        GeoRasterThemeDefinition geoRasterThemeDefinition = (GeoRasterThemeDefinition)shadedReliefThemeDefinition.getGeorDef();
        for (int i = 0; i < dArray.length; ++i) {
            RenderedImage renderedImage = shadedReliefThemeProducer.getShadedReliefRenderedImage(i);
            if (dArray[i] == null || renderedImage == null) continue;
            double d = 0.0;
            int n = 0;
            Point2D point2D = null;
            boolean bl2 = shadedReliefThemeProducer.isImageFlipped(i);
            JSDOGeometry jSDOGeometry = null;
            double d2 = shadedReliefThemeProducer.getImageRotation(i);
            if (d2 != 0.0) {
                d = d2;
                point2D = shadedReliefThemeProducer.getImageRotationRefPoint(i);
                jSDOGeometry = shadedReliefThemeProducer.getImageRotationMask(i);
                n = shadedReliefThemeProducer.getImageTransformation(i);
            }
            float f = geoRasterThemeDefinition.getAlpha();
            float f2 = shadedReliefTheme.getDecorator().getOpacity();
            if (f2 >= 0.0f && f2 < 1.0f) {
                f = f2;
            }
            Vector<JSDOGeometry> vector = null;
            if (shadedReliefThemeProducer.getPolygonMask() != null) {
                vector = new Vector<JSDOGeometry>();
                vector.add(shadedReliefThemeProducer.getPolygonMask());
            } else if (shadedReliefThemeProducer.getPolygonMasks() != null && shadedReliefThemeProducer.getPolygonMasks().size() > 0) {
                if (geoRasterThemeDefinition.getPolygonMaskGeoRasterJoinColumn() != null) {
                    String string = shadedReliefThemeProducer.getGeoRasterIds().get(i);
                    vector = shadedReliefThemeProducer.getPolygonMasks().get(string);
                } else {
                    vector = shadedReliefThemeProducer.getPolygonMasks().get("1");
                }
            }
            this.renderGeoRasterImage(graphics2D, renderedImage, dArray[i], bl, f, visContext, vector, d, point2D, bl2, jSDOGeometry, n);
            dArray[i] = null;
        }
        dArray = null;
    }

    private void renderGeoRasterTheme(Graphics2D graphics2D, GeoRasterTheme geoRasterTheme, boolean bl, VisContext visContext) {
        double[][] dArray = geoRasterTheme.getMBRs();
        GeoRasterThemeProducer geoRasterThemeProducer = (GeoRasterThemeProducer)geoRasterTheme.getProducer();
        GeoRasterThemeDefinition geoRasterThemeDefinition = (GeoRasterThemeDefinition)geoRasterTheme.getDefinition();
        if (dArray == null || dArray.length == 0 || geoRasterThemeProducer.getRenderedImages().size() == 0) {
            log.warning("GeoRaster theme " + geoRasterTheme.getName() + " has no rendered images.");
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            RenderedImage renderedImage = geoRasterThemeProducer.getRenderedImage(i);
            if (dArray[i] == null || renderedImage == null) continue;
            double d = 0.0;
            int n = 0;
            Point2D point2D = null;
            boolean bl2 = geoRasterThemeProducer.isImageFlipped(i);
            JSDOGeometry jSDOGeometry = null;
            double d2 = geoRasterThemeProducer.getImageRotation(i);
            if (d2 != 0.0) {
                d = d2;
                point2D = geoRasterThemeProducer.getImageRotationRefPoint(i);
                jSDOGeometry = geoRasterThemeProducer.getImageRotationMask(i);
                n = geoRasterThemeProducer.getImageTransformation(i);
            }
            float f = geoRasterThemeDefinition.getAlpha();
            float f2 = geoRasterTheme.getDecorator().getOpacity();
            if (f2 >= 0.0f && f2 < 1.0f) {
                f = f2;
            }
            Vector<JSDOGeometry> vector = null;
            if (geoRasterThemeProducer.getPolygonMask() != null) {
                vector = new Vector<JSDOGeometry>();
                vector.add(geoRasterThemeProducer.getPolygonMask());
            } else if (geoRasterThemeProducer.getPolygonMasks() != null && geoRasterThemeProducer.getPolygonMasks().size() > 0) {
                if (geoRasterThemeDefinition.getPolygonMaskGeoRasterJoinColumn() != null) {
                    String string = geoRasterThemeProducer.getGeoRasterIds().get(i);
                    vector = geoRasterThemeProducer.getPolygonMasks().get(string);
                } else {
                    vector = geoRasterThemeProducer.getPolygonMasks().get("1");
                }
            }
            this.renderGeoRasterImage(graphics2D, renderedImage, dArray[i], bl, f, visContext, vector, d, point2D, bl2, jSDOGeometry, n);
            dArray[i] = null;
        }
        dArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderGeoRasterImage(Graphics2D graphics2D, RenderedImage renderedImage, double[] dArray, boolean bl, float f, VisContext visContext, Vector<JSDOGeometry> vector, double d, Point2D point2D, boolean bl2, JSDOGeometry jSDOGeometry, int n) {
        log.finest("image ground mbr=" + dArray[0] + "," + dArray[1] + " " + dArray[2] + "," + dArray[3]);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        AffineTransform affineTransform = visContext.getAffineXF();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(dArray[0], dArray[3]), double_);
            affineTransform.transform(new Point2D.Double(dArray[2], dArray[1]), double_2);
        }
        if (renderedImage != null) {
            Object object;
            int n2 = (int)((Point2D)double_).getX();
            int n3 = (int)((Point2D)double_).getY();
            int n4 = renderedImage.getWidth();
            int n5 = renderedImage.getHeight();
            log.finest("image width: " + n4 + ", height:" + n5);
            log.finest("rendering image at: " + n2 + ", " + n3);
            BufferedImage bufferedImage = null;
            if (renderedImage instanceof BufferedImage) {
                log.finer("Rendered Image is buffered image.");
                bufferedImage = (BufferedImage)renderedImage;
            } else {
                log.finer("Rendered Image is not buffered image.");
                if (renderedImage instanceof PlanarImage) {
                    bufferedImage = ((PlanarImage)renderedImage).getAsBufferedImage();
                    log.finer("Planar Image converted to BufferedImage.");
                } else {
                    log.info("Unable to render this type of Java Image.");
                    return;
                }
            }
            if (bufferedImage == null) {
                log.info("Unable to render null image.");
                return;
            }
            if (bl2) {
                bufferedImage = this.flipImage(bufferedImage);
            }
            if (d != 0.0) {
                bufferedImage = this.transformImage(bufferedImage, d, point2D, n);
            }
            if (jSDOGeometry != null) {
                object = new Vector<JSDOGeometry>();
                ((Vector)object).add(jSDOGeometry);
                bufferedImage = this.applyPolygonMask(bufferedImage, dArray, (Vector<JSDOGeometry>)object);
            }
            if (vector != null) {
                bufferedImage = this.applyPolygonMask(bufferedImage, dArray, vector);
            }
            object = null;
            if (f > 0.0f && f < 1.0f) {
                object = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            Image image = null;
            AffineTransform affineTransform2 = graphics2D.getTransform();
            try {
                if (!bl) {
                    log.warning("Image scaling set to false is ignored. GeoRaster image is always scaled");
                }
                double d2 = (((Point2D)double_2).getX() - ((Point2D)double_).getX() + 1.0) / (double)bufferedImage.getWidth();
                double d3 = (((Point2D)double_2).getY() - ((Point2D)double_).getY() + 1.0) / (double)bufferedImage.getHeight();
                ParameterBlock parameterBlock = new ParameterBlock();
                parameterBlock.addSource(bufferedImage);
                parameterBlock.add((float)d2);
                parameterBlock.add((float)d3);
                parameterBlock.add(0.0f);
                parameterBlock.add(0.0f);
                parameterBlock.add(new InterpolationNearest());
                image = JAI.create((String)"scale", (ParameterBlock)parameterBlock, null).getAsBufferedImage();
                boolean bl3 = false;
                if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(visContext.getQueryWindow())) {
                    double d4 = -1.0 * (visContext.getRotation() * Math.PI / 180.0);
                    Point2D.Double double_3 = new Point2D.Double();
                    affineTransform.transform(new Point2D.Double(visContext.getQueryWindow().getCenterX(), visContext.getQueryWindow().getCenterY()), double_3);
                    AffineTransform affineTransform3 = AffineTransform.getRotateInstance(d4, ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
                    graphics2D.setTransform(affineTransform3);
                    bl3 = true;
                }
                graphics2D.drawImage(image, n2, n3, null);
                if (bl3) {
                    graphics2D.setTransform(affineTransform2);
                }
            }
            catch (Exception exception) {
                graphics2D.setTransform(affineTransform2);
                log.severe(exception.getMessage());
            }
            finally {
                if (f > 0.0f && f < 1.0f) {
                    try {
                        graphics2D.setComposite((Composite)object);
                    }
                    catch (Exception exception) {}
                }
                if (image != null) {
                    image.flush();
                    image = null;
                }
            }
        }
    }

    private BufferedImage applyPolygonMask(BufferedImage bufferedImage, double[] dArray, Vector<JSDOGeometry> vector) {
        if (bufferedImage == null) {
            return bufferedImage;
        }
        if (vector != null && vector.size() > 0) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            XFViewPort xFViewPort = new XFViewPort();
            xFViewPort.setStrict(true);
            xFViewPort.setDataView(dArray[0], dArray[1], dArray[2], dArray[3]);
            xFViewPort.setDeviceView(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            AffineTransform affineTransform = xFViewPort.getAffineTransform();
            for (int i = 0; i < vector.size(); ++i) {
                JSDOGeometry jSDOGeometry = vector.get(i);
                Shape shape = jSDOGeometry.createShape(affineTransform);
                BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                Graphics2D graphics2D2 = bufferedImage3.createGraphics();
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D2.setPaint(Color.blue);
                graphics2D2.fill(shape);
                graphics2D2.dispose();
                graphics2D.setComposite(AlphaComposite.getInstance(6, 1.0f));
                graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            }
            graphics2D.dispose();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    private BufferedImage flipImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        return JAI.create((String)"transpose", (RenderedImage)bufferedImage, (Object)TransposeDescriptor.FLIP_VERTICAL).getAsBufferedImage();
    }

    private BufferedImage transformImage(BufferedImage bufferedImage, double d, Point2D point2D, int n) {
        if (bufferedImage == null) {
            return null;
        }
        double d2 = -1.0 * (d * Math.PI / 180.0);
        BufferedImage bufferedImage2 = null;
        ParameterBlock parameterBlock = null;
        parameterBlock = new ParameterBlock();
        parameterBlock.addSource(bufferedImage);
        if (n == 2 || n == 3) {
            parameterBlock.add((float)d2);
            if (n == 2) {
                parameterBlock.add(ShearDescriptor.SHEAR_HORIZONTAL);
            } else {
                parameterBlock.add(ShearDescriptor.SHEAR_VERTICAL);
            }
            parameterBlock.add(0.0f);
            parameterBlock.add(0.0f);
            parameterBlock.add(new InterpolationNearest());
            bufferedImage2 = JAI.create((String)"shear", (ParameterBlock)parameterBlock, null).getAsBufferedImage();
        } else {
            if (point2D == null) {
                parameterBlock.add((float)(bufferedImage.getWidth() / 2));
                parameterBlock.add((float)(bufferedImage.getHeight() / 2));
            } else {
                parameterBlock.add((float)point2D.getX());
                parameterBlock.add((float)point2D.getY());
            }
            parameterBlock.add((float)d2);
            parameterBlock.add(new InterpolationNearest());
            bufferedImage2 = JAI.create((String)"rotate", (ParameterBlock)parameterBlock, null).getAsBufferedImage();
        }
        return bufferedImage2;
    }

    public void saveTGA(String string, int n, int n2, Raster raster) throws FileNotFoundException, IOException, Render3DException {
        int n3;
        if (!(string = string.trim()).endsWith(".tga")) {
            // empty if block
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[18];
        for (n3 = 0; n3 < 18; ++n3) {
            byArray[n3] = n3 == 2 ? 2 : (n3 == 12 ? (int)(n % 256) : (n3 == 13 ? (int)(n / 256) : (n3 == 14 ? (int)(n2 % 256) : (n3 == 15 ? (int)(n2 / 256) : (n3 == 16 ? 24 : (n3 == 17 ? 32 : 0))))));
        }
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        for (n3 = 0; n3 < n2; ++n3) {
            byte[] byArray2 = new byte[n * 3];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                double[] dArray = new double[raster.getNumBands()];
                dArray = raster.getPixel(i, n3, dArray);
                Vector3d vector3d = new Vector3d(dArray);
                byArray2[n4] = this.clampColorComponent(vector3d.z);
                byArray2[n4 + 1] = this.clampColorComponent(vector3d.y);
                byArray2[n4 + 2] = this.clampColorComponent(vector3d.x);
                n4 += 3;
            }
            fileOutputStream.write(byArray2);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private byte clampColorComponent(double d) {
        int n = (int)(d * 255.0);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return (byte)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTIFFImage(Graphics2D graphics2D, byte[] byArray, double[] dArray, boolean bl, float f, VisContext visContext) {
        if (byArray == null) {
            return;
        }
        ByteArraySeekableStream byteArraySeekableStream = null;
        try {
            byteArraySeekableStream = new ByteArraySeekableStream(byArray);
        }
        catch (Exception exception) {
            log.severe("Unable to create TIFF image.");
            return;
        }
        RenderedOp renderedOp = JAI.create((String)"stream", (Object)byteArraySeekableStream);
        log.finest("image ground mbr=" + dArray[0] + "," + dArray[1] + " " + dArray[2] + "," + dArray[3]);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        AffineTransform affineTransform = visContext.getAffineXF();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(dArray[0], dArray[3]), double_);
            affineTransform.transform(new Point2D.Double(dArray[2], dArray[1]), double_2);
        }
        if (renderedOp != null) {
            int n = (int)((Point2D)double_).getX();
            int n2 = (int)((Point2D)double_).getY();
            int n3 = renderedOp.getWidth();
            int n4 = renderedOp.getHeight();
            log.finest("image width: " + n3 + ", height:" + n4);
            log.finest("rendering image at: " + n + ", " + n2);
            BufferedImage bufferedImage = null;
            if (renderedOp instanceof BufferedImage) {
                log.finer("Rendered Image is buffered image.");
                bufferedImage = (BufferedImage)renderedOp;
            } else {
                log.finer("Rendered Image is not buffered image.");
                if (renderedOp instanceof PlanarImage) {
                    bufferedImage = ((PlanarImage)renderedOp).getAsBufferedImage();
                    log.finer("Planar Image converted to BufferedImage.");
                } else {
                    log.info("Unable to render this type of Java Image.");
                    return;
                }
            }
            if (bufferedImage == null) {
                log.info("Unable to render null image.");
                return;
            }
            Composite composite = null;
            if (f > 0.0f && f < 1.0f) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean bl2 = false;
                if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(visContext.getQueryWindow())) {
                    double d = -1.0 * visContext.getRotation() * Math.PI / 180.0;
                    Point2D.Double double_3 = new Point2D.Double();
                    affineTransform.transform(new Point2D.Double(visContext.getQueryWindow().getCenterX(), visContext.getQueryWindow().getCenterY()), double_3);
                    AffineTransform affineTransform3 = AffineTransform.getRotateInstance(d, ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
                    graphics2D.setTransform(affineTransform3);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    bl2 = true;
                }
                if (bl) {
                    graphics2D.drawImage(bufferedImage, n, n2, (int)(((Point2D)double_2).getX() - ((Point2D)double_).getX() + 1.0), (int)(((Point2D)double_2).getY() - ((Point2D)double_).getY() + 1.0), null);
                } else {
                    log.finest("Drawing image in original resolution.");
                    if (visContext.getDeviceWindow().contains(10.0, n4 - n2) || visContext.getDeviceWindow().contains(n3 - n, 10.0)) {
                        graphics2D.drawImage(bufferedImage, n, n2, n3 + 1, n4 + 1, null);
                    } else {
                        graphics2D.drawImage((Image)bufferedImage, n, n2, null);
                    }
                }
                if (bl2) {
                    graphics2D.setTransform(affineTransform2);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                }
            }
            catch (Exception exception) {
                graphics2D.setTransform(affineTransform2);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                log.severe(exception.getMessage());
            }
            finally {
                if (f > 0.0f && f < 1.0f) {
                    try {
                        graphics2D.setComposite(composite);
                    }
                    catch (Exception exception) {}
                }
                bufferedImage.flush();
                bufferedImage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderImage(Graphics2D graphics2D, Image image, double[] dArray, float f, VisContext visContext) {
        if (image == null) {
            log.finest("Image is null. Rendering aborted.");
            return;
        }
        if (dArray == null) {
            log.warning("Image MBR not defined. Rendering aborted.");
            return;
        }
        log.finest("Image ground mbr=" + dArray[0] + "," + dArray[1] + " " + dArray[2] + "," + dArray[3]);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        AffineTransform affineTransform = visContext.getAffineXF();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(dArray[0], dArray[3]), double_);
            affineTransform.transform(new Point2D.Double(dArray[2], dArray[1]), double_2);
        }
        if (image != null) {
            int n = (int)((Point2D)double_).getX();
            int n2 = (int)((Point2D)double_).getY();
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            log.finest("image width: " + n3 + ", height:" + n4);
            log.finest("rendering image at: " + n + ", " + n2);
            Composite composite = null;
            if (f > 0.0f && f < 1.0f) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean bl = false;
                if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(visContext.getQueryWindow())) {
                    double d = -1.0 * visContext.getRotation() * Math.PI / 180.0;
                    Point2D.Double double_3 = new Point2D.Double();
                    affineTransform.transform(new Point2D.Double(visContext.getQueryWindow().getCenterX(), visContext.getQueryWindow().getCenterY()), double_3);
                    AffineTransform affineTransform3 = AffineTransform.getRotateInstance(d, ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
                    graphics2D.setTransform(affineTransform3);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    bl = true;
                }
                graphics2D.drawImage(image, n, n2, (int)(((Point2D)double_2).getX() - ((Point2D)double_).getX() + 1.0), (int)(((Point2D)double_2).getY() - ((Point2D)double_).getY() + 1.0), null);
                if (bl) {
                    graphics2D.setTransform(affineTransform2);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                }
            }
            catch (Exception exception) {
                graphics2D.setTransform(affineTransform2);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                log.severe(exception.getMessage());
            }
            finally {
                if (f > 0.0f && f < 1.0f) {
                    try {
                        graphics2D.setComposite(composite);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

