/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;

public class LegendEntry {
    public static final int ITEM_TYPE_STYLE = 0;
    public static final int ITEM_TYPE_SEPARATOR = 1;
    public static final int ITEM_TYPE_TITLE = 2;
    public static final int[] PROFILE_TEXT_SIZE = new int[]{9, 12, 16};
    public static final int[] PROFILE_IMAGE_WIDTH = new int[]{24, 40, 64};
    public static final int[] PROFILE_IMAGE_HEIGHT = new int[]{14, 23, 38};
    public static final int[] PROFILE_AVSTYLE_WIDTH = new int[]{95, 120, 160};
    public static final int[] PROFILE_AVSTYLE_HEIGHT = new int[]{75, 120, 180};
    int type = 0;
    String styleName = null;
    String text = null;
    int profile = 1;
    int pWidth;
    int pHeight;
    int pTextSize = 0;
    int userWidth = -1;
    int userHeight = -1;
    String fontFamily = null;
    Color background = Color.white;
    Color foreground = Color.black;
    Style style = null;
    AttributedString as = null;
    boolean isAVStyle = false;
    int numSpaces = 0;
    BufferedImage bimage = null;

    public LegendEntry(String string, String string2) {
        this.styleName = string;
        this.text = string2 == null ? "" : string2;
    }

    public LegendEntry() {
        this.type = 1;
    }

    public LegendEntry(Style style, String string) {
        this.text = string == null ? "" : string;
        this.style = style;
        if (style instanceof AdvancedStyle) {
            this.isAVStyle = true;
        }
    }

    public LegendEntry(String string) {
        this.type = 2;
        this.text = string;
    }

    public void setUserSpcifiedDimensioin(int n, int n2) {
        this.userWidth = n;
        this.userHeight = n2;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public Font getFont() {
        if (this.fontFamily != null) {
            return new Font(this.fontFamily, 0, this.getTextSize());
        }
        return null;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void addTab() {
        this.numSpaces += 4;
    }

    public int getNumSpaces() {
        return this.numSpaces;
    }

    public boolean hasAdvancedStyle() {
        return this.isAVStyle;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public boolean materializeStyles(VisContext visContext) {
        if (this.styleName == null || this.styleName.length() == 0 || this.style != null) {
            return true;
        }
        if (this.style == null) {
            this.style = visContext.resolveStyle(this.styleName);
            if (this.style == null) {
                return false;
            }
            this.style.resolveStyles(DSManager.getStyleCache(visContext.getMasterDataSourceName()), visContext.getDynamicStyles());
        }
        StyleModifiers styleModifiers = this.style.convertToPixelSize(null);
        if (this.style instanceof AdvancedStyle) {
            this.pHeight = PROFILE_AVSTYLE_HEIGHT[this.profile];
            this.isAVStyle = true;
            if (this.style instanceof VariableMarkerStyle) {
                int n = 2;
                BucketSeries bucketSeries = ((VariableMarkerStyleModel)((VariableMarkerStyle)this.style).getModel()).getBucketSeries();
                int n2 = bucketSeries.size();
                for (int i = 0; i < n2; ++i) {
                    Bucket bucket = bucketSeries.getBucket(i);
                    StyleMarker styleMarker = (StyleMarker)bucket.getRenderStyle();
                    if (styleMarker == null) continue;
                    StyleModifiers styleModifiers2 = null;
                    if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                        styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(((VariableMarkerStyle)this.style).getBaseMarkerName().toUpperCase() + "_" + i);
                    }
                    int n3 = styleMarker.getDesiredHeight();
                    if (styleModifiers2 != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                        n3 = ((MarkerStyleModifiers)styleModifiers2).getHeight();
                    }
                    n += n3 + 2;
                }
                if (n > this.pHeight) {
                    this.pHeight = n;
                }
            } else if (this.style instanceof VariablePieChartStyle) {
                int n = 2;
                BucketSeries bucketSeries = ((VariablePieChartStyleModel)((VariablePieChartStyle)this.style).getModel()).getBucketSeries();
                int n4 = bucketSeries.size();
                for (int i = 0; i < n4; ++i) {
                    Bucket bucket = bucketSeries.getBucket(i);
                    PieChartStyle pieChartStyle = (PieChartStyle)bucket.getRenderStyle();
                    if (pieChartStyle == null) continue;
                    StyleModifiers styleModifiers3 = null;
                    if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                        styleModifiers3 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers("PIECHART_" + i);
                    }
                    int n5 = pieChartStyle.getPieRadius() * 2;
                    if (styleModifiers3 != null && styleModifiers3 instanceof PieChartStyleModifiers) {
                        n5 = ((PieChartStyleModifiers)styleModifiers3).getPieRadius() * 2;
                    }
                    n += n5 + 2;
                }
                if (n > this.pHeight) {
                    this.pHeight = n;
                }
            }
        } else if (this.style instanceof StyleMarker) {
            StyleMarker styleMarker = (StyleMarker)this.style;
            int n = styleMarker.getDesiredWidth();
            int n6 = styleMarker.getDesiredHeight();
            if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
                n = ((MarkerStyleModifiers)styleModifiers).getWidth();
                n6 = ((MarkerStyleModifiers)styleModifiers).getHeight();
            }
            if (n6 > 0 && n6 > PROFILE_IMAGE_HEIGHT[this.profile]) {
                this.pHeight = n6;
            }
        }
        if (this.userHeight > 0) {
            this.pHeight = this.userHeight;
        }
        return true;
    }

    public int getUserWidth() {
        return this.userWidth;
    }

    public int getUseHeight() {
        return this.userHeight;
    }

    public int getPreferredWidth() {
        if (this.userWidth > 0) {
            this.pWidth = this.userWidth;
            return this.pWidth;
        }
        if (this.as != null) {
            AttributedCharacterIterator attributedCharacterIterator = null;
            attributedCharacterIterator = this.as.getIterator();
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            float f = 9999.0f;
            TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
            this.pWidth = (int)textLayout.getAdvance();
        } else {
            this.pWidth = this.hasAdvancedStyle() ? PROFILE_AVSTYLE_WIDTH[this.profile] : 0;
        }
        return this.pWidth;
    }

    public int getPreferredHeight() {
        return this.pHeight;
    }

    public void prepare(VisContext visContext) {
        this.materializeStyles(visContext);
        this.assembleAttrString(true);
    }

    public AttributedString getAttrString() {
        return this.as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assembleAttrString(boolean bl) {
        int n;
        double d = PROFILE_TEXT_SIZE[this.profile];
        if (this.pTextSize > 0) {
            d = this.pTextSize;
        }
        int n2 = PROFILE_IMAGE_WIDTH[this.profile];
        if (this.type == 1) {
            this.as = new AttributedString(" ");
            this.as.addAttribute(TextAttribute.SIZE, new Float(d));
            this.as.addAttribute(TextAttribute.FOREGROUND, this.background);
            return true;
        }
        String string = "";
        if (this.numSpaces > 0) {
            for (n = 0; n < this.numSpaces; ++n) {
                string = string + " ";
            }
        }
        if (this.type == 2) {
            this.as = new AttributedString(string + this.text);
            if (this.foreground != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.foreground);
            } else {
                this.as.addAttribute(TextAttribute.FOREGROUND, Color.black);
            }
            if (this.fontFamily != null) {
                this.as.addAttribute(TextAttribute.FAMILY, this.fontFamily);
            }
            this.as.addAttribute(TextAttribute.SIZE, new Float(d));
            return true;
        }
        this.as = this.style != null ? new AttributedString(string + "A " + this.text + " ") : new AttributedString(string + this.text + " ");
        if (this.foreground != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, this.foreground);
        } else {
            this.as.addAttribute(TextAttribute.FOREGROUND, Color.black);
        }
        if (this.fontFamily != null) {
            this.as.addAttribute(TextAttribute.FAMILY, this.fontFamily);
        }
        this.as.addAttribute(TextAttribute.SIZE, new Float(d));
        if (this.style != null) {
            Object object;
            n = this.pHeight;
            int n3 = 0;
            int n4 = PROFILE_TEXT_SIZE[this.profile];
            if (this.pTextSize > 0) {
                n4 = this.pTextSize;
            }
            if (this.hasAdvancedStyle() && this.userWidth <= 0) {
                n3 = ((AdvancedStyle)this.style).getMaxLegendWidth(null, n4);
                n2 = Math.max(n3, PROFILE_AVSTYLE_WIDTH[this.profile]);
            } else if (this.userWidth > 0) {
                n2 = this.userWidth;
            }
            this.bimage = new BufferedImage(n2, n, 2);
            Graphics2D graphics2D = (Graphics2D)this.bimage.getGraphics();
            if (bl) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.background != null) {
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, n2, n);
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float(1.0f, 1.0f, n2 - 2, n - 2);
            try {
                object = this.style.convertToPixelSize(null);
                this.style.apply(null, graphics2D, (Rectangle2D)float_, (StyleModifiers)object);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            finally {
                graphics2D.dispose();
            }
            object = new ImageGraphicAttribute(this.bimage, 0, 0.0f, n / 2 + 3);
            this.as.addAttribute(TextAttribute.CHAR_REPLACEMENT, object, this.numSpaces, this.numSpaces + 1);
        }
        return true;
    }

    public void destroy() {
        this.as = null;
        if (this.bimage != null) {
            this.bimage.flush();
            this.bimage = null;
        }
    }

    public String toXMLString() {
        switch (this.type) {
            case 1: {
                return "<entry is_separator=\"true\" />";
            }
            case 2: {
                return "<entry is_title=\"true\" text=\"" + this.text + "\"/>";
            }
            case 0: {
                String string = this.text != null ? " text=\"" + this.text + "\" " : "";
                String string2 = this.userWidth > 0 ? " width=\"" + this.userWidth + "\"" : "";
                String string3 = this.userHeight > 0 ? " height=\"" + this.userHeight + "\"" : "";
                return "<entry style=\"" + this.styleName + "\"" + string + string2 + string3 + (this.numSpaces > 0 ? " tab=\"" + this.numSpaces / 4 + "\" " : "") + "/>";
            }
        }
        return "";
    }

    public int getImageHeight() {
        return PROFILE_IMAGE_HEIGHT[this.profile];
    }

    public int getImageWidth() {
        if (this.hasAdvancedStyle()) {
            return PROFILE_AVSTYLE_WIDTH[this.profile];
        }
        return PROFILE_IMAGE_WIDTH[this.profile];
    }

    public int getType() {
        return this.type;
    }

    public int getTextSize() {
        if (this.pTextSize > 0) {
            return this.pTextSize;
        }
        return PROFILE_TEXT_SIZE[this.profile] + 1;
    }

    public void setTextSize(int n) {
        this.pTextSize = n;
    }

    public Style getStyle() {
        return this.style;
    }

    public String getText() {
        String string = "";
        if (this.numSpaces > 0) {
            for (int i = 0; i < this.numSpaces; ++i) {
                string = string + " ";
            }
        }
        if (this.type == 2) {
            return string + this.text;
        }
        if (this.type == 0) {
            return string + this.text;
        }
        return "";
    }

    public void setProfile(int n) {
        this.profile = n;
        this.pHeight = PROFILE_IMAGE_HEIGHT[n];
        this.pWidth = PROFILE_IMAGE_WIDTH[n];
    }

    public int getProfile() {
        return this.profile;
    }
}

