/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.style.Style;
import oracle.sdovis.theme.VectorThemeDefinition;

public class LoadThemeData2 {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    Theme mTheme = null;
    Rectangle2D mQueryWin = null;
    VisContext vc = null;
    long reqTimeout = 0L;
    Exception exception = null;

    public LoadThemeData2(Theme theme, Rectangle2D rectangle2D, VisContext visContext) {
        this.mTheme = theme;
        this.mQueryWin = rectangle2D;
        this.vc = visContext;
        if (visContext.isTileRequest() && theme.getDefinition() instanceof VectorThemeDefinition) {
            theme.windowBuffer = this.isLabelTheme(theme, visContext) ? VisContext.BUFFER_LABEL_THEME : VisContext.BUFFER_VECTOR_THEME;
            this.mQueryWin = visContext.getExtendedQueryWindow(theme.windowBuffer);
        }
        this.reqTimeout = theme instanceof WMSMapTheme || theme instanceof MapCacheTheme ? theme.getDecorator().getRequestTimeout() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block15: {
            log.finer("LoadThemeData2 running thread: " + Thread.currentThread().getName());
            this.mTheme.prepareData(this.mQueryWin, this.vc);
            this.mTheme.postPreparation(this.vc);
            Object var3_1 = null;
            try {
                this.mTheme.getDecorator().setPrepared(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mTheme = null;
            this.vc = null;
            {
                break block15;
                catch (OutOfMemoryError outOfMemoryError) {
                    log.severe("Out of memory error while preparing " + this.mTheme.getName() + " : " + outOfMemoryError.getMessage());
                    if (this.vc != null) {
                        this.vc.setDataException(new DataException("Out of memory."));
                    }
                    Object var3_2 = null;
                    try {
                        this.mTheme.getDecorator().setPrepared(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mTheme = null;
                    this.vc = null;
                    break block15;
                }
                catch (DataException dataException) {
                    if (dataException.isAbortedByUser()) {
                        log.log(Level.FINEST, "Theme " + this.mTheme.getName() + " is aborted per user's request.", dataException);
                    } else {
                        this.exception = dataException;
                        if (this.vc != null) {
                            this.vc.setDataException(dataException);
                        }
                        log.log(Level.SEVERE, "Exception fetching data for theme " + this.mTheme.getName() + ".", dataException);
                    }
                    Object var3_3 = null;
                    try {
                        this.mTheme.getDecorator().setPrepared(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mTheme = null;
                    this.vc = null;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    this.mTheme.getDecorator().setPrepared(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mTheme = null;
                this.vc = null;
                throw throwable;
            }
        }
    }

    private boolean isLabelTheme(Theme theme, VisContext visContext) {
        String[] stringArray = theme.getRenderingStyles();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Style style = MapMaker.getStyleWithName(stringArray[i], theme.getDataSourceName(), visContext);
            if (style == null || style.getModel().getType() != 5) continue;
            return true;
        }
        return false;
    }
}

