/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.RenderingRule;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.LocalThemeDefinition;

public class LocalTheme
extends Theme
implements Serializable {
    public LocalTheme(String string, Vector vector) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(string);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(vector);
    }

    public LocalTheme(String string, ArrayList arrayList) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(string);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(arrayList);
    }

    public LocalTheme(String string, StyledFeatureI[] styledFeatureIArray) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(string);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(styledFeatureIArray);
    }

    public LocalTheme(String string) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(string);
        this.setProducer(new LocalThemeDataProducer(this));
    }

    public boolean isTextLabelPresent() {
        return ((LocalThemeDataProducer)this.producer).isTextLabelPresent();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.definition.getName());
        objectOutputStream.writeDouble(this.decorator.getMinScale());
        objectOutputStream.writeDouble(this.decorator.getMaxScale());
        StyledFeatureI[] styledFeatureIArray = this.producer.getStyledFeatures();
        int n = styledFeatureIArray != null ? styledFeatureIArray.length : 0;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(styledFeatureIArray[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setDefinition(new LocalThemeDefinition());
        String string = objectInputStream.readUTF();
        this.definition.setName(string);
        this.decorator.setMinScale(objectInputStream.readDouble());
        this.decorator.setMaxScale(objectInputStream.readDouble());
        int n = objectInputStream.readInt();
        if (n == 0) {
            return;
        }
        StyledFeatureI[] styledFeatureIArray = new StyledFeatureI[n];
        for (int i = 0; i < n; ++i) {
            styledFeatureIArray[i] = (StyledFeature)objectInputStream.readObject();
        }
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(styledFeatureIArray);
    }

    public void destroy() {
    }

    public String[] getRenderingStyles() {
        StyledFeatureI[] styledFeatureIArray = ((LocalThemeDataProducer)this.producer).getStyledFeatures();
        if (styledFeatureIArray == null || styledFeatureIArray.length < 1) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < styledFeatureIArray.length; ++i) {
            RenderingRule[] renderingRuleArray;
            String string = styledFeatureIArray[i].getFeatureStyleName();
            if (string != null && !arrayList.contains(string.toUpperCase())) {
                arrayList.add(string.toUpperCase());
            }
            if ((renderingRuleArray = styledFeatureIArray[i].getRenderingRules()) == null) continue;
            for (int j = 0; j < renderingRuleArray.length; ++j) {
                string = renderingRuleArray[j].getStyleName();
                if (string == null || arrayList.contains(string.toUpperCase())) continue;
                arrayList.add(string.toUpperCase());
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLabelingStyles() {
        StyledFeatureI[] styledFeatureIArray = ((LocalThemeDataProducer)this.producer).getStyledFeatures();
        if (styledFeatureIArray == null || styledFeatureIArray.length < 1) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < styledFeatureIArray.length; ++i) {
            String string = styledFeatureIArray[i].getLabelStyleName();
            if (string == null || arrayList.contains(string.toUpperCase())) continue;
            arrayList.add(string.toUpperCase());
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

