/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.lbs.mapcache.MCSServlet;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.sdovis.Theme;
import oracle.sdovis.theme.MapCacheThemeDefinition;
import oracle.sdovis.theme.MapCacheThemeProducer;

public class MapCacheTheme
extends Theme {
    String mapSourceName = null;
    String dataSource = null;
    private MapCache cache = null;
    int srid = 0;
    private Rectangle2D mapWindow = null;
    private boolean snapToCachedScale = false;
    private String externalMapviewerURL;

    public MapCacheTheme(String string, String string2, String string3, boolean bl, String string4) {
        int n = string3.indexOf(".");
        if (n > 0) {
            this.mapSourceName = string3.substring(n + 1);
            this.dataSource = string3.substring(0, n);
        } else {
            this.mapSourceName = string3;
            this.dataSource = string2;
        }
        if (string4 != null && !(string4 = string4.trim()).endsWith("/")) {
            string4 = string4 + "/";
        }
        this.externalMapviewerURL = string4;
        if (string4 == null) {
            this.cache = MCSServlet.server.getMapCacheByName(string2, this.mapSourceName);
            if (this.cache == null) {
                return;
            }
        }
        MapCacheThemeDefinition mapCacheThemeDefinition = new MapCacheThemeDefinition(string, string3, string4);
        this.setDefinition(mapCacheThemeDefinition);
        this.setProducer(new MapCacheThemeProducer(this));
        this.snapToCachedScale = bl;
        if (this.cache != null) {
            this.srid = this.cache.config.coordinateSystem.srid;
        }
    }

    public boolean isTextLabelPresent() {
        return false;
    }

    public boolean cacheInstanceExists() {
        return this.cache != null;
    }

    public int getSRID() {
        return this.srid;
    }

    public MapCache getCacheInstance() {
        return this.cache;
    }

    public void setMapWindow(Rectangle2D rectangle2D) {
        this.mapWindow = rectangle2D;
    }

    public Rectangle2D getMapWindow() {
        return this.mapWindow;
    }

    public boolean snapToCachedScale() {
        return this.snapToCachedScale;
    }

    public String getExternalMapViewerURL() {
        return this.externalMapviewerURL;
    }

    public String getTileLayerName() {
        return this.mapSourceName;
    }

    public String getDataSourceName() {
        if (this.dataSource == null) {
            return super.getDataSourceName();
        }
        return this.dataSource;
    }

    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }
}

