/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.DataException;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.Legend;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.RenderingEngine;
import oracle.sdovis.SRS;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeList;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisContext;
import oracle.sdovis.VisException;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ImageThemeProducer;
import oracle.sdovis.theme.WMSMapThemeProducer;
import oracle.sdovis.util.GIFMaker;
import oracle.sdovis.util.Util;

public class MapMaker
implements VisConstants {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};
    static String MAP_TABLE = "USER_SDO_MAPS";
    static String THEME_TABLE = "USER_SDO_THEMES";
    static String STYLE_TABLE = "USER_SDO_STYLES";
    static final int STYLE_CACHE_LIMIT = 9999;
    public static final AffineTransform idTransform = new AffineTransform();
    protected VisContext vc = null;
    RenderingEngine mRenderEng;
    StyleCache defaultStyleCache = new StyleCache(null, 999);

    public MapMaker() {
        this.vc = new VisContext();
        this.vc.setSrs(new SRS());
        try {
            this.vc.setDeviceWindow(new Rectangle2D.Double(0.0, 0.0, 500.0, 375.0));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.mRenderEng = new RenderingEngine();
        this.mRenderEng.setMapper(this);
    }

    public String getMasterDataSource() {
        return this.vc.getMasterDataSourceName();
    }

    public void setMasterDataSource(String string) {
        this.vc.setMasterDataSourceName(string);
    }

    public int getMasterSrid() {
        return this.vc.getMasterSRID();
    }

    public void setMasterSRID(int n) {
        this.vc.setMasterSRID(n);
    }

    public RenderingEngine getRenderingEngine() {
        return this.mRenderEng;
    }

    public void setInterrupted(boolean bl) {
        this.vc.setInterrupted(bl);
    }

    public boolean isInterrupted() {
        return this.vc.isInterrupted();
    }

    public String getMapTitle() {
        return this.vc.getTitle();
    }

    public void setMapTitle(String string) {
        this.vc.setTitle(string);
    }

    public Style getMapTitleStyle() {
        return this.vc.getTitleStyle();
    }

    public String getMapTitlePosition() {
        return this.vc.getTitlePos();
    }

    public static void setGlobalMapTitle(String string) {
        GlobalVisContext.setGlobalMapTitle(string);
    }

    public static String getGlobalMapTitle() {
        return GlobalVisContext.getGlobalMapTitle();
    }

    public static void setGlobalMapTitleFont(String string) {
        GlobalVisContext.setGlobalMapTitleFont(string);
    }

    public static String getGlobalMaptitleFont() {
        return GlobalVisContext.getGlobalMaptitleFont();
    }

    public static void setGlobalMapTitlePos(String string) {
        GlobalVisContext.setGlobalMapTitlePos(string);
    }

    public static String getGlobalMapTitlePos() {
        return GlobalVisContext.getGlobalMapTitlePos();
    }

    public static void setGlobalMapFootnote(String string) {
        GlobalVisContext.setGlobalMapFootnote(string);
    }

    public static String getGlobalMapFootnote() {
        return GlobalVisContext.getGlobalMapFootnote();
    }

    public static void setGlobalMapFootnoteFont(String string) {
        GlobalVisContext.setGlobalMapFootnoteFont(string);
    }

    public static String getGlobalMapFootnoteFont() {
        return GlobalVisContext.getGlobalMapFootnoteFont();
    }

    public static void setGlobalMapFootnotePos(String string) {
        GlobalVisContext.setGlobalMapFootnotePos(string);
    }

    public static String getGlobalMapFootnotePos() {
        return GlobalVisContext.getGlobalMapFootnotePos();
    }

    public VisContext getVisContext() {
        return this.vc;
    }

    public void setMapTitleStyle(StyleText styleText, String string) {
        this.vc.setTitleStyle(styleText);
        this.vc.setTitlePos(string);
    }

    public void setMapTitleStyleName(String string) {
        this.vc.setTitleStyleName(string);
    }

    public void setMapTitlePosition(String string) {
        this.vc.setTitlePos(string);
    }

    public static boolean isValidPosition(String string) {
        for (int i = 0; i < POSITIONS.length; ++i) {
            if (!POSITIONS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.vc.reset();
    }

    public String getMapFootNote() {
        return this.vc.getFootnote();
    }

    public Style getMapFootNoteStyle() {
        return this.vc.getFootnoteStyle();
    }

    public String getMapFootNotePosition() {
        return this.vc.getFootnotePos();
    }

    public void setMapFootNote(String string) {
        this.vc.setFootnote(string);
    }

    public void setMapFootNoteStyleName(String string) {
        this.vc.setFootnoteStyleName(string);
    }

    public void setMapFootNoteStyle(StyleText styleText, String string) {
        this.vc.setFootnoteStyle(styleText);
        this.vc.setFootnotePos(string);
    }

    public void setMapFootNotePosition(String string) {
        this.vc.setFootnotePos(string);
    }

    public static void setGlobalCustomLogo(String string, String string2) {
        try {
            GlobalVisContext.setLogo(new CustomLogo(string, string2));
        }
        catch (Exception exception) {
            log.severe("error setting global logo");
        }
    }

    public static Image getGlobalCustomLogo() {
        CustomLogo customLogo = GlobalVisContext.getLogo();
        return customLogo != null ? customLogo.getLogo() : null;
    }

    public static String getGlobalCustomLogoPosition() {
        CustomLogo customLogo = GlobalVisContext.getLogo();
        return customLogo != null ? customLogo.getPositionHint() : null;
    }

    public Color getBackgroundColor() {
        return this.vc.getBgColor();
    }

    public void setBackgroundColor(Color color) {
        this.vc.setBgColor(color);
    }

    public Image getBackgroundImage() {
        return this.vc.getBgImage();
    }

    public void setBackgroundImage(Image image) {
        this.vc.setBgImage(image);
    }

    public static boolean getGeomReoriented() {
        return GlobalVisContext.getReorientGeomOridnates();
    }

    public static void setGeomReoriented(boolean bl) {
        GlobalVisContext.setReorientGeomOrdinates(bl);
    }

    public static double computeScale(double d, int n) {
        double d2 = (double)n / (double)SRS.getDPI();
        return d / d2;
    }

    public void setQueryWindow(double d, double d2, double d3, double d4) {
        this.vc.setQueryWindow(new Rectangle2D.Double(d, d2, d3 - d, d4 - d2));
    }

    public void setFullExtent() {
        this.vc.setQueryWindow(new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public Rectangle2D getQueryWindow() {
        return this.vc.getQueryWindow();
    }

    public Point2D getCenter() {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        return rectangle2D != null ? new Point2D.Double(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0, rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0) : null;
    }

    public void setAntiAliasing(boolean bl) {
        this.vc.setAntialiasing(bl);
    }

    public void setImageScaling(boolean bl) {
        this.vc.setImageScaling(bl);
    }

    public boolean getImageScaling() {
        return this.vc.getImageScaling();
    }

    public boolean getAntiAliasing() {
        return this.vc.getAntialiasing();
    }

    public void setTextAntialiasing(boolean bl) {
        this.vc.setTextAntialiasing(bl);
    }

    public boolean getTextAntialiasing() {
        return this.vc.getTextAntialiasing();
    }

    public boolean getTransparent() {
        return this.vc.getTransparent();
    }

    public void setTransparent(boolean bl) {
        this.vc.setTransparent(bl);
    }

    public boolean getBBox() {
        return this.vc.getBBox();
    }

    public void setBBox(boolean bl) {
        this.vc.setBBox(bl);
    }

    public void setImageType(int n) {
        try {
            this.vc.setImageType(n);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public int getImageType() {
        return this.vc.getImageType();
    }

    public int getDeviceWidth() {
        Rectangle2D rectangle2D = this.vc.getDeviceWindow();
        double d = rectangle2D.getWidth();
        return (int)d;
    }

    public int getDeviceHeight() {
        return (int)this.vc.getDeviceWindow().getHeight();
    }

    public void setDeviceSize(double d, double d2, double d3, double d4) {
        int n = (int)(d3 - d);
        int n2 = (int)(d4 - d2);
        try {
            this.vc.setDeviceWindow(new Rectangle2D.Double(d, d2, n, n2));
        }
        catch (VisException visException) {
            log.log(Level.SEVERE, visException.getMessage(), visException);
        }
    }

    public void setDeviceSize2(double d, double d2, double d3, double d4) throws VisException {
        int n = (int)(d3 - d);
        int n2 = (int)(d4 - d2);
        this.vc.setDeviceWindow(new Rectangle2D.Double(d, d2, n, n2));
    }

    public void setNoQuery(boolean bl) {
        this.vc.setNoQuery(bl);
    }

    public boolean getNoQuery() {
        return this.vc.getNoQuery();
    }

    public void setLegend(Legend legend) {
        this.vc.setLegend(legend);
    }

    public Legend getLegend() {
        return this.vc.getLegend();
    }

    public int addTheme(Theme theme) {
        return this.vc.getThemeList().addTheme(theme);
    }

    public void addTheme(Theme theme, int n) {
        this.vc.getThemeList().addTheme(theme, n);
    }

    public void removeTheme(int n) {
        this.vc.getThemeList().removeTheme(n);
    }

    public void removeAllThemes() {
        this.vc.getThemeList().clear();
    }

    public Theme getTheme(int n) {
        return this.vc.getThemeList().getTheme(n);
    }

    public Theme getTheme(String string) {
        return this.vc.getThemeList().getTheme(string);
    }

    public Vector getThemes() {
        return this.vc.getThemeList().getThemes();
    }

    public void setThemes(Collection collection) {
        this.vc.getThemeList().setThemes(collection);
    }

    public int getNumThemes() {
        return this.vc.getThemeList().size();
    }

    public void moveThemeUp(int n) {
        this.vc.getThemeList().moveThemeUp(n);
    }

    public void moveThemeDown(int n) {
        this.vc.getThemeList().moveThemeDown(n);
    }

    public void zoomIn(double d, Graphics2D graphics2D) throws DataException {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        if (rectangle2D == null) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMaxY();
        if (MapMaker.isSpecial(rectangle2D)) {
            return;
        }
        if (d <= 1.0) {
            return;
        }
        double d6 = rectangle2D.getCenterX();
        double d7 = rectangle2D.getCenterY();
        double d8 = rectangle2D.getWidth() / (d * 2.0);
        double d9 = rectangle2D.getHeight() / (d * 2.0);
        d2 = d6 - d8;
        d4 = d6 + d8;
        d3 = d7 - d9;
        d5 = d7 + d9;
        Theme theme = this.vc.getThemeList().getTheme(0);
        if (theme != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        rectangle2D = this.vc.getSrs().getOptimalQueryWindow(d2, d3, d4, d5, this.vc.getDeviceWindow(), this.vc);
        this.vc.setQueryWindow(rectangle2D);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(graphics2D);
            graphics2D.dispose();
        } else {
            this.renderEm(graphics2D);
        }
    }

    public Image zoomIn(double d) throws DataException {
        this.zoomIn(d, null);
        return this.vc.getMapImage();
    }

    public void zoomIn(double d, int n, int n2, Graphics2D graphics2D) throws DataException {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D == null || rectangle2D2 == null) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMaxY();
        double d6 = rectangle2D2.getMinX();
        double d7 = rectangle2D2.getMinY();
        double d8 = rectangle2D2.getMaxX();
        double d9 = rectangle2D2.getMaxY();
        if (MapMaker.isSpecial(rectangle2D)) {
            return;
        }
        if ((double)n < d6 || (double)n2 < d7 || (double)n > d8 || (double)n2 > d9) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        double[] dArray = new double[2];
        if (!this.inverse(nArray, dArray)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double d10 = (d4 - d2) / 2.0;
        double d11 = (d5 - d3) / 2.0;
        rectangle2D = new Rectangle2D.Double(dArray[0] - d10, dArray[1] - d11, d4 - d2, d5 - d3);
        this.vc.setQueryWindow(rectangle2D);
        this.zoomIn(d, graphics2D);
    }

    public Image zoomIn(double d, int n, int n2) throws DataException {
        this.zoomIn(d, n, n2, null);
        return this.vc.getMapImage();
    }

    public void zoomOut(double d, Graphics2D graphics2D) throws DataException {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D == null) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMaxY();
        if (MapMaker.isSpecial(rectangle2D)) {
            return;
        }
        if (d <= 1.0) {
            return;
        }
        double d6 = rectangle2D.getCenterX();
        double d7 = rectangle2D.getCenterY();
        double d8 = (d4 - d2) * d / 2.0;
        double d9 = (d5 - d3) * d / 2.0;
        d2 = d6 - d8;
        d4 = d6 + d8;
        d3 = d7 - d9;
        d5 = d7 + d9;
        Theme theme = this.vc.getThemeList().getTheme(0);
        if (theme != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        rectangle2D = this.vc.getSrs().getOptimalQueryWindow(d2, d3, d4, d5, rectangle2D2, this.vc);
        this.vc.setQueryWindow(rectangle2D);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(graphics2D);
            graphics2D.dispose();
        } else {
            this.renderEm(graphics2D);
        }
    }

    public Image zoomOut(double d) throws DataException {
        this.zoomOut(d, null);
        return this.vc.getMapImage();
    }

    public void zoomOut(double d, int n, int n2, Graphics2D graphics2D) throws DataException {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D == null || rectangle2D2 == null) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMaxY();
        double d6 = rectangle2D2.getMinX();
        double d7 = rectangle2D2.getMinY();
        double d8 = rectangle2D2.getMaxX();
        double d9 = rectangle2D2.getMaxY();
        if (MapMaker.isSpecial(rectangle2D)) {
            return;
        }
        if ((double)n < d6 || (double)n2 < d7 || (double)n > d8 || (double)n2 > d9) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        double[] dArray = new double[2];
        if (!this.inverse(nArray, dArray)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double d10 = (d4 - d2) / 2.0;
        double d11 = (d5 - d3) / 2.0;
        rectangle2D = new Rectangle2D.Double(dArray[0] - d10, dArray[1] - d11, d4 - d2, d5 - d3);
        this.vc.setQueryWindow(rectangle2D);
        this.zoomOut(d, graphics2D);
    }

    public Image zoomOut(double d, int n, int n2) throws DataException {
        this.zoomOut(d, n, n2, null);
        return this.vc.getMapImage();
    }

    public void pan(int n, int n2, Graphics2D graphics2D) throws DataException {
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (rectangle2D == null || rectangle2D2 == null) {
            return;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D2.getMinX();
        double d6 = rectangle2D2.getMinY();
        double d7 = rectangle2D2.getMaxX();
        double d8 = rectangle2D2.getMaxY();
        if (MapMaker.isSpecial(rectangle2D)) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        double[] dArray = new double[2];
        if (!this.inverse(nArray, dArray)) {
            log.severe("Could not inverse a device coordinate.");
            return;
        }
        double d9 = (d3 - d) / 2.0;
        double d10 = (d4 - d2) / 2.0;
        Theme theme = this.vc.getThemeList().getTheme(0);
        if (theme != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        rectangle2D = this.vc.getSrs().getOptimalQueryWindow(dArray[0] - d9, dArray[1] - d10, dArray[0] + d9, dArray[1] + d10, rectangle2D2, this.vc);
        this.vc.setQueryWindow(rectangle2D);
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.vc.getMapImage().getGraphics();
            this.renderEm(graphics2D);
            graphics2D.dispose();
        } else {
            this.renderEm(graphics2D);
        }
    }

    public Image pan(int n, int n2) throws DataException {
        this.pan(n, n2, null);
        return this.vc.getMapImage();
    }

    StyleCache pickStyleCache(String string) {
        DataSourceI dataSourceI = DSManager.get(string);
        if (dataSourceI == null) {
            return this.defaultStyleCache;
        }
        return dataSourceI.getStyleCache();
    }

    public HashMap getCachedStyles() {
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        return new HashMap(styleCache.getAllStyles());
    }

    public void removeAllCachedStyles() {
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (styleCache != null) {
            styleCache.removeAll();
        }
    }

    public void addStyleToCache(Style style, String string) {
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (styleCache != null) {
            styleCache.put(string, style);
        }
    }

    public void deleteStyleFromCache(String string) {
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (styleCache != null) {
            styleCache.remove(string);
        }
    }

    public Style getStyleWithName(String string) {
        if (string == null) {
            return null;
        }
        Style style = this.vc.getDynamicStyle(string);
        if (style != null) {
            return style;
        }
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        if (styleCache != null) {
            style = styleCache.get(string);
        }
        return style;
    }

    public static Style getStyleWithName(String string, String string2, VisContext visContext) {
        if (string == null) {
            return null;
        }
        Style style = null;
        if (visContext != null && (style = visContext.getDynamicStyle(string)) != null) {
            return style;
        }
        if (string2 == null) {
            log.severe("data src name is null in getStyleWithName().");
            return null;
        }
        try {
            StyleCache styleCache = DSManager.get(string2).getStyleCache();
            return styleCache.get(string);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    public boolean styleExists(String string) {
        StyleCache styleCache = this.pickStyleCache(this.vc.getMasterDataSourceName());
        Style style = null;
        if (styleCache != null) {
            style = styleCache.get(string);
        }
        return style != null;
    }

    public SRS getSRS() {
        return this.vc.getSrs();
    }

    public Image renderMap(double d, double d2, double d3, double d4) throws DataException {
        Object object;
        this.vc.setBBox(true);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (object = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(((Theme)object).getSRID());
        }
        sRS = this.vc.getSrs();
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d3, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        object = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image image = this.renderEm((Graphics2D)object);
        ((Graphics)object).dispose();
        return image;
    }

    public Image renderMap() throws DataException {
        Object object;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (object = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(((Theme)object).getSRID());
        }
        this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        object = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image image = this.renderEm((Graphics2D)object);
        ((Graphics)object).dispose();
        return image;
    }

    public void renderMap(Graphics2D graphics2D) throws DataException {
        Theme theme;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            this.paintBlankImg(graphics2D);
            return;
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (theme = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.renderEm(graphics2D);
    }

    public Image renderMap(Rectangle2D rectangle2D) throws DataException {
        Object object;
        if (rectangle2D == null) {
            return this.renderMap();
        }
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (object = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(((Theme)object).getSRID());
        }
        this.setQueryWindow(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
        object = (Graphics2D)this.vc.getMapImage().getGraphics();
        Image image = this.renderEm((Graphics2D)object);
        ((Graphics)object).dispose();
        return image;
    }

    public void renderMap(double d, double d2, double d3, double d4, Graphics2D graphics2D) throws DataException {
        Theme theme;
        this.vc.setBBox(true);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            this.paintBlankImg(graphics2D);
            return;
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (theme = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        sRS = this.vc.getSrs();
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d3, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(graphics2D);
    }

    public void renderMapToFile(double d, double d2, double d3, double d4, String string) throws DataException {
        this.vc.setBBox(true);
        Image image = null;
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            image = this.getBlankImg(this.vc.getMapImage());
        } else {
            image = this.renderMap(d, d2, d3, d4);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GIFMaker gIFMaker = new GIFMaker(fileOutputStream);
            gIFMaker.encode((BufferedImage)image);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void renderMapToFile(String string) throws DataException {
        Object object;
        Object object2;
        this.vc.setBBox(false);
        Image image = null;
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            image = this.getBlankImg(this.vc.getMapImage());
        } else {
            object2 = this.vc.getThemeList().getTheme(0);
            if (object2 != null) {
                this.vc.setMasterSRID(((Theme)object2).getSRID());
            }
            this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            object = (Graphics2D)this.vc.getMapImage().getGraphics();
            image = this.renderEm((Graphics2D)object);
            ((Graphics)object).dispose();
        }
        try {
            object2 = new FileOutputStream(string);
            object = new GIFMaker((OutputStream)object2);
            ((GIFMaker)object).encode((BufferedImage)image);
            ((FileOutputStream)object2).close();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public Image renderMap(double d, double d2, double d3) throws DataException {
        Object object;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (object = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(((Theme)object).getSRID());
        }
        sRS = this.vc.getSrs();
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d3, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        object = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderEm((Graphics2D)object);
        ((Graphics)object).dispose();
        return this.vc.getMapImage();
    }

    public void renderMap(double d, double d2, double d3, Graphics2D graphics2D) throws DataException {
        Theme theme;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            this.paintBlankImg(graphics2D);
            return;
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (theme = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        sRS = this.vc.getSrs();
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d3, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(graphics2D);
    }

    public Image renderMapWithScale(double d, double d2, long l) throws DataException {
        Theme theme;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            return this.getBlankImg(this.vc.getMapImage());
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (theme = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        if ((sRS = this.vc.getSrs()) == null) {
            log.info("Can not use ratio scale on a map without SRS.");
            return this.getBlankImg(this.vc.getMapImage());
        }
        double d3 = sRS.getScreenInchScale(l, new Point2D.Double(d, d2));
        log.finer("Screen inches scale: " + d3);
        if (d3 == -1.0) {
            log.info("Can not convert ratio scale on a map with SRID = " + sRS.getSRID());
            return this.getBlankImg(this.vc.getMapImage());
        }
        double d4 = d3 * this.vc.getDeviceWindow().getHeight() / (double)SRS.getDPI();
        if (this.vc.isPDFformatRequest()) {
            d4 /= 0.75;
        }
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        Graphics2D graphics2D = (Graphics2D)this.vc.getMapImage().getGraphics();
        this.renderEm(graphics2D);
        graphics2D.dispose();
        return this.vc.getMapImage();
    }

    public void renderMapWithScale(double d, double d2, long l, Graphics2D graphics2D) throws DataException {
        Theme theme;
        this.vc.setBBox(false);
        if (this.getNumThemes() == 0) {
            log.info(RSBundle.getMsg("MAPVIEWER-01000"));
            this.paintBlankImg(graphics2D);
            return;
        }
        SRS sRS = this.vc.getSrs();
        if ((sRS == null || sRS.getSRID() < 1) && (theme = this.vc.getThemeList().getTheme(0)) != null) {
            this.vc.setMasterSRID(theme.getSRID());
        }
        if ((sRS = this.vc.getSrs()) == null) {
            log.info("Can not use ratio scale on a map without SRS.");
            return;
        }
        log.finer("Ratio scale: " + l);
        double d3 = sRS.getScreenInchScale(l, new Point2D.Double(d, d2));
        log.finer("Screen inches scale: " + d3);
        if (d3 == -1.0) {
            log.info("Can not convert ratio scale on a map with SRID = " + sRS.getSRID());
            return;
        }
        double d4 = d3 * this.vc.getDeviceWindow().getHeight() / (double)SRS.getDPI();
        if (this.vc.isPDFformatRequest()) {
            d4 /= 0.75;
        }
        log.finer("Map Size: " + d4);
        this.vc.setQueryWindow(sRS.getOptimalQueryWindow(d, d2, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderEm(graphics2D);
    }

    public boolean inverse(int[] nArray, double[] dArray) {
        Object object;
        if (this.mRenderEng == null) {
            return false;
        }
        XFViewPort xFViewPort = this.vc.getViewportTransform();
        if (xFViewPort == null) {
            return false;
        }
        if (!xFViewPort.inverse(nArray, dArray)) {
            return false;
        }
        if (this.vc.getLastRotation() != 0.0) {
            object = Util.rotatePoint(dArray[0], dArray[1], this.vc.getQueryWindow().getCenterX(), this.vc.getQueryWindow().getCenterY(), this.vc.getLastRotation() * -1.0);
            dArray[0] = ((Point2D)object).getX();
            dArray[1] = ((Point2D)object).getY();
        }
        if ((object = this.vc.getProjection()) != null) {
            Proj.P2 p2 = new Proj.P2();
            if (!object.inverse(dArray[0], dArray[1], p2)) {
                log.severe("Projection cannot inverse transform the coordinates.");
                return false;
            }
            dArray[0] = p2.x;
            dArray[1] = p2.y;
            return true;
        }
        return true;
    }

    public String getViewPortTransformInfo() {
        return this.vc.getViewportTransform().toString();
    }

    public static synchronized void addCustomImageRenderer(CustomImageRenderer customImageRenderer, String string) {
        GlobalVisContext.addCustomImageRenderer(string, customImageRenderer);
        log.info("added a custom image renderer for " + string);
    }

    public static CustomImageRenderer findCustomImageRenderer(String string) {
        return GlobalVisContext.findCustomImageRenderer(string);
    }

    public Vector getLiveFeatureVector() {
        return this.vc.getLiveFeatures();
    }

    public void addLiveFeature(StyledFeatureI styledFeatureI) {
        this.vc.addLiveFeature(styledFeatureI);
    }

    public void clearLiveFeatures() {
        this.vc.clearLiveFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image renderEm(Graphics2D graphics2D) throws DataException {
        Cloneable cloneable;
        long l = System.currentTimeMillis();
        if (MapMaker.isSpecial(this.vc.getQueryWindow())) {
            this.clearRotation();
        }
        this.vc.setInterrupted(false);
        this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
        try {
            if (!this.vc.getNoQuery()) {
                for (int i = 0; i < this.vc.getThemeList().size(); ++i) {
                    cloneable = this.vc.getThemeList().getTheme(i);
                    if (cloneable.getDecorator().isPrepared() || !cloneable.getDecorator().withinScaleLimits(this.vc.getCurrentScale())) continue;
                    cloneable.prepareData(this.vc.getQueryWindow(), this.vc);
                    cloneable.postPreparation(this.vc);
                }
            }
        }
        finally {
            this.vc.setNoQuery(false);
        }
        if (MapMaker.isSpecial(this.vc.getQueryWindow())) {
            this.vc.setQueryWindow(this.buildDataMBR());
            this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
        }
        if (this.vc.getMapCache() != null) {
            MapCache mapCache = this.vc.getMapCache();
            cloneable = mapCache.getMapBoundingBox(this.vc.getQueryWindow(), (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight(), !this.vc.snapToCachedScale());
            Image image = null;
            if (cloneable != null) {
                try {
                    image = mapCache.getMap((Rectangle2D)cloneable, (int)this.vc.getDeviceWindow().getWidth(), (int)this.vc.getDeviceWindow().getHeight());
                }
                catch (Exception exception) {
                    log.warning("Failed to generated cached base map!");
                    log.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            if (image != null) {
                this.vc.setQueryWindow((Rectangle2D)cloneable);
                graphics2D.drawImage(image, 0, 0, null);
                this.vc.removeBaseMapThemes();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        log.info(" **** time spent on loading features: " + l3 + "ms.");
        l = System.currentTimeMillis();
        this.mRenderEng.render(graphics2D, this.vc);
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        log.info(" **** time spent on rendering: " + l4 + "ms");
        this.vc.setLastRotation(this.vc.getRotation());
        return this.vc.getMapImage();
    }

    protected Rectangle2D buildDataMBR() {
        Theme theme = null;
        RectangularShape rectangularShape = null;
        double d = 0.05;
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < themeList.size(); ++i) {
            theme = themeList.getTheme(i);
            double[] dArray = theme.getDataMBR();
            if (dArray == null) continue;
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
        }
        if (rectangularShape == null) {
            log.warning("null MBR resulted from buildDataMBR.");
            return null;
        }
        double d2 = rectangularShape.getMinX();
        double d3 = rectangularShape.getMinY();
        double d4 = rectangularShape.getMaxX();
        double d5 = rectangularShape.getMaxY();
        d2 -= (d4 - d2) * d;
        d3 -= (d5 - d3) * d;
        d4 += (d4 - d2) * d;
        d5 += (d5 - d3) * d;
        ((Rectangle2D)rectangularShape).add(d2, d3);
        ((Rectangle2D)rectangularShape).add(d4, d5);
        log.finest("mbr of all themes: " + rectangularShape);
        return rectangularShape;
    }

    protected Rectangle2D buildDataMBR(String[] stringArray, float f, boolean bl, Rectangle2D rectangle2D) {
        Theme theme = null;
        RectangularShape rectangularShape = null;
        double d = f;
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray;
            theme = themeList.getLastMatchingTheme(stringArray[i]);
            if (theme == null || (dArray = theme.getDataMBR()) == null) continue;
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
        }
        if (rectangularShape == null) {
            log.warning("Null MBR resulted from buildDataMBR(themes).");
            return null;
        }
        double d2 = rectangularShape.getMinX();
        double d3 = rectangularShape.getMinY();
        double d4 = rectangularShape.getMaxX();
        double d5 = rectangularShape.getMaxY();
        double d6 = Math.abs(d5 - d3);
        double d7 = Math.abs(d4 - d2);
        if (bl) {
            double d8 = d7 / d6;
            double d9 = rectangle2D.getWidth() / rectangle2D.getHeight();
            if (d8 > d9) {
                d6 = d7 / d9;
            } else if (d8 < d9) {
                d7 = d6 * d9;
            }
            double d10 = (d2 + d4) / 2.0;
            double d11 = (d3 + d5) / 2.0;
            d2 = d10 - d7 / 2.0;
            d3 = d11 - d6 / 2.0;
            d4 = d10 + d7 / 2.0;
            d5 = d11 + d6 / 2.0;
        }
        ((Rectangle2D)rectangularShape).add(d2 -= d7 * d, d3 -= d6 * d);
        ((Rectangle2D)rectangularShape).add(d4 += d7 * d, d5 += d6 * d);
        log.finest("mbr of all bounding themes: " + rectangularShape);
        return rectangularShape;
    }

    protected Rectangle2D buildDataMBR(String[] stringArray, double d, float f, boolean bl, Rectangle2D rectangle2D) {
        double d2;
        double d3;
        if (d <= 0.0) {
            return this.buildDataMBR(stringArray, f, bl, rectangle2D);
        }
        Theme theme = null;
        RectangularShape rectangularShape = null;
        double d4 = f;
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray;
            theme = themeList.getLastMatchingTheme(stringArray[i]);
            if (theme == null || (dArray = theme.getDataMBR()) == null) continue;
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
        }
        if (rectangularShape == null) {
            log.warning("Null MBR resulted from buildDataMBR(themes).");
            return null;
        }
        double d5 = rectangularShape.getMinX();
        double d6 = rectangularShape.getMinY();
        double d7 = rectangularShape.getMaxX();
        double d8 = rectangularShape.getMaxY();
        double d9 = Math.abs(d8 - d6);
        double d10 = Math.abs(d7 - d5);
        if (d9 == 0.0 || d10 == 0.0) {
            log.finer("Applying mbr size");
            d3 = d5 + d10 / 2.0;
            d2 = d6 + d9 / 2.0;
            d5 = d3 - d / 2.0;
            d7 = d3 + d / 2.0;
            d6 = d2 - d / 2.0;
            d8 = d2 + d / 2.0;
            d9 = d;
            d10 = d;
        }
        if (bl) {
            d2 = d10 / d9;
            d3 = rectangle2D.getWidth() / rectangle2D.getHeight();
            if (d2 > d3) {
                d9 = d10 / d3;
            } else if (d2 < d3) {
                d10 = d9 * d3;
            }
            double d11 = (d5 + d7) / 2.0;
            double d12 = (d6 + d8) / 2.0;
            d5 = d11 - d10 / 2.0;
            d6 = d12 - d9 / 2.0;
            d7 = d11 + d10 / 2.0;
            d8 = d12 + d9 / 2.0;
        }
        ((Rectangle2D)rectangularShape).add(d5 -= d10 * d4, d6 -= d9 * d4);
        ((Rectangle2D)rectangularShape).add(d7 += d10 * d4, d8 += d9 * d4);
        log.finest("mbr of all bounding themes: " + rectangularShape);
        return rectangularShape;
    }

    public AffineTransform getAffineTransform() {
        return this.vc.getAffineXF();
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.vc.setAffineXF(affineTransform);
    }

    public static final boolean isSpecial(Rectangle2D rectangle2D) {
        if (Double.isInfinite(rectangle2D.getWidth()) || Double.isNaN(rectangle2D.getWidth()) || Double.isInfinite(rectangle2D.getHeight()) || Double.isNaN(rectangle2D.getHeight())) {
            return true;
        }
        return MapMaker.isSpecial(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public static final boolean isSpecial(double d, double d2, double d3, double d4) {
        return Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private Image getBlankImg(Image image) {
        if (this.getLegend() == null) {
            Color color = this.getBackgroundColor();
            if (color == null) {
                color = Color.white;
            }
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setColor(color);
            Rectangle2D rectangle2D = this.vc.getDeviceWindow();
            graphics2D.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()), (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()));
            this.mRenderEng.renderMapTitle(graphics2D, this.vc);
            this.mRenderEng.renderMapFootNote(graphics2D, this.vc);
            graphics2D.dispose();
            return image;
        }
        Legend legend = this.getLegend();
        Rectangle2D rectangle2D = legend.computeMBR();
        BufferedImage bufferedImage = this.vc.getLegendImage();
        if (bufferedImage != null) {
            bufferedImage.flush();
            bufferedImage = null;
        }
        bufferedImage = new BufferedImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1, this.vc.getImageType());
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        legend.paint(graphics2D, 0, 0);
        graphics2D.dispose();
        this.vc.setLegendImage(bufferedImage);
        return bufferedImage;
    }

    private void paintBlankImg(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (this.getLegend() == null) {
            Color color = this.getBackgroundColor();
            if (color == null) {
                color = Color.white;
            }
            graphics2D.setColor(color);
            Rectangle2D rectangle2D = this.vc.getDeviceWindow();
            graphics2D.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()), (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()));
            this.mRenderEng.renderMapTitle(graphics2D, this.vc);
            this.mRenderEng.renderMapFootNote(graphics2D, this.vc);
        } else {
            Legend legend = this.getLegend();
            legend.paint(graphics2D, 0, 0);
        }
    }

    public static void setFastUnpickle(boolean bl) {
        GlobalVisContext.setFastUnpickle(bl);
        if (bl) {
            // empty if block
        }
    }

    public static boolean getFastUnpickle() {
        return GlobalVisContext.getFastUnpickle();
    }

    public static void setUGP(boolean bl) {
        GlobalVisContext.setUgp(bl);
    }

    public static boolean getUGP() {
        return GlobalVisContext.getUgp();
    }

    public static void setLocalAdjustment(boolean bl) {
    }

    public static boolean getLocalAdjustment() {
        return false;
    }

    public void renderSVGMap(Writer writer, double d, double d2, double d3, boolean bl) throws DataException, IOException {
        if (this.getNumThemes() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01000"));
            return;
        }
        SRS sRS = this.vc.getSrs();
        if (sRS == null || sRS.getSRID() < 1) {
            Theme theme = this.vc.getThemeList().getTheme(0);
            this.vc.setMasterSRID(theme.getSRID());
        }
        this.vc.setQueryWindow(this.vc.getSrs().getOptimalQueryWindow(d, d2, d3, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderSVGEm(writer, bl);
    }

    public void renderSVGMapWithScale(Writer writer, double d, double d2, long l, boolean bl) throws DataException, IOException {
        if (this.getNumThemes() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01000"));
            return;
        }
        SRS sRS = this.vc.getSrs();
        if (sRS == null || sRS.getSRID() < 1) {
            Theme theme = this.vc.getThemeList().getTheme(0);
            this.vc.setMasterSRID(theme.getSRID());
        }
        if ((sRS = this.vc.getSrs()) == null) {
            log.info("Can not use ratio scale on a map without SRS.");
            return;
        }
        log.finer("Ratio scale: " + l);
        double d3 = sRS.getScreenInchScale(l, new Point2D.Double(d, d2));
        log.finer("Screen inches scale: " + d3);
        if (d3 == -1.0) {
            log.info("Can not convert ratio scale on a map with SRID = " + sRS.getSRID());
            return;
        }
        double d4 = d3 * this.vc.getDeviceWindow().getHeight() / (double)SRS.getDPI();
        log.finer("Map Size: " + d4);
        this.vc.setQueryWindow(this.vc.getSrs().getOptimalQueryWindow(d, d2, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderSVGEm(writer, bl);
    }

    public void renderSVGMap(Writer writer, double d, double d2, double d3, double d4, boolean bl) throws DataException, IOException {
        if (this.getNumThemes() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01000"));
            return;
        }
        SRS sRS = this.vc.getSrs();
        if (sRS == null || sRS.getSRID() < 1) {
            Theme theme = this.vc.getThemeList().getTheme(0);
            this.vc.setMasterSRID(theme.getSRID());
        }
        this.vc.setQueryWindow(this.vc.getSrs().getOptimalQueryWindow(d, d2, d3, d4, this.vc.getDeviceWindow(), this.vc));
        if (!this.vc.getImageScaling()) {
            this.resizeQueryWindow();
        }
        this.renderSVGEm(writer, bl);
    }

    public void renderSVGMap(Writer writer, boolean bl) throws DataException, IOException {
        if (this.getNumThemes() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01000"));
            return;
        }
        this.setQueryWindow(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.renderSVGEm(writer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSVGEm(Writer writer, boolean bl) throws DataException, IOException {
        long l = System.currentTimeMillis();
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        Rectangle2D rectangle2D2 = this.vc.getDeviceWindow();
        if (MapMaker.isSpecial(this.vc.getQueryWindow())) {
            this.clearRotation();
        }
        this.vc.setScale(rectangle2D, rectangle2D2);
        ThemeList themeList = this.vc.getThemeList();
        try {
            if (!this.vc.getNoQuery()) {
                for (int i = 0; i < themeList.size(); ++i) {
                    Theme theme = themeList.getTheme(i);
                    if (!theme.getDecorator().withinScaleLimits(this.vc.getCurrentScale())) continue;
                    theme.prepareData(rectangle2D, this.vc);
                    theme.postPreparation(this.vc);
                }
            }
        }
        finally {
            this.vc.setNoQuery(false);
        }
        if (MapMaker.isSpecial(rectangle2D)) {
            rectangle2D = this.buildDataMBR();
            this.vc.setQueryWindow(rectangle2D);
            this.vc.setScale(rectangle2D, rectangle2D2);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        log.info(" **** time spent on loading features: " + l3 + "ms.");
        l = System.currentTimeMillis();
        this.mRenderEng.renderSVG(writer, this.vc, bl);
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        log.info(" **** time spent on rendering flash xml: " + l4 + "ms");
        this.vc.setLastRotation(this.vc.getRotation());
    }

    private ImageTheme getImageTheme() {
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < themeList.size(); ++i) {
            Theme theme = themeList.getTheme(i);
            if (!(theme instanceof ImageTheme)) continue;
            if (theme.getDecorator().withinScaleLimits(this.vc.getCurrentScale())) {
                // empty if block
            }
            return (ImageTheme)theme;
        }
        return null;
    }

    private ShadedReliefTheme getShadedReliefTheme() {
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < themeList.size(); ++i) {
            Theme theme = themeList.getTheme(i);
            if (!(theme instanceof ShadedReliefTheme)) continue;
            if (theme.getDecorator().withinScaleLimits(this.vc.getCurrentScale())) {
                // empty if block
            }
            return (ShadedReliefTheme)theme;
        }
        return null;
    }

    private GeoRasterTheme getGeoRasterTheme() {
        ThemeList themeList = this.vc.getThemeList();
        for (int i = 0; i < themeList.size(); ++i) {
            Theme theme = themeList.getTheme(i);
            if (!(theme instanceof GeoRasterTheme)) continue;
            if (theme.getDecorator().withinScaleLimits(this.vc.getCurrentScale())) {
                // empty if block
            }
            return (GeoRasterTheme)theme;
        }
        return null;
    }

    private void resizeQueryWindow() {
        try {
            this.vc.setScale(this.vc.getQueryWindow(), this.vc.getDeviceWindow());
            ImageTheme imageTheme = this.getImageTheme();
            if (imageTheme != null) {
                ImageThemeDefinition imageThemeDefinition = (ImageThemeDefinition)imageTheme.getDefinition();
                if (imageThemeDefinition.getImageResolution() > 0.0) {
                    double d = imageThemeDefinition.getImageResolution() * this.vc.getDeviceWindow().getHeight();
                    double d2 = this.vc.getQueryWindow().getCenterX();
                    double d3 = this.vc.getQueryWindow().getCenterY();
                    this.vc.setQueryWindow(this.vc.getSrs().getOptimalQueryWindow(d2, d3, d, this.vc.getDeviceWindow(), this.vc));
                } else {
                    log.warning("No image_resolution set for the image theme: " + imageThemeDefinition.getName());
                    log.warning("Image will be rescaled to fit query window.");
                    this.vc.setImageScaling(true);
                }
            } else {
                GeoRasterTheme geoRasterTheme = this.getGeoRasterTheme();
                if (geoRasterTheme != null) {
                    log.warning("Currently, image scaling set to false has no effect for GeoRaster themes");
                    log.warning("GeoRaster themes will be rescaled to fit query window.");
                    this.vc.setImageScaling(true);
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static void setShowQueryWindow(boolean bl) {
        GlobalVisContext.setShowQueryWindow(bl);
    }

    public Theme addCustomGeomTheme(String string, String string2, Properties properties, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String[] stringArray2, String[] stringArray3, int n) {
        Field[] fieldArray;
        string = string.toUpperCase();
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomGeomThemeDefinition customGeomThemeDefinition = new CustomGeomThemeDefinition(string, string2, properties, n2);
        customGeomThemeDefinition.setSpatialColumn(string3);
        customGeomThemeDefinition.setFeatureStyleName(string5);
        customGeomThemeDefinition.setLabelColumn(string6);
        customGeomThemeDefinition.setLabelStyleName(string7);
        customGeomThemeDefinition.setRuntimeProperties(properties);
        if (stringArray != null && stringArray.length > 0) {
            fieldArray = new Field[stringArray.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(stringArray[i]);
                field.setDisplayName(stringArray2[i]);
                fieldArray[i] = field;
            }
            customGeomThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        customGeomThemeDefinition.setNonSpatialColumns(stringArray3);
        fieldArray = new CustomGeomTheme(customGeomThemeDefinition);
        this.addTheme((Theme)fieldArray, n);
        return fieldArray;
    }

    public void clearRotation() {
        if (this.vc != null) {
            this.vc.setRotation(0.0);
            this.vc.setLastRotation(0.0);
        }
    }

    public String[] getRenderedThemes(boolean bl) {
        if (this.vc == null) {
            return null;
        }
        ThemeList themeList = this.vc.getThemeList();
        if (themeList == null || themeList.size() < 1) {
            return null;
        }
        boolean bl2 = false;
        Rectangle2D rectangle2D = this.vc.getQueryWindow();
        if (rectangle2D == null) {
            bl2 = true;
        } else {
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMinY();
            double d3 = rectangle2D.getMaxX();
            double d4 = rectangle2D.getMaxY();
            bl2 = Util.isFullExtent(d, d2, d3, d4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < themeList.size(); ++i) {
            Rectangle2D.Double double_;
            double[] dArray;
            Object object;
            Theme theme = themeList.getTheme(i);
            if (theme instanceof ImageTheme || theme instanceof GeoRasterTheme) {
                object = null;
                if (theme instanceof ImageTheme) {
                    object = ((ImageThemeProducer)theme.getProducer()).getMBRs();
                }
                if (theme instanceof GeoRasterTheme) {
                    object = ((GeoRasterThemeProducer)theme.getProducer()).getMBRs();
                }
                if (object == null || ((double[][])object).length <= 0) continue;
                arrayList.add(theme.getName());
                continue;
            }
            if (theme instanceof WMSMapTheme) {
                if (((WMSMapThemeProducer)theme.getProducer()).getWMSMap() == null) continue;
                arrayList.add(theme.getName());
                continue;
            }
            object = theme.getProducer().getStyledFeatures();
            if (object == null || ((double[][])object).length <= 0 || theme instanceof LocalTheme && (!bl || !bl2 && ((dArray = theme.getProducer().getDataMBR()) == null || !rectangle2D.intersects(double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]))))) continue;
            arrayList.add(theme.getName());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

