/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataProvider;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.NSDataProviderMgr;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;

public class NsDpHandler {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private NsDpInfo def;
    private boolean prepared;
    private NSDataSet data;
    private NSDataLoader thread;

    public NsDpHandler(NsDpInfo nsDpInfo) {
        this.def = nsDpInfo;
    }

    public void startThread() {
        this.thread = new NSDataLoader();
        this.thread.start();
    }

    public boolean waitForThread() throws Exception {
        if (this.thread == null) {
            return false;
        }
        this.thread.join(300000L);
        if (this.thread.getException() == null) {
            return true;
        }
        throw this.thread.getException();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread = null;
        }
        if (this.data != null) {
            this.data.close();
        }
    }

    public void setDef(NsDpInfo nsDpInfo) {
        this.def = nsDpInfo;
    }

    public NsDpInfo getDef() {
        return this.def;
    }

    public void setData(NSDataSet nSDataSet) {
        this.data = nSDataSet;
    }

    public NSDataSet getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDataJoin(VisContext visContext) {
        if (this.def.isProcessed()) {
            return;
        }
        Theme theme = visContext.getThemeList().getLastMatchingTheme(this.def.getTheme());
        if (theme == null) {
            log.severe("NSDataHandler: cannot find referenced theme: " + this.def.getTheme());
            this.def.setProcessed(true);
            return;
        }
        try {
            block7: {
                try {
                    StyledFeatureI[] styledFeatureIArray = this.doJoin(theme.getStyledFeatures(), this.data, this.def.getCustomRenderStyle());
                    if (styledFeatureIArray != null && styledFeatureIArray.length > 0) {
                        theme.getProducer().setStyledFeatures(styledFeatureIArray);
                        break block7;
                    }
                    log.info("NSDataHandler: no matching feature found.");
                    if (this.def.isShowUnmatched()) break block7;
                    styledFeatureIArray = new StyledFeature[]{};
                    theme.getProducer().setStyledFeatures(styledFeatureIArray);
                }
                catch (Exception exception) {
                    log.severe("NSDataHandler: failure joining theme: " + this.def.getTheme());
                    log.log(Level.SEVERE, exception.getMessage(), exception);
                    Object var5_6 = null;
                    this.def.setProcessed(true);
                }
            }
            Object var5_5 = null;
            this.def.setProcessed(true);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.def.setProcessed(true);
            throw throwable;
        }
    }

    private StyledFeatureI[] doJoin(StyledFeatureI[] styledFeatureIArray, NSDataSet nSDataSet, String string) {
        NSRow nSRow;
        String string2;
        Object object;
        long l = System.currentTimeMillis();
        if (styledFeatureIArray == null) {
            log.severe("No renderable features found during NSDP join.");
            return new StyledFeature[0];
        }
        if (nSDataSet == null) {
            log.severe("No non-spatial data found during NSDP join.");
            return new StyledFeature[0];
        }
        int n = styledFeatureIArray.length;
        int n2 = nSDataSet.size();
        Vector<Object> vector = new Vector<Object>();
        Hashtable<String, NSRow> hashtable = new Hashtable<String, NSRow>((int)((double)n2 * 1.2));
        NSRow[] nSRowArray = nSDataSet.getRows();
        if (nSRowArray == null) {
            nSRowArray = new NSRow[]{};
        }
        for (int i = 0; i < nSRowArray.length; ++i) {
            NSRow nSRow2 = nSRowArray[i];
            object = nSRow2.getKeyAttribute();
            if (object == null) {
                log.warning("cannot find a primary key attribute.");
                continue;
            }
            string2 = "" + ((Field)object).getValue();
            nSRow = hashtable.put(string2.toUpperCase(), nSRow2);
            if (nSRow == null) continue;
            log.warning("duplicate NSRow found: " + string2);
        }
        String string3 = this.def.getJoinColumnSpatial();
        for (int i = 0; i < n; ++i) {
            object = styledFeatureIArray[i];
            string2 = this.findKeyValue((StyledFeatureI)object, string3);
            if (string2 == null) {
                log.info("cannot find a key value in the styled feature.");
                continue;
            }
            nSRow = (NSRow)hashtable.get(string2.toUpperCase());
            if (nSRow == null) {
                if (i != 0) continue;
                log.finer("Cannot find any matching NSRow for key (from spatial table): " + string2);
                continue;
            }
            this.modifyFeature((StyledFeatureI)object, nSRow, string);
            object.setNsdpMetaInfo(nSDataSet.getMetadata());
            RenderingRule[] renderingRuleArray = nSDataSet.getCustomRenderingRules();
            if (renderingRuleArray != null && renderingRuleArray.length > 0) {
                object.setFeatureStyleName(renderingRuleArray[0].getStyleName());
                object.setRenderingRules(renderingRuleArray);
            }
            vector.add(object);
        }
        log.finest("Time spent on NSDP join:" + (System.currentTimeMillis() - l) + "ms. Matches found: " + vector.size() + ".");
        if (this.def.isShowUnmatched()) {
            return styledFeatureIArray;
        }
        return vector.toArray(new StyledFeatureI[vector.size()]);
    }

    private String findKeyValue(StyledFeatureI styledFeatureI, String string) {
        Field field;
        int n;
        Field[] fieldArray = styledFeatureI.getIdentifiableAttributes();
        Field[] fieldArray2 = styledFeatureI.getRenderableAttributes();
        String string2 = styledFeatureI.getLabel();
        String string3 = null;
        if (fieldArray != null && fieldArray.length > 0) {
            for (n = 0; n < fieldArray.length; ++n) {
                field = fieldArray[n];
                if (field == null || !string.equalsIgnoreCase(field.getName()) && !string.equalsIgnoreCase(field.getDisplayName())) continue;
                string3 = "" + field.toString();
                string3 = string3.toUpperCase();
                break;
            }
        }
        if (string3 == null && fieldArray2 != null && fieldArray2.length > 0) {
            for (n = 0; n < fieldArray2.length; ++n) {
                field = fieldArray2[n];
                if (field == null || !string.equalsIgnoreCase(field.getName()) && !string.equalsIgnoreCase(field.getDisplayName())) continue;
                string3 = "" + field.toString();
                string3 = string3.toUpperCase();
                break;
            }
        }
        if (string3 == null && string2 != null) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = styledFeatureI.getID();
        }
        return string3;
    }

    private void modifyFeature(StyledFeatureI styledFeatureI, NSRow nSRow, String string) {
        int n = nSRow.size() - 1;
        if (nSRow.getLabelAttribute() != null) {
            --n;
        }
        Field[] fieldArray = styledFeatureI.getIdentifiableAttributes();
        Vector<Field> vector = new Vector<Field>();
        if (fieldArray != null && fieldArray.length > 0) {
            for (int i = 0; i < fieldArray.length; ++i) {
                vector.add(fieldArray[i]);
            }
        }
        Field[] fieldArray2 = new Field[n];
        Field field = null;
        int n2 = 0;
        for (int i = 0; i < nSRow.size(); ++i) {
            Field field2 = nSRow.get(i);
            if (field2.isKey() || field2.isLabelText()) {
                if (field2.isLabelText()) {
                    field = field2;
                }
                vector.add(field2);
                continue;
            }
            fieldArray2[n2++] = (Field)field2.clone();
        }
        styledFeatureI.setRenderableAttributes(fieldArray2);
        styledFeatureI.setIdentifiableAttributes(vector.toArray(new Field[vector.size()]));
        if (string != null && string.length() > 0) {
            styledFeatureI.setFeatureStyle(null);
            styledFeatureI.setFeatureStyleName(string);
        }
        if (field != null) {
            styledFeatureI.setLabel(field.getString());
        }
    }

    public class NSDataLoader
    extends Thread {
        Exception ex;
        NSDataSet nsdata;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (NsDpHandler.this.def.isProcessed()) {
                return;
            }
            NSDataProvider nSDataProvider = NSDataProviderMgr.getProvider(NsDpHandler.this.def.getDpId());
            if (nSDataProvider == null) {
                this.ex = new Exception("cannot find NS data provider for: " + NsDpHandler.this.def.getDpId());
                return;
            }
            try {
                try {
                    long l = System.currentTimeMillis();
                    Properties properties = NsDpHandler.this.def.getDpParams();
                    Hashtable<String, String> hashtable = NsDpHandler.this.def.getContextObjects();
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, String>(11);
                    }
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)properties.get(string);
                        hashtable.put(string, string2);
                    }
                    log.finest("NsDpHandler: begin building NS data set...");
                    this.nsdata = nSDataProvider.buildDataSet(hashtable);
                    NsDpHandler.this.data = this.nsdata;
                    log.finest("Time spent getting NSDP data: " + (System.currentTimeMillis() - l) + "ms.");
                }
                catch (Exception exception) {
                    this.ex = exception;
                    log.log(Level.SEVERE, exception.getMessage(), exception);
                    this.nsdata = null;
                    Object var10_10 = null;
                    NsDpHandler.this.prepared = true;
                    return;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                NsDpHandler.this.prepared = true;
                throw throwable;
            }
            NsDpHandler.this.prepared = true;
        }

        public Exception getException() {
            return this.ex;
        }

        public NSDataSet getNSDataSet() {
            return this.nsdata;
        }
    }
}

