/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.Proj;

public class ProjAzEd
implements Proj {
    private static final int SOUTH_POLE = 1;
    private static final int NORTH_POLE = 2;
    private double R;
    private double clon;
    private double clat;
    private double dlon;
    private double dlat;
    private double easting;
    private double northing;
    private double _cos_clat;
    private double _sin_clat;
    private double o_clon;
    private double o_clat;
    private int pole_pos = 0;
    private Rectangle2D virtualQW;
    private static double[] bg;

    public ProjAzEd(double d, double d2) {
        this(6378206.4, d, d2);
    }

    public ProjAzEd(double d, double d2, double d3) {
        this.R = d;
        if (d3 == 90.0) {
            this.pole_pos = 2;
        } else if (d3 == -90.0) {
            this.pole_pos = 1;
        }
        this.dlon = Proj.util.Clip(d2, -360.0, 360.0);
        this.dlat = Proj.util.Clip(d3, -90.0, 90.0);
        this.o_clon = this.dlon <= 0.0 ? this.dlon + 180.0 : this.dlon - 180.0;
        this.o_clat = this.dlat == 0.0 ? 0.0 : -this.dlat;
        this.clon = Proj.util.Clip(d2 * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = Proj.util.Clip(d3 * (Math.PI / 180), -1.5707963267948966, 1.5707963267948966);
        this.init();
    }

    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.dlon, this.dlat};
    }

    public static ProjAzEd restore(double[] dArray) {
        if (dArray[0] != 1.0) {
            System.err.println("Error: Projection ID does not match!");
        }
        return new ProjAzEd(dArray[1], dArray[2], dArray[3]);
    }

    public double getR() {
        return this.R;
    }

    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    public int getProjId() {
        return 1;
    }

    public final boolean forward(double d, double d2, Proj.P2 p2) {
        boolean bl;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl2 = bl = d2 >= 90.0 || d2 <= -90.0;
        d2 = d2 == 90.0 ? 1.5707963267948966 : (d2 == -90.0 ? -1.5707963267948966 : (d2 *= Math.PI / 180));
        double d5 = Proj.util.adjustLon((d *= Math.PI / 180) - this.clon);
        double d6 = 0.0;
        double d7 = this._sin_clat * Math.sin(d2) + this._cos_clat * Math.cos(d2) * Math.cos(d5);
        if (Math.abs(1.0 - d7) < 1.0E-15) {
            p2.set(0.0 + this.easting, 0.0 + this.northing);
            return true;
        }
        if (Math.abs(-1.0 - d7) < 1.0E-10) {
            return false;
        }
        double d8 = Math.acos(d7);
        d6 = d8 / Math.sin(d8);
        d3 = bl ? 0.0 : this.R * d6 * Math.cos(d2) * Math.sin(d5);
        d4 = bl ? this.R * d6 * this._cos_clat * Math.sin(d2) : this.R * d6 * (this._cos_clat * Math.sin(d2) - this._sin_clat * Math.cos(d2) * Math.cos(d5));
        p2.set(d3 + this.easting, d4 + this.northing);
        return true;
    }

    public final boolean inverse(double d, double d2, Proj.P2 p2) {
        double d3 = 0.0;
        double d4 = 0.0;
        if ((d -= this.easting) == 0.0 && (d2 -= this.northing) == 0.0) {
            d4 = this.clon * 57.29577951308232;
            d3 = this.clat * 57.29577951308232;
            p2.set(d4, d3);
            return true;
        }
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = d5 / this.R;
        d3 = Math.asin(Math.cos(d6) * this._sin_clat + d2 * Math.sin(d6) * this._cos_clat / d5);
        if (this.pole_pos == 2) {
            d4 = this.clon + Math.atan2(d, -d2);
        } else if (this.pole_pos == 1) {
            d4 = this.clon + Math.atan2(d, d2);
        } else {
            double d7 = Math.atan2(d * Math.sin(d6), d5 * this._cos_clat * Math.cos(d6) - d2 * this._sin_clat * Math.sin(d6));
            d4 = this.clon + d7;
        }
        d3 *= 57.29577951308232;
        d4 *= 57.29577951308232;
        d3 = Proj.util.Clip(d3, -90.0, 90.0);
        if (d4 > 180.0) {
            d4 -= 360.0;
        } else if (d4 < -180.0) {
            d4 += 360.0;
        }
        p2.set(d4, d3);
        return true;
    }

    public void setOffset(double d, double d2) {
        this.easting = d;
        this.northing = d2;
    }

    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double d, double d2) {
        return Math.abs(d2) > this.northing + Math.PI * this.R || Math.abs(d) > this.easting + Math.PI * this.R;
    }

    public Proj.P2 getOpposite() {
        return new Proj.P2(this.o_clon, this.o_clat);
    }

    public double[] getBoundingGeom() {
        return bg;
    }

    public double[] getParallel(double d, double d2) {
        if (d >= 90.0 || d <= -90.0) {
            return null;
        }
        if (Math.abs(d) > 55.0) {
            d2 *= (double)((int)Math.max(1.0, Math.abs(d) / 20.0));
        }
        CoordArray coordArray = new CoordArray(720);
        float f = -240.0f;
        while (f <= 240.0f) {
            coordArray.add(f, d);
            f = (float)((double)f + d2);
        }
        return coordArray.getAll();
    }

    public static Rectangle2D getQueryWindow(double d, double d2, double d3, Rectangle2D rectangle2D, Proj[] projArray) {
        double d4;
        d3 = Math.abs(d3);
        Rectangle2D.Double double_ = null;
        double d5 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d6 = d3;
        double d7 = d3 * d5;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d - d7 / 2.0, d2 - d6 / 2.0, d7, d6);
        if (d2 > 90.0) {
            d2 = 90.0;
        } else if (d2 < -90.0) {
            d2 = -90.0;
        } else if (Math.abs(90.0 - d2) < d3 * 0.05) {
            d2 = 90.0;
        } else if (Math.abs(-90.0 - d2) < d3 * 0.05) {
            d2 = -90.0;
        }
        double d8 = 0.0;
        double d9 = 0.0;
        if (d2 == -90.0) {
            d8 = -90.0;
            d9 = Proj.util.Clip(-90.0 + d6, -90.0, 90.0);
        } else if (d2 == 90.0) {
            d8 = Proj.util.Clip(90.0 - d6, -90.0, 90.0);
            d9 = 90.0;
        } else {
            d8 = d2 - d6 / 2.0;
            d9 = d2 + d6 / 2.0;
            if (d9 > 90.0) {
                d4 = d9 - 90.0;
                d8 = Proj.util.Clip(d8 - d4, -90.0, 90.0);
            }
            if (d8 < -90.0) {
                d4 = Math.abs(d8 + 90.0);
                d9 = Proj.util.Clip(d9 + d4, -90.0, 90.0);
            }
            d8 = Proj.util.Clip(d8, -90.0, 90.0);
            d9 = Proj.util.Clip(d9, -90.0, 90.0);
        }
        if (d > 180.0) {
            d -= 360.0;
        } else if (d < -180.0) {
            d += 360.0;
        }
        d4 = 0.0;
        double d10 = 0.0;
        if (d7 >= 360.0) {
            d7 = 360.0;
            d4 = Proj.util.Clip(d - d7 / 2.0, -360.0, 360.0);
            d10 = Proj.util.Clip(d + d7 / 2.0, -360.0, 360.0);
        } else {
            d7 = Math.abs(d9 - d8) * d5;
            d4 = Proj.util.Clip(d - d7 / 2.0, -360.0, 360.0);
            d10 = Proj.util.Clip(d + d7 / 2.0, -360.0, 360.0);
        }
        double_ = new Rectangle2D.Double(d4, d8, d10 - d4, d9 - d8);
        ProjAzEd projAzEd = new ProjAzEd(d, d2);
        projAzEd.virtualQW = double_2;
        projArray[0] = projAzEd;
        return double_;
    }

    public Rectangle2D getBoundingBox(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = d4 = this.R * Math.PI;
        double d6 = rectangle2D.getHeight();
        double d7 = rectangle2D.getWidth();
        double d8 = d7 / d6;
        if (this.pole_pos == 2 || this.pole_pos == 1) {
            Proj.P2 p2;
            d3 = this.dlon;
            d2 = this.pole_pos == 2 ? this.dlat - d6 / 2.0 : this.dlat + d6 / 2.0;
            if (this.forward(d3, d2, p2 = new Proj.P2())) {
                double d9;
                d5 = Math.abs(p2.y - this.northing) * 2.0;
                d4 = d5 * d8;
                if (this.virtualQW != null && (d9 = this.virtualQW.getHeight()) >= 180.0) {
                    d5 *= d9 / 180.0;
                    d4 *= d9 / 180.0;
                }
                return new Rectangle2D.Double(-d4 / 2.0, -d5 / 2.0, d4, d5);
            }
            System.err.println("ProjAzEd: cannot do forward transformation on " + d3 + "," + d2);
        }
        d3 = Math.abs(this.dlat) > 40.0 ? 810.0 : (Math.abs(this.dlat) > 20.0 ? 630.0 : 540.0);
        d2 = d7 / d3;
        d4 *= d2;
        d5 *= d2;
        if (this.virtualQW != null && (d = this.virtualQW.getHeight()) > 180.0) {
            d4 *= d / 180.0;
            d5 *= d / 180.0;
        }
        return new Rectangle2D.Double(-d4 / 2.0, -d5 / 2.0, d4, d5);
    }

    private void init() {
        this._cos_clat = Math.cos(this.clat);
        this._sin_clat = Math.sin(this.clat);
    }

    private static void createBG() {
        double d = 6378206.4;
        CoordArray coordArray = new CoordArray(750);
        double d2 = Math.PI * d;
        for (int i = 0; i <= 360; ++i) {
            double d3 = d2 * Math.cos((double)i * (Math.PI / 180));
            double d4 = d2 * Math.sin((double)i * (Math.PI / 180));
            coordArray.add(d3, d4);
        }
        bg = coordArray.getAll();
    }

    static {
        ProjAzEd.createBG();
    }
}

