/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.Proj;
import oracle.sdovis.Spheroid;

public class ProjMercator
implements Proj {
    private double R;
    private double clat;
    private double clon;
    private double easting;
    private double northing;

    public ProjMercator() {
        this(Spheroid.clarke1866.getSemiMajorAxis(), 0.0, 0.0);
    }

    public ProjMercator(double d) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), d, 0.0);
    }

    public ProjMercator(double d, double d2) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), d, d2);
    }

    public ProjMercator(double d, double d2, double d3) {
        this.R = d;
        this.clon = Proj.util.Clip(d2 * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = d3 * (Math.PI / 180);
        this.init();
    }

    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.clon, this.clat};
    }

    public double getR() {
        return this.R;
    }

    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    public Proj.P2 getOpposite() {
        return null;
    }

    public int getProjId() {
        return 2;
    }

    public Rectangle2D getBoundingBox(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return null;
    }

    public final boolean forward(double d, double d2, Proj.P2 p2) {
        double d3 = this.R * Proj.util.adjustLon((d *= Math.PI / 180) - this.clon);
        double d4 = Math.sin(d2 *= Math.PI / 180);
        double d5 = 0.0;
        d5 = d4 != 1.0 ? this.R * 0.5 * Math.log((1.0 + d4) / (1.0 - d4)) : Double.POSITIVE_INFINITY;
        p2.set(d3 + this.easting, d5 + this.northing);
        return true;
    }

    public final boolean inverse(double d, double d2, Proj.P2 p2) {
        if (Double.isInfinite(d2)) {
            return false;
        }
        double d3 = Math.exp(-(d2 -= this.northing) / this.R);
        double d4 = 1.5707963267948966 - 2.0 * Math.atan(d3);
        double d5 = Proj.util.adjustLon(this.clon + (d -= this.easting) / this.R);
        p2.set(d5 * 57.29577951308232, d4 * 57.29577951308232);
        return true;
    }

    public void setOffset(double d, double d2) {
        this.easting = d;
        this.northing = d2;
    }

    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double d, double d2) {
        return Double.isInfinite(d2);
    }

    public double[] getBoundingGeom() {
        return null;
    }

    public double[] getParallel(double d, double d2) {
        CoordArray coordArray = new CoordArray(1440);
        int n = 360;
        int n2 = 0;
        while (n >= -360) {
            coordArray.add(n, d);
            --n;
            ++n2;
        }
        return coordArray.getAll();
    }

    private void init() {
        this.easting = 0.0;
        this.northing = 0.0;
    }
}

