/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageRenderer;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.Legend;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.SVGMap;
import oracle.sdovis.ScaleBarRenderer;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeList;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.theme.MapCacheThemeProducer;
import oracle.sdovis.theme.PredGeomThemeProducer;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeProducer;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.RenderingUtils;

public class RenderingEngine {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    VectorRenderer vecRenderer = new VectorRenderer();
    ImageRenderer imgRenderer = new ImageRenderer();
    MapMaker mapper = null;
    boolean localthemesInLegend = false;

    public VectorRenderer getVectorRenderer() {
        return this.vecRenderer;
    }

    public ImageRenderer getImageRenderer() {
        return this.imgRenderer;
    }

    public void setMapper(MapMaker mapMaker) {
        this.mapper = mapMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D graphics2D, VisContext visContext) {
        Object object;
        Object object2;
        Cloneable cloneable;
        int n;
        this.prepareForRendering(visContext);
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        Color color = visContext.getBgColor();
        if (color != null) {
            if (visContext.getDeviceType() == 1) {
                graphics2D.setColor(color);
            } else if (visContext.getDeviceType() == 3) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setColor(color);
            }
            graphics2D.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()), (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()));
        } else if (visContext.isTileRequest()) {
            graphics2D.setBackground(new Color(1, 1, 1, 0));
            graphics2D.clearRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()), (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()));
        }
        Image image = visContext.getBgImage();
        if (image != null) {
            graphics2D.drawImage(image, 0, 0, (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()), (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()), null);
        }
        this.vecRenderer.prepare(visContext);
        double d = visContext.getCurrentScale();
        ThemeList themeList = visContext.getThemeList();
        int n2 = this.findLastCasedLineTheme(themeList, visContext);
        for (n = 0; n < themeList.size(); ++n) {
            Image image2;
            cloneable = themeList.getTheme(n);
            if (cloneable == null) continue;
            if ((cloneable instanceof ImageTheme || cloneable instanceof GeoRasterTheme || cloneable instanceof ShadedReliefTheme) && !visContext.getKeepThemesOrder()) {
                this.imgRenderer.render(graphics2D, (Theme)cloneable, visContext);
                continue;
            }
            if (cloneable instanceof WMSMapTheme && !visContext.getKeepThemesOrder() && ((WMSMapTheme)cloneable).getIsBackgroundImage()) {
                object2 = (WMSMapThemeProducer)((Theme)cloneable).getProducer();
                image2 = ((WMSMapThemeProducer)object2).getWMSMap();
                if (image2 == null) continue;
                this.renderWMSImage(image2, (Theme)cloneable, visContext, graphics2D);
                continue;
            }
            if (!(cloneable instanceof MapCacheTheme) || visContext.getKeepThemesOrder() || (image2 = ((MapCacheThemeProducer)(object2 = (MapCacheThemeProducer)((Theme)cloneable).getProducer())).getThemeImage()) == null) continue;
            if (visContext.getRotation() == 0.0) {
                int n3 = (int)visContext.getDeviceWindow().getWidth();
                int n4 = (int)visContext.getDeviceWindow().getHeight();
                float f = ((Theme)cloneable).getDecorator().getOpacity();
                if (f >= 0.0f && f < 1.0f) {
                    object = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    graphics2D.drawImage(image2, 0, 0, n3, n4, null);
                    graphics2D.setComposite((Composite)object);
                    continue;
                }
                graphics2D.drawImage(image2, 0, 0, n3, n4, null);
                continue;
            }
            ImageRenderer.renderImage(graphics2D, image2, ((MapCacheThemeProducer)object2).getDataMBR(), ((Theme)cloneable).getDecorator().getOpacity(), visContext);
        }
        if (!visContext.renderRasterOnly() || visContext.renderRasterBaseMapInSVG()) {
            int n5;
            for (n = 0; n < themeList.size(); ++n) {
                cloneable = themeList.getTheme(n);
                if (cloneable != null) {
                    if ((cloneable instanceof ImageTheme || cloneable instanceof GeoRasterTheme || cloneable instanceof ShadedReliefTheme) && visContext.getKeepThemesOrder()) {
                        this.imgRenderer.render(graphics2D, (Theme)cloneable, visContext);
                        continue;
                    }
                    if (cloneable instanceof WMSMapTheme && (visContext.getKeepThemesOrder() || !((WMSMapTheme)cloneable).getIsBackgroundImage())) {
                        object2 = (WMSMapThemeProducer)((Theme)cloneable).getProducer();
                        Image image3 = ((WMSMapThemeProducer)object2).getWMSMap();
                        if (image3 == null) continue;
                        this.renderWMSImage(image3, (Theme)cloneable, visContext, graphics2D);
                        continue;
                    }
                    if (cloneable instanceof MapCacheTheme && visContext.getKeepThemesOrder()) {
                        object2 = (MapCacheThemeProducer)((Theme)cloneable).getProducer();
                        Image image4 = ((MapCacheThemeProducer)object2).getThemeImage();
                        if (image4 == null) continue;
                        if (visContext.getRotation() == 0.0) {
                            int n6 = (int)visContext.getDeviceWindow().getWidth();
                            int n7 = (int)visContext.getDeviceWindow().getHeight();
                            float f = ((Theme)cloneable).getDecorator().getOpacity();
                            if (f >= 0.0f && f < 1.0f) {
                                object = graphics2D.getComposite();
                                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                                graphics2D.drawImage(image4, 0, 0, n6, n7, null);
                                graphics2D.setComposite((Composite)object);
                                continue;
                            }
                            graphics2D.drawImage(image4, 0, 0, n6, n7, null);
                            continue;
                        }
                        ImageRenderer.renderImage(graphics2D, image4, ((MapCacheThemeProducer)object2).getDataMBR(), ((Theme)cloneable).getDecorator().getOpacity(), visContext);
                        continue;
                    }
                    if (visContext.renderRasterOnly() && (!visContext.renderRasterBaseMapInSVG() || !((Theme)cloneable).getDecorator().isPartOfBaseMap())) continue;
                    object2 = visContext.getMapImage();
                    float f = ((Theme)cloneable).getDecorator().getOpacity();
                    if (f >= 0.0f && f < 1.0f) {
                        BufferedImage bufferedImage = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 2);
                        Graphics2D graphics2D2 = bufferedImage.createGraphics();
                        this.vecRenderer.render(graphics2D2, (Theme)cloneable, visContext);
                        graphics2D2.dispose();
                        Composite composite = graphics2D.getComposite();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                        graphics2D.setComposite(composite);
                        bufferedImage.flush();
                        bufferedImage = null;
                        continue;
                    }
                    this.vecRenderer.render(graphics2D, (Theme)cloneable, visContext);
                    if (n2 < 0 || n < n2) continue;
                    try {
                        if (visContext.getCasedLines().size() <= 0) continue;
                        visContext.getCasedLines().renderCasedLines(graphics2D, visContext);
                        continue;
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, "exception while rendering cased lines.", exception);
                        continue;
                    }
                    finally {
                        n2 = -1;
                    }
                }
                log.fine("theme is null or out of scale range.");
            }
            Vector<Object> vector = new Vector<Object>(themeList.size());
            for (int i = 0; i < themeList.size(); ++i) {
                object2 = themeList.getTheme(i);
                if (object2 instanceof ImageTheme || object2 instanceof GeoRasterTheme || object2 instanceof ShadedReliefTheme || object2 instanceof WMSMapTheme) continue;
                if (((Theme)object2).isTextLabelPresent()) {
                    vector.addElement(object2);
                    continue;
                }
                vector.insertElementAt(object2, 0);
            }
            cloneable = new Hashtable();
            for (n5 = 0; n5 < vector.size(); ++n5) {
                String string;
                Theme theme = (Theme)vector.elementAt(n5);
                if (!theme.getShowLabels() || !theme.getDecorator().withinScaleLimits(visContext.getCurrentScale()) || !(theme instanceof PredefinedGeometryTheme)) continue;
                PredefinedGeometryTheme predefinedGeometryTheme = (PredefinedGeometryTheme)theme;
                if (((PredGeomThemeProducer)theme.getProducer()).getBindingParameters() != null || ((Hashtable)cloneable).get(string = ((PredefinedGeometryTheme)theme).getDataSourceName() + "." + ((PredefinedGeometryTheme)theme).getName()) != null) continue;
                ((Hashtable)cloneable).put(string, theme);
            }
            for (n5 = vector.size() - 1; n5 >= 0; --n5) {
                Object object3;
                Theme theme;
                Theme theme2 = (Theme)vector.elementAt(n5);
                if (!theme2.getShowLabels() || theme2 instanceof PredefinedGeometryTheme && ((PredGeomThemeProducer)theme2.getProducer()).getBindingParameters() == null && (theme = (Theme)((Hashtable)cloneable).get(object3 = ((PredefinedGeometryTheme)theme2).getDataSourceName() + "." + ((PredefinedGeometryTheme)theme2).getName())) != null && theme != theme2 || theme2 == null || visContext.renderRasterOnly() && (!visContext.renderRasterBaseMapInSVG() || !theme2.getDecorator().isPartOfBaseMap())) continue;
                object3 = visContext.getMapImage();
                float f = theme2.getDecorator().getOpacity();
                if (f >= 0.0f && f < 1.0f) {
                    BufferedImage bufferedImage = new BufferedImage(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight(), 2);
                    object = bufferedImage.createGraphics();
                    this.vecRenderer.label((Graphics2D)object, theme2, visContext);
                    ((Graphics)object).dispose();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.setComposite(composite);
                    bufferedImage.flush();
                    bufferedImage = null;
                    continue;
                }
                this.vecRenderer.label(graphics2D, theme2, visContext);
            }
            if (!visContext.renderRasterBaseMapInSVG()) {
                this.renderMapTitle(graphics2D, visContext);
                this.renderMapFootNote(graphics2D, visContext);
                try {
                    this.renderMapLogo(graphics2D, visContext);
                    this.renderMapLengend(graphics2D, visContext);
                }
                catch (Exception exception) {
                    log.log(Level.SEVERE, "error rendering logo and/or legend.", exception);
                }
            }
        }
        this.renderScaleBar(graphics2D, visContext);
        this.renderNorthArrow(graphics2D, visContext);
        visContext.setLastMapScale(visContext.getCurrentScale());
        if (GlobalVisContext.showQueryWindow) {
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>(1);
            cloneable = new StyledFeature();
            cloneable.setShape(visContext.getQueryWindow());
            cloneable.setGeomType(2);
            cloneable.setFeatureStyle(new StyleColor(null, Color.green));
            arrayList.add(cloneable);
            LocalTheme localTheme = new LocalTheme("tmp_" + System.currentTimeMillis(), arrayList);
            this.vecRenderer.render(graphics2D, localTheme, visContext);
        }
    }

    private int findLastCasedLineTheme(ThemeList themeList, VisContext visContext) {
        int n = -1;
        block0: for (int i = 0; i < themeList.size(); ++i) {
            StyledFeatureI[] styledFeatureIArray;
            String[] stringArray;
            boolean bl;
            Theme theme = themeList.getTheme(i);
            if (theme instanceof ImageTheme || theme instanceof GeoRasterTheme || theme instanceof WMSMapTheme || theme instanceof MapCacheTheme || theme instanceof PredefinedGeometryTheme && !(bl = RenderingUtils.hasCasedLineStyle(stringArray = (styledFeatureIArray = (StyledFeatureI[])theme.getDefinition()).getRenderingStyles(), theme.getDataSourceName(), visContext)) || (styledFeatureIArray = theme.getProducer().getStyledFeatures()) == null) continue;
            for (int j = 0; j < styledFeatureIArray.length; ++j) {
                boolean bl2;
                Style style;
                StyledFeatureI styledFeatureI = styledFeatureIArray[j];
                if (styledFeatureI == null || (style = styledFeatureI.getFeatureStyle()) != null && !(style instanceof StyleLine)) continue;
                if (style == null && (style = visContext.resolveStyle(styledFeatureI.getFeatureStyleName(), theme.getDataSourceName())) != null && !(bl2 = style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles()))) {
                    log.warning("cannot resolve referenced styles for style " + style.getModel().getName());
                }
                if (style == null) continue;
                if (style instanceof StyleLine) {
                    if (styledFeatureI.getGeomType() != 2 && styledFeatureI.getGeomType() != 6 || !((StyleLine)style).supportCasedLine()) continue;
                    n = i;
                    continue block0;
                }
                if (!(style instanceof BucketStyle) || style instanceof ColorSchemeStyle || style instanceof VariableMarkerStyle || style instanceof VariablePieChartStyle || styledFeatureI.getGeomType() != 2 && styledFeatureI.getGeomType() != 6 || !((BucketStyle)style).hasCasedLineStyles()) continue;
                n = i;
                continue block0;
            }
        }
        return n;
    }

    private void prepareForRendering(VisContext visContext) {
        visContext.clearLiveFeatures();
        if (visContext.getCasedLines() != null) {
            visContext.getCasedLines().clear();
        }
        if (visContext.getProjection() != null) {
            visContext.setQueryWindow(this.applyProjection(visContext.getQueryWindow(), visContext.getDeviceWindow(), visContext.getProjection()));
        }
        visContext.getViewportTransform().setDataScaleOnX(1.0);
        XFViewPort xFViewPort = visContext.getViewportTransform();
        xFViewPort.setStrict(visContext.getBBox());
        xFViewPort.setDataView(visContext.getQueryWindow());
        xFViewPort.setDeviceView(visContext.getDeviceWindow());
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        visContext.setAffineXF(affineTransform);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        log.finest("xfm: " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderMapLengend(Graphics2D graphics2D, VisContext visContext) {
        Object object;
        int n;
        int n2;
        Legend legend;
        block8: {
            block9: {
                int n3;
                Rectangle2D rectangle2D;
                Rectangle2D rectangle2D2;
                block15: {
                    int n4;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        legend = this.prepareLegend(visContext);
                                        rectangle2D2 = visContext.getDeviceWindow();
                                        if (legend == null) {
                                            return;
                                        }
                                        rectangle2D = legend.computeMBR();
                                        n2 = -1;
                                        n = -1;
                                        n3 = legend.getOffsetX();
                                        n4 = legend.getOffsetY();
                                        if (legend.getLocation() != null) break block9;
                                        object = legend.getPositionHint();
                                        if (!"SOUTH_WEST".equals(object)) break block10;
                                        n2 = n3;
                                        n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                        break block8;
                                    }
                                    if (!"SOUTH_EAST".equals(object)) break block11;
                                    n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                                    n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                    break block8;
                                }
                                if (!"SOUTH".equals(object)) break block12;
                                n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                                n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                break block8;
                            }
                            if (!"NORTH".equals(object)) break block13;
                            n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                            n = n4;
                            break block8;
                        }
                        if (!"NORTH_EAST".equals(object)) break block14;
                        n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                        n = n4;
                        break block8;
                    }
                    if (!"NORTH_WEST".equals(object)) break block15;
                    n2 = n3;
                    n = n4;
                    break block8;
                }
                if ("CENTER".equals(object)) {
                    n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                    break block8;
                } else if ("EAST".equals(object)) {
                    n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                    break block8;
                } else {
                    if (!"WEST".equals(object)) {
                        log.severe("Invalid legend positioning hint!");
                        return;
                    }
                    n2 = n3;
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                }
                break block8;
            }
            n2 = (int)legend.getLocation().getX();
            n = (int)legend.getLocation().getY();
        }
        object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (visContext.getAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        legend.paint(graphics2D, n2, n);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderMapLengend(SVGMap sVGMap, VisContext visContext) {
        int n;
        int n2;
        Legend legend;
        block6: {
            block7: {
                String string;
                int n3;
                Rectangle2D rectangle2D;
                Rectangle2D rectangle2D2;
                block13: {
                    int n4;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        legend = this.prepareLegend(visContext);
                                        if (legend == null) {
                                            return;
                                        }
                                        rectangle2D2 = visContext.getDeviceWindow();
                                        rectangle2D = legend.computeMBR();
                                        n2 = -1;
                                        n = -1;
                                        n3 = legend.getOffsetX();
                                        n4 = legend.getOffsetY();
                                        if (legend.getLocation() != null) break block7;
                                        string = legend.getPositionHint();
                                        if (!"SOUTH_WEST".equals(string)) break block8;
                                        n2 = n3;
                                        n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                        break block6;
                                    }
                                    if (!"SOUTH_EAST".equals(string)) break block9;
                                    n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                                    n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                    break block6;
                                }
                                if (!"SOUTH".equals(string)) break block10;
                                n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                                n = (int)(rectangle2D2.getHeight() - rectangle2D.getHeight() - (double)n4);
                                break block6;
                            }
                            if (!"NORTH".equals(string)) break block11;
                            n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                            n = n4;
                            break block6;
                        }
                        if (!"NORTH_EAST".equals(string)) break block12;
                        n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                        n = n4;
                        break block6;
                    }
                    if (!"NORTH_WEST".equals(string)) break block13;
                    n2 = n3;
                    n = n4;
                    break block6;
                }
                if ("CENTER".equals(string)) {
                    n2 = (int)((rectangle2D2.getWidth() - rectangle2D.getWidth()) / 2.0);
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                    break block6;
                } else if ("EAST".equals(string)) {
                    n2 = (int)(rectangle2D2.getWidth() - rectangle2D.getWidth() - (double)n3);
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                    break block6;
                } else {
                    if (!"WEST".equals(string)) {
                        log.severe("Invalid legend positioning hint!");
                        return;
                    }
                    n2 = n3;
                    n = (int)((rectangle2D2.getHeight() - rectangle2D.getHeight()) / 2.0);
                }
                break block6;
            }
            n2 = (int)legend.getLocation().getX();
            n = (int)legend.getLocation().getY();
        }
        sVGMap.drawLegend(legend, n2, n);
    }

    public void renderMapLogo(Graphics2D graphics2D, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        if (visContext.renderSVGLayersOnly()) {
            return;
        }
        CustomLogo customLogo = GlobalVisContext.getLogo();
        if (customLogo == null) {
            return;
        }
        Image image = customLogo.getLogo();
        if (image == null) {
            return;
        }
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        int n = 2;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(null), image.getHeight(null));
        int n2 = -1;
        int n3 = -1;
        String string = customLogo.getPositionHint();
        if ("SOUTH_WEST".equals(string)) {
            n2 = n;
            n3 = (int)(rectangle2D.getHeight() - ((RectangularShape)float_).getHeight() - (double)n);
        } else if ("SOUTH_EAST".equals(string)) {
            n2 = (int)(rectangle2D.getWidth() - ((RectangularShape)float_).getWidth() - (double)n);
            n3 = (int)(rectangle2D.getHeight() - ((RectangularShape)float_).getHeight() - (double)n);
        } else if ("SOUTH".equals(string)) {
            n2 = (int)((rectangle2D.getWidth() - ((RectangularShape)float_).getWidth()) / 2.0);
            n3 = (int)(rectangle2D.getHeight() - ((RectangularShape)float_).getHeight() - (double)n);
        } else if ("NORTH".equals(string)) {
            n2 = (int)((rectangle2D.getWidth() - ((RectangularShape)float_).getWidth()) / 2.0);
            n3 = n;
        } else if ("NORTH_EAST".equals(string)) {
            n2 = (int)(rectangle2D.getWidth() - ((RectangularShape)float_).getWidth() - (double)n);
            n3 = n;
        } else if ("NORTH_WEST".equals(string)) {
            n2 = n;
            n3 = n;
        } else if ("CENTER".equals(string)) {
            n2 = (int)((rectangle2D.getWidth() - ((RectangularShape)float_).getWidth()) / 2.0);
            n3 = (int)((rectangle2D.getHeight() - ((RectangularShape)float_).getHeight()) / 2.0);
        } else if ("EAST".equals(string)) {
            n2 = (int)(rectangle2D.getWidth() - ((RectangularShape)float_).getWidth() - (double)n);
            n3 = (int)((rectangle2D.getHeight() - ((RectangularShape)float_).getHeight()) / 2.0);
        } else if ("WEST".equals(string)) {
            n2 = n;
            n3 = (int)((rectangle2D.getHeight() - ((RectangularShape)float_).getHeight()) / 2.0);
        } else {
            log.severe("Invalid map logo positioning hint!");
            return;
        }
        graphics2D.drawImage(image, n2, n3, null);
    }

    public void renderMapTitle(Graphics2D graphics2D, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        double[] dArray = this.prepareMapTitle(visContext);
        if (dArray == null) {
            return;
        }
        String string = visContext.getTitle();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapTitle();
        }
        StyleText styleText = visContext.getTitleStyle();
        try {
            styleText.apply(graphics2D, (float)dArray[0], (float)dArray[1], string, null);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public void renderMapTitle(SVGMap sVGMap, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        if (visContext.renderSVGLayersOnly()) {
            return;
        }
        double[] dArray = this.prepareMapTitle(visContext);
        if (dArray == null) {
            return;
        }
        String string = visContext.getTitle();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapTitle();
        }
        StyleText styleText = visContext.getTitleStyle();
        styleText.applyToCenter(sVGMap, (int)dArray[0], (int)dArray[1], string, null);
    }

    private double[] prepareMapTitle(VisContext visContext) {
        StyleText styleText;
        String string = visContext.getTitle();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapTitle();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (visContext.getTitleStyle() == null) {
            if (visContext.getTitleStyleName() != null) {
                try {
                    styleText = (StyleText)visContext.resolveStyle(visContext.getTitleStyleName());
                    visContext.setTitleStyle(styleText);
                }
                catch (Exception exception) {
                    log.severe(exception.getMessage());
                    visContext.setTitleStyle(new StyleText(new Font(GlobalVisContext.getGlobalMaptitleFont(), 1, 18), Color.blue));
                    ((TextStyleModel)visContext.getTitleStyle().getModel()).setHalo(3.2f, Color.white);
                }
            } else {
                visContext.setTitleStyle(new StyleText(new Font(GlobalVisContext.getGlobalMaptitleFont(), 1, 18), Color.blue));
                ((TextStyleModel)visContext.getTitleStyle().getModel()).setHalo(3.2f, Color.white);
            }
        }
        styleText = visContext.getTitleStyle();
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        if (styleText == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = styleText.getVisualBounds(string, null);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = rectangle2D2.getWidth();
        double d4 = rectangle2D2.getHeight();
        double d5 = rectangle2D.getWidth() * 0.04;
        double d6 = rectangle2D.getHeight() * 0.03;
        String string2 = visContext.getTitlePos();
        if (string2 == null) {
            string2 = GlobalVisContext.getGlobalMapTitlePos();
        }
        if ("NORTH".equals(string2)) {
            d = rectangle2D.getWidth() / 2.0;
            d2 = d4 / 2.0 + d6;
        } else if ("SOUTH".equals(string2)) {
            d = rectangle2D.getWidth() / 2.0;
            d2 = rectangle2D.getHeight() - d4 / 2.0 - d6;
        } else if ("WEST".equals(string2)) {
            d = d5 + d3 / 2.0;
            d2 = d4 / 2.0 + d6;
        } else if ("EAST".equals(string2)) {
            d = rectangle2D.getWidth() - d3 / 2.0 - d5;
            d2 = d4 / 2.0 + d6;
        } else {
            log.warning("invalid map title positioin; placing on NORTH");
            d = rectangle2D.getWidth() / 2.0;
            d2 = d4 / 2.0 + d6;
        }
        return new double[]{d, d2};
    }

    public void renderMapFootNote(Graphics2D graphics2D, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        double[] dArray = this.prepareMapFootNote(visContext);
        if (dArray == null) {
            return;
        }
        String string = visContext.getFootnote();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapFootnote();
        }
        StyleText styleText = visContext.getFootnoteStyle();
        try {
            styleText.apply(graphics2D, (float)dArray[0], (float)dArray[1], string, null);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
    }

    public void renderMapFootNote(SVGMap sVGMap, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        if (visContext.renderSVGLayersOnly()) {
            return;
        }
        double[] dArray = this.prepareMapFootNote(visContext);
        if (dArray == null) {
            return;
        }
        String string = visContext.getFootnote();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapFootnote();
        }
        StyleText styleText = visContext.getFootnoteStyle();
        styleText.applyToCenter(sVGMap, (int)dArray[0], (int)dArray[1], string, null);
    }

    private double[] prepareMapFootNote(VisContext visContext) {
        Cloneable cloneable;
        StyleText styleText;
        String string = visContext.getFootnote();
        if (string == null) {
            string = GlobalVisContext.getGlobalMapFootnote();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (visContext.getFootnoteStyle() == null) {
            if (visContext.getFootnoteStyleName() != null) {
                try {
                    styleText = (StyleText)visContext.resolveStyle(visContext.getFootnoteStyleName());
                    visContext.setFootnoteStyle(styleText);
                }
                catch (Exception exception) {
                    log.severe(exception.getMessage());
                    cloneable = new StyleText(new Font(GlobalVisContext.getGlobalMapFootnoteFont(), 0, 12), Color.black);
                    ((TextStyleModel)((StyleText)cloneable).getModel()).setHalo(2.5f, Color.white);
                    visContext.setFootnoteStyle((StyleText)cloneable);
                }
            } else {
                styleText = new StyleText(new Font(GlobalVisContext.getGlobalMapFootnoteFont(), 0, 12), Color.black);
                ((TextStyleModel)styleText.getModel()).setHalo(2.5f, Color.white);
                visContext.setFootnoteStyle(styleText);
            }
        }
        if ((styleText = visContext.getFootnoteStyle()) == null) {
            return null;
        }
        cloneable = visContext.getDeviceWindow();
        Rectangle2D rectangle2D = styleText.getVisualBounds(string, null);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = ((RectangularShape)cloneable).getWidth() * 0.01;
        double d6 = ((RectangularShape)cloneable).getHeight() * 0.0075;
        String string2 = visContext.getFootnotePos();
        if (string2 == null) {
            string2 = GlobalVisContext.getGlobalMapFootnotePos();
        }
        if ("NORTH".equals(string2)) {
            d = ((RectangularShape)cloneable).getWidth() / 2.0;
            d2 = d4 / 2.0 + d6;
        } else if ("SOUTH".equals(string2)) {
            d = ((RectangularShape)cloneable).getWidth() / 2.0;
            d2 = ((RectangularShape)cloneable).getHeight() - d4 / 2.0 - d6;
        } else if ("WEST".equals(string2) || "SOUTH_WEST".equals(string2)) {
            d = d5 + d3 / 2.0;
            d2 = ((RectangularShape)cloneable).getHeight() - d4 / 2.0 - d6;
        } else if ("EAST".equals(string2) || "SOUTH_EAST".equals(string2)) {
            d = ((RectangularShape)cloneable).getWidth() - d3 / 2.0 - d5;
            d2 = ((RectangularShape)cloneable).getHeight() - d4 / 2.0 - d6;
        } else if ("NORTH_EAST".equals(string2)) {
            d = ((RectangularShape)cloneable).getWidth() - d3 / 2.0 - d5;
            d2 = d4 / 2.0 + d6;
        } else if ("NORTH_WEST".equals(string2)) {
            d = d5 + d3 / 2.0;
            d2 = d4 / 2.0 + d6;
        } else {
            d = ((RectangularShape)cloneable).getWidth() / 2.0;
            d2 = ((RectangularShape)cloneable).getHeight() / 2.0;
        }
        return new double[]{d, d2};
    }

    public void renderScaleBar(SVGMap sVGMap, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        if (visContext.getSrs() == null) {
            log.warning("SRS is null. Scale bar not rendered.");
            return;
        }
        ScaleBar scaleBar = visContext.getScaleBar();
        if (scaleBar == null) {
            return;
        }
        ScaleBarRenderer scaleBarRenderer = new ScaleBarRenderer(scaleBar, visContext.getSrs(), visContext.getQueryWindow(), visContext.getDeviceWindow());
        scaleBarRenderer.renderScaleBar(sVGMap);
    }

    public void renderScaleBar(Graphics2D graphics2D, VisContext visContext) {
        if (visContext.isDisableMapPieces()) {
            return;
        }
        if (visContext.getSrs() == null) {
            log.warning("SRS is null. Scale bar not rendered.");
            return;
        }
        ScaleBar scaleBar = visContext.getScaleBar();
        if (scaleBar == null) {
            return;
        }
        ScaleBarRenderer scaleBarRenderer = new ScaleBarRenderer(scaleBar, visContext.getSrs(), visContext.getQueryWindow(), visContext.getDeviceWindow());
        scaleBarRenderer.renderScaleBar(graphics2D);
    }

    public void renderNorthArrow(Graphics2D graphics2D, VisContext visContext) {
        NorthArrow northArrow = visContext.getNorthArrow();
        if (northArrow == null) {
            return;
        }
        if (northArrow.getStyle() == null) {
            log.warning("North arrow must have a style defined. Not rendered.");
            return;
        }
        StyleMarker styleMarker = (StyleMarker)visContext.resolveStyle(northArrow.getStyle());
        if (styleMarker != null) {
            MarkerStyleModel markerStyleModel = (MarkerStyleModel)styleMarker.getModel();
            int n = markerStyleModel.getForcedWidth();
            int n2 = markerStyleModel.getForcedHeight();
            double d = markerStyleModel.getRotation();
            markerStyleModel.setForcedWidth(northArrow.getWidth());
            markerStyleModel.setForcedHeight(northArrow.getHeight());
            markerStyleModel.setRotation(-1.0 * visContext.getRotation() * Math.PI / 180.0);
            try {
                styleMarker.apply(visContext, graphics2D, (float)northArrow.getLocationX(), (float)northArrow.getLocationY(), null);
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
            }
            markerStyleModel.setForcedWidth(n);
            markerStyleModel.setForcedHeight(n2);
            markerStyleModel.setRotation(d);
        } else {
            log.warning("Unable to load north arrow style " + northArrow.getStyle() + ". Not rendered.");
        }
    }

    public void renderNorthArrow(SVGMap sVGMap, VisContext visContext) {
        NorthArrow northArrow = visContext.getNorthArrow();
        if (northArrow == null) {
            return;
        }
        if (northArrow.getStyle() == null) {
            log.warning("North arrow must have a style defined. Not rendered.");
            return;
        }
        StyleMarker styleMarker = (StyleMarker)visContext.resolveStyle(northArrow.getStyle());
        if (styleMarker != null) {
            MarkerStyleModel markerStyleModel = (MarkerStyleModel)styleMarker.getModel();
            int n = markerStyleModel.getForcedWidth();
            int n2 = markerStyleModel.getForcedHeight();
            double d = markerStyleModel.getRotation();
            markerStyleModel.setForcedWidth(northArrow.getWidth());
            markerStyleModel.setForcedHeight(northArrow.getHeight());
            markerStyleModel.setRotation(-1.0 * visContext.getRotation() * Math.PI / 180.0);
            try {
                styleMarker.apply(visContext, sVGMap, (float)northArrow.getLocationX(), (float)northArrow.getLocationY(), null);
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
            }
            markerStyleModel.setForcedWidth(n);
            markerStyleModel.setForcedHeight(n2);
            markerStyleModel.setRotation(d);
        } else {
            log.warning("Unable to load north arrow style " + northArrow.getStyle() + ". Not rendered.");
        }
    }

    public void renderSVG(Writer writer, VisContext visContext, boolean bl) throws IOException {
        Theme theme;
        int n;
        Object object;
        this.prepareForRendering(visContext);
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        this.vecRenderer.prepare(visContext);
        SVGMap sVGMap = new SVGMap((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), visContext, bl);
        Color color = visContext.getBgColor();
        if (color != null) {
            object = visContext.getDeviceType() == 1 ? color : (visContext.getDeviceType() == 3 ? Color.white : color);
            sVGMap.setBackGround((Color)object);
        }
        if (visContext.getTransparent() || visContext.getBgImageUrl() != null) {
            sVGMap.setBackGround(null);
        }
        if (visContext.getBgImageUrl() != null) {
            sVGMap.setBgImageUrl(visContext.getBgImageUrl());
        }
        object = visContext.getThemeList();
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < ((ThemeList)object).size(); ++i) {
            Theme theme2 = ((ThemeList)object).getTheme(i);
            if (theme2 == null) continue;
            if (!(theme2 instanceof ImageTheme || theme2 instanceof GeoRasterTheme || theme2 instanceof WMSMapTheme || visContext.renderRasterBaseMapInSVG() && theme2.getDecorator().isPartOfBaseMap())) {
                this.vecRenderer.renderThemeIntoSVG(sVGMap, theme2, visContext);
                continue;
            }
            if (visContext.renderRasterBaseMapInSVG() && theme2.getDecorator().isPartOfBaseMap()) {
                if (bl2) continue;
                bl2 = true;
                sVGMap.addTheme(visContext.rasterThemeNames[0], visContext.rasterImageNames[0], true);
                ++n2;
                continue;
            }
            if (!(theme2 instanceof ImageTheme) && !(theme2 instanceof GeoRasterTheme) && !(theme2 instanceof WMSMapTheme)) continue;
            sVGMap.addTheme(visContext.rasterThemeNames[n2], visContext.rasterImageNames[n2], theme2.getDecorator().isVisibleInSVG());
            ++n2;
        }
        Vector<Theme> vector = new Vector<Theme>(((ThemeList)object).size());
        for (n = 0; n < ((ThemeList)object).size(); ++n) {
            theme = ((ThemeList)object).getTheme(n);
            if (theme instanceof ImageTheme || theme instanceof GeoRasterTheme || theme instanceof WMSMapTheme) continue;
            if (theme.isTextLabelPresent()) {
                vector.addElement(theme);
                continue;
            }
            vector.insertElementAt(theme, 0);
        }
        for (n = 0; n < vector.size(); ++n) {
            theme = (Theme)vector.elementAt(n);
            if (!theme.getShowLabels() || theme == null || visContext.renderRasterBaseMapInSVG() && theme.getDecorator().isPartOfBaseMap()) continue;
            this.vecRenderer.label(sVGMap, theme, visContext);
        }
        this.renderMapTitle(sVGMap, visContext);
        this.renderMapFootNote(sVGMap, visContext);
        this.renderScaleBar(sVGMap, visContext);
        try {
            this.renderMapLengend(sVGMap, visContext);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.renderNorthArrow(sVGMap, visContext);
        sVGMap.output(writer);
    }

    private Rectangle2D applyProjection(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Proj proj) {
        return proj.getBoundingBox(rectangle2D, rectangle2D2);
    }

    public static void setShowQW(boolean bl) {
        GlobalVisContext.showQueryWindow = bl;
    }

    private void renderWMSImage(Image image, Theme theme, VisContext visContext, Graphics2D graphics2D) {
        if (image == null || theme == null) {
            return;
        }
        WMSMapThemeProducer wMSMapThemeProducer = (WMSMapThemeProducer)theme.getProducer();
        WMSMapThemeDefinition wMSMapThemeDefinition = (WMSMapThemeDefinition)theme.getDefinition();
        Image image2 = null;
        if ((wMSMapThemeDefinition.getFormat() == null || wMSMapThemeDefinition.getFormat().equalsIgnoreCase("image/png")) && wMSMapThemeDefinition.isTransparent()) {
            Color color = StyleUtils.getColor(wMSMapThemeDefinition.getBgColor());
            if (color == null) {
                color = new Color(255, 255, 255);
            }
            ImageFilter imageFilter = new ImageFilter();
            imageFilter.setTransparentColor(color.getRed(), color.getGreen(), color.getBlue());
            image2 = imageFilter.getFilteredImage(image);
            if (image2 != null && !ImageUtils.waitForImage(image2)) {
                log.warning("Unable to get filtered image for WMS png format.");
                image2.flush();
                image2 = null;
            } else {
                log.info("Transparent pixels of WMS png image have been filtered.");
            }
        }
        if (visContext.getRotation() == 0.0) {
            int n = (int)visContext.getDeviceWindow().getWidth();
            int n2 = (int)visContext.getDeviceWindow().getHeight();
            float f = theme.getDecorator().getOpacity();
            if (f >= 0.0f && f < 1.0f) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                if (image2 == null) {
                    graphics2D.drawImage(image, 0, 0, n, n2, null);
                } else {
                    graphics2D.drawImage(image2, 0, 0, n, n2, null);
                }
                graphics2D.setComposite(composite);
            } else if (image2 == null) {
                graphics2D.drawImage(image, 0, 0, n, n2, null);
            } else {
                graphics2D.drawImage(image2, 0, 0, n, n2, null);
            }
        } else if (image2 == null) {
            ImageRenderer.renderImage(graphics2D, image, wMSMapThemeProducer.getDataMBR(), theme.getDecorator().getOpacity(), visContext);
        } else {
            ImageRenderer.renderImage(graphics2D, image2, wMSMapThemeProducer.getDataMBR(), theme.getDecorator().getOpacity(), visContext);
        }
        if (image2 != null) {
            ImageUtils.removeImageFromTracker(image2);
            image2.flush();
            image2 = null;
        }
    }

    public Legend prepareLegend(VisContext visContext) {
        if (visContext == null) {
            return null;
        }
        Legend legend = visContext.getLegend();
        if (legend == null) {
            return null;
        }
        if (this.mapper == null || legend.getNumColumns() > 0) {
            return legend;
        }
        String[] stringArray = this.mapper.getRenderedThemes(this.localthemesInLegend);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<ThemeDefinition> arrayList = new ArrayList<ThemeDefinition>();
        for (int i = 0; i < stringArray.length; ++i) {
            Theme theme = null;
            ThemeDefinition themeDefinition = null;
            if (visContext.getThemeList() != null) {
                for (int j = 0; j < visContext.getThemeList().size(); ++j) {
                    Theme theme2 = visContext.getThemeList().getTheme(j);
                    if (!theme2.getName().equalsIgnoreCase(stringArray[i])) continue;
                    theme = theme2;
                    themeDefinition = theme.getDefinition();
                    break;
                }
            }
            if (themeDefinition == null) continue;
            arrayList.add(themeDefinition);
        }
        if (arrayList.size() > 0) {
            ThemeDefinition[] themeDefinitionArray = new ThemeDefinition[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                themeDefinitionArray[i] = (ThemeDefinition)arrayList.get(i);
            }
            legend.prepare(themeDefinitionArray, visContext);
            return legend;
        }
        return null;
    }

    public void useLocalThemesInAutomaticLegend(boolean bl) {
        this.localthemesInLegend = bl;
    }

    public boolean useLocalThemesInAutomaticLegend() {
        return this.localthemesInLegend;
    }

    public class ImageFilter {
        private ResImageFilter m_imageFilter = new ResImageFilter();

        public void setTransparentColor(int n, int n2, int n3) {
            this.m_imageFilter.setTransparentColor(n, n2, n3);
        }

        public Image getFilteredImage(Image image) {
            if (image == null) {
                return null;
            }
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this.m_imageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }

        public class ResImageFilter
        extends RGBImageFilter {
            private int m_rgbMaskColor = 0;

            public void setTransparentColor(int n, int n2, int n3) {
                this.m_rgbMaskColor = new Color(n, n2, n3).getRGB();
            }

            public int filterRGB(int n, int n2, int n3) {
                if (n3 == this.m_rgbMaskColor) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        }
    }
}

