/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.ClassPathUpdate;

public class SDataProviderMgr {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static Hashtable<String, SDataProviderDescriptor> providers = new Hashtable(7);

    public static boolean registerProvider(String string, String string2, String string3, Properties properties) {
        if (string == null || string2 == null) {
            return false;
        }
        if (providers.get(string) != null) {
            log.warning("Spatial Provider " + string + " is already registered.");
            return true;
        }
        if (string3 != null) {
            try {
                ClassPathUpdate.addFile(string3);
            }
            catch (Exception exception) {
                log.severe("Unable to register spatial provider " + string);
                return false;
            }
        }
        SDataProviderDescriptor sDataProviderDescriptor = new SDataProviderDescriptor();
        sDataProviderDescriptor.initProperties = properties;
        sDataProviderDescriptor.className = string2;
        sDataProviderDescriptor.jarFile = string3;
        providers.put(string, sDataProviderDescriptor);
        SDataProvider sDataProvider = SDataProviderMgr.getProviderInstance(string);
        if (sDataProvider == null) {
            log.severe("Unable to get an instance for spatial provider " + string);
            providers.remove(string);
            log.warning("Spatial Provider " + string + " has not been registered.");
            return false;
        }
        sDataProviderDescriptor.sProvider = sDataProvider;
        log.info("Spatial Provider " + string + " has been registered.");
        return true;
    }

    public static void removeProvider(String string) {
        if (string == null) {
            return;
        }
        providers.remove(string);
    }

    public static void removeAll() {
        providers.clear();
    }

    public static String getProviderClassName(String string) {
        if (string == null) {
            return null;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null) {
            return null;
        }
        return sDataProviderDescriptor.className;
    }

    public static String getProviderJarFile(String string) {
        if (string == null) {
            return null;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null) {
            return null;
        }
        return sDataProviderDescriptor.jarFile;
    }

    public static String[] getProviderInitParameterNames(String string) {
        if (string == null) {
            return null;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null || sDataProviderDescriptor.sProvider == null) {
            return null;
        }
        return sDataProviderDescriptor.sProvider.getInitParameterNames();
    }

    public static String[] getProviderRuntimeParameterNames(String string) {
        if (string == null) {
            return null;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null || sDataProviderDescriptor.sProvider == null) {
            return null;
        }
        return sDataProviderDescriptor.sProvider.getRuntimeParameterNames();
    }

    public static String[] getProvidersID() {
        if (providers.size() == 0) {
            return null;
        }
        int n = 0;
        String[] stringArray = new String[providers.size()];
        Enumeration<String> enumeration = providers.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static SDataProvider getProviderInstance(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SDataProviderMgr.getProviderClassName(string);
        if (string2 == null) {
            log.warning("Unable to find data provider class for provider " + string);
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            SDataProvider sDataProvider = (SDataProvider)clazz.newInstance();
            SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
            if (sDataProviderDescriptor == null) {
                sDataProvider.init(null);
            } else {
                sDataProvider.init(sDataProviderDescriptor.initProperties);
            }
            return sDataProvider;
        }
        catch (Exception exception) {
            log.warning("Unable to get data provider instance for class " + string2);
            return null;
        }
    }

    public static boolean setProviderInitProperties(String string, Properties properties) {
        if (string == null) {
            return false;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null) {
            return false;
        }
        sDataProviderDescriptor.initProperties = properties;
        return true;
    }

    public static Properties getProviderInitProperties(String string) {
        if (string == null) {
            return null;
        }
        SDataProviderDescriptor sDataProviderDescriptor = providers.get(string);
        if (sDataProviderDescriptor == null) {
            return null;
        }
        return sDataProviderDescriptor.initProperties;
    }

    private static class SDataProviderDescriptor {
        public SDataProvider sProvider = null;
        public Properties initProperties = null;
        public String className = null;
        public String jarFile = null;

        SDataProviderDescriptor() {
        }
    }
}

