/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.ProjAzEd;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.Spheroid;
import oracle.sdovis.VisContext;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class SRS {
    public static final int UNDEFINED_CS = 0;
    public static final int GEODETIC_CS = 1;
    public static final int PROJECTED_CS = 2;
    public static final int LOCAL_CS = 3;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mDataSource = null;
    private int srid = 0;
    private String unit = null;
    private double conversionFactor = 1.0;
    private Spheroid spheroid = null;
    private int csType = 0;
    public static Hashtable distUnitList = new Hashtable(79);
    public static Hashtable angularUnitList = new Hashtable(17);
    static int dpi = 96;

    public SRS() {
    }

    public SRS(String string) {
        this.mDataSource = string;
    }

    public void set(int n, String string, double d, int n2, Spheroid spheroid) {
        this.srid = n;
        this.unit = string;
        this.conversionFactor = d;
        this.csType = n2;
        this.spheroid = spheroid;
    }

    public boolean isGeodetic() {
        return this.csType == 1;
    }

    public int getCoordSysType() {
        return this.csType;
    }

    public int getSRID() {
        return this.srid;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public Rectangle2D getOptimalQueryWindow(double d, double d2, double d3, Rectangle2D rectangle2D, VisContext visContext) {
        d3 = Math.abs(d3);
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit) && MapMaker.getUGP()) {
            return this.getQW4GP(d, d2, d3, rectangle2D, visContext);
        }
        double d4 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d5 = d3;
        double d6 = d4 * d3;
        log.finest("*** isGeodetic=" + this.isGeodetic() + ", unit=" + this.unit);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d - d6 / 2.0, d2 - d5 / 2.0, d6, d5);
        boolean bl = false;
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit)) {
            double d7 = double_.getMinX();
            double d8 = double_.getMinY();
            double d9 = double_.getMaxX();
            double d10 = double_.getMaxY();
            log.finest("before adjusting: minX = " + d7 + ", maxX=" + d9 + " minY=" + d8 + ", maxY=" + d10 + "  w=" + d6 + ", h=" + d5);
            if (d6 >= 360.0) {
                double d11;
                double d12 = d11 = 180.0 - Math.abs(d) >= Math.abs(d) ? 0.0 : 180.0;
                if (d11 == 0.0) {
                    d7 = -180.0;
                    d9 = 180.0;
                } else {
                    d7 = 0.0;
                    d9 = 360.0;
                }
                bl = true;
            }
            if (d8 < -90.0) {
                d8 = -90.0;
                bl = true;
            }
            if (d10 > 90.0) {
                d10 = 90.0;
                bl = true;
            }
            log.finest("After adjusting: minX = " + d7 + ", maxX=" + d9 + " minY=" + d8 + ", maxY=" + d10 + "  w=" + d6 + ", h=" + d5);
            if (bl) {
                log.warning("Resizing query window to be within valid bounds.");
                double_ = new Rectangle2D.Double(d7, d8, d9 - d7, d10 - d8);
            }
        }
        return double_;
    }

    public Rectangle2D getOptimalQueryWindow(double d, double d2, double d3, double d4, Rectangle2D rectangle2D, VisContext visContext) {
        if (this.isGeodetic() && "DECIMAL DEGREE".equals(this.unit) && GlobalVisContext.getUgp()) {
            double d5 = d + (d3 - d) / 2.0;
            double d6 = d2 + (d4 - d2) / 2.0;
            double d7 = Math.abs(d4 - d2);
            return this.getQW4GP(d5, d6, d7, rectangle2D, visContext);
        }
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    private Rectangle2D getQW4GP(double d, double d2, double d3, Rectangle2D rectangle2D, VisContext visContext) {
        d3 = Math.abs(d3);
        Rectangle2D rectangle2D2 = null;
        Proj[] projArray = new Proj[1];
        rectangle2D2 = ProjAzEd.getQueryWindow(d, d2, d3, rectangle2D, projArray);
        visContext.setProjection(projArray[0]);
        return rectangle2D2;
    }

    public Spheroid getSpheroid() {
        return this.spheroid;
    }

    public double getRatioScale(double d, Point2D point2D) {
        Double d2 = SRS.getDistanceConversionFactor(this.unit);
        boolean bl = this.isGeodetic();
        double d3 = 0.0;
        if (d2 == null && !bl) {
            return -1.0;
        }
        double d4 = -1.0;
        if (bl) {
            if (this.spheroid == null) {
                return -1.0;
            }
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            if (point2D == null) {
                dArray[0] = 0.0;
                dArray2[0] = dArray[0];
                dArray[1] = 0.0;
                dArray2[1] = Math.PI / 180;
            } else {
                dArray[0] = point2D.getX() * (Math.PI / 180);
                dArray2[0] = dArray[0];
                dArray[1] = point2D.getY() * (Math.PI / 180);
                dArray2[1] = (point2D.getY() + 1.0) * (Math.PI / 180);
            }
            d4 = Util.dist(dArray, dArray2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
            d3 = 1.0 / d4;
        } else {
            d3 = 1.0 / d2;
        }
        double d5 = 0.0254;
        Double d6 = SRS.getDistanceConversionFactor("INCH");
        if (d6 != null) {
            d5 = d6;
        }
        return d / (double)SRS.getDPI() / ((d5 /= (double)SRS.getDPI()) * d3);
    }

    public double getScreenInchScale(double d, Point2D point2D) {
        Double d2 = SRS.getDistanceConversionFactor(this.unit);
        boolean bl = this.isGeodetic();
        double d3 = 0.0;
        if (d2 == null && !bl) {
            return -1.0;
        }
        double d4 = -1.0;
        if (bl) {
            if (this.spheroid == null) {
                return -1.0;
            }
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            if (point2D == null) {
                dArray[0] = 0.0;
                dArray2[0] = dArray[0];
                dArray[1] = 0.0;
                dArray2[1] = Math.PI / 180;
            } else {
                dArray[0] = point2D.getX() * (Math.PI / 180);
                dArray2[0] = dArray[0];
                dArray[1] = point2D.getY() * (Math.PI / 180);
                dArray2[1] = (point2D.getY() + 1.0) * (Math.PI / 180);
            }
            d4 = Util.dist(dArray, dArray2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
            d3 = 1.0 / d4;
        } else {
            d3 = 1.0 / d2;
        }
        double d5 = 0.0254;
        Double d6 = SRS.getDistanceConversionFactor("INCH");
        if (d6 != null) {
            d5 = d6;
        }
        return d * (d5 /= (double)SRS.getDPI()) * d3 * (double)SRS.getDPI();
    }

    public JSDOGeometry shift(JSDOGeometry jSDOGeometry, Rectangle2D rectangle2D) {
        JSDOGeometry jSDOGeometry2;
        if (!this.isGeodetic()) {
            jSDOGeometry2 = jSDOGeometry;
        } else {
            boolean bl = SRS.isMBRSmall(jSDOGeometry);
            boolean bl2 = SRS.isMBRInWindow(jSDOGeometry, rectangle2D);
            jSDOGeometry2 = bl && bl2 ? jSDOGeometry : (jSDOGeometry.isPoint() ? (jSDOGeometry.isOrientedPoint() ? this.shiftOrientedPoint(jSDOGeometry, rectangle2D) : this.shiftSinglePoint(jSDOGeometry, rectangle2D)) : (jSDOGeometry.isMultiPoint() ? (jSDOGeometry.isOrientedMultiPoint() ? this.shiftOrientedPoint(jSDOGeometry, rectangle2D) : this.shiftMultiPoint(jSDOGeometry, rectangle2D)) : this.shiftRegularGeometry(jSDOGeometry, rectangle2D)));
        }
        return jSDOGeometry2;
    }

    private JSDOGeometry shiftSinglePoint(JSDOGeometry jSDOGeometry, Rectangle2D rectangle2D) {
        double[] dArray = jSDOGeometry.getPoint();
        if (dArray == null) {
            return null;
        }
        double d = SRS.shiftPoint(dArray[0], rectangle2D.getMinX(), rectangle2D.getMaxX());
        JSDOGeometry jSDOGeometry2 = null;
        jSDOGeometry2 = dArray.length > 2 && !Double.isNaN(dArray[2]) ? new JSDOGeometry(d, dArray[1], dArray[2], this.srid) : new JSDOGeometry(d, dArray[1], this.srid);
        return jSDOGeometry2;
    }

    private JSDOGeometry shiftMultiPoint(JSDOGeometry jSDOGeometry, Rectangle2D rectangle2D) {
        int n = jSDOGeometry.getDimensions();
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        if (dArray == null) {
            return null;
        }
        int[] nArray = jSDOGeometry.getElemInfo();
        boolean bl = nArray.length == 3;
        int n2 = 0;
        n2 = bl ? nArray[2] : nArray.length / 3;
        if (n2 < 1) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        double[] dArray2 = new double[dArray.length];
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            dArray2[n3] = SRS.shiftPoint(dArray[n3], d, d2);
            for (int j = 1; j < n; ++j) {
                dArray2[n3 + j] = dArray[n3 + j];
            }
        }
        JSDOGeometry jSDOGeometry2 = this.copyJGeometry(jSDOGeometry, nArray2, dArray2);
        return jSDOGeometry2;
    }

    private JSDOGeometry shiftOrientedPoint(JSDOGeometry jSDOGeometry, Rectangle2D rectangle2D) {
        int n = jSDOGeometry.getDimensions();
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        if (dArray == null) {
            return null;
        }
        int[] nArray = jSDOGeometry.getElemInfo();
        int n2 = nArray.length / 6;
        if (n2 < 1) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        double[] dArray2 = new double[dArray.length];
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        for (int i = 0; i < n2; ++i) {
            int n3 = i * (n + 2);
            dArray2[n3] = SRS.shiftPoint(dArray[n3], d, d2);
            for (int j = 1; j < n + 2; ++j) {
                dArray2[n3 + j] = dArray[n3 + j];
            }
        }
        JSDOGeometry jSDOGeometry2 = this.copyJGeometry(jSDOGeometry, nArray2, dArray2);
        return jSDOGeometry2;
    }

    private JSDOGeometry shiftRegularGeometry(JSDOGeometry jSDOGeometry, Rectangle2D rectangle2D) {
        int n;
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        if (dArray == null) {
            return null;
        }
        boolean bl = SRS.isMBRSmall(jSDOGeometry);
        int n2 = jSDOGeometry.getDimensions();
        int[] nArray = jSDOGeometry.getElemInfo();
        boolean bl2 = nArray.length > 3;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        ArrayList arrayList = new ArrayList(dArray.length);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(nArray.length);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        int n5 = 0;
        if (bl2 && nArray[3] - nArray[0] == 0) {
            arrayList2.add(new Integer(nArray[0]));
            arrayList2.add(new Integer(nArray[1]));
            arrayList2.add(new Integer(nArray[2]));
            n5 = 3;
        }
        for (n = n5; n < nArray.length; n += 3) {
            int n6;
            n3 = nArray[n] - 1;
            int n7 = nArray[n + 1];
            int n8 = nArray[n + 2];
            n4 = n + 3 < nArray.length ? nArray[n + 3] - nArray[n] : dArray.length - nArray[n] + 1;
            arrayList3.clear();
            if (n7 % 100 == 1 || bl) {
                for (n6 = n3; n6 < n3 + n4; ++n6) {
                    arrayList3.add(new Double(dArray[n6]));
                }
            } else if (n7 % 100 == 3 && n8 == 3) {
                this.prepareRectangle(arrayList3, n2, dArray, n3);
            } else {
                this.prepareOtherShape(arrayList3, n2, dArray, n3, n4);
            }
            n6 = this.computeShiftDirection(arrayList3, n2, rectangle2D.getMinX(), rectangle2D.getMaxX());
            if (n6 == 1 || n6 == 4 || n6 == 5) {
                this.addElement(arrayList2, arrayList, arrayList3, n2, n7, n8, 0.0);
            }
            if (n6 == 2 || n6 == 4) {
                this.addElement(arrayList2, arrayList, arrayList3, n2, n7, n8, -360.0);
            }
            if (n6 == 3 || n6 == 5) {
                this.addElement(arrayList2, arrayList, arrayList3, n2, n7, n8, 360.0);
            }
            bl3 = n6 == 4 || n6 == 5;
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        double[] dArray2 = new double[arrayList.size()];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = (Double)arrayList.get(n);
        }
        int[] nArray2 = new int[arrayList2.size()];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (Integer)arrayList2.get(n);
        }
        JSDOGeometry jSDOGeometry2 = this.copyJGeometry(jSDOGeometry, nArray2, dArray2);
        return jSDOGeometry2;
    }

    private JSDOGeometry copyJGeometry(JSDOGeometry jSDOGeometry, int[] nArray, double[] dArray) {
        int n = jSDOGeometry.getDimensions();
        int n2 = jSDOGeometry.getType();
        n2 += n * 1000;
        if (jSDOGeometry.isLRSGeometry()) {
            n2 += n * 100;
        }
        JSDOGeometry jSDOGeometry2 = new JSDOGeometry(n2, jSDOGeometry.getSRID(), nArray, dArray);
        return jSDOGeometry2;
    }

    private void prepareOtherShape(ArrayList arrayList, int n, double[] dArray, int n2, int n3) {
        boolean bl = false;
        boolean[] blArray = new boolean[n3 / n];
        boolean bl2 = false;
        blArray[0] = true;
        arrayList.clear();
        int n4 = 1;
        int n5 = n2 + n;
        while (n4 < blArray.length) {
            double d = Math.abs(dArray[n5] - dArray[n5 - n]);
            if (d > 180.0) {
                boolean bl3 = blArray[n4] = !blArray[n4 - 1];
                if (!bl) {
                    bl2 = !(dArray[n5] > dArray[n5 - n]);
                }
                bl = true;
            } else {
                blArray[n4] = blArray[n4 - 1];
            }
            n5 = n2 + n * ++n4;
        }
        if (!bl) {
            for (n4 = n2; n4 < n2 + n3; ++n4) {
                arrayList.add(new Double(dArray[n4]));
            }
        } else {
            for (n4 = 0; n4 < blArray.length; ++n4) {
                double d = dArray[n2 + n4 * n];
                if (blArray[n4] != blArray[0]) {
                    if (bl2) {
                        arrayList.add(new Double(d + 360.0));
                    } else {
                        arrayList.add(new Double(d - 360.0));
                    }
                } else {
                    arrayList.add(new Double(d));
                }
                for (n5 = 1; n5 < n; ++n5) {
                    arrayList.add(new Double(dArray[n2 + n4 * n + n5]));
                }
            }
        }
    }

    private static boolean isMBRSmall(JGeometry jGeometry) {
        double[] dArray = jGeometry.getMBR();
        if (dArray == null) {
            return true;
        }
        return dArray[dArray.length / 2] - dArray[0] < 180.0;
    }

    private static boolean isMBRInWindow(JGeometry jGeometry, Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4 = rectangle2D.getMinX();
        if (Util.isFullExtent(d4, d3 = rectangle2D.getMaxX(), d2 = rectangle2D.getMinY(), d = rectangle2D.getMaxY())) {
            return true;
        }
        double[] dArray = jGeometry.getMBR();
        if (dArray == null) {
            return true;
        }
        return dArray[0] >= d4 && dArray[dArray.length / 2] <= d3;
    }

    private void prepareRectangle(ArrayList arrayList, int n, double[] dArray, int n2) {
        int n3;
        double d = dArray[n2 + n];
        double d2 = dArray[n2];
        if (d < d2) {
            d += 360.0;
        }
        arrayList.add(new Double(d2));
        for (n3 = 1; n3 < n; ++n3) {
            arrayList.add(new Double(dArray[n2 + n3]));
        }
        arrayList.add(new Double(d));
        for (n3 = 1; n3 < n; ++n3) {
            arrayList.add(new Double(dArray[n2 + n + n3]));
        }
    }

    private void addElement(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, int n3, double d) {
        arrayList.add(new Integer(arrayList2.size() + 1));
        arrayList.add(new Integer(n2));
        arrayList.add(new Integer(n3));
        for (int i = 0; i < arrayList3.size(); i += n) {
            double d2 = (Double)arrayList3.get(i);
            arrayList2.add(new Double(d2 + d));
            for (int j = 1; j < n; ++j) {
                arrayList2.add(arrayList3.get(i + j));
            }
        }
    }

    private int computeShiftDirection(ArrayList arrayList, int n, double d, double d2) {
        double d3;
        if (arrayList.size() < 1) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        double d4 = d3 = ((Double)arrayList.get(0)).doubleValue();
        for (int i = n; i < arrayList.size(); i += n) {
            double d5 = (Double)arrayList.get(i);
            if (d5 < d4) {
                d4 = d5;
            }
            if (!(d5 > d3)) continue;
            d3 = d5;
        }
        bl3 = !(d4 > d2) && !(d3 < d);
        bl = !(d4 - 360.0 > d2) && !(d3 - 360.0 < d);
        boolean bl4 = bl2 = !(d4 + 360.0 > d2) && !(d3 + 360.0 < d);
        if (!(bl3 || bl || bl2)) {
            return 0;
        }
        if (bl3 && !bl && !bl2) {
            return 1;
        }
        if (!bl3 && bl && !bl2) {
            return 2;
        }
        if (!bl3 && !bl && bl2) {
            return 3;
        }
        if (bl3 && bl && !bl2) {
            return 4;
        }
        if (bl3 && !bl && bl2) {
            return 5;
        }
        return 1;
    }

    private static double shiftPoint(double d, double d2, double d3) {
        double d4;
        for (d4 = d; d4 < d2; d4 += 360.0) {
        }
        while (d4 > d3) {
            d4 -= 360.0;
        }
        if (d4 >= d2 && d4 <= d3) {
            return d4;
        }
        return d;
    }

    public static final JSDOGeometry proj(JSDOGeometry jSDOGeometry, Proj proj, int n) {
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        Proj.P2 p2 = new Proj.P2();
        if (dArray != null) {
            double[] dArray2 = new double[dArray.length];
            int n2 = jSDOGeometry.getDimensions();
            for (int i = 0; i < dArray.length; i += n2) {
                double d = dArray[i];
                double d2 = dArray[i + 1];
                boolean bl = proj.forward(d, d2, p2);
                dArray2[i] = p2.x;
                dArray2[i + 1] = p2.y;
            }
            return new JSDOGeometry(jSDOGeometry.getType(), n, jSDOGeometry.getElemInfo(), dArray2);
        }
        dArray = jSDOGeometry.getPoint();
        if (dArray == null) {
            log.severe("Invalid input geometry in proj().");
            return null;
        }
        proj.forward(dArray[0], dArray[1], p2);
        if (dArray.length > 2 && !Double.isNaN(dArray[2])) {
            return new JSDOGeometry(p2.x, p2.y, dArray[2], n);
        }
        return new JSDOGeometry(p2.x, p2.y, n);
    }

    public static int getDPI() {
        return dpi;
    }

    public static Double getDistanceConversionFactor(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        return (Double)distUnitList.get(string);
    }

    public static Hashtable getDistanceUnitList() {
        return distUnitList;
    }

    public static Hashtable getAngularUnitList() {
        return angularUnitList;
    }

    public static SRS getSRS(int n, String string) {
        if (n <= 0) {
            return null;
        }
        if (string == null || string.length() == 0) {
            if (n == 999999) {
                SRS sRS = new SRS();
                sRS.set(n, null, 1.0, 0, null);
                return sRS;
            }
            return null;
        }
        SRS sRS = new SRS(null);
        int n2 = 0;
        String string2 = string.toUpperCase();
        if (string2.indexOf("PROJCS") >= 0) {
            n2 = 2;
        } else if (string2.indexOf("GEOGCS") >= 0) {
            n2 = 1;
        } else if (string2.indexOf("LOCAL_CS") >= 0) {
            n2 = 3;
        }
        Spheroid spheroid = Spheroid.getSpheroid(string2);
        int n3 = string2.lastIndexOf("UNIT");
        int n4 = 0;
        if (n3 < 0) {
            log.severe("cannot find UNIT parameter in wkt.");
            return null;
        }
        double d = 0.0;
        String string3 = null;
        try {
            while (string2.charAt(n3) != '[') {
                ++n3;
            }
            while (string2.charAt(n3) != '\"') {
                ++n3;
            }
            n4 = ++n3;
            while (string2.charAt(n4) != '\"') {
                ++n4;
            }
            string3 = string2.substring(n3, n4);
            if (string3 == null || string3.length() == 0) {
                log.severe("no unit name.");
                return null;
            }
            n3 = n4;
            while (string2.charAt(n3) != ',') {
                ++n3;
            }
            n4 = ++n3;
            while (string2.charAt(n4) != ']') {
                ++n4;
            }
            try {
                d = Double.valueOf(string2.substring(n3, n4));
            }
            catch (Exception exception) {
                log.severe("cannot parse unit conversion factor.");
                return null;
            }
        }
        catch (Exception exception) {
            log.severe("error parsing UNIT parameter in wkt.");
            return null;
        }
        if (n2 == 1) {
            Hashtable hashtable = SRSConstants.getAngularUnitList();
            if (hashtable.get(string3) == null) {
                hashtable.put(string3, new Double(d));
            }
        } else {
            Hashtable hashtable = SRSConstants.getDistanceUnitList();
            if (hashtable.get(string3) == null) {
                hashtable.put(string3, new Double(d));
            }
        }
        sRS.set(n, string3, d, n2, spheroid);
        return sRS;
    }

    static {
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception exception) {
            log.info("Using 96 as default dpi.");
        }
        distUnitList.put("CENTIMETER", new Double(0.01));
        distUnitList.put("CHAIN", new Double(20.1168));
        distUnitList.put("CHN_BEN", new Double(20.1167825));
        distUnitList.put("CHN_SRS", new Double(20.1167651));
        distUnitList.put("CL_FT", new Double(0.304797265));
        distUnitList.put("CM", new Double(0.01));
        distUnitList.put("FATHOM", new Double(1.8288));
        distUnitList.put("FOOT", new Double(0.3048));
        distUnitList.put("U.S. FOOT", new Double(0.3048));
        distUnitList.put("INCH", new Double(0.0254));
        distUnitList.put("IND_FT", new Double(0.304799518));
        distUnitList.put("IND_YARD", new Double(0.914398554));
        distUnitList.put("KILOMETER", new Double(1000.0));
        distUnitList.put("KM", new Double(1000.0));
        distUnitList.put("LINK", new Double(0.201166195));
        distUnitList.put("LINK_BEN", new Double(0.201167651));
        distUnitList.put("LINK_SRS", new Double(0.201167651));
        distUnitList.put("M", new Double(1.0));
        distUnitList.put("METER", new Double(1.0));
        distUnitList.put("MILE", new Double(1609.344));
        distUnitList.put("MILLIMETER", new Double(0.001));
        distUnitList.put("MM", new Double(0.001));
        distUnitList.put("MOD_USFT", new Double(0.304812253));
        distUnitList.put("NAUT_MILE", new Double(1852.0));
        distUnitList.put("ROD", new Double(5.0292));
        distUnitList.put("SRS_YARD", new Double(0.914398415));
        distUnitList.put("SURVEY_FOOT", new Double(0.3048006));
        distUnitList.put("YARD", new Double(0.9144));
        angularUnitList.put("DECIMAL DEGREE", new Double(Math.PI / 180));
        angularUnitList.put("RADIAN", new Double(1.0));
        angularUnitList.put("DECIMAL MINUTE", new Double(2.908882086657216E-4));
        angularUnitList.put("DECIMAL SECOND", new Double(4.84813681109536E-6));
        angularUnitList.put("GON", new Double(0.015707963267948967));
        angularUnitList.put("GRAD", new Double(0.015707963267948967));
    }
}

