/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.Legend;
import oracle.sdovis.LegendColumn;
import oracle.sdovis.LegendEntry;
import oracle.sdovis.SRS;
import oracle.sdovis.ScaleBarRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.svg.MaxLineSegment;
import oracle.sdovis.svg.SVGUtil;
import oracle.sdovis.svg.ShapeConverter;
import oracle.sdovis.util.RectArray;

public class SVGMap {
    private static final double DEFAULT_MIN_DIST = 0.5;
    private static final double STROKE_FACTOR = 0.5;
    public static boolean printBoundingBoxes = false;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private int width = 400;
    private int height = 300;
    private Color backGround = null;
    private String bgImageUrl = null;
    private Hashtable predefinedShapes = new Hashtable(64);
    private Hashtable selectablePredefinedShapes = new Hashtable(64);
    private Hashtable cssTable = new Hashtable(64);
    private Hashtable segTable = new Hashtable(512);
    private StringBuffer definition = new StringBuffer(8192);
    private StringBuffer css = new StringBuffer(4096);
    private StringBuffer svgDrawing = new StringBuffer(65536);
    private String legendStr = "";
    private StringBuffer scaleBarSB = new StringBuffer(200);
    private int idx = 0;
    private int styleIdx = 0;
    private int lineLabelGroupIdx = 0;
    private int labelGroupIdx = 0;
    private int themeIdx = 0;
    private int pathIdx = 0;
    private int zoomLevels = 4;
    private double zoomFactor = 2.0;
    private StringBuffer[] lineLabelGroups = null;
    private StringBuffer[] labelGroups = null;
    private StringBuffer globalLabel = new StringBuffer(8192);
    private double[] scaleTable = null;
    private double initialScale = 1.0;
    private boolean showNavigationBar = true;
    private boolean isTiny = false;
    private String currentStyle = "";
    private String currentSelectedStyle = "";
    private int lastStyleIdx = 0;
    private int sameStyleCount = 0;
    private RectArray[] coverLists = null;
    private Hashtable hiddenThemes = new Hashtable(10);
    private boolean hideCurrentTheme = false;
    private boolean showInfo = true;
    private String svgOnClick = null;
    private String svgOnMouseMove = null;
    private String themeOnClick = null;
    private ArrayList themeOnClickList = new ArrayList(10);
    private int selectableCount = 0;
    private int selectableThemeCount = 0;
    private ArrayList selectableThemeList = new ArrayList(10);
    private AffineTransform aTransform = null;
    private boolean layersOnly = false;
    private boolean generateStyles = true;
    private boolean deviceCoordinateSys = true;
    private boolean renderLabels = true;
    private String onRectangleSelect = null;
    private String onPolygonSelect = null;
    private String themeOnMouseMove = null;
    private String themeOnMouseOver = null;
    private String themeOnMouseOut = null;
    private ArrayList themeOnMouseMoveList = new ArrayList(10);
    private ArrayList themeOnMouseOverList = new ArrayList(10);
    private ArrayList themeOnMouseOutList = new ArrayList(10);
    SRS srs = null;
    private String infoTipFont = null;

    public SVGMap(int n, int n2, VisContext visContext, boolean bl) {
        int n3;
        this.width = n;
        this.height = n2;
        this.srs = visContext.getSrs();
        this.initialScale = visContext.getSVGInitScale();
        this.showNavigationBar = visContext.showSVGNavigationBar();
        this.showInfo = visContext.getSVGShowInfo();
        this.svgOnClick = visContext.getSVGOnClick();
        this.svgOnMouseMove = visContext.getSVGOnMouseMove();
        this.aTransform = visContext.getAffineXF();
        this.isTiny = bl;
        int n4 = visContext.getSVGZoomLevels();
        double d = visContext.getSVGZoomFactor();
        if (n4 > 0) {
            this.zoomLevels = n4;
        }
        if (d > 1.0) {
            this.zoomFactor = d;
        }
        this.coverLists = new RectArray[this.zoomLevels];
        this.lineLabelGroups = new StringBuffer[this.zoomLevels];
        this.labelGroups = new StringBuffer[this.zoomLevels];
        this.scaleTable = new double[this.zoomLevels];
        this.scaleTable[0] = 1.0;
        this.layersOnly = visContext.renderSVGLayersOnly();
        if (this.layersOnly) {
            this.zoomLevels = 1;
        }
        this.generateStyles = visContext.renderSVGStyles();
        this.renderLabels = visContext.renderSVGLabels();
        this.deviceCoordinateSys = visContext.renderSVGInDevCoordSys();
        this.onRectangleSelect = visContext.getSVGOnRectangleSelect();
        this.onPolygonSelect = visContext.getSVGOnPolygonSelect();
        this.infoTipFont = visContext.getSVGInfoFont();
        if (this.infoTipFont == null) {
            this.infoTipFont = "Arial";
        }
        for (n3 = 1; n3 < this.zoomLevels; ++n3) {
            this.scaleTable[n3] = this.scaleTable[n3 - 1] * d;
        }
        this.lineLabelGroups[0] = new StringBuffer(1024);
        this.labelGroups[0] = new StringBuffer(1024);
        this.coverLists[0] = visContext.getCRArray() != null ? visContext.getCRArray() : new RectArray(500);
        for (n3 = 1; n3 < this.zoomLevels; ++n3) {
            this.lineLabelGroups[n3] = new StringBuffer(1024);
            this.labelGroups[n3] = new StringBuffer(1024);
            if (visContext.getCRArray() != null) {
                // empty if block
            }
            this.coverLists[n3] = (RectArray)visContext.getCRArray().clone();
        }
    }

    public boolean getLayersOnly() {
        return this.layersOnly;
    }

    public boolean getDeviceCoordinateSys() {
        return this.deviceCoordinateSys;
    }

    public void setBackGround(Color color) {
        this.backGround = color;
    }

    public void setBgImageUrl(String string) {
        this.bgImageUrl = string;
    }

    public String getBgImgaeUrl() {
        return this.bgImageUrl;
    }

    public String getPredefinedId(Object object) {
        return (String)this.predefinedShapes.get(object);
    }

    public String addPredefinedMarker(StyleMarker styleMarker) {
        this.predefinedShapes.put(styleMarker, "" + this.idx);
        this.definition.append(styleMarker.toSVG("" + this.idx, false));
        return "" + this.idx++;
    }

    public void appendToSVGDrawing(String string) {
        this.svgDrawing.append(string);
    }

    public void output(Writer writer) throws IOException {
        if (!this.layersOnly) {
            writer.write("<?xml version=\"1.0\" ?>");
            writer.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\" >\n");
            writer.write("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"main\" xml:space=\"preserve\" width=\"" + this.width + "\" height=\"" + this.height + "\" ");
            writer.write((this.isTiny ? "" : "zoomAndPan=\"disable\" onmousedown=\"mouseClicked(evt)\" onmousemove=\"mouseMoved(evt)\" onmouseup=\"endSelect(evt)\" onload=\"initSVG(evt);" + (this.initialScale > 1.0 ? "setZoomRatio(" + this.initialScale + ");" : "") + "\"") + ">\n");
            if (!this.isTiny) {
                String string;
                int n;
                writer.write("  <script language=\"JavaScript\">//<![CDATA[\n");
                writer.write("    var cx=" + this.width / 2 + " ;\n");
                writer.write("    var cy=" + this.height / 2 + " ;\n");
                writer.write("    var ocx=" + this.width / 2 + " ;\n");
                writer.write("    var ocy=" + this.width / 2 + " ;\n");
                writer.write("    var width=" + this.width + " ;\n");
                writer.write("    var height=" + this.height + " ;\n");
                writer.write("    var labelGroupCnt=" + this.themeIdx + ";\n");
                writer.write("    var labelLevelGroupCnt=" + this.lineLabelGroupIdx + ";\n");
                writer.write("    var nonLineLabelLevelGroupCnt=" + this.labelGroupIdx + ";\n");
                writer.write("    var maxScale = " + this.scaleTable[this.zoomLevels - 1] + ";\n");
                writer.write("    var zoomFactor = " + this.zoomFactor + ";\n");
                writer.write("    var zoomLevels = " + this.zoomLevels + ";\n");
                writer.write("    var scale=" + this.initialScale + ";\n");
                writer.write("    var infoon =" + (this.showInfo ? 1 : 0) + ";\n");
                writer.write("    var selectableThemeList = new Array(" + this.getSelectableThemeList() + ");\n");
                writer.write("    var selectedIdList = new Array(" + this.selectableThemeList.size() + ");\n");
                writer.write("    var selectedCountList = new Array(" + this.selectableThemeList.size() + ");\n");
                writer.write("    function initSelectedIdList()\n");
                writer.write("    {\n");
                if (this.selectableThemeList.size() > 0) {
                    writer.write("      for(i=0; i<" + this.selectableThemeList.size() + "; i++)\n");
                    writer.write("      {\n");
                    writer.write("        selectedIdList[i] = new Array(200);\n");
                    writer.write("        selectedCountList[i] = 0;\n");
                    writer.write("      }\n");
                }
                writer.write("    }\n");
                writer.write("    function onRectangleSelect(evt)\n");
                writer.write("    {\n");
                if (this.onRectangleSelect != null) {
                    writer.write("    " + this.onRectangleSelect + "();\n");
                }
                writer.write("    }\n");
                writer.write("    function onPolygonSelect(evt)\n");
                writer.write("    {\n");
                if (this.onPolygonSelect != null) {
                    writer.write("    " + this.onPolygonSelect + "();\n");
                }
                writer.write("    }\n");
                this.insertFile(writer, "SVGScripts.txt");
                writer.write("    function mouseClicked(evt)\n");
                writer.write("    {\n");
                writer.write("      if(evt.button!=0)\n");
                writer.write("        return ;\n");
                writer.write("      else if(windowselect==1)\n");
                writer.write("        startSelect(evt);\n");
                writer.write("      else if(polygonselect==1||simpleLineDrawing==1||polylineDrawing==1)\n");
                writer.write("        freeDraw(evt);\n");
                if (this.svgOnClick != null) {
                    writer.write("      else if(featureselect==0)\n");
                    writer.write("        parent." + this.svgOnClick + "(evt.clientX,evt.clientY);\n");
                }
                writer.write("    }\n");
                writer.write("    function mouseMoved(evt)\n");
                writer.write("    {\n");
                writer.write("      moveMouse(evt);\n");
                if (this.svgOnMouseMove != null) {
                    writer.write("        parent." + this.svgOnMouseMove + "(evt.clientX,evt.clientY);\n");
                }
                writer.write("    }\n");
                for (n = 0; n < this.themeOnClickList.size(); ++n) {
                    string = (String)this.themeOnClickList.get(n);
                    writer.write("    function onclick" + (n + 1) + "(evt)\n");
                    writer.write("    {\n");
                    writer.write("      if(evt.button!=0)\n");
                    writer.write("        return ;\n");
                    writer.write("      else if(windowselect==1)\n");
                    writer.write("        startSelect(evt);\n");
                    writer.write("      else if(featureselect==1)\n");
                    writer.write("      {\n");
                    writer.write("        var t=evt.getTarget();\n");
                    writer.write("        parent." + string + "(getThemeName(t),t.getAttribute('key'),evt.clientX,evt.clientY);\n");
                    writer.write("      }\n");
                    writer.write("    }\n");
                }
                for (n = 0; n < this.themeOnMouseMoveList.size(); ++n) {
                    string = (String)this.themeOnMouseMoveList.get(n);
                    writer.write("    function onmousemove" + (n + 1) + "(evt)\n");
                    writer.write("    {\n");
                    writer.write("      if(evt.button!=0)\n");
                    writer.write("        return ;\n");
                    writer.write("      var t=evt.getTarget();\n");
                    writer.write("      parent." + string + "(getThemeName(t),t.getAttribute('key'),evt.clientX,evt.clientY);\n");
                    writer.write("    }\n");
                }
                for (n = 0; n < this.themeOnMouseOverList.size(); ++n) {
                    string = (String)this.themeOnMouseOverList.get(n);
                    writer.write("    function onmouseover" + (n + 1) + "(evt)\n");
                    writer.write("    {\n");
                    writer.write("      if(evt.button!=0)\n");
                    writer.write("        return ;\n");
                    writer.write("      var t=evt.getTarget();\n");
                    writer.write("      parent." + string + "(getThemeName(t),t.getAttribute('key'),evt.clientX,evt.clientY);\n");
                    writer.write("    }\n");
                }
                for (n = 0; n < this.themeOnMouseOutList.size(); ++n) {
                    string = (String)this.themeOnMouseOutList.get(n);
                    writer.write("    function onmouseout" + (n + 1) + "(evt)\n");
                    writer.write("    {\n");
                    writer.write("      if(evt.button!=0)\n");
                    writer.write("        return ;\n");
                    writer.write("      var t=evt.getTarget();\n");
                    writer.write("      parent." + string + "(getThemeName(t),t.getAttribute('key'),evt.clientX,evt.clientY);\n");
                    writer.write("    }\n");
                }
                if (this.aTransform != null) {
                    this.outputTransformFunction(writer);
                }
                writer.write(SVGUtil.getJSDistFunction(this.srs));
                writer.write("//]]>\n");
                writer.write("  </script>\n");
                writer.write("<svg id=\"root\" width=\"" + this.width + "\" height=\"" + this.height + "\">\n");
            }
            this.outputDefinition(writer);
        }
        this.outputSVGDrawing(writer);
        if (!this.layersOnly) {
            if (!this.isTiny) {
                writer.write("<path id=\"freedrawpath\" d=\"\" stroke=\"black\" stroke-width=\"1.5\" fill=\"none\" visibility=\"hidden\"/>\n");
                writer.write("<rect id=\"selectwindow\" x=\"0\" y=\"0\" width=\"0\" height=\"0\" stroke=\"black\" fill=\"grey\" opacity=\"0.5\" visibility=\"hidden\"/>");
            }
            writer.write("</svg>");
            if (!this.isTiny) {
                writer.write(this.legendStr);
                if (this.scaleBarSB.length() > 0) {
                    writer.write(this.scaleBarSB.toString() + "</g></g>\n");
                }
                writer.write("<g id=\"infowindow\" transform=\"translate(100,100)\">\n");
                writer.write("<rect id=\"infobox\" x=\"0\" y=\"0\" width=\"80\" height=\"120\" rx=\"5\" ry=\"5\" fill=\"#bbbbbb\" stroke=\"none\" opacity=\"0.8\" visibility=\"hidden\"></rect> \n");
                writer.write("<text id=\"infotext1\" x=\"5\" y=\"14\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext2\" x=\"5\" y=\"26\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext3\" x=\"5\" y=\"38\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext4\" x=\"5\" y=\"50\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext5\" x=\"5\" y=\"62\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext6\" x=\"5\" y=\"74\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext7\" x=\"5\" y=\"86\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext8\" x=\"5\" y=\"98\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext9\" x=\"5\" y=\"110\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext10\" x=\"5\" y=\"122\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext11\" x=\"5\" y=\"134\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext12\" x=\"5\" y=\"146\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext13\" x=\"5\" y=\"158\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext14\" x=\"5\" y=\"170\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext15\" x=\"5\" y=\"182\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("<text id=\"infotext16\" x=\"5\" y=\"194\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\" visibility=\"hidden\">i</text>\n");
                writer.write("</g>\n");
                if (this.showNavigationBar) {
                    writer.write("<g transform=\"translate(" + (this.width - 30) + ",30)\">\n");
                    writer.write("<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"170\" rx=\"5\" ry=\"5\" stroke=\"grey\" stroke-width=\"1\" fill=\"#bbbbbb\" opacity=\"0.6\" /> \n");
                    writer.write("<g transform=\"translate(0,0)\" onclick=\"zoomin()\" onmouseover=\"changeStatus('zoomin', 'on')\" onmouseout=\"changeStatus('zoomin', 'off')\">\n");
                    writer.write("<circle id=\"zoomin\" cx=\"0\" cy=\"0\" r=\"12\" stroke=\"blue\" stroke-width=\"1\" fill=\"#cceeff\" />\n");
                    writer.write("<path d=\"M-8,0 L8,0\" stroke=\"black\" stroke-width=\"2\" />\n");
                    writer.write("<path d=\"M0,-8 L0,8\" stroke=\"black\" stroke-width=\"2\" />\n");
                    writer.write("</g>\n");
                    writer.write("<g transform=\"translate(0,30)\" onclick=\"zoomout()\" onmouseover=\"changeStatus('zoomout', 'on')\" onmouseout=\"changeStatus('zoomout', 'off')\">\n");
                    writer.write("<circle id=\"zoomout\" cx=\"0\" cy=\"0\" r=\"12\" stroke=\"blue\" stroke-width=\"1\" fill=\"grey\"/>\n");
                    writer.write("<path d=\"M-8,0 L8,0\" stroke=\"black\" stroke-width=\"2\" />\n");
                    writer.write("</g>\n");
                    writer.write("<g transform=\"translate(0,60)\" onclick=\"switchInfoStatus()\" onmouseover=\"displayLabel(evt)\" onmouseout=\"hideInfoLabel()\">\n");
                    writer.write("<circle id=\"info\" cx=\"0\" cy=\"0\" r=\"12\" stroke=\"blue\" stroke-width=\"1\" fill=\"" + (this.showInfo ? "red" : "#cceeff") + "\" label='Show hidden information'/>\n");
                    writer.write("<text x=\"-10\" y=\"4\" stroke=\"black\" font-size=\"12\" label='Show hidden information'>Info</text>\n");
                    writer.write("</g>\n");
                    writer.write("<g transform=\"translate(0,90)\" onclick=\"switchLegendStatus()\" onmouseover=\"displayLabel(evt)\" onmouseout=\"hideInfoLabel()\">\n");
                    writer.write("<circle id=\"lgdbutton\" cx=\"0\" cy=\"0\" r=\"12\" stroke=\"blue\" stroke-width=\"1\" fill=\"" + (this.legendStr.length() == 0 ? "grey" : "#cceeff") + "\" label='Show legend'/>\n");
                    writer.write("<text x=\"-3\" y=\"4\" stroke=\"black\" font-size=\"12\" label='Show legend'>L</text>\n");
                    writer.write("</g>\n");
                    writer.write("<g transform=\"translate(0,125)\">\n");
                    writer.write("<path id=\"pannorth\" d=\"M-8,-9 L0,-17 L8,-9 L-8,-9\" stroke=\"blue\" fill=\"grey\" onclick=\"pannorth()\" onmouseover=\"changeStatus('pannorth', 'on')\" onmouseout=\"changeStatus('pannorth', 'off')\"/>\n");
                    writer.write("<path id=\"pansouth\" d=\"M-8,9 L0,17 L8,9 L-8,9\" stroke=\"blue\" fill=\"grey\" onclick=\"pansouth()\" onmouseover=\"changeStatus('pansouth', 'on')\" onmouseout=\"changeStatus('pansouth', 'off')\"/>\n");
                    writer.write("<path id=\"paneast\" d=\"M-9,-8 L-17,0 L-9,8 L-9,-8\" stroke=\"blue\" fill=\"grey\" onclick=\"paneast()\" onmouseover=\"changeStatus('paneast', 'on')\" onmouseout=\"changeStatus('paneast', 'off')\"/>\n");
                    writer.write("<path id=\"panwest\" d=\"M9,-8 L17,0 L9,8 L9,-8\" stroke=\"blue\" fill=\"grey\" onclick=\"panwest()\" onmouseover=\"changeStatus('panwest', 'on')\" onmouseout=\"changeStatus('panwest', 'off')\"/>\n");
                    writer.write("</g>\n");
                    writer.write("</g>\n");
                }
                writer.write("<g id=\"labelwindow\" visibility=\"hidden\" transform=\"translate(100,100)\" pointer-events=\"none\">\n");
                writer.write("<rect id=\"labelbox\" x=\"0\" y=\"0\" width=\"80\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#bbbbbb\" stroke=\"none\" opacity=\"0.8\" ></rect> \n");
                writer.write("<text id=\"labeltext\" x=\"5\" y=\"14\" font-family=\"" + this.infoTipFont + "\" font-size=\"12\" text-anchor=\"start\">test</text>\n");
                writer.write("</g>\n");
                writer.write("<g id=\"distancewindow\" visibility=\"hidden\" transform=\"translate(5,10)\" pointer-events=\"none\">\n");
                writer.write("<rect id=\"distancebox\" x=\"0\" y=\"0\" width=\"80\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#bbbbbb\" stroke=\"none\" opacity=\"0.8\" ></rect> \n");
                writer.write("<text id=\"distancetext\" x=\"5\" y=\"14\" font-family=\"Arial\" font-size=\"12\" text-anchor=\"start\">Distance:0</text>\n");
                writer.write("</g>\n");
                writer.write("<g id=\"coordwindow\" visibility=\"visible\" transform=\"translate(5," + (this.height - 20) + ")\" pointer-events=\"none\">\n");
                writer.write("<rect id=\"coordbox\" x=\"0\" y=\"0\" width=\"40\" height=\"20\" rx=\"5\" ry=\"5\" fill=\"#bbbbbb\" stroke=\"none\" opacity=\"0.8\" ></rect> \n");
                writer.write("<text id=\"coordtext\" x=\"5\" y=\"14\" font-family=\"Arial\" font-size=\"12\" text-anchor=\"start\">0,0</text>\n");
                writer.write("</g>\n");
                writer.write("<g id=\"loadingbar\" transform=\"translate(" + (this.width / 2 - 50) + "," + this.height / 2 + ")\" visibility=\"hidden\">\n");
                writer.write("<rect width=\"100\" height=\"10\" fill=\"white\" stroke=\"black\"/>\n");
                writer.write("<rect width=\"10\" height=\"10\" fill=\"red\">\n");
                writer.write("    <animate attributeName=\"x\" from=\"0\" to=\"90\" dur=\"1s\" repeatCount=\"indefinite\"/>\n");
                writer.write("</rect>\n");
                writer.write("<text x=\"30\" y=\"7\" font-size=\"9\">Loading...</text>\n");
                writer.write("</g>\n");
                writer.write("</svg>");
            }
        }
    }

    public void outputTransformFunction(Writer writer) throws IOException {
        try {
            AffineTransform affineTransform = this.aTransform.createInverse();
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            double d3 = affineTransform.getShearX();
            double d4 = affineTransform.getShearY();
            double d5 = affineTransform.getTranslateX();
            double d6 = affineTransform.getTranslateY();
            writer.write("    function getUserCoordinate(x, y)\n");
            writer.write("    {\n");
            writer.write("      x = (x-width/2.0)/scale+cx;\n");
            writer.write("      y = (y-height/2.0)/scale+cy;\n");
            writer.write("      var result=new Array(2);\n");
            writer.write("      result[0]=(" + d + ")*x+(" + d3 + ")*y+(" + d5 + ");\n");
            writer.write("      result[1]=(" + d4 + ")*x+(" + d2 + ")*y+(" + d6 + ");\n");
            writer.write("      return result;");
            writer.write("    }\n");
            writer.write("    function getUserCoordFromSVGCoord(x, y)\n");
            writer.write("    {\n");
            writer.write("      var result=new Array(2);\n");
            writer.write("      result[0]=(" + d + ")*x+(" + d3 + ")*y+(" + d5 + ");\n");
            writer.write("      result[1]=(" + d4 + ")*x+(" + d2 + ")*y+(" + d6 + ");\n");
            writer.write("      return result;");
            writer.write("    }\n");
            d = this.aTransform.getScaleX();
            d2 = this.aTransform.getScaleY();
            d3 = this.aTransform.getShearX();
            d4 = this.aTransform.getShearY();
            d5 = this.aTransform.getTranslateX();
            d6 = this.aTransform.getTranslateY();
            writer.write("    function getSVGCoordinate(x, y)\n");
            writer.write("    {\n");
            writer.write("      var result=new Array(2);\n");
            writer.write("      result[0]=(" + d + ")*x+(" + d3 + ")*y+(" + d5 + ");\n");
            writer.write("      result[1]=(" + d4 + ")*x+(" + d2 + ")*y+(" + d6 + ");\n");
            writer.write("      return result;");
            writer.write("    }\n");
            writer.write("    function getScreenCoordinate(x, y)\n");
            writer.write("    {\n");
            writer.write("      var result=new Array(2);\n");
            writer.write("      x=(" + d + ")*x+(" + d3 + ")*y+(" + d5 + ");\n");
            writer.write("      y=(" + d4 + ")*x+(" + d2 + ")*y+(" + d6 + ");\n");
            writer.write("      result[0]=(x-cx)*scale+width/2.0;\n");
            writer.write("      result[1]=(y-cy)*scale+height/2.0;\n");
            writer.write("      return result;");
            writer.write("    }\n");
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            log.severe("Cannot create reverse tranformation");
            this.aTransform = null;
        }
    }

    public void addTheme(String string, String string2, boolean bl) {
        if (!bl) {
            this.hiddenThemes.put(string, string);
            this.hideCurrentTheme = true;
        } else {
            this.hideCurrentTheme = false;
        }
        this.svgDrawing.append("\n<g id=\"theme_" + SVGUtil.UTFEncode(string, true) + "\" visibility=\"" + (bl ? "visible" : "hidden") + "\">");
        this.svgDrawing.append("<image x=\"0\" y=\"0\" width=\"" + this.width + "\" height=\"" + this.height + "\" " + "xlink:href=\"" + string2 + "\" />");
        this.svgDrawing.append("</g>\n");
    }

    public void addTheme(String string, ThemeDecorator themeDecorator) {
        boolean bl = themeDecorator.isVisibleInSVG();
        boolean bl2 = themeDecorator.isSelectableInSVG();
        this.checkStyleGroup(null, null);
        if (!bl) {
            this.hiddenThemes.put(string, string);
            this.hideCurrentTheme = true;
        } else {
            this.hideCurrentTheme = false;
        }
        this.themeOnClick = themeDecorator.getOnClickInSVG();
        this.themeOnMouseMove = themeDecorator.getOnMouseMoveInSVG();
        this.themeOnMouseOver = themeDecorator.getOnMouseOverInSVG();
        this.themeOnMouseOut = themeDecorator.getOnMouseOutInSVG();
        if (this.themeOnClick != null) {
            this.themeOnClickList.add(this.themeOnClick);
        }
        if (this.themeOnMouseMove != null) {
            this.themeOnMouseMoveList.add(this.themeOnMouseMove);
        }
        if (this.themeOnMouseOver != null) {
            this.themeOnMouseOverList.add(this.themeOnMouseOver);
        }
        if (this.themeOnMouseOut != null) {
            this.themeOnMouseOutList.add(this.themeOnMouseOut);
        }
        if (bl2) {
            ++this.selectableThemeCount;
            this.selectableThemeList.add(string);
        }
        this.svgDrawing.append("\n<g id=\"theme_" + SVGUtil.UTFEncode(string, true) + "\" visibility=\"" + (bl ? "visible" : "hidden") + "\">");
    }

    public void closeTheme() {
        for (int i = 0; i < this.zoomLevels; ++i) {
            if (this.labelGroups[i].length() <= 0) continue;
            this.svgDrawing.append(this.labelGroups[i]);
            this.svgDrawing.append("</g>");
            this.labelGroups[i].delete(0, this.labelGroups[i].length());
        }
        this.hideCurrentTheme = false;
        this.themeOnClick = null;
        this.svgDrawing.append("</g>");
    }

    public String addLabelGroupForTheme(StyleText styleText, String string) {
        String string2 = "label_" + string;
        boolean bl = this.hiddenThemes.get(string) == null;
        this.hideCurrentTheme = !bl;
        this.checkStyleGroup(null, null);
        this.svgDrawing.append("<g id=\"" + string2 + "\" " + (styleText != null ? this.getStyle(styleText.getFont(), styleText.getColor(), false) : "") + " visibility=\"" + (bl ? "visible" : "hidden") + "\">");
        for (int i = 0; i < this.zoomLevels; ++i) {
            this.labelGroups[i].delete(0, this.labelGroups[i].length());
        }
        this.globalLabel.delete(0, this.globalLabel.length());
        return string2;
    }

    public void closeLabelGroup() {
        this.hideCurrentTheme = false;
        if (this.globalLabel.length() > 0) {
            this.svgDrawing.append(this.globalLabel);
        } else {
            for (int i = 0; i < this.zoomLevels; ++i) {
                if (this.labelGroups[i].length() <= 0) continue;
                this.svgDrawing.append(this.labelGroups[i]);
                this.svgDrawing.append("</g>");
            }
        }
        this.svgDrawing.append("</g>");
    }

    public String addLineLabelGroupForTheme(StyleText styleText, boolean bl) {
        String string = "l" + this.themeIdx++;
        this.checkStyleGroup(null, null);
        this.svgDrawing.append("<g id=\"" + string + "\" " + this.getStyle(styleText.getFont(), styleText.getColor(), false) + " font-size=\"" + styleText.getFont().getSize() + "\" size-fixed=\"" + bl + "\">");
        this.globalLabel.delete(0, this.globalLabel.length());
        for (int i = 0; i < this.zoomLevels; ++i) {
            this.lineLabelGroups[i].delete(0, this.lineLabelGroups[i].length());
        }
        return string;
    }

    public void closeLineLabelGroup() {
        this.hideCurrentTheme = false;
        if (this.globalLabel.length() > 0) {
            this.svgDrawing.append(this.globalLabel);
        }
        for (int i = 0; i < this.zoomLevels; ++i) {
            if (this.lineLabelGroups[i].length() <= 0) continue;
            this.svgDrawing.append(this.lineLabelGroups[i]);
            this.svgDrawing.append("</g>");
        }
        this.svgDrawing.append("</g>");
    }

    private String getInfoLabelAction(String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer(150);
        if (this.isTiny) {
            return "";
        }
        if (this.layersOnly && !this.renderLabels) {
            return "";
        }
        if (string == null || string.trim().length() == 0) {
            string = null;
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = null;
        }
        if (string == null && string2 == null) {
            if (this.themeOnMouseOver != null) {
                stringBuffer.append("onmouseover=\"onmouseover" + this.themeOnMouseOverList.size() + "(evt)\" ");
            }
            if (this.themeOnMouseOut != null) {
                stringBuffer.append("onmouseout=\"onmouseout" + this.themeOnMouseOutList.size() + "(evt)\" ");
            }
            return stringBuffer.toString();
        }
        String string4 = this.themeOnMouseOver == null ? "" : "onmouseover" + this.themeOnMouseOverList.size() + "(evt);";
        String string5 = string3 = this.themeOnMouseOut == null ? "" : "onmouseout" + this.themeOnMouseOutList.size() + "(evt);";
        if (string != null && string2 != null) {
            stringBuffer.append("onmouseover=\"displayInfoLabel(evt);" + string4 + "\" ");
        } else if (string != null) {
            stringBuffer.append("onmouseover=\"displayInfo(evt);" + string4 + "\" ");
        } else {
            stringBuffer.append("onmouseover=\"displayLabel(evt);" + string4 + "\" ");
        }
        stringBuffer.append("onmouseout=\"hideInfoLabel();" + string3 + "\" ");
        string = string == null ? "" : "info=\"" + SVGUtil.UTFEncode(string, true) + "\" ";
        string2 = string2 == null ? "" : "label=\"" + SVGUtil.UTFEncode(string2, true) + "\" ";
        if (this.layersOnly) {
            return string + string2;
        }
        return stringBuffer.append(string + string2).toString();
    }

    public void drawPredefinedShape(String string, double d, double d2, double d3, int n, int n2, double d4, double d5, String string2, String string3, int n3, boolean bl, String string4) {
        String string5 = this.getMouseActionString(bl, string4);
        this.checkStyleGroup(null, null);
        d3 = d3 * 180.0 / Math.PI;
        if (n3 < 0) {
            this.drawPredefinedShape(string, d, d2, d3, n, n2, d4, d5, string2, string3, bl, string4);
            return;
        }
        StringBuffer stringBuffer = this.labelGroups[n3];
        if (stringBuffer.length() == 0) {
            stringBuffer.append("<g id=\"nlg" + this.labelGroupIdx++ + "\" zoom_level=\"" + n3);
            stringBuffer.append("\" visibility=\"" + (n3 > 0 || this.hideCurrentTheme ? "hidden" : "visible") + "\" " + "th=\"" + (this.hideCurrentTheme ? "y" : "n") + "\">");
        }
        if (d4 == 1.0 && d5 == 1.0) {
            stringBuffer.append("<use xlink:href=\"#" + string + "\" ");
            if (d3 == 0.0) {
                stringBuffer.append("x=\"" + SVGUtil.getDoubleString(d, 2) + "\" y=\"" + SVGUtil.getDoubleString(d2, 2) + "\" ");
            } else {
                stringBuffer.append("transform=\"translate(" + SVGUtil.getDoubleString(d, 2) + "," + SVGUtil.getDoubleString(d2, 2) + ") rotate(" + d3 + ")\" ");
            }
            if (this.layersOnly) {
                stringBuffer.append("size=\"" + n + "," + n2 + "\" ");
            }
            String string6 = this.getInfoLabelAction(string3, string2);
            stringBuffer.append(string6);
            stringBuffer.append(string5 + "/>");
        } else {
            stringBuffer.append("<use xlink:href=\"#" + string + "\" ");
            stringBuffer.append("transform=\"translate(" + SVGUtil.getDoubleString(d, 2) + "," + SVGUtil.getDoubleString(d2, 2) + ") scale(" + SVGUtil.getDoubleString(d4, 2) + "," + SVGUtil.getDoubleString(d5, 2) + ")");
            if (d3 != 0.0) {
                stringBuffer.append(" rotate(" + d3 + ")");
            }
            stringBuffer.append("\" ");
            if (this.layersOnly) {
                stringBuffer.append("size=\"" + n + "," + n2 + "\" ");
            }
            String string7 = this.getInfoLabelAction(string3, string2);
            stringBuffer.append(string7);
            stringBuffer.append(string5 + "/>");
        }
    }

    public void drawPredefinedShape(String string, double d, double d2, double d3, int n, int n2, double d4, double d5, String string2, String string3, boolean bl, String string4) {
        String string5 = this.getMouseActionString(bl, string4);
        this.checkStyleGroup(null, null);
        d3 = d3 * 180.0 / Math.PI;
        if (d4 == 1.0 && d5 == 1.0) {
            this.svgDrawing.append("<use xlink:href=\"#" + string + "\" ");
            if (d3 == 0.0) {
                this.svgDrawing.append("x=\"" + SVGUtil.getDoubleString(d, 2) + "\" y=\"" + SVGUtil.getDoubleString(d2, 2) + "\" ");
            } else {
                this.svgDrawing.append("transform=\"translate(" + SVGUtil.getDoubleString(d, 2) + "," + SVGUtil.getDoubleString(d2, 2) + ") rotate(" + d3 + ")\" ");
            }
            if (this.layersOnly) {
                this.svgDrawing.append("size=\"" + n + "," + n2 + "\" ");
            }
            String string6 = this.getInfoLabelAction(string3, string2);
            this.svgDrawing.append(string6);
            this.svgDrawing.append(string5 + "/>");
        } else {
            this.svgDrawing.append("<use xlink:href=\"#" + string + "\" ");
            this.svgDrawing.append("transform=\"translate(" + SVGUtil.getDoubleString(d, 2) + "," + SVGUtil.getDoubleString(d2, 2) + ") scale(" + SVGUtil.getDoubleString(d4, 2) + "," + SVGUtil.getDoubleString(d5, 2) + ")");
            if (d3 != 0.0) {
                this.svgDrawing.append(" rotate(" + d3 + ")");
            }
            this.svgDrawing.append("\" ");
            if (this.layersOnly) {
                this.svgDrawing.append("size=\"" + n + "," + n2 + "\" ");
            }
            String string7 = this.getInfoLabelAction(string3, string2);
            this.svgDrawing.append(string7);
            this.svgDrawing.append(string5 + "/>");
        }
    }

    private double getMinScale() {
        return 1.0 / this.scaleTable[this.zoomLevels - 1];
    }

    private boolean globalLineLabelIsValid(int n, int n2, MaxLineSegment maxLineSegment) {
        double d = maxLineSegment.segmentLength;
        int n3 = 3;
        if ((double)n < d * 0.8) {
            Cloneable cloneable;
            int n4;
            ArrayList arrayList = maxLineSegment.pointArray;
            if (arrayList.size() < 2) {
                return false;
            }
            Point2D point2D = (Point2D)arrayList.get(0);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            double d4 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            double d5 = maxLineSegment.segmentLength * 0.1;
            ArrayList[] arrayListArray = new ArrayList[this.zoomLevels];
            for (n4 = 0; n4 < this.zoomLevels; ++n4) {
                cloneable = new ArrayList(100);
                arrayListArray[n4] = cloneable;
            }
            for (n4 = 1; n4 < arrayList.size(); ++n4) {
                cloneable = (Point2D)arrayList.get(n4);
                double d6 = ((Point2D)cloneable).getX();
                double d7 = ((Point2D)cloneable).getY();
                double d8 = Math.sqrt((d6 - d2) * (d6 - d2) + (d7 - d3) * (d7 - d3));
                if (!bl && d5 < d4 + d8) {
                    double d9 = d5 - d4;
                    bl = true;
                    d2 += (d6 - d2) * d9 / d8;
                    d3 += (d7 - d3) * d9 / d8;
                    d4 += d9;
                    d8 -= d9;
                }
                d4 += d8;
                if (!bl) {
                    d2 = d6;
                    d3 = d7;
                    continue;
                }
                if (d4 > d5 + (double)n) {
                    bl2 = true;
                    d6 -= (d6 - d2) * (d4 - d5 - (double)n) / d8;
                    d7 -= (d7 - d3) * (d4 - d5 - (double)n) / d8;
                }
                if (d8 < (double)n3 && !bl2) {
                    d4 -= d8;
                    continue;
                }
                for (int i = 0; i < this.zoomLevels; ++i) {
                    ArrayList arrayList2 = LabelHelper.getBoundingRectsWithoutConflicts(this.coverLists[i], d2, d3, d6, d7, (double)n2);
                    if (arrayList2 == null) {
                        return false;
                    }
                    arrayListArray[i].addAll(arrayList2);
                }
                if (bl2) {
                    bl3 = true;
                    break;
                }
                d2 = d6;
                d3 = d7;
            }
            if (bl3) {
                for (n4 = 0; n4 < this.zoomLevels; ++n4) {
                    for (int i = 0; i < arrayListArray[n4].size(); ++i) {
                        this.coverLists[n4].insert((Rectangle2D)arrayListArray[n4].get(i));
                    }
                    arrayListArray[n4].clear();
                }
                return true;
            }
        }
        return false;
    }

    private int getLabelZoomLevel(int n, int n2, MaxLineSegment maxLineSegment) {
        double d = maxLineSegment.segmentLength;
        int n3 = 3;
        int n4 = -1;
        for (int i = this.zoomLevels - 1; i >= 0; --i) {
            int n5;
            double d2 = (double)n * 1.0 / this.scaleTable[i];
            double d3 = (double)n2 * 1.0 / this.scaleTable[i];
            if (!(d2 < d * 0.8)) break;
            if (this.coverLists[i] == null) {
                n4 = i;
                continue;
            }
            ArrayList arrayList = maxLineSegment.pointArray;
            if (arrayList.size() < 2) break;
            Point2D point2D = (Point2D)arrayList.get(0);
            double d4 = point2D.getX();
            double d5 = point2D.getY();
            double d6 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            double d7 = maxLineSegment.segmentLength * 0.1;
            ArrayList arrayList2 = new ArrayList(100);
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                Point2D point2D2 = (Point2D)arrayList.get(n5);
                double d8 = point2D2.getX();
                double d9 = point2D2.getY();
                double d10 = Math.sqrt((d8 - d4) * (d8 - d4) + (d9 - d5) * (d9 - d5));
                if (!bl && d7 < d6 + d10) {
                    double d11 = d7 - d6;
                    bl = true;
                    d4 += (d8 - d4) * d11 / d10;
                    d5 += (d9 - d5) * d11 / d10;
                    d6 += d11;
                    d10 -= d11;
                }
                d6 += d10;
                if (!bl) {
                    d4 = d8;
                    d5 = d9;
                    continue;
                }
                if (d6 > d7 + d2) {
                    bl2 = true;
                    d8 -= (d8 - d4) * (d6 - d7 - d2) / d10;
                    d9 -= (d9 - d5) * (d6 - d7 - d2) / d10;
                }
                if (d10 < (double)n3 && !bl2) {
                    d6 -= d10;
                    continue;
                }
                ArrayList arrayList3 = LabelHelper.getBoundingRectsWithoutConflicts(this.coverLists[i], d4, d5, d8, d9, d3);
                if (arrayList3 == null) break;
                arrayList2.addAll(arrayList3);
                if (bl2) {
                    bl3 = true;
                    break;
                }
                d4 = d8;
                d5 = d9;
            }
            if (!bl3) break;
            for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                this.coverLists[i].insert((Rectangle2D)arrayList2.get(n5));
            }
            n4 = i;
            if (arrayList2 == null) continue;
            arrayList2.clear();
        }
        return n4;
    }

    public void drawLabelOnLineString(StyleText styleText, String string, String string2, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        Font font = styleText.getFont();
        Color color = styleText.getColor();
        MaxLineSegment maxLineSegment = (MaxLineSegment)this.segTable.get(string);
        if (maxLineSegment == null) {
            return;
        }
        int n = (int)styleText.getVisualBounds(string2, null).getWidth();
        int n2 = (int)styleText.getVisualBounds(string2, null).getHeight();
        if (bl2) {
            if (this.globalLineLabelIsValid(n, n2, maxLineSegment)) {
                this.addGlobalLineLabel(string, string2, maxLineSegment.labelOffset);
            }
        } else {
            int n3 = this.getLabelZoomLevel(n, n2, maxLineSegment);
            if (n3 < 0) {
                return;
            }
            this.addLineLabelToGroup(n3, string, string2, maxLineSegment.labelOffset);
        }
    }

    private void addLabelToGroup(int n, String string, double d, double d2, double d3, Font font, Color color) {
        StringBuffer stringBuffer = this.labelGroups[n];
        String string2 = SVGUtil.getDoubleString(d);
        String string3 = SVGUtil.getDoubleString(d2);
        if (stringBuffer.length() == 0) {
            stringBuffer.append("<g id=\"nlg" + this.labelGroupIdx++ + "\" zoom_level=\"" + n);
            stringBuffer.append("\" visibility=\"" + (n > 0 || this.hideCurrentTheme ? "hidden" : "visible") + "\" " + "th=\"" + (this.hideCurrentTheme ? "y" : "n") + "\">");
        }
        if (d3 == 0.0) {
            stringBuffer.append("<text x=\"" + string2 + "\" y=\"" + string3 + "\" ");
        } else {
            stringBuffer.append("<text transform=\"translate(" + string2 + "," + string3 + ") rotate(" + d3 * 180.0 / Math.PI + ")\" ");
        }
        stringBuffer.append(this.getStyle(font, color, false) + " font-size=\"" + (double)font.getSize() / this.scaleTable[n] + "\">");
        stringBuffer.append(SVGUtil.UTFEncode(string));
        stringBuffer.append("</text>");
    }

    private void addLabelToGroup(int n, String string, double d, double d2, double d3, int n2) {
        StringBuffer stringBuffer = this.labelGroups[n];
        String string2 = SVGUtil.getDoubleString(d);
        String string3 = SVGUtil.getDoubleString(d2);
        if (stringBuffer.length() == 0) {
            stringBuffer.append("<g id=\"nlg" + this.labelGroupIdx++ + "\" zoom_level=\"" + n);
            stringBuffer.append("\" font-size=\"" + (double)n2 / this.scaleTable[n]);
            stringBuffer.append("\" visibility=\"" + (n > 0 || this.hideCurrentTheme ? "hidden" : "visible") + "\" " + "th=\"" + (this.hideCurrentTheme ? "y" : "n") + "\">");
        }
        if (d3 == 0.0) {
            stringBuffer.append("<text x=\"" + string2 + "\" y=\"" + string3 + "\" " + " >");
        } else {
            stringBuffer.append("<text transform=\"translate(" + string2 + "," + string3 + ") rotate(" + d3 * 180.0 / Math.PI + ")\" >");
        }
        stringBuffer.append(SVGUtil.UTFEncode(string));
        stringBuffer.append("</text>");
    }

    private void addGlobalLineLabel(String string, String string2, int n) {
        this.globalLabel.append("<text>");
        this.globalLabel.append("<textPath xlink:href=\"#" + string + "\" ");
        this.globalLabel.append("startOffset=\"" + n + "%\" >");
        this.globalLabel.append(SVGUtil.UTFEncode(string2));
        this.globalLabel.append("</textPath></text>");
    }

    private void addLineLabelToGroup(int n, String string, String string2, int n2) {
        StringBuffer stringBuffer = this.lineLabelGroups[n];
        if (stringBuffer.length() == 0) {
            stringBuffer.append("<g id=\"lg" + this.lineLabelGroupIdx++ + "\" max_scale=\"" + this.scaleTable[n] + "\" ");
            stringBuffer.append("visibility=\"" + (n > 0 || this.hideCurrentTheme ? "hidden" : "visible") + "\" " + "th=\"" + (this.hideCurrentTheme ? "y" : "n") + "\">");
        }
        stringBuffer.append("<text>");
        stringBuffer.append("<textPath xlink:href=\"#" + string + "\" ");
        stringBuffer.append("startOffset=\"" + n2 + "%\" >");
        stringBuffer.append(SVGUtil.UTFEncode(string2));
        stringBuffer.append("</textPath></text>");
    }

    public void drawRectangle(double d, double d2, double d3, double d4, Color color, Color color2) {
        String string = this.getStyle(color, 1.0f, color2);
        if (this.checkStyleGroup(string, null)) {
            string = "";
        }
        this.svgDrawing.append("<rect x=\"" + SVGUtil.getDoubleString(d) + "\" y=\"" + SVGUtil.getDoubleString(d2) + "\" width=\"" + SVGUtil.getDoubleString(d3) + "\" height=\"" + SVGUtil.getDoubleString(d4) + "\" " + string + "/>");
    }

    private boolean checkStyleGroup(String string, String string2) {
        if (string != null && this.currentStyle != null && string.equals(this.currentStyle)) {
            ++this.sameStyleCount;
            return true;
        }
        if (this.sameStyleCount > 1) {
            String string3 = this.svgDrawing.substring(this.lastStyleIdx);
            this.svgDrawing.delete(this.lastStyleIdx, this.svgDrawing.length());
            this.svgDrawing.append("<g " + this.currentStyle + (this.currentSelectedStyle == null ? "" : " " + this.currentSelectedStyle) + ">");
            this.svgDrawing.append(string3);
            this.svgDrawing.append("</g>");
        }
        this.currentStyle = string;
        this.currentSelectedStyle = string2;
        this.lastStyleIdx = this.svgDrawing.length();
        this.sameStyleCount = 1;
        return false;
    }

    public void drawText(String string, double d, double d2, double d3, Font font, Color color, int n) {
        if (n < 0) {
            this.drawText(string, d, d2, d3, font, color);
        } else {
            this.addLabelToGroup(n, string, d, d2, d3, font, color);
        }
    }

    public void drawText(String string, double d, double d2, double d3, Font font, Color color) {
        String string2 = this.getStyle(font, color);
        if (this.checkStyleGroup(string2, null)) {
            string2 = "";
        }
        if (d3 == 0.0) {
            this.svgDrawing.append("<text x=\"" + SVGUtil.getDoubleString(d) + "\" y=\"" + SVGUtil.getDoubleString(d2) + "\" " + string2 + " >");
        } else {
            this.svgDrawing.append("<text " + string2 + " transform=\"translate(" + SVGUtil.getDoubleString(d) + "," + SVGUtil.getDoubleString(d2) + ") rotate(" + SVGUtil.getDoubleString(d3 * 180.0 / Math.PI, 2) + ")\" >");
        }
        this.svgDrawing.append(SVGUtil.UTFEncode(string));
        this.svgDrawing.append("</text>");
    }

    public void drawLine(double d, double d2, double d3, double d4, Color color, float f, float[] fArray) {
        String string = this.getStyle(color, f, fArray);
        if (this.checkStyleGroup(string, null)) {
            string = "";
        }
        this.svgDrawing.append("<path " + string + " d=\"M" + SVGUtil.getDoubleString(d) + "," + SVGUtil.getDoubleString(d2) + " L" + SVGUtil.getDoubleString(d3) + "," + SVGUtil.getDoubleString(d4) + "\" />");
    }

    public String drawLineString(Shape shape, Rectangle2D rectangle2D, Color color, float f, float[] fArray, String string, double d, boolean bl, String string2) {
        return this.drawLineString(shape, rectangle2D, color, f, fArray, null, null, null, string, d, bl, string2);
    }

    public String drawLineString(Shape shape, Rectangle2D rectangle2D, Color color, float f, float[] fArray, String string, Font font, Color color2, String string2, double d, boolean bl, String string3) {
        String string4;
        String string5 = this.getStyle(color, f, fArray);
        String string6 = string4 = bl ? this.getSelectedStyle(color, f, fArray) : "";
        if (this.checkStyleGroup(string5, string4)) {
            string5 = "";
            string4 = "";
        }
        --this.sameStyleCount;
        String string7 = this.getMouseActionString(bl, string3);
        if (shape instanceof Ellipse2D) {
            if (this.sameStyleCount == 0) {
                string5 = this.currentStyle;
                string4 = this.currentSelectedStyle;
            }
            this.svgDrawing.append("<g " + string5 + " " + string4 + " ");
            ++this.sameStyleCount;
            String string8 = this.getInfoLabelAction(string2, string);
            this.svgDrawing.append(string8);
            this.svgDrawing.append(string7 + ">");
            ShapeConverter.appendEllipseString(this.svgDrawing, (Ellipse2D)shape);
            this.svgDrawing.append("</g>");
        } else if (string == null || string.trim().length() == 0 || this.layersOnly) {
            String string9 = "<path d=\"";
            this.svgDrawing.append(string9);
            int n = this.svgDrawing.length();
            if (this.layersOnly && !this.deviceCoordinateSys) {
                ShapeConverter.appendShapeString(this.svgDrawing, shape, this.deviceCoordinateSys);
            } else {
                ShapeConverter.appendLineString(this.svgDrawing, shape, rectangle2D, 1.0, 1.0, 0, 0, d);
            }
            if (n == this.svgDrawing.length()) {
                this.svgDrawing.delete(n - string9.length(), n);
            } else {
                if (this.sameStyleCount == 0) {
                    string5 = this.currentStyle;
                    string4 = this.currentSelectedStyle;
                }
                this.svgDrawing.append("\" " + string5 + " " + string4 + " ");
                ++this.sameStyleCount;
                String string10 = this.getInfoLabelAction(string2, string);
                this.svgDrawing.append(string10);
                this.svgDrawing.append(string7 + " />");
            }
        } else {
            String string11 = "path" + this.pathIdx++;
            this.definition.append("<path id=\"" + string11 + "\" d=\"");
            int n = this.definition.length();
            MaxLineSegment maxLineSegment = ShapeConverter.appendLineString(this.definition, shape, rectangle2D, 1.0, 1.0, 0, 0, d);
            if (this.definition.length() == n) {
                this.definition.delete(n - ("<path id=\"" + string11 + "\" d=\"").length(), n);
            } else {
                this.definition.append("\" />");
                if (this.sameStyleCount == 0) {
                    string5 = this.currentStyle;
                    string4 = this.currentSelectedStyle;
                }
                this.svgDrawing.append("<use xlink:href=\"#" + string11 + "\" " + string5 + " " + string4 + " ");
                ++this.sameStyleCount;
                String string12 = this.getInfoLabelAction(string2, string);
                this.svgDrawing.append(string12);
                this.svgDrawing.append(string7 + " />");
                this.segTable.put(string11, maxLineSegment);
                return string11;
            }
        }
        return null;
    }

    private String getMouseActionString(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.layersOnly || string == null) {
            return "";
        }
        if (bl) {
            stringBuffer.append(" onmousedown=\"select(evt);");
            if (this.themeOnClick != null) {
                stringBuffer.append("onclick" + this.themeOnClickList.size() + "(evt);");
            }
            stringBuffer.append("\"");
            if (this.themeOnMouseMove != null) {
                stringBuffer.append(" onmousemove=\"onmousemove" + this.themeOnMouseMoveList.size() + "(evt);\"");
            }
        } else {
            if (this.themeOnClick != null) {
                stringBuffer.append(" onmousedown=\"onclick" + this.themeOnClickList.size() + "(evt)\"");
            }
            if (this.themeOnMouseMove != null) {
                stringBuffer.append(" onmousemove=\"onmousemove" + this.themeOnMouseMoveList.size() + "(evt);\"");
            }
        }
        if (bl || this.themeOnClick != null || this.themeOnMouseMove != null || this.themeOnMouseOver != null) {
            stringBuffer.append(" key='" + string + "' ");
        }
        return stringBuffer.toString();
    }

    public String drawShape(Shape shape, Color color, float f, Color color2, String string, String string2, Rectangle2D rectangle2D, double d, boolean bl, String string3) {
        String string4 = this.getInfoLabelAction(string2, string);
        String string5 = this.getMouseActionString(bl, string3);
        if (shape instanceof Ellipse2D) {
            String string6;
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            String string7 = this.getStyle(color, f, color2);
            String string8 = string6 = bl ? this.getSelectedStyle(color, f, color2) : "";
            if (this.checkStyleGroup(string7, null)) {
                string7 = "";
                string6 = "";
            }
            if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
                this.svgDrawing.append("<circle cx=\"" + SVGUtil.getDoubleString(ellipse2D.getCenterX(), 2) + "\" cy=\"" + SVGUtil.getDoubleString(ellipse2D.getCenterY(), 2) + "\" r=\"" + SVGUtil.getDoubleString(ellipse2D.getWidth() / 2.0, 2) + "\" ");
                this.svgDrawing.append(string7 + " " + string6 + " ");
                this.svgDrawing.append(string4);
                this.svgDrawing.append(string5);
                this.svgDrawing.append("/>");
            } else {
                this.svgDrawing.append("<g transform=\"scale(1," + ellipse2D.getHeight() / ellipse2D.getWidth() + ")\" ");
                this.svgDrawing.append(string7 + " " + string6 + " ");
                this.svgDrawing.append(string4);
                this.svgDrawing.append(string5);
                this.svgDrawing.append(">");
                this.svgDrawing.append("<circle cx=\"" + SVGUtil.getDoubleString(ellipse2D.getCenterX(), 2) + "\" cy=\"" + SVGUtil.getDoubleString(ellipse2D.getCenterY(), 2) + "\" r=\"" + SVGUtil.getDoubleString(ellipse2D.getWidth() / 2.0, 2) + "\"/>");
            }
            if (ellipse2D.getWidth() != ellipse2D.getHeight()) {
                this.svgDrawing.append("</g>");
            }
        } else {
            int n = this.svgDrawing.length();
            this.svgDrawing.append("<path d=\"");
            boolean bl2 = this.layersOnly && !this.deviceCoordinateSys ? ShapeConverter.appendShapeString(this.svgDrawing, shape, this.deviceCoordinateSys) : ShapeConverter.appendShapeString(this.svgDrawing, shape, rectangle2D, 1.0, 1.0, 0, 0, d);
            if (this.svgDrawing.length() < n + 10) {
                this.svgDrawing.delete(n, this.svgDrawing.length());
                return null;
            }
            if (bl2) {
                String string9;
                String string10 = this.getStyle(color, f, color2);
                String string11 = string9 = bl ? this.getSelectedStyle(color, f, color2) : "";
                if (string10 != null && this.currentStyle != null && string10.equals(this.currentStyle)) {
                    ++this.sameStyleCount;
                    string10 = "";
                    string9 = "";
                } else {
                    if (this.sameStyleCount > 1) {
                        String string12 = this.svgDrawing.substring(this.lastStyleIdx, n);
                        String string13 = this.svgDrawing.substring(n);
                        this.svgDrawing.delete(this.lastStyleIdx, this.svgDrawing.length());
                        this.svgDrawing.append("<g " + this.currentStyle + (this.currentSelectedStyle == null ? "" : " " + this.currentSelectedStyle) + ">");
                        this.svgDrawing.append(string12);
                        this.svgDrawing.append("</g>");
                        n = this.svgDrawing.length();
                        this.svgDrawing.append(string13);
                    }
                    this.currentStyle = string10;
                    this.currentSelectedStyle = string9;
                    this.lastStyleIdx = n;
                    this.sameStyleCount = 1;
                }
                this.svgDrawing.append("\" " + string10 + " " + string9 + " ");
            } else {
                String string14;
                if (color == null) {
                    color = color2;
                }
                f = 1.0f;
                String string15 = this.getStyle(color, f);
                String string16 = string14 = bl ? this.getSelectedStyle(color, f, color2) : "";
                if (string15 != null && this.currentStyle != null && string15.equals(this.currentStyle)) {
                    ++this.sameStyleCount;
                    string15 = "";
                    string14 = "";
                } else {
                    if (this.sameStyleCount > 1) {
                        String string17 = this.svgDrawing.substring(this.lastStyleIdx, n);
                        String string18 = this.svgDrawing.substring(n);
                        this.svgDrawing.delete(this.lastStyleIdx, this.svgDrawing.length());
                        this.svgDrawing.append("<g " + this.currentStyle + (this.currentSelectedStyle == null ? "" : " " + this.currentSelectedStyle) + ">");
                        this.svgDrawing.append(string17);
                        this.svgDrawing.append("</g>");
                        n = this.svgDrawing.length();
                        this.svgDrawing.append(string18);
                    }
                    this.currentStyle = string15;
                    this.currentSelectedStyle = string14;
                    this.lastStyleIdx = n;
                    this.sameStyleCount = 1;
                }
                this.svgDrawing.append("\" " + string15 + " " + string14 + " ");
            }
            this.svgDrawing.append(string4);
            this.svgDrawing.append(string5);
            this.svgDrawing.append(" />");
        }
        return null;
    }

    public void drawPieChart(int n, int n2, int n3, double[] dArray, Color[] colorArray, String[] stringArray) {
        this.checkStyleGroup(null, null);
        n3 = (int)((double)n3 * 1.25);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        double d2 = Math.PI * 2;
        int n4 = n3;
        int n5 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = d == 0.0 ? 1.0 / (double)dArray.length * Math.PI * 2.0 : dArray[i] / d * Math.PI * 2.0;
            if (d3 == 0.0) continue;
            int n6 = (int)((double)n3 * Math.cos(d2 -= d3));
            int n7 = (int)((double)n3 * Math.sin(d2));
            this.svgDrawing.append("<path d=\"M" + n + "," + n2 + " L" + (n4 + n) + "," + (n5 + n2) + " A" + n3 + "," + n3 + " 0 " + (d3 > Math.PI ? 1 : 0) + " 0 " + (n6 + n) + "," + (n7 + n2) + " L" + n + "," + n2 + "z\" ");
            String string = "";
            if (colorArray[i].getAlpha() < 255) {
                string = "opacity=\"" + (double)colorArray[i].getAlpha() / 255.0 + "\" ";
            }
            this.svgDrawing.append(string + "stroke=\"black\" stroke-width=\"0.5\" fill=\"" + (d == 0.0 ? "grey" : SVGMap.getColorString(colorArray[i])) + "\"");
            String string2 = "";
            String string3 = "";
            string3 = dArray[i] == (double)((int)dArray[i]) ? "" + (int)dArray[i] : "" + dArray[i];
            if (stringArray != null && stringArray[i] != null && !this.layersOnly) {
                string2 = " label=\"" + stringArray[i] + ":" + string3 + "\" onmouseover=\"displayLabel(evt)\"";
            }
            this.svgDrawing.append(string2 + "/>");
            n4 = n6;
            n5 = n7;
        }
    }

    public void createScaleBar(double d, double d2, int n) {
        this.scaleBarSB.append("<g transform=\"translate(" + (int)d + "," + (int)d2 + ")\">");
    }

    public void addScaleBarLevel(int n) {
        if (n > 0) {
            this.scaleBarSB.append("</g>");
        }
        this.scaleBarSB.append("<g id=\"scalebar" + n + "\" visibility=\"" + (n == 0 ? "visible" : "hidden") + "\">");
    }

    public void renderMetricBar(ScaleBarRenderer scaleBarRenderer, int n, int n2, int n3, int n4, int n5, StyleText styleText) {
        int n6 = scaleBarRenderer.getBarHeight();
        ScaleBar scaleBar = scaleBarRenderer.getDefinition();
        int n7 = scaleBar.getLabelFont().getSize();
        float f = scaleBar.getLabelHaloSize();
        Rectangle2D rectangle2D = styleText.getVisualBounds(scaleBarRenderer.getEdDisplayI(), null);
        if (scaleBar.getMode().equals("DUAL_MODES")) {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n4 + n6 * 2 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getUnitNameI() + "</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)(n + n5) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 + n6 * 2 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayI() + "</text>\n");
            n4 += n6;
        } else if ("BOTTOM".equalsIgnoreCase(scaleBar.getLabelPosition())) {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n4 + n6 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">0</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)(n + n5) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 + n6 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayI() + " " + scaleBarRenderer.getUnitNameI() + "</text>\n");
        } else {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n4 - n7 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">0</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)(n + n5) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 - n7 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayI() + " " + scaleBarRenderer.getUnitNameI() + "</text>\n");
        }
        if (n5 > 75) {
            this.scaleBarSB.append("<rect x=\"" + n + "\" y=\"" + n4 + "\" " + "width=\"" + SVGUtil.getDoubleString((double)n5 / 4.0, 2) + "\" height=\"" + n6 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor1()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
            this.scaleBarSB.append("<rect x=\"" + SVGUtil.getDoubleString((double)n + (double)n5 / 4.0, 2) + "\" y=\"" + n4 + "\" " + "width=\"" + SVGUtil.getDoubleString((double)n5 / 4.0, 2) + "\" height=\"" + n6 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor2()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
            this.scaleBarSB.append("<rect x=\"" + SVGUtil.getDoubleString((double)n + (double)n5 / 2.0, 2) + "\" y=\"" + n4 + "\" " + "width=\"" + SVGUtil.getDoubleString((double)n5 / 2.0, 2) + "\" height=\"" + n6 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor1()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
            rectangle2D = styleText.getVisualBounds(scaleBarRenderer.getEdHalfDisplayI(), null);
            if (scaleBar.getMode().equals("METRIC_MODE")) {
                if ("BOTTOM".equalsIgnoreCase(scaleBar.getLabelPosition())) {
                    this.scaleBarSB.append("<text x=\"" + ((double)(n + n5 / 2) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 + n6 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdHalfDisplayI() + "</text>\n");
                } else {
                    this.scaleBarSB.append("<text x=\"" + ((double)(n + n5 / 2) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 - n7 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdHalfDisplayI() + "</text>\n");
                }
            } else {
                this.scaleBarSB.append("<text x=\"" + ((double)(n + n5 / 2) - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n4 + n6 + n7 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdHalfDisplayI() + "</text>\n");
            }
        } else {
            this.scaleBarSB.append("<rect x=\"" + n + "\" y=\"" + n4 + "\" " + "width=\"" + n5 + "\" height=\"" + n6 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor2()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
        }
    }

    public void renderUSBar(ScaleBarRenderer scaleBarRenderer, int n, int n2, int n3, StyleText styleText) {
        int n4 = scaleBarRenderer.getBarHeight();
        ScaleBar scaleBar = scaleBarRenderer.getDefinition();
        int n5 = scaleBar.getLabelFont().getSize();
        float f = 0.0f;
        double d = scaleBarRenderer.getUsMarker1Dist() / scaleBarRenderer.getEdpp();
        Rectangle2D rectangle2D = styleText.getVisualBounds(scaleBarRenderer.getEdDisplayU(), null);
        if (scaleBar.getMode().equals("DUAL_MODES")) {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n2 - n5 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getUnitNameU() + "</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)n + d - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n2 - n5 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayU() + "</text>\n");
        } else if ("BOTTOM".equalsIgnoreCase(scaleBar.getLabelPosition())) {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n2 + n4 + n5 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + 0 + "</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)n + d - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n2 + n4 + n5 / 2 + 6) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayU() + " " + scaleBarRenderer.getUnitNameU() + "</text>\n");
        } else {
            this.scaleBarSB.append("<text x=\"" + n + "\" y=\"" + (n2 - n5 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + 0 + "</text>\n");
            this.scaleBarSB.append("<text x=\"" + ((double)n + d - rectangle2D.getWidth() / 2.0) + "\" y=\"" + (n2 - n5 / 2 + 4) + "\" " + this.getStyle(styleText.getFont(), Color.BLACK, false) + " " + "font-size=\"" + styleText.getFont().getSize() + "\">" + scaleBarRenderer.getEdDisplayU() + " " + scaleBarRenderer.getUnitNameU() + "</text>\n");
        }
        this.scaleBarSB.append("<rect x=\"" + n + "\" y=\"" + n2 + "\" " + "width=\"" + SVGUtil.getDoubleString(d, 2) + "\" height=\"" + n4 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor2()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
        if (scaleBar.getMode().equals("DUAL_MODES") && (double)n3 - d > 0.0) {
            this.scaleBarSB.append("<rect x=\"" + SVGUtil.getDoubleString((double)n + d, 2) + "\" y=\"" + n2 + "\" " + "width=\"" + SVGUtil.getDoubleString((double)n3 - d, 2) + "\" height=\"" + n4 + "\" " + "fill=\"" + SVGMap.getColorString(scaleBar.getColor1()) + "\" " + "stroke=\"" + SVGMap.getColorString(Color.BLACK) + "\" " + "stroke-width=\"0.8\"/>\n");
        }
    }

    public void drawLegend(Legend legend, int n, int n2) {
        int n3;
        this.checkStyleGroup(null, null);
        int n4 = 3;
        int n5 = this.svgDrawing.length();
        Color color = legend.getBackground();
        Color color2 = legend.getBorderColor();
        int n6 = color2 != null ? color2.getAlpha() : 255;
        int n7 = color != null ? color.getAlpha() : 255;
        String string = n6 == 255 ? "" : " stroke-opacity=\"" + (float)n6 / 255.0f + "\"";
        String string2 = n7 == 255 ? "" : " fill-opacity=\"" + (float)n7 / 255.0f + "\"";
        this.svgDrawing.append("<g id=\"legend\" visibility=\"" + (this.isTiny ? "visible" : "hidden") + "\" transform=\"translate(" + n + "," + n2 + ")\">\n");
        this.svgDrawing.append("<rect width=\"" + legend.getMBR().getWidth() + "\" height=\"" + legend.getMBR().getHeight() + "\" fill=\"" + SVGMap.getColorString(legend.getBackground()) + "\"" + string2 + " stroke=\"" + SVGMap.getColorString(legend.getBorderColor()) + "\"" + string + " stroke-width=\"" + legend.getBorderWidth() + "\"/>\n");
        Color color3 = legend.getTextColor();
        int n8 = n4;
        int n9 = n4;
        for (n3 = 0; n3 < legend.getNumColumns(); ++n3) {
            LegendColumn legendColumn = legend.getColumn(n3);
            this.drawLegendColumn(legendColumn, n8, n9);
            Rectangle2D rectangle2D = legendColumn.getMBR();
            n8 = (int)((double)n8 + (rectangle2D.getWidth() + (double)n4));
        }
        this.checkStyleGroup(null, null);
        this.svgDrawing.append("</g>\n");
        n3 = this.svgDrawing.length();
        this.legendStr = this.svgDrawing.substring(n5, n3);
        this.svgDrawing.delete(n5, n3);
        this.lastStyleIdx = this.svgDrawing.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawLegendColumn(LegendColumn legendColumn, int n, int n2) {
        Object object;
        int n3;
        Color color;
        int n4 = legendColumn.getNumEntries();
        if (n4 == 0) {
            return;
        }
        float f = LegendEntry.PROFILE_IMAGE_HEIGHT[legendColumn.getProfile()];
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (legendColumn.getBackground() != null && legendColumn.getBorderColor() != null) {
            color = legendColumn.getBackground();
            Color color2 = legendColumn.getBorderColor();
            n3 = color2 != null ? color2.getAlpha() : 255;
            int n5 = color != null ? color.getAlpha() : 255;
            String string = n3 == 255 ? "" : " stroke-opacity=\"" + (float)n3 / 255.0f + "\"";
            object = n5 == 255 ? "" : " fill-opacity=\"" + (float)n5 / 255.0f + "\"";
            this.svgDrawing.append("<rect x=\"" + n + "\" y=\"" + n2 + "\" width=\"" + legendColumn.getMBR().getWidth() + "\" height=\"" + legendColumn.getMBR().getHeight() + "\" fill=\"" + SVGMap.getColorString(legendColumn.getBackground()) + "\"" + (String)object + " stroke=\"" + SVGMap.getColorString(legendColumn.getBorderColor()) + "\"" + string + " stroke-width=\"" + legendColumn.getBorderWidth() + "\" />\n");
        }
        color = legendColumn.getTextColor();
        try {
            int n6 = 3;
            for (n3 = 0; n3 < legendColumn.getNumEntries(); ++n3) {
                LegendEntry legendEntry = legendColumn.getEntry(n3);
                int n7 = legendEntry.getPreferredHeight();
                object = legendEntry.getAttrString();
                if (object == null) continue;
                attributedCharacterIterator = ((AttributedString)object).getIterator();
                this.drawLegendEntry(legendEntry, n + 5, (n6 += n7) - n7 / 2, color);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void drawLegendEntry(LegendEntry legendEntry, int n, int n2, Color color) {
        switch (legendEntry.getType()) {
            case 1: {
                return;
            }
            case 2: {
                this.svgDrawing.append("<text x=\"" + n + "\" y=\"" + n2 + "\" " + this.getStyle(legendEntry.getFont(), color, false) + " " + "font-size=\"" + legendEntry.getTextSize() + "\">" + SVGUtil.UTFEncode(legendEntry.getText()) + "</text>\n");
                return;
            }
            case 0: {
                Rectangle2D rectangle2D;
                Style style = legendEntry.getStyle();
                int n3 = 5;
                int n4 = legendEntry.getImageWidth();
                int n5 = legendEntry.getPreferredHeight();
                if (style instanceof StyleMarker) {
                    rectangle2D = ((StyleMarker)style).getMBR();
                    if (rectangle2D.getWidth() < (double)n4) {
                        n4 = (int)rectangle2D.getWidth();
                    }
                    if (rectangle2D.getHeight() < (double)n5) {
                        n5 = (int)rectangle2D.getHeight();
                    }
                }
                if (style != null) {
                    rectangle2D = new Rectangle2D.Float(n + legendEntry.getImageWidth() / 2 - n4 / 2, n2 - n5 / 2, n4, n5);
                    try {
                        style.apply(null, this, rectangle2D, null);
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, exception.getMessage(), exception);
                    }
                    n3 += legendEntry.getImageWidth();
                }
                this.drawText(legendEntry.getText(), n + n3, n2 + 3, 0.0, legendEntry.getFont(), color);
                return;
            }
        }
    }

    public void drawPoint(Point2D point2D, String string, String string2, double d, boolean bl, String string3) {
        this.svgDrawing.append("<use xlink:href=\"#" + string + "\" x=\"" + point2D.getX() + "\" y=\"" + point2D.getY() + "\"" + " " + (string2 != null ? string2 : "") + " />");
    }

    private String getStyle(Font font, Color color, boolean bl) {
        if (!this.generateStyles) {
            return "";
        }
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        String string = "";
        if (color.getAlpha() < 255) {
            string = "fill-opacity=\"" + (double)color.getAlpha() / 255.0 + "\" ";
        }
        if (this.isTiny || this.layersOnly) {
            return "font-weight=\"normal\" " + (bl ? "font-size=\"" + font.getSize() + "\" " : " ") + "font-family=\"" + font.getName() + "\" " + string + "fill=\"" + SVGMap.getColorString(color) + "\"";
        }
        return this.getCSStyle(font, color, bl);
    }

    private String getCSStyle(Font font, Color color, boolean bl) {
        String string;
        String string2;
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        if ((string2 = (String)this.cssTable.get(string = font.getName() + ":" + SVGMap.getColorString(color))) == null) {
            string2 = "style" + this.styleIdx++;
            String string3 = "";
            if (color.getAlpha() < 255) {
                string3 = ";fill-opacity:" + (double)color.getAlpha() / 255.0;
            }
            this.css.append("." + string2 + "{font-weight:normal;" + (bl ? "font-size:" + font.getSize() : "")).append(";font-family:'" + font.getName() + "';fill:" + SVGMap.getColorString(color) + string3 + "}\n");
            this.cssTable.put(string, string2);
        }
        return "class=\"" + string2 + "\"";
    }

    private String getStyle(Font font, Color color) {
        if (!this.generateStyles) {
            return "";
        }
        if (this.isTiny || this.layersOnly) {
            return this.getStyle(font, color, 1.0);
        }
        return this.getCSStyle(font, color, 1.0);
    }

    private String getStyle(Font font, Color color, double d) {
        if (!this.generateStyles) {
            return "";
        }
        if (this.isTiny || this.layersOnly) {
            if (font == null) {
                font = new Font("Dialog", 0, 10);
            }
            String string = "";
            if (color.getAlpha() < 255) {
                string = " fill-opacity=\"" + (double)color.getAlpha() / 255.0 + "\"";
            }
            return "font-weight=\"normal\" font-size=\"" + (double)font.getSize() * d + "\" " + "font-family=\"" + font.getName() + "\" fill=\"" + SVGMap.getColorString(color) + "\"" + string;
        }
        return this.getCSStyle(font, color, d);
    }

    private String getCSStyle(Font font, Color color, double d) {
        String string;
        String string2;
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        if ((string2 = (String)this.cssTable.get(string = font.getName() + ":" + font.getSize() + ":" + SVGMap.getColorString(color))) == null) {
            String string3 = "";
            if (color.getAlpha() < 255) {
                string3 = ";fill-opacity:" + (double)color.getAlpha() / 255.0;
            }
            string2 = "style" + this.styleIdx++;
            this.css.append("." + string2 + "{font-weight:normal;font-size:" + (double)font.getSize() * d).append(";font-family:'" + font.getName() + "';fill:" + SVGMap.getColorString(color) + string3 + "}\n");
            this.cssTable.put(string, string2);
        }
        return "class=\"" + string2 + "\"";
    }

    private String getStyle(Color color, float f) {
        if (!this.generateStyles) {
            return "";
        }
        if (this.isTiny || this.layersOnly) {
            return this.getStyle(color, f, (float[])null);
        }
        return this.getCSStyle(color, f, (float[])null);
    }

    private String getSelectedStyle(Color color, float f, float[] fArray) {
        if (!this.generateStyles) {
            return "";
        }
        color = SVGMap.getSelectedColor(color);
        return "s" + this.getCSStyle(color, f, fArray);
    }

    private String getStyle(Color color, float f, float[] fArray) {
        if (!this.generateStyles) {
            return "";
        }
        if (this.isTiny || this.layersOnly) {
            String string = SVGMap.getColorString(color);
            String string2 = "";
            if (color.getAlpha() < 255) {
                string2 = " stroke-opacity=\"" + (double)color.getAlpha() / 255.0 + "\"";
            }
            String string3 = "";
            if (fArray != null && fArray.length > 0) {
                for (int i = 0; i < fArray.length; ++i) {
                    string3 = string3 + fArray[i] + " ";
                }
            }
            return "stroke=\"" + string + "\"" + string2 + " stroke-width=\"" + (double)f * 0.5 + "\" " + (string3.length() == 0 ? "" : "stroke-dasharray=\"" + string3 + "\" ") + "stroke-linecap=\"round\" stroke-linejoin=\"round\" fill=\"none\"";
        }
        return this.getCSStyle(color, f, fArray);
    }

    private String getCSStyle(Color color, float f, float[] fArray) {
        String string;
        String string2;
        String string3 = SVGMap.getColorString(color);
        String string4 = "";
        if (color.getAlpha() < 255) {
            string4 = ";stroke-opacity:" + (double)color.getAlpha() / 255.0;
        }
        String string5 = "";
        if (fArray != null && fArray.length > 0) {
            for (int i = 0; i < fArray.length; ++i) {
                string5 = string5 + fArray[i] + " ";
            }
        }
        if ((string2 = (String)this.cssTable.get(string = string3 + ":" + f + ":" + string5)) == null) {
            string2 = "style" + this.styleIdx++;
            this.css.append("." + string2 + "{stroke:" + string3 + string4 + ";stroke-width:" + (double)f * 0.5 + ";" + (string5.length() == 0 ? "" : "stroke-dasharray:" + string5 + ";") + "stroke-linecap:round;stroke-linejoin:round;fill:none}\n");
            this.cssTable.put(string, string2);
        }
        return "class=\"" + string2 + "\"";
    }

    private static Color getSelectedColor(Color color) {
        if (color == null) {
            return null;
        }
        int n = ~color.getRed() % 256;
        if (n < 0) {
            n = 256 + n;
        }
        return new Color(n, color.getGreen(), color.getBlue());
    }

    private String getSelectedStyle(Color color, float f, Color color2) {
        if (!this.generateStyles) {
            return "";
        }
        color = SVGMap.getSelectedColor(color);
        color2 = SVGMap.getSelectedColor(color2);
        return "s" + this.getCSStyle(color, f, color2);
    }

    private String getStyle(Color color, float f, Color color2) {
        if (!this.generateStyles) {
            return "";
        }
        if (this.isTiny || this.layersOnly) {
            String string = SVGMap.getColorString(color2);
            String string2 = SVGMap.getColorString(color);
            if (color2 != null && color == null) {
                string2 = string;
                color = color2;
            }
            String string3 = "";
            if (color.getAlpha() < 255) {
                string3 = " stroke-opacity=\"" + (double)color.getAlpha() / 255.0 + "\"";
            }
            String string4 = "";
            if (color2.getAlpha() < 255) {
                string4 = " fill-opacity=\"" + (double)color2.getAlpha() / 255.0 + "\"";
            }
            return "stroke=\"" + string2 + "\"" + string3 + " stroke-width=\"" + (double)f * 0.5 + "\" " + "fill=\"" + string + "\"" + string4;
        }
        return this.getCSStyle(color, f, color2);
    }

    private String getCSStyle(Color color, float f, Color color2) {
        String string;
        String string2;
        String string3 = SVGMap.getColorString(color2);
        String string4 = SVGMap.getColorString(color);
        if (color2 != null && color == null) {
            string4 = string3;
        }
        if ((string2 = (String)this.cssTable.get(string = string4 + ":" + f + ":" + string3 + (color != null ? "" + color.getAlpha() : "") + "_" + (color2 != null ? "" + color2.getAlpha() : ""))) == null) {
            int n = color != null ? color.getAlpha() : 255;
            int n2 = color2 != null ? color2.getAlpha() : 255;
            String string5 = n == 255 ? "" : ";stroke-opacity:" + (float)n / 255.0f;
            String string6 = n2 == 255 ? "" : ";fill-opacity:" + (float)n2 / 255.0f;
            string2 = "style" + this.styleIdx++;
            this.css.append("." + string2 + "{stroke:" + string4 + ";stroke-width:" + (double)f * 0.5 + string5).append(";fill:" + string3 + string6 + "}\n");
            this.cssTable.put(string, string2);
        }
        return "class=\"" + string2 + "\"";
    }

    public static String getStrokeFillString(Color color, float f, Color color2) {
        String string = "";
        if (color.getAlpha() < 255) {
            string = " stroke-opacity=\"" + (double)color.getAlpha() / 255.0 + "\"";
        }
        String string2 = "";
        if (color2.getAlpha() < 255) {
            string2 = " fill-opacity=\"" + (double)color2.getAlpha() / 255.0 + "\"";
        }
        return "stroke=\"" + SVGMap.getColorString(color) + "\"" + string + " stroke-width=\"" + (double)f * 0.5 + "\" fill=\"" + SVGMap.getColorString(color2) + "\"" + string2;
    }

    public static String getSelectedStrokeFillString(Color color, float f, Color color2) {
        color = SVGMap.getSelectedColor(color);
        color2 = SVGMap.getSelectedColor(color2);
        String string = "";
        if (color.getAlpha() < 255) {
            string = " stroke-opacity=\"" + (double)color.getAlpha() / 255.0 + "\"";
        }
        String string2 = "";
        if (color2.getAlpha() < 255) {
            string2 = " fill-opacity=\"" + (double)color2.getAlpha() / 255.0 + "\"";
        }
        return "stroke=\"" + SVGMap.getColorString(color) + "\"" + string + " stroke-width=\"" + (double)f * 0.5 + "\" fill=\"" + SVGMap.getColorString(color2) + "\"" + string2;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return "none";
        }
        String string = Integer.toHexString(color.getRGB());
        if (string.length() > 6) {
            string = string.substring(2);
        }
        return "#" + string;
    }

    private void outputDefinition(Writer writer) throws IOException {
        if (this.definition.length() > 0 || this.css.length() > 0) {
            writer.write("<defs>");
            if (this.css.length() > 0) {
                writer.write("<style type=\"text/css\">\n<![CDATA[\n");
                writer.write(this.css.toString());
                writer.write("]]>\n</style>\n");
            }
            if (this.definition.length() > 0) {
                writer.write(this.definition.toString());
            }
            writer.write("</defs>\n");
        }
    }

    private void outputSVGDrawing(Writer writer) throws IOException {
        this.checkStyleGroup(null, null);
        if (!this.layersOnly && this.backGround != null) {
            writer.write("<rect width=\"" + this.width + "\" height=\"" + this.height + "\" x=\"0\" y=\"0\" stroke=\"none\" fill=\"" + SVGMap.getColorString(this.backGround) + "\"/>\n");
        }
        if (!this.layersOnly && this.bgImageUrl != null) {
            writer.write("<image x=\"0\" y=\"0\" width=\"" + this.width + "\" height=\"" + this.height + "\" " + "xlink:href=\"" + this.bgImageUrl + "\" />\n");
        }
        if (this.svgDrawing.length() > 0) {
            writer.write(this.svgDrawing.toString());
        }
    }

    private void insertFile(Writer writer, String string) {
        InputStream inputStream = SVGMap.class.getResourceAsStream(string);
        try {
            int n = inputStream.read();
            while (n > 0) {
                writer.write(n);
                n = inputStream.read();
            }
        }
        catch (Exception exception) {
            log.severe("Could not open file " + string);
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private String getSelectableThemeList() {
        if (this.selectableThemeList.size() == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < this.selectableThemeList.size(); ++i) {
            if (i == 0) {
                stringBuffer.append("\"" + (String)this.selectableThemeList.get(i) + "\"");
                continue;
            }
            stringBuffer.append(",\"" + (String)this.selectableThemeList.get(i) + "\"");
        }
        return stringBuffer.toString();
    }

    public int getZoomLevels() {
        return this.zoomLevels;
    }

    public RectArray[] getCoverLists() {
        return this.coverLists;
    }

    public RectArray getCoverList(int n) {
        return this.coverLists[n];
    }

    public void insertIntoCoverList(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.zoomLevels; ++i) {
            int n = (int)this.scaleTable[i];
            this.coverLists[i].insert(d * (double)n, d2 * (double)n, d3 * (double)n, d4 * (double)n);
        }
    }

    public double getScale(int n) {
        if (n < 0) {
            return 1.0;
        }
        return this.scaleTable[n];
    }

    public boolean isTiny() {
        return this.isTiny;
    }

    public void setOnClick(String string) {
        if (string != null) {
            this.themeOnClickList.add(string);
        }
        this.themeOnClick = string;
    }

    public void setOnMouseMove(String string) {
        if (string != null) {
            this.themeOnMouseMoveList.add(string);
        }
        this.themeOnMouseMove = string;
    }

    public void setOnMouseOver(String string) {
        if (string != null) {
            this.themeOnMouseOverList.add(string);
        }
        this.themeOnMouseOver = string;
    }

    public void setOnMouseOut(String string) {
        if (string != null) {
            this.themeOnMouseOutList.add(string);
        }
        this.themeOnMouseOut = string;
    }

    public boolean renderLayersOnly() {
        return this.layersOnly;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    private void outputCoverList(int n) {
        RectArray rectArray = this.coverLists[n];
        for (int i = 0; i < rectArray.size(); ++i) {
            Rectangle2D rectangle2D = rectArray.elementAt(i);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            double d3 = rectangle2D.getMinY();
            double d4 = rectangle2D.getMaxY();
            this.svgDrawing.append("<path fill=\"none\" stroke=\"black\" d=\"M" + d + "," + d3 + " L" + d2 + "," + d3 + " L" + d2 + "," + d4 + " L" + d + "," + d4 + " L" + d + "," + d3 + "\" />\n");
        }
    }
}

