/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.Spheroid;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.util.Util;

public class ScaleBarRenderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private ScaleBar definition = null;
    boolean geodetic;
    String unit;
    double earthDistance = -1.0;
    double edpp = 0.0;
    Spheroid spheroid = null;
    private String unitNameI;
    private String edDisplayI;
    private String edHalfDisplayI;
    private String unitNameU;
    private String edDisplayU;
    private double usMarker1Dist;
    private Rectangle2D mDeviceView;
    private Rectangle2D dataView;
    private int barHeight = 7;
    private static NiceRange[] niceRanges = new NiceRange[]{new NiceRange(1.0E-4, 0.001, 1.0E-4), new NiceRange(0.001, 0.01, 0.001), new NiceRange(0.01, 0.1, 0.01), new NiceRange(0.1, 1.0, 0.1), new NiceRange(1.0, 10.0, 1.0), new NiceRange(10.0, 100.0, 10.0), new NiceRange(100.0, 1000.0, 100.0), new NiceRange(1000.0, 5000.0, 500.0), new NiceRange(5000.0, 100000.0, 1000.0), new NiceRange(100000.0, 1000000.0, 5000.0), new NiceRange(1000000.0, 1.0E7, 50000.0), new NiceRange(1.0E7, 1.0E8, 500000.0), new NiceRange(1.0E8, 1.0E9, 5000000.0), new NiceRange(1.0E9, 1.0E10, 5.0E7)};

    private ScaleBarRenderer() {
    }

    public ScaleBarRenderer(ScaleBar scaleBar, SRS sRS, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.definition = scaleBar;
        this.earthDistance = 0.0;
        this.unit = sRS.getUnit();
        this.geodetic = sRS.isGeodetic();
        this.spheroid = sRS.getSpheroid();
        if (scaleBar.getLengthHint() == 0) {
            scaleBar.setLengthHint((int)(rectangle2D2.getWidth() * 0.175));
        }
        this.mDeviceView = rectangle2D2;
        this.dataView = rectangle2D;
        this.determineEarthDistance(rectangle2D, rectangle2D2);
        this.setupDisplayInfo();
    }

    public ScaleBar getDefinition() {
        return this.definition;
    }

    public void setEarthDistance(double d) {
        this.earthDistance = d;
    }

    public double getEarthDistance() {
        return this.earthDistance;
    }

    public void setEDPP(double d) {
        this.edpp = d;
    }

    public double getEDPP() {
        return this.edpp;
    }

    private void determineEarthDistance(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Double d = SRS.getDistanceConversionFactor(this.unit);
        if (d == null && !this.geodetic) {
            return;
        }
        double d2 = -1.0;
        if (this.geodetic) {
            if (this.spheroid == null) {
                return;
            }
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            dArray[0] = (rectangle2D.getMinX() + rectangle2D.getMaxX()) * 0.5 * (Math.PI / 180);
            dArray2[0] = dArray[0];
            dArray[1] = rectangle2D.getMinY() * (Math.PI / 180);
            dArray2[1] = rectangle2D.getMaxY() * (Math.PI / 180);
            d2 = Util.dist(dArray, dArray2, this.spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - this.spheroid.getEccentricity2()), this.spheroid.getFlattening());
        } else {
            double d3 = d;
            d2 = rectangle2D.getHeight() * d3;
        }
        this.edpp = d2 / rectangle2D2.getHeight();
        double d4 = (double)this.definition.getLengthHint() * this.edpp;
        NiceRange niceRange = this.findRange(d4);
        if (niceRange == null) {
            this.earthDistance = -1.0;
            return;
        }
        this.earthDistance = this.findEarthDist(niceRange, d4);
    }

    private NiceRange findRange(double d) {
        for (int i = 0; i < niceRanges.length; ++i) {
            NiceRange niceRange = niceRanges[i];
            if (!(d >= niceRange.min) || !(d < niceRange.max)) continue;
            return niceRange;
        }
        log.warning("cannot find a suitable range for scalebar.");
        return null;
    }

    private double findEarthDist(NiceRange niceRange, double d) {
        double d2;
        for (double d3 = d2 = niceRange.min >= 10.0 ? 0.0 : niceRange.min; d3 < niceRange.max; d3 += niceRange.increment) {
            double d4 = d - d3;
            if (d4 > niceRange.increment) continue;
            double d5 = d3 + niceRange.increment - d;
            return d4 > d5 ? d3 + niceRange.increment : (d3 == 0.0 ? niceRange.min : d3);
        }
        return -1.0;
    }

    private String cleanup0s(String string) {
        int n = string.indexOf(".");
        while (string.endsWith("0") && n >= 0) {
            string = string.substring(0, string.length() - 1);
            n = string.indexOf(".");
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void setupDisplayInfo() {
        if (this.earthDistance < 0.0) {
            this.edDisplayI = "";
            this.edHalfDisplayI = "";
            this.unitNameI = "";
            return;
        }
        if (this.earthDistance > 100000.0) {
            int n = (int)this.earthDistance / 1000;
            this.edDisplayI = "" + n;
            this.edHalfDisplayI = "" + n / 2;
            this.unitNameI = "km";
            int n2 = (int)(this.earthDistance / 1609.344);
            n2 = this.findFloor4Miles(n2);
            this.edDisplayU = "" + n2;
            this.usMarker1Dist = (double)n2 * 1609.344;
            this.unitNameU = "mi";
        } else if (this.earthDistance > 10000.0) {
            double d = this.earthDistance / 1000.0;
            this.edDisplayI = "" + d;
            this.edDisplayI = this.cleanup0s(this.edDisplayI);
            this.edHalfDisplayI = "" + d / 2.0;
            this.edHalfDisplayI = this.cleanup0s(this.edHalfDisplayI);
            this.unitNameI = "km";
            int n = (int)(this.earthDistance / 1609.344);
            n = this.findFloor4Miles(n);
            this.edDisplayU = "" + n;
            this.usMarker1Dist = (double)n * 1609.344;
            this.unitNameU = "mi";
        } else if (this.earthDistance >= 1000.0) {
            this.edDisplayI = "" + new Integer((int)this.earthDistance);
            this.edHalfDisplayI = "" + new Integer((int)(this.earthDistance / 2.0));
            this.unitNameI = "m";
            if (this.earthDistance >= 1609.344) {
                int n = (int)(this.earthDistance / 1609.344);
                n = this.findFloor4Miles(n);
                this.edDisplayU = "" + n;
                this.usMarker1Dist = (double)n * 1609.344;
                this.unitNameU = "mi";
            } else {
                double d = this.earthDistance / 1609.344;
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(2);
                this.edDisplayU = "" + numberFormat.format(d);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = numberFormat.parse(this.edDisplayU).doubleValue() * 1609.344;
                }
                catch (Exception exception) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "mi";
            }
        } else {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(4);
            this.edDisplayI = "" + numberFormat.format(this.earthDistance);
            this.edHalfDisplayI = "" + numberFormat.format(this.earthDistance / 2.0);
            try {
                this.earthDistance = numberFormat.parse(this.edDisplayI).doubleValue();
            }
            catch (Exception exception) {
                log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
            }
            this.edDisplayI = this.cleanup0s(this.edDisplayI);
            this.edHalfDisplayI = this.cleanup0s(this.edHalfDisplayI);
            this.unitNameI = "m";
            if (this.earthDistance >= 152.0) {
                double d = this.earthDistance / 1609.344;
                numberFormat.setMaximumFractionDigits(2);
                this.edDisplayU = "" + numberFormat.format(d);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = numberFormat.parse(this.edDisplayU).doubleValue() * 1609.344;
                }
                catch (Exception exception) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "mi";
            } else if (this.earthDistance >= 0.3048) {
                int n = (int)(this.earthDistance / 0.3048);
                n = this.findFloor4Miles(n);
                this.edDisplayU = "" + n;
                this.usMarker1Dist = (double)n * 0.3048;
                this.unitNameU = "ft";
            } else {
                double d = this.earthDistance / 0.0254;
                numberFormat.setMaximumFractionDigits(2);
                this.edDisplayU = "" + numberFormat.format(d);
                this.edDisplayU = this.cleanup0s(this.edDisplayU);
                try {
                    this.usMarker1Dist = numberFormat.parse(this.edDisplayU).doubleValue() * 0.0254;
                }
                catch (Exception exception) {
                    log.warning("ScaleBar: invalid number format:" + this.edDisplayU + ".");
                }
                this.unitNameU = "in";
            }
        }
    }

    private int findFloor4Miles(int n) {
        if (n <= 10) {
            return n;
        }
        if (n > 10 && n <= 100) {
            int n2 = n % 10;
            return n - n2;
        }
        if (n > 100 && n <= 1000) {
            int n3 = n % 100;
            n -= n3;
            if (n3 > 50) {
                n += 50;
            }
            return n;
        }
        int n4 = n % 1000;
        n -= n4;
        if (n4 > 500) {
            n += 500;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderScaleBar(Graphics2D graphics2D) {
        if (this.earthDistance < 0.0 || this.edpp == 0.0) {
            log.warning("cannot render scale bar.");
            return;
        }
        int n = (int)(this.earthDistance / this.edpp);
        double[] dArray = this.determineLocation(n);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setTransform(AffineTransform.getTranslateInstance(dArray[0], dArray[1]));
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = n2 + n / 4;
            int n5 = n2 + n / 2;
            StyleText styleText = new StyleText(this.definition.getLabelFont(), this.definition.getLabelColor(), this.definition.getLabelHaloSize());
            if ("METRIC_MODE".equals(this.definition.getMode())) {
                this.renderMetricBar(graphics2D, n2, n4, n5, n3, n, styleText);
            } else if ("US_MODE".equals(this.definition.getMode())) {
                this.renderUSBar(graphics2D, n2, n3, n, styleText);
            } else {
                this.renderUSBar(graphics2D, n2, n3, n, styleText);
                this.renderMetricBar(graphics2D, n2, n4, n5, n3, n, styleText);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    private void renderMetricBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, StyleText styleText) throws StyleNotApplicableException {
        int n6 = this.barHeight;
        int n7 = this.definition.getLabelFont().getSize();
        float f = this.definition.getLabelHaloSize();
        if (this.definition.getMode().equals("DUAL_MODES")) {
            styleText.apply(graphics2D, n, (float)(n4 + n6 * 2) + ((float)n7 + f) / 2.0f + 2.0f, LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.unitNameI, null);
            styleText.apply(graphics2D, n + n5, (float)(n4 + n6 * 2) + ((float)n7 + f) / 2.0f + 2.0f, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edDisplayI, null);
            n4 += n6;
        } else if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
            styleText.apply(graphics2D, n, (int)((float)(n4 + n6) + ((float)n7 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            styleText.apply(graphics2D, n + n5 - n7, (int)((float)(n4 + n6) + ((float)n7 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayI + " " + this.unitNameI, null);
        } else {
            styleText.apply(graphics2D, n, (int)((float)n4 - ((float)n7 + f) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            styleText.apply(graphics2D, n + n5 - n7, (int)((float)n4 - ((float)n7 + f) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayI + " " + this.unitNameI, null);
        }
        if (n5 > 75) {
            graphics2D.setStroke(new BasicStroke(0.8f));
            graphics2D.setColor(this.definition.getColor1());
            graphics2D.fillRect(n, n4, n5 / 4 + 1, n6);
            graphics2D.setColor(this.definition.getColor2());
            graphics2D.fillRect(n2, n4, n5 / 4 + 1, n6);
            graphics2D.setColor(this.definition.getColor1());
            graphics2D.fillRect(n3, n4, n5 / 2, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n4, n5 - 1, n6);
            graphics2D.drawLine(n2, n4, n2, n4 + n6);
            graphics2D.drawLine(n3, n4, n3, n4 + n6);
            if (this.definition.getMode().equals("METRIC_MODE")) {
                if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
                    styleText.apply(graphics2D, n + n5 / 2, (int)((float)(n4 + n6) + ((float)n7 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
                } else {
                    styleText.apply(graphics2D, n + n5 / 2, (int)((float)n4 - ((float)n7 + f) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
                }
            } else {
                styleText.apply(graphics2D, n + n5 / 2, (int)((float)(n4 + n6) + ((float)n7 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edHalfDisplayI, null);
            }
        } else {
            graphics2D.setStroke(new BasicStroke(0.8f));
            graphics2D.setColor(this.definition.getColor2());
            graphics2D.fillRect(n, n4, n5, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n4, n5 - 1, n6);
        }
    }

    private void renderUSBar(Graphics2D graphics2D, int n, int n2, int n3, StyleText styleText) throws StyleNotApplicableException {
        int n4 = this.barHeight;
        int n5 = this.definition.getLabelFont().getSize();
        int n6 = (int)(this.usMarker1Dist / this.edpp);
        float f = this.definition.getLabelHaloSize();
        if (this.definition.getMode().equals("DUAL_MODES")) {
            styleText.apply(graphics2D, n, (int)((float)n2 - ((float)n5 + f) / 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.unitNameU, null);
            styleText.apply(graphics2D, n + n6, (int)((float)n2 - ((float)n5 + f) / 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, this.edDisplayU, null);
        } else if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
            styleText.apply(graphics2D, n, (int)((float)(n2 + n4) + ((float)n5 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            styleText.apply(graphics2D, n + n6 - n5, (int)((float)(n2 + n4) + ((float)n5 + f) / 2.0f + 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayU + " " + this.unitNameU, null);
        } else {
            styleText.apply(graphics2D, n, (int)((float)n2 - ((float)n5 + f) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, "0", null);
            styleText.apply(graphics2D, n + n6 - n5, (int)((float)n2 - ((float)n5 + f) / 2.0f - 2.0f), LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, this.edDisplayU + " " + this.unitNameU, null);
        }
        graphics2D.setStroke(new BasicStroke(0.8f));
        graphics2D.setColor(this.definition.getColor2());
        graphics2D.fillRect(n, n2, n6, n4);
        if (this.definition.getMode().equals("DUAL_MODES")) {
            graphics2D.setColor(this.definition.getColor1());
            graphics2D.fillRect(n + n6, n2, n3 - n6, n4);
        }
        if (this.definition.getMode().equals("DUAL_MODES")) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2, n3 - 1, n4);
            if (n + n6 < n + n3 - 1) {
                graphics2D.drawLine(n + n6, n2, n + n6, n2 + n4);
            }
        } else {
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2, n6 - 1, n4);
        }
    }

    private double[] determineLocation(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = n;
        double d4 = this.barHeight;
        int n2 = this.definition.getLabelFont().getSize();
        double d5 = 10.0;
        if (this.definition.getOffsetX() > 0) {
            d5 = this.definition.getOffsetX();
        }
        double d6 = 10.0;
        if (this.definition.getOffsetY() > 0) {
            d6 = this.definition.getOffsetY();
        }
        String string = this.definition.getPosition();
        float f = this.definition.getLabelHaloSize();
        if (f < 0.0f) {
            f = 0.0f;
        }
        d = this.mDeviceView.getWidth() / 2.0 - d3 / 2.0 - (double)(n2 * 2);
        if (string.indexOf("NORTH") >= 0) {
            d2 = Math.rint((float)this.definition.getLabelFont().getSize() + f + 2.0f + (float)d6);
            if ("BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition()) && !this.definition.getMode().equalsIgnoreCase("DUAL_MODES")) {
                d2 = d6;
            }
        } else if (string.indexOf("SOUTH") >= 0) {
            if (this.definition.getMode().equalsIgnoreCase("DUAL_MODES")) {
                d2 = Math.rint(this.mDeviceView.getHeight() - 2.0 * d4 - (double)((float)n2 + f) - 2.0 - d6);
            } else {
                d2 = Math.rint(this.mDeviceView.getHeight() - d4 - (double)((float)n2 + f) - 2.0 - d6);
                if (!"BOTTOM".equalsIgnoreCase(this.definition.getLabelPosition())) {
                    d2 = this.mDeviceView.getHeight() - d4 - d6;
                }
            }
        }
        if (string.indexOf("EAST") >= 0) {
            String string2 = "";
            if (this.definition.getMode().equals("DUAL_MODES")) {
                String string3 = this.edDisplayI;
                String string4 = this.edDisplayU;
                string2 = string3.length() > string4.length() ? string3 : string4;
            } else {
                string2 = this.definition.getMode().equals("METRIC_MODE") ? this.edDisplayI + " " + this.unitNameI : this.edDisplayU + " " + this.unitNameU;
            }
            int n3 = string2.length() <= 2 ? 1 : string2.length() - 2;
            d = this.mDeviceView.getWidth() - d3 - d5 - (double)(n2 * n3);
        } else if (string.indexOf("WEST") >= 0) {
            d = d5;
        }
        return new double[]{d, d2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderScaleBar(SVGMap sVGMap) {
        if (this.earthDistance < 0.0 || this.edpp == 0.0) {
            log.warning("cannot render scale bar.");
            return;
        }
        int n = (int)(this.earthDistance / this.edpp);
        int n2 = n;
        int n3 = (int)(this.usMarker1Dist / this.edpp);
        if (n2 < n3) {
            n2 = n3;
        }
        double[] dArray = this.determineLocation(n2);
        String string = this.definition.getPosition();
        if (("SOUTH_EAST".equals(string) || "NORTH_EAST".equals(string)) && dArray[0] - 50.0 > 20.0) {
            dArray[0] = dArray[0] - 50.0;
        }
        sVGMap.createScaleBar(dArray[0], dArray[1], n2);
        for (int i = 0; i < sVGMap.getZoomLevels(); ++i) {
            sVGMap.addScaleBarLevel(i);
            if (i > 0) {
                this.dataView.setRect(this.dataView.getX(), this.dataView.getY(), this.dataView.getWidth() / sVGMap.getZoomFactor(), this.dataView.getHeight() / sVGMap.getZoomFactor());
                this.determineEarthDistance(this.dataView, this.mDeviceView);
                this.setupDisplayInfo();
            }
            if ((n2 = (n = (int)(this.earthDistance / this.edpp))) < (n3 = (int)(this.usMarker1Dist / this.edpp))) {
                n2 = n3;
            }
            try {
                int n4 = 0;
                int n5 = 0;
                int n6 = n4 + n2 / 4;
                int n7 = n4 + n2 / 2;
                StyleText styleText = new StyleText(this.definition.getLabelFont(), this.definition.getLabelColor(), this.definition.getLabelHaloSize());
                if ("METRIC_MODE".equals(this.definition.getMode())) {
                    sVGMap.renderMetricBar(this, n4, n6, n7, n5, n2, styleText);
                    continue;
                }
                if ("US_MODE".equals(this.definition.getMode())) {
                    sVGMap.renderUSBar(this, n4, n5, n2, styleText);
                    continue;
                }
                sVGMap.renderUSBar(this, n4, n5, n2, styleText);
                sVGMap.renderMetricBar(this, n4, n6, n7, n5, n2, styleText);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            continue;
        }
    }

    public double getEdpp() {
        return this.edpp;
    }

    public String getUnitNameI() {
        return this.unitNameI;
    }

    public String getEdDisplayI() {
        return this.edDisplayI;
    }

    public String getEdHalfDisplayI() {
        return this.edHalfDisplayI;
    }

    public String getUnitNameU() {
        return this.unitNameU;
    }

    public double getUsMarker1Dist() {
        return this.usMarker1Dist;
    }

    public String getEdDisplayU() {
        return this.edDisplayU;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    private static class NiceRange {
        public double min;
        public double max;
        public double increment;

        public NiceRange(double d, double d2, double d3) {
            this.min = d;
            this.max = d2;
            this.increment = d3;
        }
    }
}

