/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.shape.rtree.Rtree;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileFeatureJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;

public class ShapefileDataProvider
implements SDataProvider {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataDirectory = null;
    private Point2D filterResolution = null;

    public String[] getInitParameterNames() {
        return new String[]{"datadir"};
    }

    public String[] getRuntimeParameterNames() {
        return new String[]{"filename"};
    }

    public boolean init(Properties properties) {
        this.dataDirectory = null;
        if (properties == null) {
            return true;
        }
        this.dataDirectory = properties.getProperty("datadir");
        if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
            this.dataDirectory = properties.getProperty("DATADIR");
            if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
                log.fine("Init properties does not define \"datadir\" parameter.");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDataSet buildDataSet(Rectangle2D rectangle2D, String[] stringArray, Properties properties) {
        String string = this.getFileNameToUse(properties);
        if (string == null) {
            return null;
        }
        boolean bl = this.isFullExtent(rectangle2D);
        SDataSet sDataSet = new SDataSet();
        SObject sObject = null;
        DBFReaderJGeom dBFReaderJGeom = null;
        ShapefileReaderJGeom shapefileReaderJGeom = null;
        String string2 = string;
        int n = string.toLowerCase().indexOf(".shp");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        Rtree rtree = null;
        ArrayList arrayList = new ArrayList();
        long[] lArray = null;
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.isRtreeAvailable(string2);
        }
        try {
            int n2;
            Object object;
            if (!bl && bl2) {
                rtree = Rtree.open((String)string2, (boolean)true);
                object = new double[2][2];
                object[0][0] = rectangle2D.getMinX();
                object[0][1] = rectangle2D.getMaxX();
                object[1][0] = rectangle2D.getMinY();
                object[1][1] = rectangle2D.getMaxY();
                log.info("Tree search window: [X range] " + object[0][0] + "," + object[0][1] + " [Y range] " + object[1][0] + "," + object[1][1]);
                double[] dArray = null;
                if (this.filterResolution != null) {
                    dArray = new double[]{this.filterResolution.getX(), this.filterResolution.getY()};
                    log.finer("Filter resolution: " + dArray[0] + " , " + dArray[1]);
                }
                if (rtree.search(object, dArray, -1.0, arrayList)) {
                    log.info("Found " + arrayList.size() + " tree records.");
                    lArray = new long[arrayList.size()];
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        lArray[n2] = ((Integer)arrayList.get(n2)).longValue();
                    }
                }
            }
            dBFReaderJGeom = new DBFReaderJGeom(string2);
            shapefileReaderJGeom = new ShapefileReaderJGeom(string2);
            object = new ShapefileFeatureJGeom();
            int n3 = shapefileReaderJGeom.getShpFileType();
            n2 = dBFReaderJGeom.numFields();
            int n4 = dBFReaderJGeom.numRecords();
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = dBFReaderJGeom.getFieldType(i);
            }
            String[] stringArray2 = ShapefileFeatureJGeom.getOraFieldNames((DBFReaderJGeom)dBFReaderJGeom, (byte[])byArray, (int)n2);
            int n5 = 0;
            if (lArray != null) {
                n4 = lArray.length;
            }
            log.info("Reading " + n4 + " shape records...");
            for (int i = 0; i < n4; ++i) {
                Hashtable hashtable = null;
                hashtable = lArray == null ? ShapefileFeatureJGeom.fromRecordToFeature((DBFReaderJGeom)dBFReaderJGeom, (ShapefileReaderJGeom)shapefileReaderJGeom, (byte[])byArray, (int)n2, (int)i, (int)0) : ShapefileFeatureJGeom.fromRecordToFeature((DBFReaderJGeom)dBFReaderJGeom, (ShapefileReaderJGeom)shapefileReaderJGeom, (byte[])byArray, (int)n2, (int)((int)(lArray[i] - 1L)), (int)0);
                ArrayList<Field> arrayList2 = new ArrayList<Field>();
                try {
                    JGeometry jGeometry;
                    int n6;
                    Field field;
                    Field[] fieldArray;
                    if (n3 == 5 || n3 == 15 || n3 == 25) {
                        if (stringArray != null) {
                            block16: for (int j = 0; j < stringArray.length; ++j) {
                                fieldArray = stringArray[j];
                                field = null;
                                for (n6 = 0; n6 < stringArray2.length; ++n6) {
                                    if (!fieldArray.equalsIgnoreCase(stringArray2[n6])) continue;
                                    if (hashtable.get(stringArray2[n6]) instanceof String) {
                                        field = Field.createField((String)hashtable.get(stringArray2[n6]), "string");
                                        field.setName((String)fieldArray);
                                    } else if (hashtable.get(stringArray2[n6]) instanceof Integer) {
                                        field = new Field((Integer)hashtable.get(stringArray2[n6]));
                                        field.setName((String)fieldArray);
                                    } else if (hashtable.get(stringArray2[n6]) instanceof Double) {
                                        field = new Field((Double)hashtable.get(stringArray2[n6]));
                                        field.setName((String)fieldArray);
                                    }
                                    if (field == null) continue block16;
                                    arrayList2.add(field);
                                    continue block16;
                                }
                            }
                        }
                        if ((jGeometry = (JGeometry)hashtable.get("geometry")) != null) {
                            fieldArray = null;
                            if (arrayList2.size() > 0) {
                                fieldArray = arrayList2.toArray(new Field[arrayList2.size()]);
                            }
                            sObject = new SObject(jGeometry, fieldArray);
                            sDataSet.addObject(sObject);
                            continue;
                        }
                        log.warning("Record " + (i + 1) + " has null geometry. Ignored.");
                        continue;
                    }
                    if (stringArray != null) {
                        block18: for (int j = 0; j < stringArray.length; ++j) {
                            fieldArray = stringArray[j];
                            field = null;
                            for (n6 = 0; n6 < stringArray2.length; ++n6) {
                                if (!fieldArray.equalsIgnoreCase(stringArray2[n6])) continue;
                                if (hashtable.get(stringArray2[n6]) instanceof String) {
                                    field = Field.createField((String)hashtable.get(stringArray2[n6]), "string");
                                    field.setName((String)fieldArray);
                                } else if (hashtable.get(stringArray2[n6]) instanceof Integer) {
                                    field = new Field((Integer)hashtable.get(stringArray2[n6]));
                                    field.setName((String)fieldArray);
                                } else if (hashtable.get(stringArray2[n6]) instanceof Double) {
                                    field = new Field((Double)hashtable.get(stringArray2[n6]));
                                    field.setName((String)fieldArray);
                                }
                                if (field == null) continue block18;
                                arrayList2.add(field);
                                continue block18;
                            }
                        }
                    }
                    if ((jGeometry = (JGeometry)hashtable.get("geometry")) != null) {
                        fieldArray = null;
                        if (arrayList2.size() > 0) {
                            fieldArray = arrayList2.toArray(new Field[arrayList2.size()]);
                        }
                        sObject = new SObject(jGeometry, fieldArray);
                        sDataSet.addObject(sObject);
                        continue;
                    }
                    log.warning("Record " + (i + 1) + " has null geometry. ignored.");
                    continue;
                }
                catch (Exception exception) {
                    ++n5;
                    log.warning(exception + "\nRecord #" + (i + 1) + " not retrieved.");
                }
            }
        }
        catch (Exception exception) {
            log.severe("Exception: " + exception.getMessage());
        }
        finally {
            try {
                rtree.close();
                dBFReaderJGeom.closeDBF();
                shapefileReaderJGeom.closeShapefile();
            }
            catch (Exception exception) {}
        }
        log.info("Done.");
        if (sDataSet.getSize() == 0) {
            return null;
        }
        return sDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field[] getAttributeList(Properties properties) {
        String string = this.getFileNameToUse(properties);
        if (string == null) {
            return null;
        }
        DBFReaderJGeom dBFReaderJGeom = null;
        String string2 = string;
        int n = string.toLowerCase().indexOf(".shp");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        Vector<Field> vector = new Vector<Field>();
        try {
            dBFReaderJGeom = new DBFReaderJGeom(string2);
            int n2 = dBFReaderJGeom.numFields();
            for (int i = 0; i < n2; ++i) {
                Field field = null;
                int n3 = 0;
                switch (dBFReaderJGeom.getFieldType(i)) {
                    case 66: {
                        log.warning("Field type B not yet supported. Attribute ignored.");
                        break;
                    }
                    case 67: 
                    case 76: {
                        n3 = 8;
                        break;
                    }
                    case 68: {
                        n3 = 10;
                        break;
                    }
                    case 71: {
                        log.warning("Field type G not yet supported. Attribute ignored.");
                        break;
                    }
                    case 73: {
                        n3 = 3;
                        break;
                    }
                    case 70: {
                        n3 = 5;
                        break;
                    }
                    case 78: 
                    case 79: {
                        n3 = 6;
                        break;
                    }
                    case 77: {
                        log.warning("Field type M not yet supported");
                        break;
                    }
                    default: {
                        log.warning("Undefined DBF field type (1) " + dBFReaderJGeom.getFieldType(i));
                    }
                }
                if (n3 == 0) continue;
                field = new Field();
                field.setName(dBFReaderJGeom.getFieldName(i).toUpperCase());
                field.setType(n3);
                vector.add(field);
            }
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            Field[] fieldArray = null;
            return fieldArray;
        }
        finally {
            if (dBFReaderJGeom != null) {
                try {
                    dBFReaderJGeom.closeDBF();
                }
                catch (Exception exception) {}
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new Field[vector.size()]);
    }

    public Rectangle2D getDataExtents(Properties properties) {
        String string = this.getFileNameToUse(properties);
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = string.toLowerCase().indexOf(".shp");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        try {
            ShapefileReaderJGeom shapefileReaderJGeom = new ShapefileReaderJGeom(string2);
            double d = shapefileReaderJGeom.getMinX();
            double d2 = shapefileReaderJGeom.getMaxX();
            double d3 = shapefileReaderJGeom.getMinY();
            double d4 = shapefileReaderJGeom.getMaxY();
            return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
    }

    public boolean buildSpatialIndex(Properties properties) {
        String string;
        File file;
        String string2 = this.getFileNameToUse(properties);
        if (string2 == null) {
            return false;
        }
        String string3 = string2;
        int n = string2.toLowerCase().indexOf(".shp");
        if (n > -1) {
            string3 = string2.substring(0, n);
        }
        if ((file = new File(string = string3 + ".oix")).exists()) {
            file.delete();
        }
        log.info("Building RTree in disk...");
        Rtree rtree = Rtree.createPackedShapeRtree((String)string3, (int)2, (int)8192);
        if (rtree == null) {
            log.info("Unable to create RTree in disk.");
            return false;
        }
        log.info("RTree creation is done. Index file is: " + string);
        rtree.close();
        return true;
    }

    private boolean isFullExtent(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return true;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        return Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private synchronized boolean isRtreeAvailable(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string + ".oix";
        File file = new File(string2);
        if (!file.exists()) {
            log.info("Building RTree in disk...");
            Rtree rtree = Rtree.createPackedShapeRtree((String)string, (int)2, (int)8192);
            if (rtree == null) {
                log.info("Unable to create RTree in disk. Will do a sequential search.");
                return false;
            }
            log.info("RTree creation is done.");
            rtree.close();
            return true;
        }
        return true;
    }

    public void setFilterResolution(Point2D point2D) {
        this.filterResolution = point2D;
    }

    public Point2D getFilterResolution() {
        return this.filterResolution;
    }

    private String getFileNameToUse(Properties properties) {
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("filename");
        if (!(string != null && string.trim().length() != 0 || (string = properties.getProperty("FILENAME")) != null && string.trim().length() != 0)) {
            log.severe("Input properties must define \"filename\" parameter.");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            log.warning("Can not access file: " + string);
            if (this.dataDirectory == null) {
                return null;
            }
            log.info("Provider default data directory will be used: " + this.dataDirectory);
            int n = string.lastIndexOf("/");
            if (n < 0) {
                n = string.lastIndexOf("\\");
            }
            string = n == -1 ? this.dataDirectory + File.separator + string : this.dataDirectory + File.separator + string.substring(n + 1, string.length());
            log.info("File to be processed: " + string);
            File file2 = new File(string);
            if (!file2.exists()) {
                log.severe("File can not be accessed on provider data directory. Copy files there.");
                return null;
            }
        }
        return string;
    }
}

