/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.Serializable;
import java.util.ArrayList;
import oracle.sdovis.util.Util;

public final class Spheroid
implements Serializable {
    String name;
    double semiMajorAxis;
    double flattening;
    public static final Spheroid clarke1866 = new Spheroid("Clarke 1866", 6378206.4, 0.0033900753040885176);
    public static final Spheroid wgs1972 = new Spheroid("WGS 72", 6378135.0, 0.003352779454167505);
    public static final Spheroid australian = new Spheroid("Australian", 6378160.0, 0.003352891869237217);
    public static final Spheroid krassovsky = new Spheroid("Krassovsky", 6378245.0, 0.003352329869259135);
    public static final Spheroid international1924 = new Spheroid("International 1924", 6378388.0, 0.003367003367003367);
    public static final Spheroid hayford = new Spheroid("Hayford", 6378388.0, 0.003367003367003367);
    public static final Spheroid clarke1880 = new Spheroid("Clarke 1880", 6378249.145, 0.003407561378699334);
    public static final Spheroid grs80 = new Spheroid("GRS 80", 6378137.0, 0.003352810681182319);
    public static final Spheroid clarke66michigan = new Spheroid("Clarke 1866 (Michigan)", 6378450.047484481, 294.9786982);
    public static final Spheroid airy1930 = new Spheroid("Airy 1930", 6377563.396, 0.0033408506414970775);
    public static final Spheroid bessel1841 = new Spheroid("Bessel 1841", 6377397.155, 0.003342773182174806);
    public static final Spheroid everest = new Spheroid("Everest", 6377276.345, 0.003324449296662885);
    public static final Spheroid sphere6370997 = new Spheroid("Sphere (6370997m)", 6370997.0, 0.0);
    public static final Spheroid airy1930ireland = new Spheroid("Airy 1930(Ireland 1965)", 6377340.189, 0.0033408506414970775);
    public static final Spheroid bessel1841schwarzeck = new Spheroid("Bessel 1841 (Schwarzeck)", 6377483.865, 0.003342773182174806);
    public static final Spheroid clarke1880arc = new Spheroid("Clarke 1880 (Arc 1950)", 6378249.145326, 0.0034075461956028646);
    public static final Spheroid clarke1880merchich = new Spheroid("Clarke 1880 (Merchich)", 6378249.2, 0.003407549999492275);
    public static final Spheroid everestkertau = new Spheroid("Everest (Kertau)", 6377304.063, 0.003324449296662885);
    public static final Spheroid fischer1960mercury = new Spheroid("Fischer 1960 (Mercury)", 6378166.0, 0.003352329869259135);
    public static final Spheroid fischer1960southasia = new Spheroid("Fischer 1960 (South Asia)", 6378155.0, 0.003352329869259135);
    public static final Spheroid fischer1968 = new Spheroid("Fischer 1968", 6378150.0, 0.003352329869259135);
    public static final Spheroid grs1967 = new Spheroid("GRS 67", 6378160.0, 0.003352923712996414);
    public static final Spheroid helmert1906 = new Spheroid("Helmert 1906", 6378200.0, 0.003352329869259135);
    public static final Spheroid hough = new Spheroid("Hough", 6378270.0, 0.003367003367003367);
    public static final Spheroid southamerican1969 = new Spheroid("South American 1969", 6378160.0, 0.003352891869237217);
    public static final Spheroid waroffice = new Spheroid("War Office", 6378300.583, 0.0033783783783783786);
    public static final Spheroid wgs1960 = new Spheroid("WGS 60", 6378165.0, 0.003352329869259135);
    public static final Spheroid wgs1966 = new Spheroid("WGS 66", 6378145.0, 0.003352891869237217);
    public static final Spheroid wgs1984 = new Spheroid("WGS 84", 6378137.0, 0.0033528106647474805);
    public static final Spheroid clarke1880ign = new Spheroid("Clarke 1880 (IGN)", 6378249.2, 0.0034075495199416463);
    public static final Spheroid iag75 = new Spheroid("IAG 75", 6378140.0, 0.003352810682317694);
    public static final Spheroid merit83 = new Spheroid("MERIT 83", 6378137.0, 0.0033528131778969143);
    public static final Spheroid newinternational1967 = new Spheroid("New International 1967", 6378157.5, 0.003352891869237217);
    public static final Spheroid walbeck = new Spheroid("Walbeck", 6376896.0, 0.003302728053372086);
    public static final Spheroid bessel1841ngo1948 = new Spheroid("Bessel 1841 (NGO 1948)", 6377492.0176, 0.0033427732134623774);
    public static final Spheroid clarke1858 = new Spheroid("Clarke 1858", 6378293.639, 0.0033983473429069766);
    public static final Spheroid clarke1880jamaica = new Spheroid("Clarke 1880 (Jamaica)", 6378249.136, 0.0034075461677355737);
    public static final Spheroid clarke1880palestine = new Spheroid("Clarke 1880 (Palestine)", 6378300.79, 0.0034075470966454984);
    public static final Spheroid everesttimbalai = new Spheroid("Everest (Timbalai)", 6377298.556, 0.003324449296662885);
    public static final Spheroid everestkalianpur = new Spheroid("Everest (Kalianpur)", 6377301.243, 0.0033244488545844182);
    public static final Spheroid indonesian = new Spheroid("Indonesian", 6378160.0, 0.003352925595228116);
    public static final Spheroid nwl9d = new Spheroid("NWL 9D", 6378145.0, 0.003352891869237217);
    public static final Spheroid nwl10d = new Spheroid("NWL 10D", 6378135.0, 0.003352779454167505);
    public static final Spheroid osu86f = new Spheroid("OSU86F", 6378136.2, 0.003352810704800373);
    public static final Spheroid osu91a = new Spheroid("OSU91A", 6378136.3, 0.003352810704800373);
    public static final Spheroid plessis1817 = new Spheroid("Plessis 1817", 6376523.0, 0.0032400207361327114);
    public static final Spheroid struve1860 = new Spheroid("Struve 1860", 6378297.0, 0.003392935907440708);
    public static final Spheroid sphere6371000 = new Spheroid("Sphere (6371000M)", 6371000.0, 0.0);

    public Spheroid(String string, double d, double d2) {
        this.name = string;
        this.semiMajorAxis = d;
        this.flattening = d2;
    }

    public String getName() {
        return this.name;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public double getSemiMinorAxis() {
        return this.semiMajorAxis - this.flattening * this.semiMajorAxis;
    }

    public double getEccentricity2() {
        return 2.0 * this.flattening - this.flattening * this.flattening;
    }

    public boolean sameAs(Spheroid spheroid) {
        return this.semiMajorAxis == spheroid.getSemiMajorAxis() && this.flattening == spheroid.getFlattening();
    }

    public static Spheroid getSpheroid(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        int n = string2.indexOf("GEOGCS");
        if (n < 0) {
            return null;
        }
        if ((n = string2.indexOf("SPHEROID", n)) < 0) {
            return null;
        }
        try {
            n = string2.indexOf("[", n);
            n = string2.indexOf("\"", n);
            int n2 = string2.indexOf("\"", n + 1);
            String string3 = string2.substring(n + 1, n2);
            n = string2.indexOf(",", n2);
            n2 = string2.indexOf("]", n);
            String string4 = string2.substring(n + 1, n2);
            ArrayList arrayList = Util.splitBy(string4, ", ");
            double d = Double.parseDouble((String)arrayList.get(0));
            double d2 = 1.0 / Double.parseDouble((String)arrayList.get(1));
            Spheroid spheroid = new Spheroid(string3, d, d2);
            return spheroid;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

