/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BuiltinStyles;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleStore;
import oracle.sdovis.VisConstants;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.VariableMarkerStyle;

public class StyleCache
implements VisConstants,
Serializable {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String dsName;
    protected Hashtable styles;
    protected int maxSize;
    protected Hashtable ttFonts;
    protected StyleStore styleStore;
    protected Hashtable editedStyles = new Hashtable();

    public StyleCache(String string, int n) {
        this.dsName = string == null ? null : string.toUpperCase();
        this.styles = new Hashtable();
        this.addBuiltInStyles();
        this.maxSize = n <= 0 ? 200 : n;
        this.ttFonts = new Hashtable();
    }

    protected void addBuiltInStyles() {
        if (this.styles == null) {
            this.styles = new Hashtable();
        }
        this.put(BuiltinStyles.highlightColorStyleName, BuiltinStyles.highlightColorStyle);
        this.put(BuiltinStyles.invisibleColorStyleName, BuiltinStyles.invisibleColorStyle);
        this.put(BuiltinStyles.blackLineStyleName, BuiltinStyles.blackLineStyle);
        this.put(BuiltinStyles.circleMarkerStyleName, BuiltinStyles.circleMarkerStyle);
        try {
            VariableMarkerStyle variableMarkerStyle = BuiltinStyles.getPointClusterStyle();
            variableMarkerStyle.resolveStyles(this, null);
            this.put(BuiltinStyles.pointClusterStyleName, variableMarkerStyle);
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setStyleStore(StyleStore styleStore) {
        this.styleStore = styleStore;
    }

    public StyleStore getStyleStore() {
        return this.styleStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style get(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        if (this.editedStyles.size() > 0 && (object = (Style)this.editedStyles.get(string)) != null) {
            return object;
        }
        object = (CacheEntry)this.styles.get(string);
        if (object != null) {
            ((CacheEntry)object).mark();
            return ((CacheEntry)object).sty;
        }
        Style style = null;
        try {
            StyleCache styleCache = this;
            synchronized (styleCache) {
                style = this.styleStore.getStyleObject(string);
            }
            if (style != null) {
                this.put(string, style);
                return style;
            }
            return null;
        }
        catch (DataException dataException) {
            log.severe("[datasource:" + this.dsName + "] cannot load style " + string);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruetypeFont getFont(String string) {
        if (string == null) {
            return null;
        }
        TruetypeFont truetypeFont = (TruetypeFont)this.ttFonts.get(string = string.toUpperCase());
        if (truetypeFont != null) {
            return truetypeFont;
        }
        try {
            StyleCache styleCache = this;
            synchronized (styleCache) {
                truetypeFont = this.styleStore.getTTFont(string);
            }
            if (truetypeFont != null) {
                this.putFont(string, truetypeFont);
                return truetypeFont;
            }
            return null;
        }
        catch (DataException dataException) {
            log.severe("[datasource:" + this.dsName + "] cannot load tt-font " + string);
            return null;
        }
    }

    public void put(String string, Style style) {
        if (this.styles.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry cacheEntry = new CacheEntry(style);
        this.styles.put(string.toUpperCase(), cacheEntry);
    }

    public void putFont(String string, TruetypeFont truetypeFont) {
        this.ttFonts.put(string.toUpperCase(), truetypeFont);
    }

    public Hashtable getAllStyles() {
        return this.styles;
    }

    public Hashtable getAllFonts() {
        return this.ttFonts;
    }

    public void remove(String string) {
        if (string != null) {
            string = string.toUpperCase();
        }
        this.styles.remove(string);
    }

    public void removeFont(String string) {
        this.ttFonts.remove(string);
    }

    public void removeAll() {
        this.styles.clear();
        this.addBuiltInStyles();
    }

    public void removeAllFonts() {
        this.ttFonts.clear();
    }

    private void purge() {
    }

    public boolean addStyleToEditedList(String string, Style style) {
        if (string == null || style == null) {
            return false;
        }
        this.editedStyles.put(string.toUpperCase(), style);
        return true;
    }

    public boolean removeStyleFromEditedList(String string) {
        if (string == null) {
            return false;
        }
        this.editedStyles.remove(string.toUpperCase());
        return true;
    }

    public void clearStyleEditedList() {
        this.editedStyles.clear();
    }

    static class CacheEntry {
        Style sty;
        long lastUsed;

        public CacheEntry(Style style) {
            this.sty = style;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

