/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.DoubleGeneralPath;
import oracle.sdovis.util.ShapeUtil;

public class StyledFeature
implements Cloneable,
Serializable,
StyledFeatureI {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    int gType = 0;
    Shape shape = null;
    Point2D point = null;
    String label = null;
    String translatedLabel = null;
    String id = null;
    String dataSource = null;
    Object appData = null;
    Style featureStyle = null;
    String featureStyleName = null;
    String labelStyleName = null;
    Style labelStyle = null;
    boolean forceLabel = false;
    boolean fixedSVGLabel = false;
    int markerStyleSize = 0;
    double markerStyleOrientation = 0.0;
    double[] radius = null;
    double[] originalRadii = null;
    double customField1 = 0.0;
    Field[] renderableValues = null;
    Field[] identifiableValues = null;
    Point2D lblPoint = null;
    transient Rectangle2D shpMBR = null;
    Rectangle2D[] mtptShpMBRs = null;
    String infoStr = null;
    String svgId = null;
    JSDOGeometry geom = null;
    boolean selectableInSVG = false;
    String onClick = null;
    String onMouseMove = null;
    String onMouseOver = null;
    String onMouseOut = null;
    boolean shapeSimplified = true;
    RenderingRule[] renderRules = null;
    String nsdpMetaInfo = null;
    boolean allowNakedPoints = true;
    int resultSetPosition = -1;
    int elementPosition = 0;
    boolean labelAsOPoint = false;
    boolean isCluster = false;

    public Rectangle2D getShpMBR() {
        return this.shpMBR;
    }

    public void setShpMBR(Rectangle2D rectangle2D) {
        this.shpMBR = rectangle2D;
    }

    public Object clone() {
        try {
            int n;
            StyledFeature styledFeature = (StyledFeature)super.clone();
            if (this.geom != null) {
                styledFeature.geom = (JSDOGeometry)this.geom.clone();
            }
            if (this.shpMBR != null) {
                styledFeature.shpMBR = (Rectangle2D)this.shpMBR.clone();
            }
            if (this.lblPoint != null) {
                styledFeature.lblPoint = (Point2D)this.lblPoint.clone();
            }
            if (this.radius != null) {
                styledFeature.radius = new double[this.radius.length];
                for (n = 0; n < this.radius.length; ++n) {
                    styledFeature.radius[n] = this.radius[n];
                }
            }
            if (this.originalRadii != null) {
                styledFeature.originalRadii = new double[this.originalRadii.length];
                for (n = 0; n < this.originalRadii.length; ++n) {
                    styledFeature.originalRadii[n] = this.originalRadii[n];
                }
            }
            if (this.renderableValues != null) {
                styledFeature.renderableValues = new Field[this.renderableValues.length];
                for (n = 0; n < this.renderableValues.length; ++n) {
                    styledFeature.renderableValues[n] = (Field)this.renderableValues[n].clone();
                }
            }
            if (this.identifiableValues != null) {
                styledFeature.identifiableValues = new Field[this.identifiableValues.length];
                for (n = 0; n < this.identifiableValues.length; ++n) {
                    styledFeature.identifiableValues[n] = (Field)this.identifiableValues[n].clone();
                }
            }
            if (this.renderRules != null) {
                styledFeature.renderRules = new RenderingRule[this.renderRules.length];
                for (n = 0; n < this.renderRules.length; ++n) {
                    styledFeature.renderRules[n] = new RenderingRule();
                    styledFeature.renderRules[n].setStyleColumns(this.renderRules[n].getStyleColumns());
                    styledFeature.renderRules[n].setStyleName(this.renderRules[n].getStyleName());
                    styledFeature.renderRules[n].setSubStyleChangeProperty(this.renderRules[n].getSubStyleChangeProperty());
                    styledFeature.renderRules[n].setSubStyleColumns(this.renderRules[n].getSubStyleColumns());
                    styledFeature.renderRules[n].setSubStyleName(this.renderRules[n].getSubStyleName());
                }
            }
            return styledFeature;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Point2D getPoint() {
        return this.point;
    }

    public void setPoint(Point2D point2D) {
        this.point = point2D;
        this.shape = null;
        this.gType = 1;
    }

    public Point2D getLabelPoint() {
        return this.lblPoint;
    }

    public void setLabelPoint(Point2D point2D) {
        this.lblPoint = point2D;
    }

    public double getCenterX() {
        if (this.point != null) {
            return this.point.getX();
        }
        return this.shape.getBounds().getCenterX();
    }

    public double getX() {
        return this.getCenterX();
    }

    public double getCenterY() {
        if (this.point != null) {
            return this.point.getY();
        }
        return this.shape.getBounds().getCenterY();
    }

    public double getY() {
        return this.getCenterY();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.gType);
        objectOutputStream.writeObject(this.label);
        objectOutputStream.writeObject(this.id);
        objectOutputStream.writeObject(this.appData);
        objectOutputStream.writeObject(this.featureStyleName);
        objectOutputStream.writeObject(this.labelStyleName);
        objectOutputStream.writeBoolean(this.forceLabel);
        objectOutputStream.writeBoolean(this.fixedSVGLabel);
        objectOutputStream.writeInt(this.markerStyleSize);
        objectOutputStream.writeDouble(this.customField1);
        objectOutputStream.writeObject(this.radius);
        objectOutputStream.writeObject(this.originalRadii);
        objectOutputStream.writeObject(this.renderableValues);
        objectOutputStream.writeObject(this.identifiableValues);
        objectOutputStream.writeObject(this.renderRules);
        objectOutputStream.writeObject(this.geom);
        this.writeShapeOrPoint(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = null;
        this.gType = objectInputStream.readInt();
        object = objectInputStream.readObject();
        if (object != null) {
            this.label = (String)object;
        }
        this.id = (String)objectInputStream.readObject();
        this.appData = objectInputStream.readObject();
        object = objectInputStream.readObject();
        if (object != null) {
            this.featureStyleName = (String)object;
        }
        if ((object = objectInputStream.readObject()) != null) {
            this.labelStyleName = (String)object;
        }
        this.forceLabel = objectInputStream.readBoolean();
        this.fixedSVGLabel = objectInputStream.readBoolean();
        this.markerStyleSize = objectInputStream.readInt();
        this.customField1 = objectInputStream.readDouble();
        object = objectInputStream.readObject();
        if (object != null) {
            this.radius = (double[])object;
        }
        if ((object = objectInputStream.readObject()) != null) {
            this.originalRadii = (double[])object;
        }
        if ((object = objectInputStream.readObject()) != null) {
            this.renderableValues = (Field[])object;
        }
        if ((object = objectInputStream.readObject()) != null) {
            this.identifiableValues = (Field[])object;
        }
        if ((object = objectInputStream.readObject()) != null) {
            this.renderRules = (RenderingRule[])object;
        }
        this.geom = (JSDOGeometry)objectInputStream.readObject();
        this.readShapeOrPoint(objectInputStream);
    }

    private void writeShapeOrPoint(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.point != null;
        objectOutputStream.writeBoolean(bl);
        if (bl) {
            objectOutputStream.writeDouble(this.point.getX());
            objectOutputStream.writeDouble(this.point.getY());
        } else {
            boolean bl2 = this.shape != null;
            objectOutputStream.writeBoolean(bl2);
            if (this.shape != null) {
                ShapeUtil.store(this.shape, objectOutputStream);
            }
        }
    }

    private void readShapeOrPoint(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            double d = objectInputStream.readDouble();
            double d2 = objectInputStream.readDouble();
            this.point = new Point2D.Double(d, d2);
        } else {
            boolean bl2 = objectInputStream.readBoolean();
            this.shape = bl2 ? ShapeUtil.load(objectInputStream) : null;
        }
    }

    public JSDOGeometry getGeometry() {
        return this.geom;
    }

    public boolean hasRenderableShape() {
        return this.point != null || this.shape != null;
    }

    public void resetRenderableShape() {
        this.point = null;
        this.shape = null;
    }

    public void setGeometry(JSDOGeometry jSDOGeometry) {
        this.geom = jSDOGeometry;
        if (jSDOGeometry == null) {
            return;
        }
        int n = jSDOGeometry.getType();
        this.setGeomType(n);
        if (jSDOGeometry.isOrientedPoint() || jSDOGeometry.isOrientedMultiPoint()) {
            double[] dArray = jSDOGeometry.getOrdinatesArray();
            int n2 = jSDOGeometry.getDimensions();
            if (dArray != null) {
                this.setMarkerStyleOrientation(dArray[n2], dArray[n2 + 1], 0.0);
            }
        }
    }

    public void buildDoubleShapeFromGeometry(AffineTransform affineTransform) {
        if (this.geom == null) {
            return;
        }
        int n = this.geom.getType();
        if (n == 1) {
            Point2D point2D = this.geom.getJavaPoint();
            Point2D point2D2 = null;
            if (affineTransform != null) {
                point2D2 = (Point2D)point2D.clone();
                affineTransform.transform(point2D, point2D2);
                this.setPoint(point2D2);
            } else {
                this.setPoint(point2D);
            }
        } else if (n == 5) {
            Point2D[] point2DArray = this.geom.getJavaPoints();
            if (point2DArray != null) {
                if (affineTransform != null) {
                    affineTransform.transform(point2DArray, 0, point2DArray, 0, point2DArray.length);
                }
                DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
                if (point2DArray.length > 0) {
                    doubleGeneralPath.moveTo(point2DArray[0].getX(), point2DArray[0].getY());
                    for (int i = 1; i < point2DArray.length; ++i) {
                        doubleGeneralPath.lineTo(point2DArray[i].getX(), point2DArray[i].getY());
                    }
                }
                this.setShape(doubleGeneralPath);
                if (this.geom.getLabelPoint() != null) {
                    this.lblPoint = this.geom.getLabelPoint();
                }
            } else {
                log.severe("empty multipoint encountered.");
            }
        } else {
            Shape shape = this.geom.createDoubleShape(affineTransform);
            this.setShape(shape);
            if (this.geom.getLabelPoint() != null) {
                this.lblPoint = this.geom.getLabelPoint();
            }
        }
    }

    public void buildShapeFromGeometry(AffineTransform affineTransform) {
        if (this.geom == null) {
            return;
        }
        int n = this.geom.getType();
        if (n == 1) {
            Point2D point2D = this.geom.getJavaPoint();
            Point2D point2D2 = null;
            if (affineTransform != null) {
                point2D2 = (Point2D)point2D.clone();
                affineTransform.transform(point2D, point2D2);
                this.setPoint(point2D2);
            } else {
                this.setPoint(point2D);
            }
        } else if (n == 5) {
            Point2D[] point2DArray = this.geom.getJavaPoints();
            if (point2DArray != null) {
                if (affineTransform != null) {
                    affineTransform.transform(point2DArray, 0, point2DArray, 0, point2DArray.length);
                }
                GeneralPath generalPath = new GeneralPath();
                if (point2DArray.length > 0) {
                    generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
                    for (int i = 1; i < point2DArray.length; ++i) {
                        generalPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
                    }
                }
                this.setShape(generalPath);
                if (this.geom.getLabelPoint() != null) {
                    this.lblPoint = this.geom.getLabelPoint();
                }
            } else {
                log.severe("empty multipoint encountered.");
            }
        } else {
            Shape shape = this.geom.createShape(affineTransform, this.shapeSimplified);
            this.setShape(shape);
            if (this.geom.getLabelPoint() != null) {
                this.lblPoint = this.geom.getLabelPoint();
            }
        }
    }

    public int getGeomType() {
        return this.gType;
    }

    public void setGeomType(int n) {
        this.gType = n;
    }

    public void setForceLabel(boolean bl) {
        this.forceLabel = bl;
    }

    public boolean getForceLabel() {
        return this.forceLabel;
    }

    public void setFixedSVGLabel(boolean bl) {
        this.fixedSVGLabel = bl;
    }

    public boolean getFixedSVGLabel() {
        return this.fixedSVGLabel;
    }

    public String getLabel() {
        return this.translatedLabel != null && this.translatedLabel.length() > 0 ? this.translatedLabel : this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Style getFeatureStyle() {
        return this.featureStyle;
    }

    public String getFeatureStyleName() {
        return this.featureStyleName;
    }

    public void setFeatureStyle(Style style) {
        this.featureStyle = style;
    }

    public void setFeatureStyleName(String string) {
        this.featureStyleName = string != null ? ((string = string.trim()).length() == 0 || string.equalsIgnoreCase("null") ? null : string) : null;
    }

    public Style getLabelStyle() {
        return this.labelStyle;
    }

    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    public void setLabelStyle(Style style) {
        this.labelStyle = style;
    }

    public void setLabelStyleName(String string) {
        this.labelStyleName = string != null ? ((string = string.trim()).length() == 0 || string.equalsIgnoreCase("null") ? null : string) : null;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public Object getCustomData() {
        return this.appData;
    }

    public void setCustomData(Object object) {
        this.appData = object;
    }

    public void setMarkerStyleSize(int n) {
        this.markerStyleSize = n > 0 ? n : 0;
    }

    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    public double getMarkerStyleOrientation() {
        return this.markerStyleOrientation;
    }

    public void setMarkerStyleOrientation(double d) {
        this.markerStyleOrientation = d;
    }

    public void setMarkerStyleOrientation(double d, double d2, double d3) {
        this.markerStyleOrientation = Math.atan2(-d2, d);
    }

    public double[] getGeomMBR() {
        if (this.geom != null) {
            int n = this.geom.getType();
            if (n == 5) {
                Point2D[] point2DArray = this.geom.getJavaPoints();
                if (point2DArray != null && point2DArray.length > 0) {
                    double d = point2DArray[0].getX();
                    double d2 = point2DArray[0].getY();
                    double d3 = point2DArray[0].getX();
                    double d4 = point2DArray[0].getY();
                    for (int i = 1; i < point2DArray.length; ++i) {
                        d = Math.min(d, point2DArray[i].getX());
                        d2 = Math.min(d2, point2DArray[i].getY());
                        d3 = Math.max(d3, point2DArray[i].getX());
                        d4 = Math.max(d4, point2DArray[i].getY());
                    }
                    return new double[]{d, d2, d3, d4};
                }
                return null;
            }
            return this.geom.getMBR();
        }
        if (this.point != null) {
            return new double[]{this.point.getX(), this.point.getY(), this.point.getX(), this.point.getY()};
        }
        return null;
    }

    public void getShapeMBR(double[] dArray) {
        if (this.shape != null) {
            Rectangle2D rectangle2D = this.shape.getBounds2D();
            dArray[0] = rectangle2D.getMinX();
            dArray[1] = rectangle2D.getMinY();
            dArray[2] = rectangle2D.getMaxX();
            dArray[3] = rectangle2D.getMaxY();
        } else if (this.point != null) {
            dArray[0] = this.point.getX();
            dArray[1] = this.point.getY();
            dArray[2] = this.point.getX();
            dArray[3] = this.point.getY();
        } else {
            return;
        }
    }

    public void setRadius(double[] dArray) {
        this.radius = dArray;
    }

    public double[] getRadius() {
        return this.radius;
    }

    public void setOriginalRadius(double[] dArray) {
        this.originalRadii = dArray;
    }

    public double[] getOriginalRadius() {
        return this.originalRadii;
    }

    public void setCustomField1(double d) {
        this.customField1 = d;
    }

    public double getCustomField1() {
        return this.customField1;
    }

    public int getNumAttributes() {
        return (this.identifiableValues != null ? this.identifiableValues.length : 0) + (this.renderableValues != null ? this.renderableValues.length : 0);
    }

    public int getNumIdentifiableAttributes() {
        return this.identifiableValues != null ? this.identifiableValues.length : 0;
    }

    public int getNumRenderableAttributes() {
        return this.renderableValues != null ? this.renderableValues.length : 0;
    }

    public Field getIdentifiableAttribute(int n) {
        return this.identifiableValues != null ? this.identifiableValues[n] : null;
    }

    public Field getRenderableAttribute(int n) {
        return this.renderableValues != null ? this.renderableValues[n] : null;
    }

    public Field[] getRenderableAttributes() {
        return this.renderableValues;
    }

    public void setIdentifiableAttributes(Field[] fieldArray) {
        this.identifiableValues = fieldArray;
    }

    public Field[] getIdentifiableAttributes() {
        return this.identifiableValues;
    }

    public void setRenderableAttributes(Field[] fieldArray) {
        this.renderableValues = fieldArray;
    }

    public Object[] getRenderableValues() {
        if (this.renderableValues == null || this.renderableValues.length == 0) {
            return null;
        }
        Object[] objectArray = new Object[this.renderableValues.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.renderableValues[i].getValue();
        }
        return objectArray;
    }

    public void setInfoStr(String string) {
        this.infoStr = string;
    }

    public String getInfoStr() {
        if (this.infoStr != null) {
            return this.infoStr;
        }
        if (this.identifiableValues == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < this.identifiableValues.length; ++i) {
            Number number;
            Field field = this.identifiableValues[i];
            if (field == null) continue;
            Object object = field.getValue();
            if (object instanceof Double) {
                number = (Double)object;
                if ((Double)number == (double)((int)((Double)number).doubleValue())) {
                    object = new Integer((int)((Double)number).doubleValue());
                }
            } else if (object instanceof Float && ((Float)(number = (Float)object)).floatValue() == (float)((int)((Float)number).floatValue())) {
                object = new Integer((int)((Float)number).floatValue());
            }
            stringBuffer.append(field.getDisplayName() + ": " + object + "\\n");
        }
        return stringBuffer.toString();
    }

    public Field[] getAttributes() {
        int n;
        int n2 = (this.identifiableValues == null ? 0 : this.identifiableValues.length) + (this.renderableValues == null ? 0 : this.renderableValues.length);
        if (n2 == 0) {
            return null;
        }
        Field[] fieldArray = new Field[n2];
        int n3 = 0;
        if (this.identifiableValues != null) {
            for (n = 0; n < this.identifiableValues.length; ++n) {
                fieldArray[n3++] = this.identifiableValues[n];
            }
        }
        if (this.renderableValues != null) {
            for (n = 0; n < this.renderableValues.length; ++n) {
                fieldArray[n3++] = this.renderableValues[n];
            }
        }
        return fieldArray;
    }

    public String getAttributeListStr() {
        Field[] fieldArray = null;
        if (this.identifiableValues != null) {
            fieldArray = this.identifiableValues;
        } else if (this.renderableValues != null) {
            fieldArray = this.renderableValues;
        } else {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < fieldArray.length; ++i) {
            Number number;
            Field field = fieldArray[i];
            if (field == null) continue;
            Object object = field.getValue();
            if (object instanceof Double) {
                number = (Double)object;
                if ((Double)number == (double)((int)((Double)number).doubleValue())) {
                    object = new Integer((int)((Double)number).doubleValue());
                }
            } else if (object instanceof Float) {
                number = (Float)object;
                if (((Float)number).floatValue() == (float)((int)((Float)number).floatValue())) {
                    object = new Integer((int)((Float)number).floatValue());
                }
            } else if (object instanceof String) {
                object = this.escapeQuote((String)object);
            }
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append((field.getDisplayName() != null ? field.getDisplayName() : field.getName()) + "=\"" + object + "\"");
        }
        return stringBuffer.toString();
    }

    private String escapeQuote(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 1 + 5);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' && (i == 0 || string.charAt(i - 1) != '\\')) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String getSVGId() {
        return this.svgId;
    }

    public void setSVGId(String string) {
        this.svgId = string;
    }

    public Rectangle2D getMBR() {
        return this.shpMBR;
    }

    public void setMBR(Rectangle2D rectangle2D) {
        this.shpMBR = rectangle2D;
    }

    public void setShapeToNull() {
        this.shape = null;
        this.point = null;
    }

    public void setSelectableInSVG(boolean bl) {
        this.selectableInSVG = bl;
    }

    public boolean selectableInSVG() {
        return this.selectableInSVG;
    }

    public void setOnClick(String string) {
        this.onClick = string;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnMouseMove(String string) {
        this.onMouseMove = string;
    }

    public String getOnMouseMove() {
        return this.onMouseMove;
    }

    public void setOnMouseOver(String string) {
        this.onMouseOver = string;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnMouseOut(String string) {
        this.onMouseOut = string;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public void setShapeSimplified(boolean bl) {
        this.shapeSimplified = bl;
    }

    public boolean isShapeSimplified() {
        return this.shapeSimplified;
    }

    public void setRenderingRules(RenderingRule[] renderingRuleArray) {
        this.renderRules = renderingRuleArray;
    }

    public RenderingRule[] getRenderingRules() {
        return this.renderRules;
    }

    public void setNsdpMetaInfo(String string) {
        this.nsdpMetaInfo = string;
    }

    public String getNsdpMetaInfo() {
        return this.nsdpMetaInfo;
    }

    public void setAllowNakedPoints(boolean bl) {
        this.allowNakedPoints = bl;
    }

    public boolean isAllowNakedPoints() {
        return this.allowNakedPoints;
    }

    public void setResultSetPosition(int n) {
        this.resultSetPosition = n;
    }

    public int getResultSetPosition() {
        return this.resultSetPosition;
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int n) {
        this.elementPosition = n;
    }

    public boolean labelAsOrientedPoint() {
        return this.labelAsOPoint;
    }

    public void setLabelAsOrientedPoint(boolean bl) {
        this.labelAsOPoint = bl;
    }

    public void setTranslatedLabel(String string) {
        this.translatedLabel = string;
    }

    public String getTranslatedLabel() {
        return this.translatedLabel;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public void setIsCluster(boolean bl) {
        this.isCluster = bl;
    }

    public void setMultiPointShapeMBRs(Rectangle2D[] rectangle2DArray) {
        this.mtptShpMBRs = rectangle2DArray;
    }

    public Rectangle2D[] getMultiPointShapeMBRs() {
        return this.mtptShpMBRs;
    }
}

