/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.theme.ThemeDefinition;

public class ThemeCache {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String dsName;
    protected Hashtable themes;
    protected int maxSize;
    protected Hashtable editedThemes = null;
    protected ThemeStore themeStore = null;

    public ThemeCache(String string, int n, ThemeStore themeStore) {
        this.dsName = string;
        this.maxSize = n;
        this.themes = new Hashtable(37);
        this.themeStore = themeStore;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public synchronized ThemeDefinition getOrLoadThemeDefinition(String string) {
        string = string.toUpperCase();
        ThemeDefinition themeDefinition = null;
        if (this.editedThemes != null && (themeDefinition = (ThemeDefinition)this.editedThemes.get(string)) != null) {
            return themeDefinition;
        }
        CacheEntry cacheEntry = (CacheEntry)this.themes.get(string);
        if (cacheEntry != null) {
            cacheEntry.mark();
            return cacheEntry.themeDef;
        }
        ThemeDefinition themeDefinition2 = null;
        try {
            themeDefinition2 = this.themeStore.getThemeDefinition(string);
            this.putThemeDefinition(string, themeDefinition2);
            return themeDefinition2;
        }
        catch (Exception exception) {
            log.severe("[datasource:" + this.dsName + "] cannot load theme " + string);
            return null;
        }
    }

    public ThemeDefinition getThemeDefinition(String string) {
        string = string.toUpperCase();
        ThemeDefinition themeDefinition = null;
        if (this.editedThemes != null && (themeDefinition = (ThemeDefinition)this.editedThemes.get(string)) != null) {
            return themeDefinition;
        }
        CacheEntry cacheEntry = (CacheEntry)this.themes.get(string);
        if (cacheEntry != null) {
            cacheEntry.mark();
            return cacheEntry.themeDef;
        }
        return null;
    }

    public void putThemeDefinition(String string, ThemeDefinition themeDefinition) {
        string = string.toUpperCase();
        if (this.themes.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry cacheEntry = new CacheEntry(themeDefinition);
        this.themes.put(string, cacheEntry);
    }

    public void remove(String string) {
        string = string.toUpperCase();
        this.themes.remove(string);
    }

    public void removeAll() {
        this.themes.clear();
    }

    private void purge() {
    }

    public boolean addThemeToEditedList(String string, ThemeDefinition themeDefinition) {
        if (string == null || themeDefinition == null) {
            return false;
        }
        if (this.editedThemes == null) {
            this.editedThemes = new Hashtable();
        }
        this.editedThemes.put(string.toUpperCase(), themeDefinition);
        return true;
    }

    public boolean removeThemeFromEditedList(String string) {
        if (string == null || this.editedThemes == null) {
            return false;
        }
        this.editedThemes.remove(string.toUpperCase());
        return true;
    }

    public void clearThemeEditedList() {
        if (this.editedThemes != null) {
            this.editedThemes.clear();
        }
    }

    public String[] getCachedThemeNames() {
        if (this.themes == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.themes.size()];
        int n = 0;
        Enumeration enumeration = this.themes.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void setThemeStore(ThemeStore themeStore) {
        this.themeStore = themeStore;
    }

    public ThemeStore getThemeStore() {
        return this.themeStore;
    }

    static class CacheEntry {
        ThemeDefinition themeDef;
        long lastUsed;

        public CacheEntry(ThemeDefinition themeDefinition) {
            this.themeDef = themeDefinition;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

