/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import oracle.sdovis.JSDOGeometry;

public class Unpickle81 {
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static boolean DEBUG = false;
    private static double[] RD100 = new double[]{0.01, 1.0E-4, 1.0E-6, 1.0E-8, 7.091869599285993E-10, -1.374797277892591E-9, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public static final JSDOGeometry unpickle(byte[] byArray) throws Exception {
        if (byArray == null || byArray.length < 7) {
            throw new Exception("invalid geometry image");
        }
        UnpickleHelper unpickleHelper = new UnpickleHelper(byArray);
        unpickleHelper.checkImageHeader();
        unpickleHelper.skipLength();
        int n = Unpickle81.getInt(unpickleHelper);
        if (DEBUG) {
            System.out.println("get gType: " + n);
        }
        int n2 = Unpickle81.getInt(unpickleHelper);
        if (DEBUG) {
            System.out.println("get srid: " + n2);
        }
        boolean bl = false;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (byArray[unpickleHelper.offset] < -1) {
            bl = false;
            ++unpickleHelper.offset;
        } else {
            bl = true;
            d = Unpickle81.getDouble(unpickleHelper);
            d2 = Unpickle81.getDouble(unpickleHelper);
            d3 = Unpickle81.getDouble(unpickleHelper);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                d = Double.NaN;
                d2 = Double.NaN;
            }
        }
        int[] nArray = Unpickle81.getElemInfoArray(unpickleHelper);
        double[] dArray = Unpickle81.getOrdinates(unpickleHelper);
        if (dArray != null && nArray != null) {
            boolean bl2 = JSDOGeometry.nonOracleETypeExists(nArray);
            if (!bl2) {
                return new JSDOGeometry(n, n2, d, d2, d3, nArray, dArray);
            }
            return JSDOGeometry.removeEType0(n, n2, d, d2, d3, nArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JSDOGeometry(d, d2, d3, n2);
            }
            return new JSDOGeometry(d, d2, n2);
        }
        System.out.println("cannot unpickle geometry. validate?");
        return null;
    }

    private static final int getInt(UnpickleHelper unpickleHelper) {
        double d = Unpickle81.getDouble(unpickleHelper);
        return Double.isNaN(d) ? 0 : (int)Math.round(d);
    }

    private static final double getDouble(UnpickleHelper unpickleHelper) {
        int n;
        int n2;
        boolean bl;
        byte[] byArray = unpickleHelper.image;
        int n3 = unpickleHelper.offset;
        double d = 0.0;
        int n4 = byArray[n3];
        if (DEBUG) {
            System.out.println("getting NUMBER...");
        }
        if (DEBUG) {
            System.out.println("\t length=" + n4);
        }
        if (n4 < 0) {
            ++unpickleHelper.offset;
            return Double.NaN;
        }
        unpickleHelper.offset += 1 + n4;
        if (n4 == 1) {
            return 0.0;
        }
        --n4;
        byte by = byArray[n3 + 1];
        boolean bl2 = bl = (by & 0x80) == 0;
        if (bl) {
            --n4;
        }
        by = (byte)(by & 0x7F);
        double d2 = 1.0;
        int n5 = n2 = bl ? 62 - by : by - 65;
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                d2 *= 100.0;
            }
        } else if (n2 < 0) {
            for (n = 0; n < -n2; ++n) {
                d2 /= 100.0;
            }
        }
        double d3 = 1.0;
        int n6 = 0;
        for (int i = 2; i < n4 + 2; ++i) {
            int n7 = byArray[n3 + i];
            n7 = bl ? 101 - n7 : --n7;
            d += (double)n7 * d3;
            d3 = RD100[n6++];
        }
        return bl ? -d : (d *= d2);
    }

    private static final int[] getElemInfoArray(UnpickleHelper unpickleHelper) throws Exception {
        byte by;
        if (DEBUG) {
            System.out.println("Entering getElemInfoArray()...");
        }
        if (DEBUG) {
            System.out.println("\t offset=" + unpickleHelper.offset);
        }
        if (((by = unpickleHelper.readByte()) & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        unpickleHelper.skipRestOfLength(by);
        if (DEBUG) {
            System.out.println("\t  after skipRestOfLength: offset=" + unpickleHelper.offset);
        }
        unpickleHelper.checkArrayHeader();
        unpickleHelper.readByte();
        if (DEBUG) {
            System.out.println("getElemInfoArray: after read first byte, offset=" + unpickleHelper.offset);
        }
        int n = unpickleHelper.readLength();
        if (DEBUG) {
            System.out.println("collection length=" + n);
        }
        if (n < 0) {
            return null;
        }
        if (n % 3 != 0) {
            throw new Exception("Corrupted element info array.");
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Unpickle81.getInt(unpickleHelper);
        }
        return nArray;
    }

    private static final double[] getOrdinates(UnpickleHelper unpickleHelper) throws Exception {
        byte by;
        if (DEBUG) {
            System.out.println("Entering getOrdinates()...");
        }
        if (DEBUG) {
            System.out.println("\t offset=" + unpickleHelper.offset);
        }
        if (((by = unpickleHelper.readByte()) & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        unpickleHelper.skipRestOfLength(by);
        if (DEBUG) {
            System.out.println("\t  after skipRestOfLength: offset=" + unpickleHelper.offset);
        }
        unpickleHelper.checkArrayHeader();
        unpickleHelper.readByte();
        if (DEBUG) {
            System.out.println("\tgetOrdinates: after read first byte, offset=" + unpickleHelper.offset);
        }
        int n = unpickleHelper.readLength();
        if (DEBUG) {
            System.out.println("collection length=" + n);
        }
        if (n < 0) {
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Unpickle81.getDouble(unpickleHelper);
        }
        return dArray;
    }

    private static final class UnpickleHelper {
        byte[] image = null;
        int offset = 0;

        public UnpickleHelper(byte[] byArray) {
            this.image = byArray;
            this.offset = 0;
        }

        public UnpickleHelper(byte[] byArray, int n) {
            this.image = byArray;
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public byte[] getImage() {
            return this.image;
        }

        public byte readByte() {
            byte by = this.image[this.offset];
            ++this.offset;
            return by;
        }

        public byte[] readBytes(int n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, n);
            this.offset += n;
            return byArray;
        }

        protected final void checkImageHeader() throws Exception {
            byte by = this.image[0];
            if ((by & 0xFF & KOPI20_IF_IS81) == 0) {
                throw new Exception("Image is not in 8.1 format");
            }
            if ((by & 0xFF & KOPI20_IF_COLL) != 0) {
                throw new Exception("Image is a collection image, expecting ADT");
            }
            byte by2 = this.image[1];
            if ((by2 & 0xFF) > KOPI20_VERSION) {
                throw new Exception("Image version is not recognized");
            }
            this.offset += 2;
        }

        public final byte[] readDataValue() {
            int n = this.image[this.offset] & 0xFF;
            if (n == KOPI20_LN_ELNL) {
                ++this.offset;
                return null;
            }
            if (n > KOPI20_LN_MAXV) {
                n = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, byArray.length);
            this.offset += byArray.length;
            return byArray;
        }

        public byte[] readDataValue(int n) {
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.offset, byArray, 0, n);
            this.offset += n;
            return byArray;
        }

        public boolean isElementNull(byte by) {
            return (by & 0xFF) == KOPI20_LN_ELNL;
        }

        protected final void skipLength() {
            int n = this.image[this.offset] & 0xFF;
            this.offset = n > KOPI20_LN_MAXV ? (this.offset += 5) : ++this.offset;
        }

        protected final void skipTo(int n) {
            if (n > this.offset) {
                this.offset = n;
            }
        }

        protected final int readLength() {
            int n = this.image[this.offset] & 0xFF;
            if (n > KOPI20_LN_MAXV) {
                if (n == KOPI20_LN_ELNL) {
                    return -1;
                }
                n = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            return n;
        }

        protected final void skipRestOfLength(byte by) throws Exception {
            if ((by & 0xFF) > KOPI20_LN_MAXV) {
                if ((by & 0xFF) == KOPI20_LN_5BLN) {
                    this.offset += 4;
                } else {
                    throw new Exception("Invalid first length byte");
                }
            }
        }

        protected final void checkPrefix() throws Exception {
            boolean bl;
            byte by = this.image[0];
            if ((by & 0xFF & KOPI20_IF_NOPS) != 0) {
                return;
            }
            long l = this.readLength() + this.getOffset();
            byte by2 = this.readByte();
            byte by3 = (byte)(by2 & 0xC);
            boolean bl2 = by3 == 0;
            boolean bl3 = by3 == 4;
            boolean bl4 = by3 == 8;
            boolean bl5 = by3 == 12;
            boolean bl6 = bl = (by2 & 0x10) != 0;
            if (bl3) {
                byte[] byArray = this.readBytes(16);
            }
            int n = 0;
            n = bl ? this.readLength() : 1;
            if (bl4 | bl5) {
                throw new Exception("Unsupported feature in prefix segment");
            }
            this.skipTo((int)l);
        }

        public final void checkArrayHeader() throws Exception {
            byte by = this.readByte();
            if ((by & 0xFF & KOPI20_IF_NOPS) != 0) {
                throw new Exception("Array image has no prefix segment");
            }
            boolean bl = true;
            if ((by & 0xFF & KOPI20_IF_COLL) != 0) {
                bl = true;
            } else if ((by & 0xFF & KOPI20_IF_DEGN) != 0) {
                bl = false;
            } else {
                throw new Exception("Image is not a collection image");
            }
            this.readByte();
            long l = this.readLength();
            if (DEBUG) {
                System.out.println("array total len=" + l);
            }
            int n = this.readLength();
            byte by2 = this.readByte();
            this.readDataValue(n - 1);
        }
    }
}

